/*
 * java.io.FileOutputStream.c
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#include <stdio.h>
#include <assert.h>
#include "files.h"
#include "java.io/FileOutputStream.h"
#include "java.io/FileDescriptor.h"

/*
 * Open a file for output.
 */
void
java_io_FileOutputStream_open(struct Hjava_io_FileOutputStream* fh, struct Hjava_lang_String* nm)
{
	int fd;
	char str[MAXPATHLEN];

	javaString2CString(nm, str, sizeof(str));

	fd = open(str, O_WRONLY|O_CREAT, 0666);
	unhand(unhand(fh)->fd)->fd = fd;
	if (fd < 0) {
		SignalError(0, "java.io.IOException", SYS_ERROR);
	}
}

/*
 * Close a file.
 */
void
java_io_FileOutputStream_close(struct Hjava_io_FileOutputStream* fh)
{
	int r;

	if (unhand(unhand(fh)->fd)->fd >= 0) {
		r = close(unhand(unhand(fh)->fd)->fd);
		unhand(unhand(fh)->fd)->fd = -1;
		if (r < 0) {
			SignalError(0, "java.io.IOException", SYS_ERROR);
		}
	}
}

/*
 * Write bytes to file.
 */
void
java_io_FileOutputStream_writeBytes(struct Hjava_io_FileOutputStream* fh, HArray* byteArray, long start, long len)
{
	int fd;
	int r;

	fd = unhand(unhand(fh)->fd)->fd;
	r = write(fd, &byteArray->data[start], len);
	if (r < 0) {
		SignalError(0, "java.io.IOException", SYS_ERROR);
	}
}

/*
 * Write a byte to file.
 */
void
java_io_FileOutputStream_write(struct Hjava_io_FileOutputStream* fh, long byte)
{
	int fd;
	int r;

	fd = unhand(unhand(fh)->fd)->fd;
	r = write(fd, &byte, 1);
	if (r < 0) {
		SignalError(0, "java.io.IOException", SYS_ERROR);
	}
}
