/*
 * Some additional stuff from the Linux include file.
 * rdavis@convex.com
 */

/*-
 * Copyright (c) 1993 Garbee and Garbee.  All rights reserved.
 *   written by Bdale Garbee, N3EUA, bdale@gag.com.
 *
 *	$Id: i82365sl.h,v 1.1 1994/01/30 01:13:50 bdale Exp $
 */

/* Register Definitions for Intel 82365SL PC Card Interface Controller */

#define PCIC_INDEX                           0x3e0
#define PCIC_DATA                            0x3e1

#define PCIC_ID_AND_REVISION_REG             0x00
#define PCIC_INTERFACE_STATUS_REG            0x01
#define PCIC_POWER_RESETDRV_CONTROL_REG      0x02
#define PCIC_INTERRUPT_AND_CONTROL_REG       0x03
#define PCIC_CARD_STATUS_CHANGE_REG          0x04
#define PCIC_CARD_STATUS_CHANGE_INTERRUPT    0x05
#define PCIC_ADDR_WIN_ENABLE_REG             0x06
#define PCIC_IO_CONTROL_REG                  0x07
#define PCIC_IO_ADDR_0_START_REG_LOW         0x08
#define PCIC_IO_ADDR_0_START_REG_HIGH        0x09
#define PCIC_IO_ADDR_0_STOP_REG_LOW          0x0A
#define PCIC_IO_ADDR_0_STOP_REG_HIGH         0x0B
#define PCIC_IO_ADDR_1_START_REG_LOW         0x0C
#define PCIC_IO_ADDR_1_START_REG_HIGH        0x0D
#define PCIC_IO_ADDR_1_STOP_REG_LOW          0x0E
#define PCIC_IO_ADDR_1_STOP_REG_HIGH         0x0F
#define PCIC_SYS_MEM_ADDR_0_MAP_START_LOW    0x10
#define PCIC_SYS_MEM_ADDR_0_MAP_START_HIGH   0x11
#define PCIC_SYS_MEM_ADDR_0_MAP_STOP_LOW     0x12
#define PCIC_SYS_MEM_ADDR_0_MAP_STOP_HIGH    0x13
#define PCIC_CARD_MEM_OFF_ADDR_0_LOW         0x14
#define PCIC_CARD_MEM_OFF_ADDR_0_HIGH        0x15

/* Offsets for PCIC registers */
#define I365_GENCTL   0x16    /* Card detect and general control register */
#define I365_GBLCTL   0x1E    /* Global control register */

/* Card detect mask for I365_STATUS */
#define CS_DETECT     0x0C

/* Flags for I365_INTCTL */
#define PC_RESET      0x40
#define PC_IOCARD     0x20

/* Offsets for I/O and memory window registers */
#define W_START       0
#define W_STOP        2
#define W_OFF         4

/* Flags for memory window registers */
#define MEM_16BIT     0x8000    /* In memory start high byte */
#define MEM_0WS       0x4000
#define MEM_WS1       0x8000    /* In memory stop high byte */
#define MEM_WS0       0x4000
#define MEM_WRPROT    0x8000    /* In offset high byte */
#define MEM_REG       0x4000

/* I365_POWER flags */
#define PWR_OFF       0x00    /* Turn off the socket */
#define PWR_OUT       0x80    /* Output enable */
#define PWR_NORESET   0x40    /* Disable RESETDRV on resume */
#define PWR_AUTO      0x20    /* Auto pwr switch enable */
#define VCC_5V        0x10    /* Vcc = 5.0v */
#define VCC_3V        0x18    /* Vcc = 3.3v */
#define VPP_5V        0x01    /* Vpp = 5.0v */
#define VPP_12V       0x02    /* Vpp = 12.0v */

/* I365_ADDRWIN flags */
#define ENA_IO_1       0x80
#define ENA_IO_0       0x40
#define ENA_MEM_4      0x10
#define ENA_MEM_3      0x08
#define ENA_MEM_2      0x04
#define ENA_MEM_1      0x02
#define ENA_MEM_0      0x01

/* I365_IOCTL flags */
#define IOCTL_1_WAIT   0x80
#define IOCTL_1_0WS    0x40
#define IOCTL_1_CS16   0x20
#define IOCTL_1_16BIT  0x10
#define IOCTL_0_WAIT   0x08
#define IOCTL_0_0WS    0x04
#define IOCTL_0_CS16   0x02
#define IOCTL_0_16BIT  0x01
