/*
 * java.lang.Float.c
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>, 1996.
 */

#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <native.h>
#include "defs.h"
#include "java.lang.stubs/Float.h"

/*
 * Convert float into a string.
 */
struct Hjava_lang_String*
java_lang_Float_toString(struct Hjava_lang_Float* none, jfloat val)
{
	char str[MAXNUMLEN];

	sprintf(str, "%g", val);
	return (makeJavaString(str, strlen(str)));
}

/*
 * Convert string to float object.
 */
struct Hjava_lang_Float*
java_lang_Float_valueOf(struct Hjava_lang_Float* none, struct Hjava_lang_String* str)
{
	struct Hjava_lang_Float* obj;
	char buf[MAXNUMLEN];
	char* endbuf;

	javaString2CString(str, buf, sizeof(buf));

	obj = (struct Hjava_lang_Float*)execute_java_constructor(0, "java.lang.Float", 0, "()V");

#if defined(HAVE_STRTOD)
	unhand(obj)->value = strtod(buf, &endbuf);
	if (*endbuf != 0) {
		SignalError(0, "java.lang.NumberFormatException", "Bad float format");
	}
#else
	/* Fall back on old atof - no error checking */
	unhand(obj)->value = atof(buf);
#endif

	return (obj);
}

/*
 * Convert float to bits.
 */
jint
java_lang_Float_floatToIntBits(struct Hjava_lang_Float* none, jfloat val)
{
	return (*(jint*)&val);
}

/*
 * Convert bits to float.
 */
float
java_lang_Float_intBitsToFloat(struct Hjava_lang_Float* none, jint val)
{
	return (*(jfloat*)&val);
}
