/*
 * locks.h
 * Manage locking system
 * This include the mutex's and cv's.
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>, 1996.
 */

#ifndef __locks_h
#define __locks_h

#include "md.h"

extern int64 waitforever;

#if defined(USE_INTERNAL_THREADS)

struct _thread;

typedef struct _iMux {
	struct _thread*		holder;
	int			count;
	struct _thread*		muxWaiters;
} iMux;

typedef struct _iCv {
	struct _thread*		cvWaiters;
	struct _iMux*		mux;
} iCv;

extern void internalLockMutex(iMux*);
extern void internalUnlockMutex(iMux*);
extern void internalWaitCond(iMux*, iCv*, int64);
extern void internalSignalCond(iCv*);
extern void internalBroadcastCond(iCv*);

#define	lockMutex(_obj)		internalLockMutex(&(_obj)->mux)
#define	unlockMutex(_obj)	internalUnlockMutex(&(_obj)->mux)
#define	waitCond(_obj, _tm)	internalWaitCond(&(_obj)->mux,&(_obj)->cv,(_tm))
#define	signalCond(_obj)	internalSignalCond(&(_obj)->cv)
#define	broadcastCond(_obj)	internalBroadcastCond(&(_obj)->cv)

#else
/*
 * Don't know what we'll do for native threading yet.
 */
#define	lockMutex(_obj)		???
#define	unlockMutex(_obj)	???
#define	waitCond(_obj, _tm)	???
#define	signalCond(_obj)	???
#define	broadcastCond(_obj)	???

#endif

#endif
