/* seq.h
 * Pseudo instruction sequences.
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>
 */

#ifndef __seq_hh
#define __seq_hh

struct _sequence;

typedef void (*ifunc)(struct _sequence*);

typedef struct _sequence {
	ifunc			func;
	int			ref;
	int			type;
	int			opt;
	union {
		jint		iconst;
		jlong		lconst;
		jdouble		fconst;
		struct {
			struct _slots*	slot;
			struct _sequence* seq;
		}		s;
	} u[3];
	struct _sequence*	next;
} sequence;

void initSeq(void);
sequence* nextSeq(void);
void seq_pop(sequence*);

extern sequence*		firstSeq;
extern sequence*		lastSeq;
extern sequence*		currSeq;

#define	ALLOCSEQNR		128

#define	seq(s)			((s)->insn)

#define	seq_slot(_s, _i)	((_s)->u[_i].s.slot)
#define	seq_seq(_s, _i)		((_s)->u[_i].s.seq)
#define	seq_value(_s, _i)	((_s)->u[_i].iconst)
#define	seq_dst(_s)		seq_slot(_s, 0)

#endif
