/*
 * itypes.c
 * Internal types.
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>, 1996.
 */

#include "itypes.h"
#include "baseClasses.h"

struct itypes types[MAXTYPES] = {
	/* 0 */			{ 0, "" },
	/* 1 */			{ 0, "" },
	/* 2 */			{ 0, "" },
	/* 3 */			{ 0, "" },
	/* TYPE_Boolean */	{ 1, "[Z" },
	/* TYPE_Char */		{ 1, "[C" }, /* Should be 2 for Unicode */
	/* TYPE_Float */	{ 4, "[F" },
	/* TYPE_Double */	{ 8, "[D" },
	/* TYPE_Byte */		{ 1, "[B" },
	/* TYPE_Short */	{ 2, "[S" },
	/* TYPE_Int */		{ 4, "[I" },
	/* TYPE_Long */		{ 8, "[J" },
	/* 12 */		{ 0, "" },
	/* 13 */		{ 0, "" },
	/* 14 */		{ 0, "" },
	/* 15 */		{ sizeof(void*), "[L" },
};

/*
 * Intialise the internal types.
 */
void
initTypes(void)
{
	int i;

	/* Translate strings */
	for (i = 0; i < MAXTYPES; i++) {
		types[i].arraySig = addString(types[i].arraySig);
	}
}

/*
 * Return the itypes information.
 */
struct itypes*
getITypes(void)
{
	return (types);
}
