/*
 * gtypes.h
 * General types.
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>, 1996.
 */

#ifndef __gtype_h
#define __gtype_h

#include "config.h"

#ifdef __CHAR_UNSIGNED__
#ifdef __STDC__
typedef signed char		int8;
#else
#error "no signed char type"
#endif
#else
typedef	char			int8;
#endif

typedef	unsigned char		uint8;

#if SIZEOF_SHORT == 2
typedef	short			int16;
typedef	unsigned short		uint16;
#else
#error "sizeof(short) must be 2"
#endif

#if SIZEOF_INT == 4
typedef	int			int32;
typedef	unsigned int		uint32;
#elif SIZEOF_LONG == 4
typedef	long			int32;
typedef	unsigned long		uint32;
#else
#error "sizeof(int) or sizeof(long) must be 4"
#endif

#if SIZEOF_LONG_LONG == 8
typedef	long long		int64;
typedef	unsigned long long	uint64;
#elif SIZEOF___INT64 == 8
typedef	__int64			int64;
typedef	unsigned __int64	uint64;
#else
typedef	struct { int32 jl, jh; }	int64;
typedef	struct { uint32 ujl, ujh; }	uint64;
#endif

#if SIZEOF_VOIDP == 4
typedef uint32			uintp;
#elif SIZEOF_VOIDP == 8
typedef uint64			uintp;
#else
#error "sizeof(void*) must be 4 or 8"
#endif

typedef enum _bool {
	false	= 0,
	true	= 1,
} bool;

/* Do we have native support for 64bit types */
#if SIZEOF_LONG_LONG == 8 || SIZEOF___INT64 == 8
#define	HAVE_NATIVE_INT64
#endif

typedef uint8			jchar;
typedef int8			jbyte;
typedef int16                   jshort;
typedef int32                   jint;
typedef int64                   jlong;
typedef void*                   jref;
typedef float                   jfloat;
typedef double                  jdouble;

typedef uint8			u1;
typedef uint16			u2;
typedef uint32			u4;

typedef	u1			nativecode;

#define	SHIFT_jchar		0
#define	SHIFT_jbyte		0
#define	SHIFT_jshort		1
#define	SHIFT_jint		2
#define	SHIFT_jlong		3
#define	SHIFT_jref		2
#define	SHIFT_jfloat		2
#define	SHIFT_jdouble		3

#endif
