/*
 * gc-incremental.h
 * The garbage collector.
 *
 * WORK IN PROGRESS - DO NOT USE !!
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>, 1996.
 */

#ifndef __gc_h
#define __gc_h

/* This is the incremental garbage collector */
#define	GC_INCREMENTAL

/* The default poolsize */
#define	DEFAULT_POOLSIZE	(2 * 1024 * 1024)

/* The maximum poolsize log2 */
#define	MAX_POOLSIZE		31

/* Map entry */
typedef struct _mapEntry {
	uint8			flags;
} mapEntry;

/* Data size covered by a single map entry - currently 64 bytes */
#define	MAP_UNIT_SHIFT		6
#define	MAP_UNIT_SIZE		(1 << MAP_UNIT_SHIFT)

/* Map flags & macros */
#define	MAP_FREE		0x00
#define	MAP_ALLOC		0x40
#define	MAP_TOUCHED		0x80
#define	MAP_USED		0xFF	/* Set by mutator */

#define	MAP_INT_TOUCHED		0x80808080

#define	MAP2ADDR(_e)							\
	(allocBase + (((_e) - mapBase) << MAP_UNIT_SHIFT))
#define	ADDR2MAP(_a)							\
	(mapBase + (((void*)(_a) - allocBase) >> MAP_UNIT_SHIFT))

#define	VALID_HEAPADDR(_a)						\
	((uintp)((_a) - allocBase) < allocSize)
#define	VALID_OBJECT(_a)						\
	(ADDR2MAP(_a)->flags & MAP_ALLOC)


/* Freelist pool */
typedef struct _poolEntry {
	struct _poolEntry*	next;
} poolEntry;

typedef struct _freePool {
	poolEntry*		first;
	uint32			size;
} freePool;

#define	NR_FREELISTS		(MAX_POOLSIZE - MAP_UNIT_SHIFT)

/* GC structure */
typedef struct _gcHead {
	int		colour;
	int		size;
	struct _gcHead*	nextGrey;
	struct _gcHead*	nextRoot;
} gcHead;

#define	INITGC(_o)	(_o).gc.colour = 0;				\
			(_o).gc.nextGrey = 0;				\
			(_o).gc.nextRoot = 0

/* Grey object lists */

#define	COLOUR_WHITE	0
#define	COLOUR_GREY	1
#define	COLOUR_BLACK	2

#define	GREYOBJECT(_a)							\
	((gcHead*)(_a))->colour = COLOUR_GREY;				\
	greyTail->nextGrey = (gcHead*)(_a);				\
	greyTail = ((gcHead*)(_a))

#define	IS_WHITEOBJECT(_a)						\
	(((gcHead*)(_a))->colour == COLOUR_WHITE)

struct _classes;
void*	newObject(int, struct _classes*, int, bool);
void	invokeGarbageCollector(void);

#endif
