/*
 * errors.h
 * Error return codes.
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>, 1996.
 */

#ifndef __errors_h
#define __errors_h

struct _classes;
struct _object;

extern struct _object* execute_java_constructor(void*, char*, struct _classes*, char*, ...);

#define	NoSuchMethodError \
	execute_java_constructor(0, "java.lang.NoSuchMethodError" , 0, "()V")
#define	ClassFormatError \
	execute_java_constructor(0, "java.lang.ClassFormatError" , 0, "()V")
#define	LinkageError \
	execute_java_constructor(0, "java.lang.LinkageError" , 0, "()V")
#define	ClassNotFoundException \
	execute_java_constructor(0, "java.lang.ClassNotFoundException" , 0, "()V")
#define	NoSuchFieldError \
	execute_java_constructor(0, "java.lang.NoSuchFieldError" , 0, "()V")
#define	OutOfMemoryError \
	execute_java_constructor(0, "java.lang.OutOfMemoryError" , 0, "()V")
#define	UnsatisfiedLinkError \
	execute_java_constructor(0, "java.lang.UnsatisfiedLinkError" , 0, "()V")
#define	VirtualMachineError \
	execute_java_constructor(0, "java.lang.VirtualMachineError" , 0, "()V")
#define	ClassCircularityError \
	execute_java_constructor(0, "java.lang.ClassCircularityError" , 0, "()V")
#define	NegativeArraySizeException \
	execute_java_constructor(0, "java.lang.NegativeArraySizeException" , 0, "()V")
#define	ClassCastException \
	execute_java_constructor(0, "java.lang.ClassCastException" , 0, "()V")
#define	IllegalMonitorStateException \
	execute_java_constructor(0, "java.lang.IllegalMonitorStateException" , 0, "()V")
#define	NullPointerException \
	execute_java_constructor(0, "java.lang.NullPointerException" , 0, "()V")
#define	ArrayIndexOutOfBoundsException \
	execute_java_constructor(0, "java.lang.ArrayIndexOutOfBoundsException" , 0, "()V")
#define	ArithmeticException \
	execute_java_constructor(0, "java.lang.ArithmeticException" , 0, "()V")

#endif
