/*
 * m68k/amigados/md.h
 * AmigaOS specific functions.
 *
 * Copyright (c) 1996 Matthias Hopf <mshopf@informatik.uni-erlangen.de>
 *
 * Permission granted for Tim Wilkinson to include this source in his
 * Kaffe system, Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */

#ifndef __m68k_amigados_md_h
#define __m68k_amigados_md_h


#include <sys/time.h>                 /* don't change! */
struct timerequest;                   /* Hack!! needed to get files including md.h *and* sys/time.h before working. */
#define DEVICES_TIMER_H  1            /* devices/timer.h (included from exec/exec.h) is broken due to an other struct timeval definition. */

#ifdef IMPORT                         /* Hack!! needed to get rid of IMPORT redefined warnings */
#  define _AMIGA_IMPORT    IMPORT
#  undef  IMPORT
#endif

#include <stdio.h>

#include <exec/exec.h>
#include <proto/exec.h>

/* #include "m68k/amigados/threads.h" */

#include "m68k/threads.h"


extern struct Task *AmigaThisTask;


#undef  THREADINFO
#define THREADINFO(ee)                                               \
		  do {                                               \
		      AmigaThisTask = FindTask (NULL);               \
		      M68K_THREADINFO (ee);                          \
		      if ((uint8 *) AmigaThisTask->tc_SPLower > (ee)->stackBase) \
		      {                                              \
			  fprintf (stderr, "stack size too low - stack left: %ld, stack needed: %ld\n", \
				   (ee)->stackEnd - (uint8 *) AmigaThisTask->tc_SPLower, threadStackSize); \
			  exit (20);                                 \
		      }                                              \
		  } while (0)

#undef  THREADSWITCH
/* we should use StackSwap instead of native code, but that would be too
 * complicated and extra overhead...
 * we *should* surround this with Forbid()/Permit() (Task struct stack
 * consistency), but overhead is too high. */
#define THREADSWITCH(to, from)                                       \
		  do {                                               \
		      AmigaThisTask->tc_SPLower = (to)->stackBase;   \
		      AmigaThisTask->tc_SPUpper = (to)->stackEnd;    \
DBG(                  printf ("setting task stack info from %x to %x\n", (to)->stackBase, (to)->stackEnd); ) \
		      M68K_THREADSWITCH(to, from);                   \
		  } while (0)

#if defined(TRANSLATOR)
#include "m68k/jit-md.h"
#endif

#undef  IMPORT
#ifdef _AMIGA_IMPORT
#  define IMPORT        _AMIGA_IMPORT
#  undef  _AMIGA_IMPORT
#endif

#endif
