/*
 * config-math.h
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>
 */

#ifndef __config_math_h
#define __config_math_h

#include <math.h>

#if defined(HAVE_REMAINDER)
#elif defined(HAVE_FMOD)
#define	remainder	fmod
#else
#error "Need some form of remainder"
#endif
#if !defined(HAVE_REMAINDERF)
#define	remainderf(a, b) (float)remainder((double)a, (double)b)
#endif

/* If we dont' have isinf() assume nothing is */
#if !defined(HAVE_ISINF)
#define	isinf(x)	0
#endif
/* If we don't have isnan() assume nothing is */
#if !defined(HAVE_ISNAN)
#define	isnan(x)	0
#endif

#endif
