/*
 * thread.h
 * Thread support.
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#ifndef __thread_h
#define __thread_h

#define	THREADCLASS		"java/lang/Thread"

#define	MIN_THREAD_PRIO		1
#define	NORM_THREAD_PRIO	5
#define	MAX_THREAD_PRIO		10

#define	THREAD_SUSPENDED	0
#define	THREAD_RUNNING		1
#define	THREAD_DEAD		2

typedef struct _ctx {
	void*			restorePoint;
	void*			stackBase;
	void*			stackEnd;
} ctx;

struct _stringClass;
struct _object;

/* This structure mirrors java.lang.ThreadGroup.h */
typedef struct _threadGroup {
	object			obj;
	struct _threadGroup*	parent;
	struct _stringClass*	name;
	long			maxPrio;
	long			destroyed;
	long			daemon;
	long			nthreads;
	struct _object*		threads;
	long			ngroups;
	struct _object*		groups;
} threadGroup;

/* This structure mirrors java.lang.Thread.h */
typedef struct _thread {
	object			obj;
	object*			name;
	long			priority;
	struct _thread*		next;
	long			PrivateInfo;
	ctx*			eetop;
	long			single_step;
	long			daemon;
	long			stillborn;
	object*			target;
	threadGroup*		group;
} thread;

extern thread* currentThread;

void initThreads(void);
void startThread(thread*);
void resumeThread(thread*);
void suspendThread(thread*);
void suspendOnQThread(thread*, thread**);
void yieldThread(void);
void killThread(thread*);
void setPriorityThread(thread*, int);

void reschedule(void);

extern int blockInts;
extern bool needReschedule;

#define	intsDisable()	blockInts++
#define	intsRestore()	if (blockInts == 1 && needReschedule == true) {	\
				reschedule();				\
			}						\
			blockInts--

#endif
