/*
 * code.c
 * Process a new code attribute.
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include "gtypes.h"
#include "file.h"
#include "errors.h"
#include "bytecode.h"
#include "code.h"
#include "classMethod.h"

void
addCode(methods* m, uint32 len, classFile* fp)
{
	Code c;
	int i;
	u2 i2;

	readu2(&c.max_stack, fp);
	readu2(&c.max_locals, fp);
	readu4(&c.code_length, fp);
	c.code = malloc(c.code_length);
	if (c.code == 0) {
		throwException(OutOfMemoryError);
	}
	readm(c.code, c.code_length, sizeof(bytecode), fp);
	readu2(&c.exception_table_length, fp);
	c.exception_table = malloc(c.exception_table_length * sizeof(exception));
	if (c.exception_table == 0) {
		throwException(OutOfMemoryError);
	}
	for (i = 0; i < c.exception_table_length; i++) {
		readu2(&i2, fp);
		c.exception_table[i].start_pc = i2;
		readu2(&i2, fp);
		c.exception_table[i].end_pc = i2;
		readu2(&i2, fp);
		c.exception_table[i].handler_pc = i2;
		readu2(&i2, fp);
		if (i2 == 0) {
			c.exception_table[i].catch_type = 0;
		}
		else {
			assert(m->constants->tags[i2] == CONSTANT_Class);
			c.exception_table[i].catch_type = (char*)m->constants->data[CLASS_NAME(i2, m->constants)];
		}
	}
	addMethodCode(m, &c);

	readAttributes(fp, m->class, m);
}
