/*
 * main.c
 * Generate native code stubs from .class files.
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#include <stdio.h>

#define	BUFSZ	100

FILE* include;
FILE* stub;
char className[BUFSZ];
char superName[BUFSZ];
char pathName[BUFSZ];
char includeName[BUFSZ];
char stubName[BUFSZ];

/*
 * MAIN
 */
int
main(int argc, char* argv[])
{
	FILE* fp;
	char* nm;
	int i;

	if (argc != 2) {
		fprintf(stderr, "Usage: kaffeh <classname>\n");
		exit(1);
	}

	nm = argv[1];

	for (i = 0; nm[i] != 0; i++) {
		switch (nm[i]) {
		case '/':
		case '.':
			className[i] = '_';
			pathName[i] = '/';
			includeName[i] = '.';
			stubName[i] = '.';
			break;
		default:
			className[i] = nm[i];
			pathName[i] = nm[i];
			includeName[i] = nm[i];
			stubName[i] = nm[i];
			break;
		}
	}
	className[i] = 0;
	pathName[i] = 0;
	includeName[i] = 0;
	stubName[i] = 0;
	strcat(pathName, ".class");
	strcat(includeName, ".h");
	strcat(stubName, "Stub.c");

	fp = fopen(pathName, "r");;
	if (fp == 0) {
		fprintf(stderr, "Failed to open '%s'.\n", pathName);
		exit(1);
	}
	include = fopen(includeName, "w");;
	if (include == 0) {
		fprintf(stderr, "Failed to create '%s'.\n", includeName);
		exit(1);
	}
	stub = fopen(stubName, "w");;
	if (stub == 0) {
		fprintf(stderr, "Failed to create '%s'.\n", stubName);
		exit(1);
	}

	fprintf(stub, "/* DO NOT EDIT THIS FILE - it is machine generated */\n");
	fprintf(stub, "#include <stubPreamble.h>\n");
	fprintf(stub, "/* Stubs for class %s */\n", className);
	readClass(fp);
	fprintf(include, "\n#endif\n");

	exit(0);
}
