/* WIDE AREA INFORMATION SERVER SOFTWARE:
   No guarantees or restrictions.  See the readme file for the full standard
   disclaimer.

   This is part of the shell user-interface for the WAIS software.  Do with it
   as you please.

   jonathan@Think.COM
*/

/* Copyright (c) CNIDR (see ../doc/CNIDR/COPYRIGHT) */


/* $Log: util.h,v $
 * Revision 1.1.1.1  1996/06/04 20:38:50  julia
 * autoconf baseline
 *
 * Revision 1.1.1.1  1996/04/30 18:22:47  dmitriy
 * Version 2.1 -- autoconf baseline
 *
 * Revision 1.1.1.2  1996/04/23  19:47:49  dmitriy
 * autoconf baseline
 *
 * Revision 2.0.1.1  1995/09/15 09:57:28  pfeifer
 * patch7: Fixed CNIDR copyright line.
 *
 * Revision 2.0  1995/09/08  08:07:21  pfeifer
 * Metaconfig baseline
 *
 * Revision 1.2  1994/08/05  07:27:41  pfeifer
 * Release beta 04
 *
 * Revision 1.1  1993/02/16  15:10:18  freewais
 * Initial revision
 *
 * Revision 1.9  92/06/22  10:49:36  jonathan
 * ?
 * 
 * Revision 1.8  92/06/15  13:49:09  jonathan
 * Removed define for PrintStatus - that's in ui/status.h now.
 * 
 * Revision 1.7  92/06/03  17:07:42  jonathan
 * Added action to RebuildListWidget, along with defines for the actions.
 * Modifed RebuildListWidget to scroll the viewport and not kill the
 * listwidget.  Mucho cleanero.
 * 
 * Revision 1.6  92/04/28  15:32:11  jonathan
 * Modified prototypes for new functionality.
 * 
 * Revision 1.5  92/03/23  16:10:14  jonathan
 * Nothing much.
 * 
 * Revision 1.4  92/03/17  14:19:26  jonathan
 * fixed header
 * 
 */

#ifndef _H_UTIL
#define _H_UTIL

#define LIST_TOP 1
#define LIST_BOTTOM 2
#define LIST_NONE 0

int get_selected_item (Widget w);
int listlength (List list);
int charlistlength (char **list);
void PrintStatusW (char * str, Widget w, boolean replacep);
void XwaisPrintf (char * str);
void ReplaceText (Widget w, char * str);
void ReplaceAsciiText (Widget w, char * str);
Widget MakeCommandButton (Widget box, char* name, XtCallbackProc function,
			      Widget vlink, Widget hlink, caddr_t data);
Widget MakeListWidget (Widget parent, String name, char **list,
			   XtCallbackProc callback, Widget vlink,Widget hlink);
void RebuildListWidget (ScrollList s, String *list, long action);
ScrollList MakeScrollList (Widget parent, String name, String* items,
			       XtCallbackProc callback, 
			       Widget vlink, Widget hlink);
Widget MakeStringBox (Widget parent, String name, String string,
			  Widget vlink, Widget hlink);
#ifdef MOTIF
Widget MakeScrolledText (Widget parent, String name, String string,
			  Widget vlink, Widget hlink);
#endif
String GetString (Widget w);
Widget MakeLabel (Widget parent, char* name, char* label,
		      Widget vlink, Widget hlink);
int find_string_slot (char* source, char* key, char* value,
			  long value_size, boolean delete_internal_quotes);
void find_value (char* source, char* key, char* value, int value_size);
void SortSources (void);
char* get_filename (char* name);
void Feep (void);
char** GetDirNames (char* directory);
void EndHelp (Widget w, XtPointer closure, XtPointer call_data);
void XwaisHelp (Widget w, XtPointer closure, XtPointer call_data);
#endif
