.\" This is -*-nroff-*-
.\" XXX standard disclaimer belongs here....
.\" $Header: /usr/local/cvsroot/postgres95/doc/man/copy.l,v 1.6 1996/07/31 18:42:41 scrappy Exp $
.TH COPY SQL 11/05/95 Postgres95 Postgres95
.SH NAME
copy \(em copy data to or from a class from or to a Unix file.
.SH SYNOPSIS
.nf
\fBcopy\fP [\fBbinary\fP] [\fBnonulls\fP] classname 
	\fBto\fP|\fBfrom\fP "filename"|\fBstdin\fR|\fBstdout\fR
	[\fBUSING DELIMITERS\fP delim]
.fi
.SH DESCRIPTION
.BR Copy
moves data between Postgres classes and standard Unix files.  The
keyword
.BR binary
changes the behavior of field formatting, as described below.
.IR Classname
is the name of an existing class.
.IR Filename
is the Unix pathname of the file.  In place of a filename, the
keywords
.BR "stdin" " and " "stdout"
can be used so that input to
.BR copy
can be written by a Libpq application and output from the
.BR copy
command can be read by a Libpq application.  The
.BR binary
keyword will force all data to be stored/read as binary objects rather
than as ASCII text.  It is somewhat faster than the normal
.BR copy
command, but is not generally portable, and the files generated are
somewhat larger, although this factor is highly dependent on the data
itself.
.PP
By default,
.BR copy
uses a tab (\\t) character as a delimiter.  The delimiter may also be changed
to any other single-character with the use of 
.BR "USING DELIMITERS"
Characters in data fields which happen to match the delimiter character
will be quoted.
.PP
You must have read access on any class whose values are read by the 
.BR copy
command, and either write or append access to a class to which values
are being appended by the
.BR copy
command.
.SH FORMAT OF OUTPUT FILES
.SS "ASCII COPY FORMAT"
When
.BR copy
is used without the
.BR binary
keyword, the file generated will have each instance on a line, with
each attribute separated by the delimiter character.  Embedded delimiter
characters will be preceeded by a backslash character (\\).  The
attribute values themselves are strings generated by the output function
associated with each attribute type.  The output function for a type
should not try to generate the backslash character; this will be handled
by 
.BR copy
itself.
.PP
Note that on input to 
.BR copy ,
backslashes are considered to be special control characters, and
should be doubled if you want to embed a backslash, i.e., the string
\*(lq12\\\\19\\88\*(rq will be converted by
.BR copy
to \*(lq12\\1988\*(rq.  The actual format for each instance is
.nf
<attr1><tab><attr2><tab>...<tab><attrn><newline>
.fi
.PP
If 
.BR copy
is sending its output to standard output instead of a file, it will
send a period (.) followed immediately by a newline, on a line by
themselves, when it is done.  Similarly, if
.BR copy
is reading from standard input, it will expect a period (.) followed
by a newline, as the first two characters on a line, to denote
end-of-file.  However,
.BR copy
will terminate (followed by the backend itself) if a true EOF is
encountered.
.PP
.BR NULL
attributes are handled simply as null strings, that is, consecutive
tabs in the input file denote a
.BR NULL
attribute.
.SS "BINARY COPY FORMAT"
In the case of
.BR "copy binary" ,
the first four bytes in the file will be the number of instances in
the file.  If this number is
.IR zero,
the
.BR "copy binary"
command will read until end of file is encountered.  Otherwise, it
will stop reading when this number of instances has been read.
Remaining data in the file will be ignored.
.PP
The format for each instance in the file is as follows.  Note that
this format must be followed
.BR EXACTLY .
Unsigned four-byte integer quantities are called uint32 in the below
description.
.nf
uint32 totallength (not including itself),
uint32 number of null attributes
[uint32 attribute number of first null attribute
 ...
 uint32 attribute number of nth null attribute],
<data>
.fi
.bp
.SS "ALIGNMENT OF BINARY DATA"
On Sun-3s, 2-byte attributes are aligned on two-byte boundaries, and
all larger attributes are aligned on four-byte boundaries.  Character
attributes are aligned on single-byte boundaries.  On other machines,
all attributes larger than 1 byte are aligned on four-byte boundaries.
Note that variable length attributes are preceded by the attribute's
length; arrays are simply contiguous streams of the array element
type.
.SH "SEE ALSO"
insert(l), create table(l), vacuum(l), libpq.
.SH BUGS
Files used as arguments to the
.BR copy
command must reside on or be accessible to the the database server
machine by being either on local disks or a networked file system.
.PP
.BR Copy
stops operation at the first error.  This should not lead to problems
in the event of a
.BR "copy from" ,
but the target relation will, of course, be partially modified in a
.BR "copy to" .
The 
.IR vacuum (l)
query should be used to clean up after a failed
.BR "copy" .
.PP
Because Postgres operates out of a different directory than the user's
working directory at the time Postgres is invoked, the result of copying
to a file \*(lqfoo\*(rq (without additional path information) may
yield unexpected results for the naive user.  In this case,
\*(lqfoo\*(rq will wind up in
.SM $PGDATA\c
/foo.  In general, the full pathname should be used when specifying
files to be copied.
.PP
.BR Copy
has virtually no error checking, and a malformed input file will
likely cause the backend to crash.  You should avoid using 
.BR copy
for input whenever possible.
