#include <ingres.h>
#include <ildr.h>
#include <lock.h>
#include <sccs.h>
#include <signal.h>

SCCSID(%W%	%G%)

int   dolock();

/*
 *	LOCKREQ.C
 *
 *	This file contains code for the client half of the lock
 *	driver system.
 *
 */

static	int	pid;


int
dolock(lock)
struct	lockreq	*lock;
{
	struct	Lockreq		slock;
	auto	int		ret_val;
	extern	int		Alockdes;

	/* translate lock to slock */
	slock.lr_act = lock->lract;
	slock.lr_type = lock->lrtype;
	slock.lr_mod = lock->lrmod;
	/* this bcopy copys three char [4] fields into one char [12] field
	   KEYSIZE happens to equal 12 */
	bcopy(lock->dbnode, slock.lr_key, KEYSIZE);	/* XXX */
	if (write(Alockdes, &slock, sizeof(slock)) != sizeof(slock))
	  syserr("lock write fail");
	if (read(Alockdes, &ret_val, sizeof(int)) != sizeof(int))
	  syserr("lock read fail");
	/* translate ret_val */
	return(ret_val);
}
