/*
 * A safer saner malloc, for careless programmers
 * $Revision: 6.21 $
 *
 * Revision History:
 * Jul 18/93 -- Danny Quah 
 *    __GO32__ or __NeXT__ already prototyped (dies otherwise).
 *    Also tweaks in malloc/realloc calls.
 */

#ifndef lint
  static char Sccsid[] = "%W% %G%";
#endif

#include <stdio.h>
#include "curs_sup.h"
#include "ss.h"

#if !defined(__GO32__) && !defined(__NeXT__)
  extern char *malloc();
  extern char *realloc();
  extern void free();
#endif /* !!__GO32__ || !!__NeXT__ */

void	fatal();

#ifdef SYSV3
  extern void free();
  extern void exit();
#endif

#define	MAGIC	(double)1234567890.12344

char *
scxmalloc(n)
unsigned n;
{
	register char *ptr;

/* Mon Jul 19 07:47:30 1993 -- Danny Quah 
 *
 *	if ((ptr = malloc(n + sizeof(double))) == NULL)
 * 	  fatal("scxmalloc: no memory");
 */
	if ((ptr = (char *) malloc(n + sizeof(double))) == (char *) NULL)
          fatal("scxmalloc: no memory");
	*((double *) ptr) = MAGIC;		/* magic number */
	return(ptr + sizeof(double));
}

/* we make sure realloc will do a malloc if needed */
char *
scxrealloc(ptr, n)
char	*ptr;
unsigned n;
{
	if (ptr == NULL)
		return(scxmalloc(n));

	ptr -= sizeof(double);
	if (*((double *) ptr) != MAGIC)
		fatal("scxrealloc: storage not scxmalloc'ed");

/* Mon Jul 19 07:48:31 1993 -- Danny Quah 
 *
 *	if ((ptr = realloc(ptr, n + sizeof(double))) == NULL)
 *		fatal("scxmalloc: no memory");
 */
	if ((ptr = (char *) realloc(ptr, n + sizeof(double))) == (char *) NULL)
          fatal("scxmalloc: no memory");          
	*((double *) ptr) = MAGIC;		/* magic number */
	return(ptr + sizeof(double));
}

void
scxfree(p)
char *p;
{
	if (p == NULL)
		fatal("scxfree: NULL");
	p -= sizeof(double);
	if (*((double *) p) != MAGIC)
		fatal("scxfree: storage not malloc'ed");
	free(p);
}

#ifdef PSC
void
fatal(str)
char *str;
{
    (void) fprintf(stderr,"%s\n", str);
    exit(1);
}
#else
void
fatal(str)
char *str;
{
    deraw();
    (void) fprintf(stderr,"%s\n", str);
    diesave();
    exit(1);
}
#endif /* PSC */
