/**********************************************************************
* %M%
* ss 	:	A SpreadSheet Program
*
* Art's Spreadsheet program.          Art Mulder ( art@cs.ualberta.ca )
* University of Alberta, Department of Computing Science.
***********************************************************************
* Menu Driver
***********************************************************************
* Functions for displaying the command menus and processing the 
* related input.
* NOTE: this is not the ONLY interface to the user.
* These functions are used exclusively by ss.c
**********************************************************************/
#ifndef lint
  static char Sccsid[] = "%W% %G%";
#endif

/*
 * Include files
 */
#include <stdio.h>
#include <sys/types.h>
#include <signal.h>
#include "curs_sup.h"
#include <ctype.h>

/*
** #ifdef BSD42
** # include <strings.h>
** #else
** # ifndef SYSIII
** #   include <string.h>
** # endif
** #endif
*/

#include "ss.h"
#include "keys.h"
#include "menu.h"
#include "m_file.h"
#include "m_edit.h"
#include "m_cell.h"
#include "m_rowcol.h"
#include "m_view.h"
#include "m_misc.h"

#include "m_macro.h"
#include "m_name.h"
#include "getinput.h"


/*	Function Prototypes (lib func's)
 *----------------------------------------------------------------------
 */
    extern	char	*getenv();

/*	External Global variables
 *----------------------------------------------------------------------
 */
    extern int showneed;	/* From main.c */
    extern int  showrange;	/* ditto */
    extern int running;		/* ditto */
    extern int anychanged; 	/* ditto */
    extern int showexpr;	/* ditto */
    extern int ClearScreen;	/* ditto */

    extern int input_method;	/* from ss.c */

    extern int lastmx, lastmy;	/* From screen.c */
    extern int lastcol, lcols;	/* ditto */

/*	Internal Macros
 *----------------------------------------------------------------------
 */

#define BACK_UP	1		/* signals: back up one menu level */

/*	Internal Function Prototypes
 ***********************************************************************
 */

static int Menu();
static int FileMenu();
static int EditMenu();     
static int CellMenu();
static int RowColumnMenu();
static int NameMenu();
static int ViewMenu();
static int InputMenu();
static int MiscMenu();
static int MacroMenu();
static int OptionsMenu();
static int TblMenu();

/*	Externally Accessible Functions
 ***********************************************************************
 */

void MainMenu()
/*----------------------------------------------------------------------
** Top command level/menu.  Invoked by the "/" command
*/
{
#   define MainSize 10
    static char MainKeys[] =  {'F', 'E', 'C',   'R', 'O', 'V','I','M','Q','N'};
    static char *MainDesc[] = {"File","Edit", "Cell","Row", "Column", "View",
	"Input", "Misc", "Quit", "Name"};
    static char *MainHelp[] = {
      "sub-menu: Operations for loading/saving the Spreadsheet file.",
      "sub-menu: General Editing Operations.",
      "sub-menu: Operations that affect the current cell only.",
      "sub-menu: General Row Operations.",
      "sub-menu: General Column Operations.",
      "sub-menu: Operations that affect your View of the Spreadsheet.",
      "sub-menu: Operations that control Input to the Spreadsheet.",
      "sub-menu: Miscellaneous Operations",
      "Quit from the program (prompts to save any changes)",
      "Display the name of the current Spreadsheet file in memory" };

    int finished = FALSE ;

    while (!finished) {

      switch (Menu(MainSize, MainKeys, MainDesc, MainHelp, MAINHELP)) {

      case 'F': finished = FileMenu();		break;
      case 'E': finished = EditMenu();		break;
      case 'C': finished = CellMenu();		break;
      case 'R': finished = RowColumnMenu(TRUE);	break; /* TRUE = Row */
      case 'O': finished = RowColumnMenu(FALSE);break;
      case 'V': finished = ViewMenu();		break;
      case 'I': finished = InputMenu();		break;
      case 'M': finished = MiscMenu();		break;

      case 'Q': 
	  FileQuit();
	  finished = TRUE;
	  break;
      
      case 'N':
	if (*curfile)
	  Sprintf(message, "** Current filename is \"%s\"", curfile);
	else
	  Sprintf(message, "** Current filename is undefined");
	Message(message);
	/** Refresh(); **/
	finished = TRUE;
	break;

      case ' ' : finished = TRUE;		break;

      case BACK_UP :		/* Can't back up to a higher level menu */
	  finished = TRUE;
	  ClearMessage;
	  break;
      }
    }

} /* MainMenu() */


/*	Internal Functions
***********************************************************************
*/
static int Menu(size, keys, keydesc, keyhelp, helpcontext)
/*----------------------------------------------------------------------
** The Main Menu display function.  Displays a menu and does rough
** preprocessign of the input.  Ensures that only valid input is received,
** also deals with aborts and help requests.
**
** NOTE: The Keys should all be in uppercase.  (if they are letters).
*/
    int 	size;		/* # of elements in keys & keydesc arrays */
    char	keys[];		/* Menu keys */
    char	*keydesc[];	/* Corresponding descriptions of keys */
    char	*keyhelp[];	/* <= 1 line help/description of keys */
    int		helpcontext;	/* A flag to pass along to help() */
/*
 * Size must be a correct number.  Anything else has an undefined effect.
 * No checking is made to ensure that all the keys & descriptions fit
 * across the screen.
 */
{
    int x;
    int  ValidInput;		/* Loop Control */
    int c;			/* input */
  int curpos = 0;		/* current position in keypos[] array */
  int *keypos;			/* array holding key display position on
				   the terminal display line */

    FullUpdate++;		/* to clear the message line */

/* build keypos array */
  keypos = (int *) Malloc( (unsigned) (sizeof(int) * size ) );

/*
 * The Command line is the top line of the display.	starts at(0,0)
 * The message/error line is the second line.		starts at(1,0)
 */

/*
 * 1) Display the Menu on the Command/error line 
 *
 * A menu looking like this should be displayed:
 *	f:File e:Edit o:Options
 * Initially, the first key would be highlighted.
 */
    (void)move(0,0); 		/* Get into position */
    (void)clrtoeol(); 		/* Clear line */

    for (x=0; x < size; x++) {
	if (x==0) {
	  keypos[x] = 0;

	  STANDOUT_START;		/* hi-light first key */
/***	  addstr(keydesc[x]); ***/	/* Key Description */
/* uncomment above line, and comment next 3 lines to stop displaying
 * the 'Key:' part of the menu.  eg: display "File" instead of 
 * "F:File".  Do the same with the following *** commented sections
 * to get all occurances.
 */
	    addch(keys[x]);    			/* Display key */
	    addch(':');                     	/* Separator */
	    addstr(keydesc[x]);			/* Key Description */
	  STANDOUT_END;	
	} else {
	  keypos[x] = keypos[x-1] + strlen(keydesc[x-1]) + 1 + 2;
		/* +1 for space btwn keys, +2 for key & separator. */

/***	  mvaddstr(0,keypos[x], keydesc[x]); ***/	/* Key Description */
	    mvaddch(0,keypos[x], keys[x]); 	/* Display key */
	    addch(':');                     	/* Separator */
	    addstr(keydesc[x]);			/* Key Description */
	}
    }

  Message(keyhelp[0]);

/*
 * 3) Get and Process input
 *
 * Valid Input:
 * a)	A '?' will invoke help.  Pass along 'helpcontext' so that help()
 *	knows from where it was invoked, so context-sensitive help can
 *	be provided.
 * b)	<Space> will Abort the menu.
 * c)   <Del>, <Backspace> will return to the previous (if any) menu.
 * d)	Any of the keys (Case is unimportant) will be accepted as valid
 *	and be returned to the calling routine for processing there.
 * e)	Anything else will result in an error (beep!)
 */
    for (;;) {			/* Forever... */
	c = nmgetch();
	switch (c) {

	case kLEFT:		/* move 'key cursor' left one position */
	  if (curpos > 0) {	/* can't go left any further from '0' */
	    /* re-display the current key, un-hiliting it, and
	     * then move to the next key and redisply it, hi-lighting it.
	     * Finally, display the help text.
	     */
/***	    mvaddstr(0,keypos[curpos], keydesc[curpos]); ***/
	      mvaddch(0,keypos[curpos], keys[curpos]); 	/* Display key */
	      addch(':');                     	/* Separator */
	      addstr(keydesc[curpos]);		/* Key Description */
	    curpos--;
	    STANDOUT_START;
/***	    mvaddstr(0,keypos[curpos], keydesc[curpos]); ***/
	      mvaddch(0,keypos[curpos], keys[curpos]); 	/* Display key */
	      addch(':');                     	/* Separator */
	      addstr(keydesc[curpos]);		/* Key Description */
	    STANDOUT_END;	
	    Message(keyhelp[curpos]);
	  } else
	    beep();		/* error bell */
	  break;
	case kRIGHT:		/* move 'key cursor' right one position */
	  if (curpos < (size-1)) {	/* can't go right any further */
/***	    mvaddstr(0,keypos[curpos], keydesc[curpos]); ***/
	      mvaddch(0,keypos[curpos], keys[curpos]); 	/* Display key */
	      addch(':');                     	/* Separator */
	      addstr(keydesc[curpos]);		/* Key Description */
	    curpos++;
	    STANDOUT_START;
/***	    mvaddstr(0,keypos[curpos], keydesc[curpos]); ***/
	      mvaddch(0,keypos[curpos], keys[curpos]); 	/* Display key */
	      addch(':');                     	/* Separator */
	      addstr(keydesc[curpos]);		/* Key Description */
	    STANDOUT_END;	
	    Message(keyhelp[curpos]);
	  } else
	    beep();		/* error bell */
	  break;

	case '?':		/* Help */
	    /** Context sensitive help **/		/** WRITE THIS **/
	    /* refresh needed? */
	    break;

	case ' ':	/* Space Bar     */
	    ClearMessage;
	    return(c);
	    break;

	case kBS:		/* BackSpace Key */
	case DEL:		/* Delete Key    */
	    return(BACK_UP) ;
	    break;

	case kCR:		/* <CR> selects the current item     */
	    ClearMessage;
	    return(keys[curpos]);
	    break;

	default:
	    c = (char) toupper(c);
	    for (x=0; x < size; x++) {	/* Check if input is valid key */
		if ( c == keys[x]) {
		    ClearMessage;
		    return(c);
		}
	    }
	    beep();		/* error bell */
	    break;
	}
    } 
    /* NOTREACHED */
} /* Menu() */


/**
 ** ADD message to Menu() so we can say
 ** "Insert Row or Column", optionally		???????????
 **/

static int FileMenu()
/*----------------------------------------------------------------------
** File command level/menu.  Invoked from the Main menu
*/
{

/*
 * ADD 'file-new' option sometime?  (Create new spreadsheet)
 */
#   define FileSize 	7
    static char FileKeys[]  = {'L',   'M',    'S',   'A', 'W','T','Q'};
    static char *FileHelp[] = {
      "Load a new spreadsheet file from disk.",
      "Merge a spreadsheet into the current one.",
      "Save the current spreadsheet into a file.",
      "Prompt for a new filename; save the spreadsheet to that file.",
      "Write a text-only listing of the current spreadsheet.",
      "Output a file in a format compatable with the indicated text formatter",
      "Quit from the program (prompts to save any changes)." };

    char tbl_mode[MAXSTR];
/* 
 * Set up menu to show the current mode of ``Tbl Save''
 *	- end up with something like ``Tbl Save(TeX)''
 */
    strcpy(tbl_mode, "Tbl Save(");
    switch (tbl_style) {
    case TBL:		strcat(tbl_mode, "tbl)");	break;
    case TEX:		strcat(tbl_mode, "TeX)");	break;
    case LATEX:		strcat(tbl_mode, "LaTeX)");	break;
    case SLATEX: 	strcat(tbl_mode, "SLaTeX)");	break;
    case FRAME:		strcat(tbl_mode, "FrameMaker)"); break;
    default:		strcat(tbl_mode, "?)");		break;
    }

    {

/*
 * This is an ugly hack, and I apologize for it.  (Art Mulder)
 */
#if defined(__STDC__) && !defined(apollo) /* Ansi C can handle this: */
    char *FileDesc[] = {"Load", "Merge", "Save", "Save As",
	"Write txt", tbl_mode, "Quit"};
#else                                         /* Non-Ansi Can't. */
    static char *FileDesc[] = {"Load", "Merge", "Save", "Save As",
    	"Write txt", "", "Quit"};
    FileDesc[6] = tbl_mode;
#endif

	switch (Menu(FileSize, FileKeys, FileDesc, FileHelp, FILEHELP)) {

	case 'L': 	FileLoad(); 		break;
	case 'M':	FileMerge(); 		break;
	case 'S':	FileSave(); 		break;
	case 'A':	FileSaveAs(); 		break;
	case 'W':	FileWriteTxt(); 	break;
	case 'T':	FileTblSave(tbl_mode); 	break;
	case 'Q':	FileQuit();		break;
	case BACK_UP:	return(FALSE);
	} /* switch */
    } /* filemenu declaration */

    return(TRUE);
} /* FileMenu() */

static int EditMenu()
/*----------------------------------------------------------------------
** Edit command level/menu.  Invoked from the Main menu
** - commands that operate either on the entire worksheet,
**   or on a range of cells.  (see the range commands of sc)
*/
{
#   define EditSize 	8
    static char EditKeys[]  ={'C','E','N','L','U','F','I','V'};
    static char *EditDesc[] ={"Copy", "Erase", "Name", "Lock", "Unlck",
			      "Format", "fIll", "Valueize"};
    static char *EditHelp[] = {
      "Copy a source range to a destination range.  (define range first!)",
      "Clear a range.  (Cleared cells may be retrived with Yank or Merge)",
      "sub-menu: Operations to name cells or ranges of cells.",
      "Lock the current cell -- or range of cells.",
      "Unlock a locked cell -- or range of cells.",
      "Assign a value format string to a range of cells.",
      "Fill a range with constant values; provide starting value & increment.",
      "Remove the expressions from a range, leaving just the values."};

    int finished = FALSE ;

    while (!finished) {
      finished = TRUE ;

      switch (Menu(EditSize, EditKeys, EditDesc, EditHelp, WORKHELP)) {

      case 'C':	EditCopy();		break;
      case 'E': EditErase();		break;
      case 'N':	finished = NameMenu();	break;
      case 'L':	EditLock();		break;
      case 'U': EditUnLock();		break;
      case 'F':	EditFormat();		break;
      case 'I':	EditFill();		break;
      case 'V':	EditValueize();		break;
      case BACK_UP: return(FALSE);
      }
    }

    return(TRUE);
} /* EditMenu() */


static int CellMenu()
/*----------------------------------------------------------------------
** Cell command level/menu.  Invoked from the Main menu
*/
{
# define CellSize 	5
  static char CellKeys[]  ={'G',    'M',    'C', 'L', 'V'};
  static char *CellDesc[] ={"Goto", "Mark", "Copy marked cell",
				  "edit Label", "edit Value"};
  static char *CellHelp[] = {
    "Goto a cell; provide a cell's name, or \"regex\" or number to search for.",
    "Mark the current cell for later copying",
    "Copy a previously marked cell to the current cell",
    "Edit the string associated with the current cell.  (use emacs cmds)",
    "Edit the value associated with the current cell.  (use emacs cmds)"};

    switch (Menu(CellSize, CellKeys, CellDesc, CellHelp, CELLHELP)) {
/**   case 'E':	CellErase();		break; **/
      case 'G':	CellGoto();		break;	
      case 'M':	CellMark();		break;
      case 'C':	CellCopy();		break;
      case 'L':	CellEditLabel();	break;
      case 'V':	CellEditValue();	break;
      case BACK_UP: return(FALSE);
    }
    return(TRUE);

} /* CellMenu() */


static int RowColumnMenu(IsRow)
/*----------------------------------------------------------------------
** Row & Column command level/menu.  Invoked from the Main menu
*/
    int IsRow;
{
    /*
     * The Row & the Column Menu are *ALMOST* identical.
     * "Format: is a Column option only.
     */
# define RowSize 	8
  static char RowKeys[]  ={'I','D','Y','M','C','H','S','V'};
  static char *RowDesc[] ={"Insert", "Delete", "Yank", "Merge", "Copy",
			   "Hide", "Show", "Valueize"};
  static char *RowHelp[] = {
    "Insert # of Rows spanned by the range.  (No range: insert one)",
    "Delete Rows spanned by the range.  (No range: delete current row)",
    "Undelete cells, make room by inserting enough Rows.",
    "Undelete cells, overwriting current cells.",
    "Duplicate the current Row, insert copy to the right of the current row.",
    "Hide the Rows spanned by the range.  (No range: hide the current row)",
    "Show the first hidden Row, starting at the top of the spreadsheet.",
    "Valueize the Rows spanned by the range.  (No range: just the current row)"};

# define ColSize 	9
  static char ColKeys[]  ={'I','D','Y','M','C','H','S','V','F'};
  static char *ColDesc[] ={"Insert", "Delete", "Yank", "Merge", "Copy",
			   "Hide", "Show", "Valueize","Fmt"};
  static char *ColHelp[] = {
    "Insert # of Col's spanned by the range.  (No range: insert one)",
    "Delete Col's spanned by the range.  (No range: delete the current col)",
    "Undelete cells, make room by inserting enough Col's.",
    "Undelete cells, overwriting current cells.",
    "Duplicate the current Col, insert copy below the current one.",
    "Hide the Col's spanned by the range.  (No range: hide the current one)",
    "Show the first hidden Col, starting at the left edge of the spreadsheet.",
    "Valueize the Col's spanned by the range.  (No range: just the current one)",
    "Format the current column (column width, decimal places, type)"};

    int menuchoice;

    if (IsRow == TRUE)		/* Processing a Row */
	menuchoice = Menu(RowSize, RowKeys, RowDesc, RowHelp, ROWHELP); 
    else			/* Processing a Column */
	menuchoice = Menu(ColSize, ColKeys, ColDesc, ColHelp, ROWHELP);
    
    switch (menuchoice) {

      case 'I':	RCInsert(IsRow);	break; /* Insert */
      case 'D': RCDelete(IsRow);	break; /* Delete */
      case 'Y': RCYank(IsRow);		break; /* Yank */
      case 'M': RCMerge();		break; /* Merge */
      case 'C': RCCopy(IsRow);		break; /* Copy */
      case 'H': RCHide(IsRow);		break; /* Hide */
      case 'S': RCShow(IsRow);		break; /* Show */
      case 'V': RCValueize(IsRow);	break; /* Valueize */
      case 'F': ColFormat();		break; /* Format Column */
      case BACK_UP: return(FALSE);
    }
    return(TRUE);

} /* RowColumnMenu() */


static int NameMenu()
/*----------------------------------------------------------------------
** Name command level/sub-menu.  Invoked from the Top-Level Edit menu.
*/
{
#   define NSize 	3
    static char NKeys[]  ={'D','E','S'};
    static char *NDesc[] ={"Define Name", "Erase Name", "Show Names"};
    static char *NHelp[] = {
      "Define a name for a range of cells.  (No range: name the current cell)",
      "Erase name assigned to range.  (No range: prompt for a name to erase)",
      "List all Names that have been assigned to cells, or ranges of cells."
      };

    switch (Menu(NSize, NKeys, NDesc, NHelp, WNHELP)) {

      case 'D':	NameDefine();	break; /* Define a name */
      case 'E':	NameErase();	break; /* Erase a name */
      case 'S':	NameShow();	break; /* Show all names */
      case BACK_UP: return(FALSE);
    }
    return(TRUE);

} /* NameMenu() */

static int ViewMenu()
/*----------------------------------------------------------------------
** View menu.  Invoked from the Main menu
*/
{
#   define ViewSize 	5
    static char ViewKeys[]  ={'C','T','V','E','R'};
    static char *ViewDesc[] ={ "Cell hiliting", "Top line disp.",
		"show Values", "show Expr.", "Recalc"};
    static char *ViewHelp[] = {
      "Enable/Disable current cell highlighting.",
      "Enable/Disable Top line display of current cell's contents.",
      "Redraw screen: highlight cells containing values.",
      "Redraw screen: highlight cells containing expressions.",
      "Recalculate the spreadsheet now."
      };

    int finished = FALSE ;

    while (!finished) {
      finished = TRUE;
      switch (Menu(ViewSize, ViewKeys, ViewDesc, ViewHelp, VIEWHELP)) {
	case 'C':	/* Cell Highlight */
	    showcell = (! showcell);
	    repaint(lastmx, lastmy, fwidth[lastcol]);
	    Message ("** Cell highlighting %sabled.", showcell ? "en" : "dis");
	    modflg++;           /* So Settings get saved in Spreadsheet file */
	    break;
	case 'T':	/* Top Line Display */
	    showtop = (! showtop);
	    Message ("** Top line display of cell contents %sabled.",
		showtop ? "en" : "dis");
	    modflg++;           /* So Settings get saved in Spreadsheet file */
	    break;

	case 'V': ViewRedraw(TRUE); 	break; /* Hilite Value-Cells */
	case 'E': ViewRedraw_Expr(); 	break; /* Hilite Exp'ns-Cells */
	case 'R': ViewRecalc(); 	break; /* Recalc Spreadsheet */
	case BACK_UP: return(FALSE);
      }
    }
    return(TRUE);

} /* ViewMenu() */

static int InputMenu()
/*----------------------------------------------------------------------
** Input commands menu.  Invoked from the Main menu
*/
{
#   define InputSize 	8
  static char InputKeys[]  ={'A','L','R','N','Z','C','P','M'};
  static char *InputDesc[] ={"Auto", "Label", "Round",
	      "Newline act'n", "Limits", "CR term.", "Pre-scale", "Macro"};
  static char *InputHelp[] = {
    "Enable/Disable automatic recalculation of the spreadsheet.",
    "Enable/Disable auto labeling of named ranges",
    "Toggle between: .5 rounds up / .5 rounds to even (Banker's round: default).",
    "Toggle: after a <CR> move nowhere / down / right / in 'last' direction.",
    "Set row/column limits on the Newline Action option.",
    "Toggle: <CR>-only termination of cell data entry / Arrow keys also.",
    "Enable/Disable dollar prescale (auto-multiply numbers by .01).",
    "sub-menu: Macro operations."
    };

  int finished = FALSE ;

  while (!finished) {
    finished = TRUE;
    switch (Menu(InputSize, InputKeys, InputDesc, InputHelp, INPUTHELP)) {
      case 'A': 	/* Auto Recalc */
	  autocalc ^= 1;
	  Message("** Automatic recalculation %sabled.", autocalc ? "en":"dis");
	  break;
      case 'L':	/* Auto Labeling */
	  autolabel = (! autolabel);
	  Message ("** Autolabel %sabled.", autolabel? "en" : "dis");
	  break;

      case 'R': /* Rounding */
	  rndinfinity ^= 1;
	  if (rndinfinity == 1)
	    Message("** Round-to-infinity (.5 rounds up) enabled");
	  else
	    Message("** Round-to-even (Banker's Round -> .5 rounds to nearest even #) enabled");
	  break;

      case 'N':	/* Newline Action */
	  ++craction;
	  if(craction >  CR_MAX)
	      craction = 0;
	  switch(craction) {
	  default:
	      craction = 0; 			/* fall through */
	  case 0:
	    Message("** After a <CR> the Cell Cursor stays put.");
	    break;
	  case CRROWS:
	    Message("** After a <CR> the Cell Cursor moves down one row.");
	    break;
	  case CRCOLS:
	    Message("** After a <CR> the Cell Cursor moves right one column.");
	    break;
	  case CRLAST:
	    Message("** After a <CR> the Cell Cursor moves in the 'last' direction entered.");
	    break;
	  }
	  break;

      case 'Z':		/* Set Row/Col Limits */
	  rowlimit = currow;
	  collimit = curcol;
	  Message("** Row and column limits set");
	  break;

      case 'C':			/* CR terminate */
	input_method ^= 1;
	if (input_method == CR_TERMINATED)
	  Message("** Cell data entry must be terminated with a <CR>");
	else
	  Message("** Cell data entry can be terminated with Arrow Keys/<CR>");
	break;

      case '$': 	 	/* WorkSheet - Options - Prescale $ */
	  if (prescale == 1.0) {
	    Message ("** Prescale enabled.  (Numbers are multiplied by .01)");
	    prescale = 0.01;
	  } else {
	    prescale = 1.0;
	    Message ("** Prescale disabled.");
	  }
	  break;
      case 'M': finished = MacroMenu();		break;
      case BACK_UP: return(FALSE);
    }
  }
  modflg++;           /* So options get saved in Spreadsheet file */

  return(TRUE);

} /* InputMenu() */

static int MiscMenu()
/*----------------------------------------------------------------------
** Misc commands menu.  Invoked from the Main menu
*/
{
#if !defined(VMS) && !defined(MSDOS) && defined(CRYPT_PATH)
#   define MiscSize 	6
#else	/* No Encryption */
  /* As long as the 'encrypt' item remains *last* in the menu, then
   * simply reducing the size by 1 is enough to ensure that it
   * does not appear
   */
#   define MiscSize 	5
#endif
    static char MiscKeys[]  ={'!','E','I','R','T' ,'X'};
    static char *MiscDesc[] ={"Shell cmd", "Ext fn's",
		"Iterations", "Recalc Ordr", "Table Sty", "Encrypt" };
    static char *MiscHelp[] = {
      "Run a shell command.  !! repeats the last shell command.",
      "Enable/Disable execution of external functions",
      "Set Max # of recalc iterations before an error is displayed.",
      "Toggle: set recalc order of spreadsheet to be by columns / by rows.",
      "sub-menu: choose Table output style.",
      "Enable/Disable encryption of spreadsheet files."
      };

    int finished = FALSE ;

while (!finished) {
  finished = TRUE;
  switch (Menu(MiscSize, MiscKeys, MiscDesc, MiscHelp, MISCHELP)) {

#if !defined(VMS) && !defined(MSDOS) && defined(CRYPT_PATH)
    case 'X': 	/* Encrypt */
      Crypt = (! Crypt);
      Message ("** Encryption %sabled.", Crypt? "en" : "dis");
      modflg++;           /* So options get saved in Spreadsheet file */
      break;
#endif

    case '!': MiscShell(); 		break; /* Execute a Shell command */
    case 'E':	/* Ext Funcs */
      extfunc = (! extfunc);
      Message ("** External functions %sabled.", extfunc? "en" : "dis");
      modflg++;           /* So options get saved in Spreadsheet file */
      break;
    case 'I':	/* Iterations=? */
      Sprintf(message, "** Enter max # iterations (currently: %d)", propagation);
      Message(message);
      buff = gi_line(FALSE);
      ABORT_AND_RETURN_IF_BUFF_NULL;
      Sprintf (line, "set iterations=%s", buff);
      ClearMessage;
      PROCESS_line;
      modflg++;           /* So options get saved in Spreadsheet file */
      break;

    case 'R':	/* Byrows or Bycols recalc? */
      if (calc_order == BYROWS) {
	calc_order = BYCOLS;
	Message("** Calculation order is by rows");
      } else {
	calc_order = BYROWS;
	Message("** Calculation order is by columns");
      }
      modflg++;           /* So options get saved in Spreadsheet file */
      break;

    case 'T': finished = TblMenu();		break;

    case BACK_UP: return(FALSE);
  }
}
return(TRUE);

} /* MiscMenu() */


static int MacroMenu()
/*----------------------------------------------------------------------
** Macro command level/menu.  Invoked from the Main menu
*/
{
#   define MacroSize 	2
    static char MacroKeys[]  = {'R',  'D',    };
    static char *MacroDesc[] = {"Run","Define"};
    static char *MacroHelp[] = {
      "Run a ss spreadsheet file as a macro",
      "Define a path for the run command to use"
      };

    switch (Menu(MacroSize, MacroKeys, MacroDesc, MacroHelp, MACROHELP)) {
      case 'R':	MacroRun();	break; /* Run macros */
      case 'D':	MacroDefine();	break; /* Define path */
      case BACK_UP: return(FALSE);
    }
    return(TRUE);

} /* MacroMenu() */

static int TblMenu()
/*----------------------------------------------------------------------
** Table output style menu.  Invoked from the Misc menu.
** Choose the output style used with the '/-File-Tbl output' option.
*/
{
#   define TblSize 	6
    static char TblKeys[]  = {'N',  'T', 'X', 'L','S','F'    };
    static char *TblDesc[] = {"None","tbl","tex","latex","slatex","frame"};
    static char *TblHelp[] = {
      "Define No table style.  (Or reset to null from another style)",
      "Use tbl delimeters around the data when performing a Tbl Save",
      "Use TeX delimeters around the data when performing a Tbl Save",
      "Use LaTeX delimeters around the data when performing a Tbl Save",
      "Use sLaTeX delimeters around the data when performing a Tbl Save",
      "Use Frame delimeters around the data when performing a Tbl Save",
      };

    switch (Menu(TblSize, TblKeys, TblDesc, TblHelp, TBLHELP)) {
      case 'N':	tbl_style = 0;      Message("** set tblstyle=0"); break;
      case 'T':	tbl_style = TBL;    Message("** set tblstyle=tbl"); break;
      case 'X':	tbl_style = TEX;    Message("** set tblstyle=TeX"); break;
      case 'L':	tbl_style = LATEX;  Message("** set tblstyle=LaTeX"); break;
      case 'S':	tbl_style = SLATEX; Message("** set tblstyle=sLaTeX"); break;
      case 'F':	tbl_style = FRAME;  Message("** set tblstyle=Frame"); break;

      case BACK_UP: return(FALSE);
    }
    modflg++;           /* So options get saved in Spreadsheet file */

    return(TRUE);

} /* TblMenu() */

/**********************************************************************
*       End
**********************************************************************/
