/**********************************************************************
* %M%
* Art Mulder ( art@cs.ualberta.ca )
* University of Alberta, Department of Computing Science.
***********************************************************************
* View Menu Operations
***********************************************************************
**********************************************************************/
#ifndef lint
  static char Sccsid[] = "%W% %G%";
#endif

/*
 * Include files
 */
#include <stdio.h>
#include <string.h>
#include <signal.h>
#include "curs_sup.h"
#include <stdlib.h>

#include "ss.h"
#include "getinput.h"
#include "m_view.h"

/*	Internal Macros & Data Structures
 *----------------------------------------------------------------------
 */
 


/*	External Global variables
 *----------------------------------------------------------------------
 */
    extern int showneed;        /* From main.c */
    extern int anychanged;      /* ditto */
    extern int showexpr;        /* ditto */
    extern int ClearScreen;     /* ditto */


/*	Externally Accessible Functions
 ***********************************************************************
 */

void ViewRedraw(show_values)
/*----------------------------------------------------------------------
** Redraw the screen, Highlight Cells containing Values if
** ``show_values'' is true.
*/
    int show_values;
{

    if (show_values == TRUE) { 
	Message("** All Highlighted cells contain Values.");
	showneed = 1;
    }
    FullUpdate++;
    ClearScreen++;
    (void) clearok(stdscr,1);

    /* Centering the display with cursor for middle */
    if(currow > (LINES-RESROW)/2)
	strow = currow - ((LINES-RESROW)/2);

} /* ViewRedraw() */

void ViewRedraw_Expr()
/*----------------------------------------------------------------------
** Redraw the screen, Highlight Cells containing Expressions 
*/
{
    Message("** All Highlighted cells contain Expressions.");

    FullUpdate++;
    showexpr = 1;
    (void) clearok(stdscr,1);
}

void ViewRecalc()
/*----------------------------------------------------------------------
** Recalculate the Spreadsheet.
*/
{
    ClearMessage;
    EvalAll ();
    changed = 0;
    anychanged = TRUE;
    Message("** Spreadsheet Recalculated.");
}

/**********************************************************************
*       End
**********************************************************************/
