/**********************************************************************
* %W% %G%
*
* ss    :       A SpreadSheet Program
*
* Art's Spreadsheet program.          Art Mulder ( art@cs.ualberta.ca )
* University of Alberta, Department of Computing Science.
***********************************************************************
* Header file for Curses-Related stuff
**********************************************************************/

#ifndef curs_sup
#  define curs_sup

/*
 * For Dec/Ultrix you have to include cursesX.h in order to get the
 * Unix System-V curses stuff.
 */
#if defined(ULTRIX)
#  include <cursesX.h>
#else	/* not Ultrix */
#  include <curses.h>
#endif

#ifndef A_STANDOUT      /* Should be defined in curses.h but if not... */

/* From: Danny Quah (dquah@pc386nb), Jul 18 1993,
 *  __GO32__ curses has no A_STANDOUT
 */
#  if !defined(__GO32__)
#   define A_STANDOUT _STANDOUT 
#  else
#   define A_STANDOUT 0
#  endif

#endif /* !defined A_STANDOUT */

/*
 * Start/Stop "standout" mode
 *	BSDI doesn't have 'attron() / attrof()' in its Curses library.
 *	In case some other OS's don't have 'standout() / standend()', we
 *	make the change here via an MACRO so it is easily toggled.
 *	NeXT doesn't either.  (13Feb94, russell@alpha3.ersys.edmonton.ab.ca)
 *	Or HP/Apollo. (16Feb94, Thomas Dickey, dickey@software.org)
 *	Or DOS w/djgpp. (16Feb94, Thomas Dickey, dickey@software.org)
 */
#if defined (__bsdi__) || defined (__NeXT__) || defined(apollo) || defined(__GO32__)
# define STANDOUT_START	standout()
# define STANDOUT_END	standend()
#else
# define STANDOUT_START	attron(A_STANDOUT)
# define STANDOUT_END	attroff(A_STANDOUT)
#endif

/*
 * Take care of some system specific curses definitions
 */
#ifndef A_CHARTEXT      /* Should be defined in curses.h */
# ifdef INTERNATIONAL
#   define A_CHARTEXT 0xff
# else
#   define A_CHARTEXT 0x7f
# endif
#endif

/*
 * beep() not in NeXT curses; check, then put here.  
 */
#if defined(__NeXT__)
#  define beep() putchar(7)
#endif

#endif /* ifndef curs_sup */
/*----------------------------------------------------------------------
 *	End
 */
