#ifndef lint
static char rcsid[] = "$Header: sys-5r4.c,v 1.7 1993/07/16 00:29:37 forys Exp $";
#endif

/*
**  This program may be freely redistributed for noncommercial purposes.
**  This entire comment MUST remain intact.
**
**  Sunos-5 support by Ric Anderson (ric@cs.arizona.edu)
**
**  Copyright 1993 by Jeff Forys (forys@syl.nj.nec.com)
*/


#define	NO_MEXTERN
#include "conf.h"
#undef	NO_MEXTERN

#include <sys/user.h>
#include <sys/proc.h>
#include <sys/priocntl.h>
#include <sys/tspriocntl.h>

#if !defined(P_PID)
#include <sys/procset.h>
#endif

#include <dirent.h>
#include <stdio.h>

/*
 * Define SigNames, NSig, and TtyDevDir here; they are used by other
 * routines and must be global.  Everyone seems to have their own
 * idea as to what NSIG should be.  Here, `NSig' is the number of
 * signals available, not counting zero.
 */
char *SigMap[] = { "0",
	"HUP", "INT", "QUIT", "ILL", "TRAP", "IOT",		/*  1 -  6 */
	"EMT", "FPE", "KILL", "BUS", "SEGV", "SYS",		/*  7 - 12 */
	"PIPE", "ALRM", "TERM", "USR1", "USR2", "CHLD",		/* 13 - 18 */
	"PWR", "WINCH", "URG", "POLL", "STOP", "TSTP",		/* 19 - 24 */
	"CONT", "TTIN", "TTOU", "VTALRM", "PROF", "XCPU",	/* 25 - 30 */
	"XFS2", "WAITING", "LWP"				/* 31 - 33 */
};
int NSig = NSIG-1;

#define	SETCMD(dst,src,maxlen) {			\
	extern char *strrchr();				\
	if (maxlen > 0) src[maxlen] = '\0';		\
	dst = (dst = strrchr(src, '/')) ? ++dst: src;	\
}

static char *TtyDevDir = "/dev";

int	Skill;			/* set 1 if running `skill', 0 if `snice' */
int	PrioMin, PrioMax;	/* min and max process priorities */
int	SigPri;			/* signal to send or priority to set */
pid_T	MyPid;			/* pid of this process */
uid_T	MyUid;			/* uid of this process */
char	*ProgName;		/* program name */

/*
 * This is the machine-dependent initialization routine.
 *
 *   - The following global variables must be initialized:
 *     MyPid, MyUid, ProgName, Skill, PrioMin, PrioMax, SigPri
 *   - The working directory will be changed to that which contains the
 *     tty devices (`TtyDevDir'); this makes argument parsing go faster.
 *   - If possible, this routine should raise the priority of this process.
 */

void skill_getpri(int *low, int *high);
int skill_setpri(pid_t pid,int niceval);

MdepInit(pname)
	char *pname;
{
	extern char *rindex(), *SysErr();

	MyPid = (pid_T) getpid();
	MyUid = (uid_T) getuid();
	SETCMD(ProgName, pname, 0)

	/*
	 * Set up minimum and maximum process priorities.
	 * Initialize SigPri to either default signal (`skill') or
	 * default priority (`snice').
	 */
	skill_getpri(&PrioMin,&PrioMax);
	/*
	 * If we are running as root, raise our priority to better
	 * catch runaway processes.
	 */
	if (MyUid == ROOTUID)
		(void) skill_setpri(MyPid, PrioMax);

	/*
	 * Determine what we are doing to processes we find.  We will
	 * either send them a signal (skill), or renice them (snice).
	 */
	Skill = (strcmp(ProgName, "snice") != 0);

	/*
	 * chdir to `TtyDevDir' to speed up tty argument parsing.
	 */
	if (chdir(TtyDevDir) < 0) {
		fprintf(stderr, "%s: chdir(%s): %s\n", ProgName, TtyDevDir,
		        SysErr());
		exit(EX_SERR);
	}
	SigPri = Skill? SIGTERM: 4;
}

/*
 * Carry out an action on a particular process.  If this is `skill',
 * then send the process a signal, otherwise this is `snice' so change
 * it's priority.
 *
 * If 0 is returned, the operation was successful, otherwise -1 is
 * returned and `errno' set.
 */
int
MdepAction(pid)
{
	if (Skill)
		return(kill(pid, SigPri));
	else
		return(skill_setpri(pid, SigPri));
}

/*
 * Now, set up everything we need to write a GetProc() routine.
 */

#include <sys/procfs.h>

#include <fcntl.h>


static char *procd =	"/proc";	/* proc direcotry */
static char *procf =	"/proc/%s";	/* proc images */


static	struct	proc *procp;
static  DIR     *dirfp = NULL;


/*
 * GetProc()
 *
 * Fill in and return a `struct ProcInfo' with information about the
 * next process.  If no processes are left, return NULL.
 */
struct ProcInfo *
GetProc()
{	char buf[FILENAME_MAX];
	int fd;
	extern char *SysErr();
	struct dirent *d;
	struct prpsinfo pinfo;
	static char *exiting = "<exiting>";
	static char *zombie = "<defunct>";
	static struct ProcInfo procinfo;

	/*
	 * If this is our first time here, open the proc directory,...
	 */
	if(dirfp == NULL) {
		if ((dirfp = opendir("/proc")) == NULL) {
			fprintf(stderr,"%s: %s: %s\n",ProgName,procd,
			  SysErr());
			exit(EX_SERR);
		}


	}

	while((d = readdir(dirfp)) != NULL) {
		if(strcmp(d->d_name,".") == 0  ||
		  strcmp(d->d_name,"..") == 0)
			continue;
		sprintf(buf,procf,d->d_name);
		if((fd = open(buf,O_RDONLY)) < 0)
			continue;	/* ignore procs we don't own */
		if(ioctl(fd,PIOCPSINFO,&pinfo) == -1) {
			(void) close(fd);
			continue;	/* ignore these too */
		}
		(void) close(fd);
		procinfo.pi_flags = 0;
		procinfo.pi_pid = pinfo.pr_pid;
		procinfo.pi_uid = pinfo.pr_uid;
		if(pinfo.pr_zomb != 0) {
			procinfo.pi_flags |= PI_ZOMBIE;
			procinfo.pi_cmd = zombie;
		}
		else {
			if(pinfo.pr_pid < 5) /* low pids are special */
				procinfo.pi_flags != PI_ASKUSR;
			if(pinfo.pr_lttydev != PRNODEV) {
				procinfo.pi_flags |= PI_CTLTTY;
				procinfo.pi_tty = pinfo.pr_lttydev;
			}
			procinfo.pi_cmd = pinfo.pr_fname;
		}
		return(&procinfo);
	}

	(void) closedir(dirfp);
	dirfp = NULL;
	return((struct ProcInfo *)NULL);
}




/**	skill_getpri - set min/max priority of our process.
 *
 *	void skill_getpri(int *low, int *high);
 *
 *	Entry	low = pointer to cell to receive Minimum value.
 *		high = pointer to cell to receive Maximum value.
 *
 *	Exit	values set.
 */


#define min(a,b)	((a) < (b) ? (a) : (b))

void skill_getpri(int *low, int *high)
{ pcparms_t getparms;
  pcinfo_t getinfo;
  tsparms_t *tparms_p;
  tsinfo_t *tinfo_p;

/* first, read the current parameters for the process.		*/

  (void) memset(&getparms,0,sizeof(getparms));
  getparms.pc_cid = PC_CLNULL;
  if(priocntl(P_PID,P_MYID,PC_GETPARMS,(caddr_t) &getparms) == -1)
    return;
  tparms_p = (tsparms_t *) getparms.pc_clparms;

/* get class info (assumes skill will be in the TS class, but	*/
/* will probably work OK for RT.				*/

  (void) memset(&getinfo,0,sizeof(getinfo));
  getinfo.pc_cid = getparms.pc_cid;
  if(priocntl(P_PID,P_MYID,PC_GETCLINFO,(caddr_t) &getinfo) == -1)
    return;
  tinfo_p = (tsinfo_t *) getinfo.pc_clinfo;

  if(tparms_p->ts_uprilim == 0) {
    *low = -abs(tinfo_p->ts_maxupri);
    *high = abs(tinfo_p->ts_maxupri);
  }
  else {
    *low = -min(abs(tparms_p->ts_uprilim),abs(tinfo_p->ts_maxupri));
    *high = min(abs(tparms_p->ts_uprilim),abs(tinfo_p->ts_maxupri));
  }
  return;
} /* skill_getpri */




/**	skill_setpri - set priority of a process.
 *
 *	int skill_setpri(pid_t pid,int niceval);
 *
 *	Entry	pid = process id of target.
 *		niceval = priority adjustment.
 *
 *	Exit	returns -1 on error, 0 for ok.
 *
 *	Notes	Used in place of setpriority, which doesn't
 *		exist under SunOS5 (Solaris 2) except in BSD
 *		compatability mode.
 */


int skill_setpri(pid_t pid,int niceval)
{ pcparms_t getparms, setprio;
  pcinfo_t getinfo;
  tsparms_t *tset_p;

/* first, read the current parameters for the process.		*/

  (void) memset(&getparms,0,sizeof(getparms));
  getparms.pc_cid = PC_CLNULL;
  if(priocntl(P_PID,pid,PC_GETPARMS,(caddr_t) &getparms) == -1)
    return(-1);

/* get class info and check for TS class - we don't understand	*/
/* other classes.						*/

  (void) memset(&getinfo,0,sizeof(getinfo));
  getinfo.pc_cid = getparms.pc_cid;
  if(priocntl(P_PID,pid,PC_GETCLINFO,(caddr_t) &getinfo) == -1)
    return(-1);
  if(strncmp(getinfo.pc_clname,"TS",2) != 0) {
    fprintf(stderr,"%s: can't change priorities for class \"%s\"\n",
     ProgName,getinfo.pc_clname);
    return(-1);
  }

/* next, use that information plus the niceval to set priority.	*/
/* we use -niceval because skill thinks negative values are 	*/
/* higher priority, but priocntl thinks positive is higher as I	*/
/* read the SunOS 5.1 priocntl(2) man page.			*/

  setprio.pc_cid = getparms.pc_cid;
  tset_p = (tsparms_t *) setprio.pc_clparms;
  tset_p->ts_uprilim = TS_NOCHANGE;
  tset_p->ts_upri = -niceval;
  if(priocntl(P_PID,pid,PC_SETPARMS,(caddr_t) &setprio) == -1)
    return(-1);
  return(0);
} /* skill_setpri */
