Subject: Pcomm patches 1 and 2

This is a shell archive of "patches" to the Pcomm distribution package.
The files found on max.cecer.army.mil alredy have the patches installed
(so don't try to install them again).  These patches are useful to those
who already have a version of Pcomm, but are missing one or more of the
patches.

Emmet P. Gray				US Army, HQ III Corps & Fort Hood
...!uunet!uiucuxc!fthood!egray		Attn: AFZF-DE-ENV
fthood!egray@uxc.cso.uiuc.edu		Directorate of Engineering & Housing
					Environmental Management Office
					Fort Hood, TX 76544-5057

------------------------------------------------------------------------------
#! /bin/sh
# This is a shell archive, meaning:
# 1. Remove everything above the #! /bin/sh line.
# 2. Save the resulting text in a file.
# 3. Execute the file with /bin/sh (not csh) to create:
#	patch.01
#	patch.02
# This archive created: Fri Nov  6 07:50:21 1992
export PATH; PATH=/bin:/usr/bin:$PATH
echo shar: "extracting 'patch.01'" '(37848 characters)'
if test -f 'patch.01'
then
	echo shar: "will not over-write existing file 'patch.01'"
else
sed 's/^X//' << \SHAR_EOF > 'patch.01'
XSubject: Patch #1 to Pcomm v2.0
X
XThis is patch #1 to the Pcomm v2.0 distribution package.  This patch
Xwill correct a minor bug with the external protocol option (when running
Xunder SVR3.2) that prevented Pcomm from detecting the death of the child
Xprocess.
X
XThe rather large size of this patch is do to the numerous changes to the
XDoc.me file.
X
XPcomm v2.0.0 was sent to the moderator of comp.sources.unix on 20 Jul 92.
X
XEmmet P. Gray				US Army, HQ III Corps & Fort Hood
X...!uunet!uiucuxc!fthood!egray		Attn: AFZF-DE-ENV
Xfthood!egray@uxc.cso.uiuc.edu		Directorate of Engineering & Housing
X					Environmental Management Office
X					Fort Hood, TX 76544-5057
X
X------------------------------------------------------------------------------
XPrereq: "2.0.0"
X*** old/patchlevel.h	Mon Jul 20 17:02:59 1992
X--- patchlevel.h	Sun Sep  6 10:19:25 1992
X***************
X*** 1,2 ****
X! #define VERSION "2.0.0"
X! #define DATE "18 Jul 92"
X--- 1,2 ----
X! #define VERSION "2.0.1"
X! #define DATE "6 Sep 92"
X*** old/Configure.sh	Mon Jul 20 17:02:53 1992
X--- Configure.sh	Mon Aug 31 10:32:16 1992
X***************
X*** 108,111 ****
X--- 108,118 ----
X  		fi
X  	fi
X+ 	if [ `grep -c "^truncate.o" /tmp/config.$$` -eq 1 ] ;then
X+ 		echo "You've got the truncate() function"
X+ 		echo "Therefore you need:	#define HAVE_TRUNCATE"
X+ 	else
X+ 		echo "You don't have the truncate() function"
X+ 		echo "Therefore you need:	#undef HAVE_TRUNCATE"
X+ 	fi
X  	rm /tmp/config.$$
X  else
X*** old/Convert.sh	Mon Jul 20 17:02:53 1992
X--- Convert.sh	Wed Jul 22 21:33:04 1992
X***************
X*** 18,22 ****
X  1,$s/D_DBITS=/D_DATA_BITS=/
X  1,$s/D_SBITS=/D_STOP_BITS=/
X! 1,$s/HOT=/HOT_KEY=/
X  1,$s/FLOW=/FLOW_CTRL=/
X  1,$s/LECHO=/LOCAL_ECHO=/
X--- 18,22 ----
X  1,$s/D_DBITS=/D_DATA_BITS=/
X  1,$s/D_SBITS=/D_STOP_BITS=/
X! 1,$s/^HOT=/HOT_KEY=/
X  1,$s/FLOW=/FLOW_CTRL=/
X  1,$s/LECHO=/LOCAL_ECHO=/
X*** old/Doc.me	Mon Jul 20 17:02:54 1992
X--- Doc.me	Mon Aug 31 10:31:31 1992
X***************
X*** 6,12 ****
X  .nr sf 3				\" section font is bold
X  .nr tf 1				\" title font is roman
X- .oh ''Pcomm Reference Manual'Page %'
X- .eh 'Page %'Pcomm Reference Manual''
X  .\" this macro is used to change the proportional font to 12 pitch
X  .de CS
X  .cs R 22
X--- 6,11 ----
X  .nr sf 3				\" section font is bold
X  .nr tf 1				\" title font is roman
X  .\" this macro is used to change the proportional font to 12 pitch
X+ .\" some folks may need ".cs CW" in lieu of ".cs R 22"
X  .de CS
X  .cs R 22
X***************
X*** 13,17 ****
X  ..
X  .\" and this one puts things back
X! .ds Cs
X  .cs R
X  ..
X--- 12,16 ----
X  ..
X  .\" and this one puts things back
X! .de Cs
X  .cs R
X  ..
X***************
X*** 47,51 ****
X--- 46,54 ----
X  program and contains no ProComm source code.  This is not a Datastorm
X  product.
X+ .bp
X+ .oh ''Pcomm Reference Manual'Page %'
X+ .eh 'Page %'Pcomm Reference Manual''
X  .pn 1
X+ .ep
X  .bp
X  .sh 1 INTRODUCTION 
X***************
X*** 201,205 ****
X  The \*(lq\-a\*(rq option is used to specify a script file to be
X  \*(lqplayed\*(rq prior to dialing, to specify the TTY to be use, or to
X! specify the mdoem to be used.  This feature can be used to customize
X  Pcomm options or perform unattended operations.
X  .lp
X--- 204,208 ----
X  The \*(lq\-a\*(rq option is used to specify a script file to be
X  \*(lqplayed\*(rq prior to dialing, to specify the TTY to be use, or to
X! specify the modem to be used.  This feature can be used to customize
X  Pcomm options or perform unattended operations.
X  .lp
X***************
X*** 214,217 ****
X--- 217,221 ----
X  \-o	Set the parity to odd
X  \-n	Set the parity to none
X+ \-w	Set the word length (number of data bits)
X  \-b	Set the baud rate
X  \-p	Dial this number
X***************
X*** 249,252 ****
X--- 253,257 ----
X  .if n .ll 8.5i
X  .CS
X+ .(b L
X  .TS
X  box center;
X***************
X*** 254,257 ****
X--- 259,263 ----
X  ^A-0 HELP 	No TTY 	FDX 	1200 E71 	LOG OFF 	PTR OFF 	CR  	CR  
X  .TE
X+ .)b
X  .Cs
X  .if n .po 1.0i
X***************
X*** 274,279 ****
X  .lp
X  .ft I
X! NOTE:\ \ If the DTE interface speed is locked, the status line will show
X! the "connected" speed rather than the speed of the serial port.
X  .ft
X  .sh 2 "Help screen"
X--- 280,286 ----
X  .lp
X  .ft I
X! NOTE:\ \ If the DTE (Data Terminal Equipment) interface speed is locked,
X! the status line will show the \*(lqconnected\*(rq speed rather than the
X! speed of the serial port.
X  .ft
X  .sh 2 "Help screen"
X***************
X*** 469,473 ****
X  3) Locked speed.  Normally Pcomm will use the baud rate in the dialing
X  directory when talking to the modem.  If the locked speed is non-zero,
X! then the baud rate specified is only one that will ever be use.  The
X  baud rate is selected from a \*(lqmenu prompt\*(rq.  See Appendix C for
X  more information about the use of this feature.
X--- 476,480 ----
X  3) Locked speed.  Normally Pcomm will use the baud rate in the dialing
X  directory when talking to the modem.  If the locked speed is non-zero,
X! then the baud rate specified is the only one that will ever be use.  The
X  baud rate is selected from a \*(lqmenu prompt\*(rq.  See Appendix C for
X  more information about the use of this feature.
X***************
X*** 491,495 ****
X  -------------------------- Modem Setup --------------------------
X  .sp
X!            1) Modem name (1 of 4) ... HAYES
X             2) Modem init string ..... ATS7=60S11=70E0Q0V1X4&D2!
X             3) Dialing command ....... ATDT
X--- 498,502 ----
X  -------------------------- Modem Setup --------------------------
X  .sp
X!            1) Modem name (1 of 5) ... HAYES
X             2) Modem init string ..... ATS7=60S11=70E0Q0V1X4&D2!
X             3) Dialing command ....... ATDT
X***************
X*** 519,523 ****
X  1) Modem name.  This is the key word that links the modem database with
X  the TTY database.  A menu prompt is used to select the modem name (and
X! the remaining parameters that go with it).  The \*(lq(1 of 4)\*(rq field
X  indicates there are additional modems in the database.
X  .lp
X--- 526,530 ----
X  1) Modem name.  This is the key word that links the modem database with
X  the TTY database.  A menu prompt is used to select the modem name (and
X! the remaining parameters that go with it).  The \*(lq(1 of 5)\*(rq field
X  indicates there are additional modems in the database.
X  .lp
X***************
X*** 546,550 ****
X  6) Auto baud detect.  Should Pcomm attempt to change the baud rate of
X  the TTY to the baud rate matching the connect string?  This feature
X! requires the connect strings to be unique.
X  .lp
X  7\-13) Connect strings.  The return messages when the modem has connected
X--- 553,558 ----
X  6) Auto baud detect.  Should Pcomm attempt to change the baud rate of
X  the TTY to the baud rate matching the connect string?  This feature
X! requires the connect strings to be unique.  This does not override the
X! locked speed feature (discussed in section 3.2).
X  .lp
X  7\-13) Connect strings.  The return messages when the modem has connected
X***************
X*** 612,617 ****
X  .lp
X  4) Flow control.  A menu prompt is shown to select between XON/XOFF flow
X! control and NONE.  Pcomm often temporarily disables flow control during
X! file transfers.
X  .lp
X  .ft I
X--- 620,625 ----
X  .lp
X  4) Flow control.  A menu prompt is shown to select between XON/XOFF flow
X! control and NONE.  A value of NONE assumes that the hardware (not Pcomm)
X! will perform the flow control.
X  .lp
X  .ft I
X***************
X*** 957,969 ****
X  \*(lqH\*(rq for half.
X  .lp
X! Auxiliary) This field has one of three uses:
X! .br
X  .in +0.5i
X! 1) Name of the shell script to be used during the auto-login \*(lqchat\*(rq
X  sequence.
X  .br
X! 2) Name of the TTY to be used.
X  .br
X! 3) Name of the Modem to be used.
X  .in
X  .lp
X--- 965,978 ----
X  \*(lqH\*(rq for half.
X  .lp
X! Auxiliary) This field contains the name of a file which has one of three
X! uses:
X! .lp
X  .in +0.5i
X! 1) A shell script to be used during the auto-login \*(lqchat\*(rq
X  sequence.
X  .br
X! 2) A particular TTY to be used for hard-wired ports.
X  .br
X! 3) A customized modem configuration to be used for the entry.
X  .in
X  .lp
X***************
X*** 976,981 ****
X  .lp
X  .ft I
X! NOTE:\ \ The ability to specify a modem allows you to customize each
X! dialing directory entry to use its own peculiar modem initization string.
X  .ft
X  .ba
X--- 985,992 ----
X  .lp
X  .ft I
X! NOTE:\ \ The ability to specify a customized modem configuration allows
X! you to tailor each dialing directory entry to meet the peculiar needs of
X! the modem at the other end of the connection.  See Appendix C for more
X! details.
X  .ft
X  .ba
X***************
X*** 1074,1081 ****
X  the remote system with only a few keystrokes.  The characters used to
X  identify the macros are the shifted number keys.  For example, if the
X! string \*(lqls -alRF \e\| more!\*(rq was assigned to the \*(lq!\*(rq key
X  (the shifted number 1 key), then when you press ^A-!, the string
X  \*(lqls -alRF | more\*(rq is sent to the remote (followed by a <CR>
X! because of the \*(lq!\*(rq character synonym).
X  .lp
X  To review or edit the keyboard macros, you type ^A-M.  The following
X--- 1085,1094 ----
X  the remote system with only a few keystrokes.  The characters used to
X  identify the macros are the shifted number keys.  For example, if the
X! string \*(lqls -alRF \e| more!\*(rq was assigned to the \*(lq!\*(rq key
X  (the shifted number 1 key), then when you press ^A-!, the string
X  \*(lqls -alRF | more\*(rq is sent to the remote (followed by a <CR>
X! because of the \*(lq!\*(rq character synonym).  Notice the use of the
X! \*(lq\e\*(rq character to remove the special meaning of the \*(lg|\*(rq
X! character synonym.
X  .lp
X  To review or edit the keyboard macros, you type ^A-M.  The following
X***************
X*** 1093,1097 ****
X  .sp
X  .\"                                                   spaces out to here
X!   ^A-! ls -alRF \e\| more!                              
X    ^A-@ 
X    ^A-# 
X--- 1106,1110 ----
X  .sp
X  .\"                                                   spaces out to here
X!   ^A-! ls -alRF \e| more!                             
X    ^A-@ 
X    ^A-# 
X***************
X*** 1206,1210 ****
X  .)x
X  .lp
X! Command files (shell scripts) can be envoked by typing ^A-5 to automate
X  keyboard input and to perform Pcomm command sequences.  The following window
X  will prompt for the file name.
X--- 1219,1223 ----
X  .)x
X  .lp
X! Command files (shell scripts) can be invoked by typing ^A-5 to automate
X  keyboard input and to perform Pcomm command sequences.  The following window
X  will prompt for the file name.
X***************
X*** 1224,1228 ****
X  .Cs
X  .lp
X! The use of shell scripts is discussed in Section 8.
X  .bp
X  .if e \{
X--- 1237,1241 ----
X  .Cs
X  .lp
X! The use of shell scripts is discussed in section 8.
X  .bp
X  .if e \{
X***************
X*** 1406,1410 ****
X  .lp
X  .ft I
X! NOTE:\ \ The external protocol feature can also be used (misused?) to pipe
X  the output of a Unix command to the remote.
X  .ft
X--- 1419,1423 ----
X  .lp
X  .ft I
X! NOTE:\ \ The external protocol feature can also be used to pipe
X  the output of a Unix command to the remote.
X  .ft
X***************
X*** 1710,1714 ****
X  .if n .ll 6.5i
X  .lp
X! Items in the window are continously updated to show the progress of the
X  dialing attempt.
X  .lp
X--- 1723,1727 ----
X  .if n .ll 6.5i
X  .lp
X! Items in the window are continuously updated to show the progress of the
X  dialing attempt.
X  .lp
X***************
X*** 1767,1774 ****
X  \*(lqpcomm_cmd\*(rq program is used to transmit command sequences to
X  Pcomm.  For example, a script can contain a line such as \*(lqpcomm_cmd
X! data_log on\*(rq to turn on the data logging feature.  The shell scripts
X! specified in the dialing directory are run \fBafter\fP the connection to
X! the remote system has been made.
X  .lp
X  You may hit the <ESC> key at any time to abort an auto-login script
X  before it has completed.
X--- 1780,1792 ----
X  \*(lqpcomm_cmd\*(rq program is used to transmit command sequences to
X  Pcomm.  For example, a script can contain a line such as \*(lqpcomm_cmd
X! data_log on\*(rq to turn on the data logging feature.
X  .lp
X+ Shell scripts specified in the dialing directory are run \fBafter\fP the
X+ connection to the remote system, while script specified on the command
X+ line (with the \-a option) are run \fBbefore\fP the connection is made.
X+ You can make a shell script work under both situations by using the
X+ \*(lqpcomm_cmd is connected\*(rq command.  See the third example in
X+ section 8.4.
X+ .lp
X  You may hit the <ESC> key at any time to abort an auto-login script
X  before it has completed.
X***************
X*** 1953,1957 ****
X  .br
X  Dial an entry from the dialing directory.  The MANUAL option is used to
X! optionaly dial a phone number without the use of the dialing directory.
X  DIAL returns after 1 attempt.  A return code of 1 means a connection
X  was made.
X--- 1971,1975 ----
X  .br
X  Dial an entry from the dialing directory.  The MANUAL option is used to
X! optionally dial a phone number without the use of the dialing directory.
X  DIAL returns after 1 attempt.  A return code of 1 means a connection
X  was made.
X***************
X*** 2185,2189 ****
X  .lp
X  .(b L
X! The following is an example fo a shell script that will dial a system,
X  log a user on, transfer a file called junk using xmodem, log out, and
X  exit Pcomm.
X--- 2203,2207 ----
X  .lp
X  .(b L
X! The following is an example of a shell script that will dial a system,
X  log a user on, transfer a file called junk using xmodem, log out, and
X  exit Pcomm.
X***************
X*** 2191,2195 ****
X  .in +0.5i
X  .CS
X! # are we allready connected?
X  answer=`pcomm_cmd if connected`
X  if [ "$answer" -eq 0 ]
X--- 2209,2213 ----
X  .in +0.5i
X  .CS
X! # are we already connected?
X  answer=`pcomm_cmd if connected`
X  if [ "$answer" -eq 0 ]
X***************
X*** 2206,2210 ****
X  # wait for the password prompt
X  waitfor assword:
X! # send my passwd
X  echo abcdefg
X  # wait for a Unix prompt
X--- 2224,2228 ----
X  # wait for the password prompt
X  waitfor assword:
X! # send my password
X  echo abcdefg
X  # wait for a Unix prompt
X***************
X*** 2264,2268 ****
X  setup, is ignored.
X  .lp
X! 8) Systems running older versions of uugetty (the bi-directional version
X  of getty that comes with HDB uucp) may require extra commands in the
X  initialization string to assure that uugetty switches to its dial out
X--- 2282,2286 ----
X  setup, is ignored.
X  .lp
X! 7) Systems running older versions of uugetty (the bi-directional version
X  of getty that comes with HDB uucp) may require extra commands in the
X  initialization string to assure that uugetty switches to its dial out
X***************
X*** 2306,2310 ****
X  .lp
X  The dialing codes used by the OBM (On Board Modem) are not
X! straight-forward.  The modem setup, as distributed, looks like this:
X  .br
X  .CS
X--- 2324,2329 ----
X  .lp
X  The dialing codes used by the OBM (On Board Modem) are not
X! straight-forward.  The modem setup, as included in the Unixpc.shar file,
X! looks like this:
X  .br
X  .CS
X***************
X*** 2406,2411 ****
X  .ba
X  .lp
X! The features and complexities of newer high speed intelligent modems
X! avialable today warrants a more detailed discussion.
X  .lp
X  1) Locked interface speed
X--- 2425,2430 ----
X  .ba
X  .lp
X! The features and complexities of the newer high speed intelligent modems
X! available today warrants a more detailed discussion.
X  .lp
X  1) Locked interface speed
X***************
X*** 2418,2422 ****
X  .lp
X  The \*(lqlocked speed\*(rq field of the TTY database was created to
X! solve this problem.  If this value is non-zero, Pcomm wll only use this
X  baud rate when talking to the modem.  The true connected baud rate
X  (14400 for example) will continue to be displayed in the status line.
X--- 2437,2441 ----
X  .lp
X  The \*(lqlocked speed\*(rq field of the TTY database was created to
X! solve this problem.  If this value is non-zero, Pcomm will only use this
X  baud rate when talking to the modem.  The true connected baud rate
X  (14400 for example) will continue to be displayed in the status line.
X***************
X*** 2435,2440 ****
X  database.  For example, you could have an entry called \*(lqTELEBIT\*(rq
X  for normal connections, one called \*(lqTELEBIT_V.32\*(rq for connecting
X! ot older V.32 modems, and another called \*(lqTELEBIT_PEP\*(rq for 
X! connections to othe PEP modems.
X  .lp
X  Pcomm uses the connect strings to determine if the modem can handle the
X--- 2454,2459 ----
X  database.  For example, you could have an entry called \*(lqTELEBIT\*(rq
X  for normal connections, one called \*(lqTELEBIT_V.32\*(rq for connecting
X! to older V.32 modems, and another called \*(lqTELEBIT_PEP\*(rq for 
X! connections to other PEP modems.
X  .lp
X  Pcomm uses the connect strings to determine if the modem can handle the
X***************
X*** 2445,2449 ****
X  specific modem for each dialing directory that my require one.
X  .lp
X! You choices are virtually unlimited...  you can have a separte modem
X  setup to control modem features such as error control, compression,
X  protocol spoofing, etc.
X--- 2464,2473 ----
X  specific modem for each dialing directory that my require one.
X  .lp
X! .ft I
X! NOTE:\ \ The default modem configuration (in a multiple setup situation)
X! must appear first in the modem database.
X! .ft
X! .lp
X! Your choices are virtually unlimited...  you can have a separate modem
X  setup to control modem features such as error control, compression,
X  protocol spoofing, etc.
X***************
X*** 2463,2467 ****
X  L1	Low speaker volume
X  Q2	Use result codes only when dialing out
X! X2	Use the most detailed result codes
X  &C1	Set DCD to follow the carrier
X  &D3	Hard reset on loss of DTR
X--- 2487,2491 ----
X  L1	Low speaker volume
X  Q2	Use result codes only when dialing out
X! X2	Use detailed result codes (connect speeds)
X  &C1	Set DCD to follow the carrier
X  &D3	Hard reset on loss of DTR
X***************
X*** 2469,2473 ****
X  S7=60	Wait at least 60 seconds for a carrier
X  S51=6	Set interface speed to 38400 baud
X! S58=2	Rull duplex RTS/CTS flow control
X  S59=15	Use result code extensions
X  S61=0	Pass modem breaks to the other end
X--- 2493,2497 ----
X  S7=60	Wait at least 60 seconds for a carrier
X  S51=6	Set interface speed to 38400 baud
X! S58=2	Full duplex RTS/CTS flow control
X  S59=15	Use result code extensions
X  S61=0	Pass modem breaks to the other end
X***************
X*** 2487,2491 ****
X  l l c
X  l l l.
X! TTY name	Modem name	Init speed
X  .sp
X  1) tty10	HAYES	0
X--- 2511,2515 ----
X  l l c
X  l l l.
X! TTY name	Modem name	Locked speed
X  .sp
X  1) tty10	HAYES	0
X***************
X*** 2499,2503 ****
X  .in
X  .lp
X! Notice that the last three entries share the same TTY.
X  .ba
X  .lp
X--- 2523,2528 ----
X  .in
X  .lp
X! Notice that the last three entries share the same TTY and are physically
X! the same modem.
X  .ba
X  .lp
X***************
X*** 2607,2612 ****
X  .)b
X  .sp 3
X! .\" Not all versions of nroff can handle a 2 column index
X  .2c
X! .nr xu 2
X  .xp
X--- 2632,2637 ----
X  .)b
X  .sp 3
X! .\" Not all versions of {t,n}roff can handle a 2 column index
X  .2c
X! .nr xu 0.2i
X  .xp
X*** old/Makefile	Mon Jul 20 17:02:55 1992
X--- Makefile	Mon Aug 17 16:30:23 1992
X***************
X*** 21,24 ****
X--- 21,28 ----
X  #LD = /usr/5bin/cc
X  
X+ #for SVR3.2
X+ #SHLIB = -lc_s
X+ #OTHER = -lpt
X+ 
X  LD = cc
X  SHLIB =
X*** old/Matches.1	Mon Jul 20 17:02:55 1992
X--- Matches.1	Sat Aug 22 16:05:44 1992
X***************
X*** 1,3 ****
X! .TH MATCHES 1 local
X  .SH NAME
X  matches \- test if string2 is contained in string1
X--- 1,3 ----
X! .TH matches L
X  .SH NAME
X  matches \- test if string2 is contained in string1
X*** old/Pcomm.1	Mon Jul 20 17:02:55 1992
X--- Pcomm.1	Sat Aug 22 16:05:44 1992
X***************
X*** 4,8 ****
X  .if n .ds lq ""
X  .el .ds lq ``
X! .TH PCOMM 1 local
X  .SH NAME
X  pcomm \- a telecommunication program
X--- 4,8 ----
X  .if n .ds lq ""
X  .el .ds lq ``
X! .TH pcomm L 
X  .SH NAME
X  pcomm \- a telecommunication program
X***************
X*** 56,78 ****
X  and telephone number from the command line.  The normal method of
X  dialing is from the dialing directory.
X  .RS 5
X- .TP
X  .B \-e
X! Set the parity to even.
X! .TP
X  .B \-o
X! Set the parity to odd.
X! .TP
X  .B \-n
X! Set the parity to none.
X! .TP
X  .B \-w
X! Set the word length (number of data bits).
X! .TP
X  .B \-b
X! Set the baud rate.
X! .TP
X  .B \-p
X! Dial this phone number.
X  .RE
X  .PP
X--- 56,78 ----
X  and telephone number from the command line.  The normal method of
X  dialing is from the dialing directory.
X+ .PP
X  .RS 5
X  .B \-e
X! 	Set the parity to even.
X! .br
X  .B \-o
X! 	Set the parity to odd.
X! .br
X  .B \-n
X! 	Set the parity to none.
X! .br
X  .B \-w
X! 	Set the word length (number of data bits).
X! .br
X  .B \-b
X! 	Set the baud rate.
X! .br
X  .B \-p
X! 	Dial this phone number.
X  .RE
X  .PP
X*** old/Pcomm_cmd.1	Mon Jul 20 17:02:56 1992
X--- Pcomm_cmd.1	Sat Aug 22 16:05:44 1992
X***************
X*** 3,7 ****
X  .if n .ds lq ""
X  .el .ds lq ``
X! .TH PCOMM_CMD 1 local
X  .SH NAME
X  pcomm_cmd \- send a command to Pcomm
X--- 3,7 ----
X  .if n .ds lq ""
X  .el .ds lq ``
X! .TH pcomm_cmd L
X  .SH NAME
X  pcomm_cmd \- send a command to Pcomm
X***************
X*** 122,129 ****
X  DIAL returns after 1 attempt.  A return code of 1 means a connection
X  was made.
X! .I
X  The dial function will not be allowed to switch TTY ports.  If the current
X  TTY is not suitable (i.e. not attached to the correct modem), the script
X  will be terminated.
X  .TP
X  REDIAL entry_number
X--- 122,130 ----
X  DIAL returns after 1 attempt.  A return code of 1 means a connection
X  was made.
X! .ft I
X  The dial function will not be allowed to switch TTY ports.  If the current
X  TTY is not suitable (i.e. not attached to the correct modem), the script
X  will be terminated.
X+ .ft
X  .TP
X  REDIAL entry_number
X*** old/Readme	Mon Jul 20 17:02:56 1992
X--- Readme	Sun Sep  6 10:16:01 1992
X***************
X*** 154,157 ****
X--- 154,160 ----
X  			#undef.
X  
X+ 	HAVE_TRUNCATE	Does your system have the truncate() system call?
X+ 			Most modern systems do.
X+ 
X  	3) Edit the Makefile.  There are provisions in the Makefile to
X  	include getcwd(3) and getopt(3) routines if they are missing
X***************
X*** 216,223 ****
X  		&F 	Restores factory settings
X  		L1	Low speaker volume
X! 		X2	Detailed result codes
X  		Q2	Turns on result codes only when dialing out
X! 		&C1	Hard reset on loss of DTR
X! 		&D3	DCD follows the carrier
X  		S0=1	Answer on first ring
X  		S7=60	60 second wait for carrier
X--- 219,226 ----
X  		&F 	Restores factory settings
X  		L1	Low speaker volume
X! 		X2	Detailed result codes (connect speeds)
X  		Q2	Turns on result codes only when dialing out
X! 		&C1	DCD follows the carrier
X! 		&D3	Hard reset on loss of DTR
X  		S0=1	Answer on first ring
X  		S7=60	60 second wait for carrier
X*** old/Release.notes	Mon Jul 20 17:02:56 1992
X--- Release.notes	Sun Sep  6 11:00:40 1992
X***************
X*** 1,2 ****
X--- 1,12 ----
X+ Patch #1, 6 Sep 92
X+ 
X+ This patch will correct a minor bug with the external protocol option
X+ (when running under SVR3.2) that prevented Pcomm from detecting the
X+ death of the child process.
X+ 
X+ The rather large size of this patch is do to the numerous changes to the
X+ Doc.me file.
X+ 
X+ ------------------------------------------------------------------------------
X  			     Pcomm version 2.0
X  				 18 Jul 92
X***************
X*** 51,299 ****
X  
X  	xpcomm - a version of Pcomm using the X window toolkits.
X- 
X- -------------------------------------------------------------------------------
X- 
X- 			     Pcomm version 1.2
X- 				 4 Feb 89
X- 
X- Compatibilities with v1.1:
X- 
X- 	The support files used with the v1.1 release are compatible with
X- 	the v1.2 release.  However, the use of the "index" field (now
X- 	called the "script" field) in the pcomm.dial_dir file has
X- 	changed dramatically (see below).
X- 
X- Things that have changed:
X- 
X- 	Berkeley flavors of Unix are now supported.  There are files
X- 	called tty_att.c and tty_ucb.c that contain the code specific
X- 	to the AT&T and Berkeley worlds.  See the config.h file for
X- 	the BSD pre-processor definition.
X- 
X- 	Auto-login scripts are now supported.  If the script field of
X- 	the dialing directory contains the name of a valid Unix shell
X- 	script, that shell script is "played" after the connection is
X- 	made to perform the auto-login "chat" sequences.  A example of a
X- 	auto-login Bourne shell script (called Sample) is included in
X- 	the distribution.
X- 
X- 	Three new external programs.  In order to assist in the creation
X- 	of the auto-login shell scripts, three external programs are
X- 	included in the distribution.
X- 
X- 		waitfor - wait for a string, return a 1 if timed out
X- 		matches - test if string2 is contained in string1
X- 		modem_break - send a modem break
X- 
X- 	There is a new support file called "pcomm.extrnl" that allows
X- 	the user to embed the names of external file transfer programs
X- 	into the list of available protocols.  (The default file
X- 	"Pcomm.extrnl", supplied with the distribution package, contains
X- 	definitions for zmodem).
X- 
X- 	The pcomm_input program has been changed to use multiple
X- 	character buffered writes to the screen.  Both the input and
X- 	output buffer sizes are tunable parameters in config.h
X- 
X- 	Newer versions of Xenix have changed the rules for creating UUCP
X- 	lock files.  See the config.h file for the description of
X- 	XENIX_LOCKS.
X- 
X- 	The -f option now looks at the name field of the dialing
X- 	directory (rather than the index field).  A match is found when
X- 	the argument to the -f is contained in a name field (an exact
X- 	match is not required).  The match does not consider upper and
X- 	lower case differences as significant.
X- 
X- Known limitations:
X- 
X- 	The detection of VCS (video command sequences) is still limited
X- 	to a very small subset of possible commands.
X- 
X- 	For the VCS emulation to work, the terminfo entries on the host
X- 	machine must match the entries on the remote.  (Don't assume 
X- 	your vt100 terminfo data is identical to someone else's).
X- 
X- 	The disp_tty() routine in s_tty.c currently does not support a
X- 	NUM_TTY definition of greater than 10.
X- 
X- Future directions:
X- 	
X- 	That's about it folks...
X- 
X- 	If Pcomm grows any more, I'll break the setup routines out as a
X- 	separate program.
X- 
X- Many thanks to the following people (and many others) for bug reports
X- and suggested improvements to the code.
X- 
X- 	Andy Fyfe		...ames!elroy!cit-vax!andy
X- 	Brian Antoine		...iscuva!tau-ceti!briana
X- 	Chad R. Larson		...ncar!noao!nud!anasaz!dcfinc!chad
X- 	David MacKenzie		...uunet!rocky2.rockefeller.edu!edf
X- 	Gary S. Trujillo	...{linus,bbn,m2c}!spdcc!gnosys!gst
X- 	George Pontis		...uunet!moldev!geo
X- 	J. Eric Townsend	...uunet!nuchat!flatline!erict
X- 	Jim Pickering		...csun!polyslo!rducky!jrp
X- 	Jim Sanchez		...uunet!mcvax!syteke!jim
X- 	Jonathan Bayer		...uunet!ispi!jbayer
X- 	MAJ Dave Dockstader	...twsc4sac@mater1.arpa
X- 	Michael Brady		...sun!portal!cup.portal.com!michealnc
X- 
X- -------------------------------------------------------------------------------
X- 
X- 			     Pcomm version 1.1
X- 				21 Aug 88
X- 
X- Incompatibilities with v1.0:
X- 
X- 	I've added a few more fields to the pcomm.param and pcomm.modem
X- 	files.  This means that those files created under previous
X- 	releases will not be compatible with the v1.1 release.  It might
X- 	be a good idea to abandon the older files and start over with
X- 	the sample files in this release.
X- 
X- Things that have changed:
X- 
X- 	An awful lot of sloppy programming on my part has now been
X- 	cleaned up.  This means that porting Pcomm to different versions
X- 	of Unix will be considerably less painful than before.
X- 
X- 	All of the tunable parameters are now in "config.h".
X- 
X- 	Pcomm now uses buffered I/O routines.  This yields higher
X- 	performance I/O at large baud rates.
X- 
X- 	File transfers now use high performance CRC calculations.
X- 
X- 	If a UUCP lockfile does exist, Pcomm now attempts to determine
X- 	if the process is still active.
X- 
X- 	An external file transfer program can be invoked from the file
X- 	transfer menu.
X- 
X- 	The keyboard macro feature is now supported (although it is
X- 	rather crude).
X- 
X- 	The virtual screen routine now understands a limited subset of
X- 	escape sequences.
X- 
X- 	The virtual screen can now be held in shared memory or in a file.
X- 
X- 	The input routine is now contained in a separate program called
X- 	pcomm_input.
X- 
X- 	You can now include a "modem break" in a dial or initialization
X- 	string.
X- 
X- 	A separate "initialization speed" feature was added to support
X- 	9600 baud modems such as the Telebit Trailblazer.  See Appendix
X- 	C of the Doc file for more info on the use of this feature.
X- 
X- 	I've added a transparent pass through mode to be used in a
X- 	communications daisy chain.
X- 
X- Known limitations:
X- 
X- 	Whenever Pcomm makes the transition from the terminal mode to
X- 	the command mode, the true screen contents are lost.  Pcomm
X- 	tries to keep track of what the true screen looks like in an
X- 	internal "virtual screen".  This means that the escape sequences
X- 	known to the hardware have to be emulated in the virtual screen.
X- 	Unfortunately, the number of escape sequences that are emulated
X- 	is quite small, so the representation of the true screen is
X- 	sometimes wrong.
X- 
X- 	For the VCS (video command sequence) emulation to work, the
X- 	terminfo entries on the host machine must match the entries on
X- 	the remote.
X- 
X- 	The disp_tty() routine in s_tty.c currently does not support a
X- 	NUM_TTY definition of greater than 10.
X- 
X- Future directions:
X- 
X- 	Continue work on the virtual screen routines.
X- 
X- 	Add dial back support.
X- 
X- 	Use shared memory to overcome the current limitation of outgoing
X- 	characters in the half duplex mode not appearing in the virtual
X- 	screen, log files, and print logs.
X- 
X- Many thanks to the following people for bug reports and ideas for
X- improving the code:
X- 
X- 	Andy Pitts	...{mtune,pacbell,kd4nc}!gladys!rbdc!andy
X- 	Chris Wiener	...ihnp4!{killer,attnssc}!crlabs!cwiener
X- 	David Brierley	...{sun,decuac,cbosgd,gatech,necntc,ukma}!rayssd!dhb
X- 	Karl Fox	...cbosgd!mstar!karl
X- 	Michael Young	...panda!genrad!mrst!sdti!mjy
X- 	Mark Mendel	...ihnp4!umn-cs!hyper!mark
X- 	Viet Hoang	...ihnp4!drutx!vgh
X- 
X- --------------------------------------------------------------------------------
X- 
X- 			     Pcomm version 1.0
X- 				12 Mar 88
X- 
X- Incompatibilities with the beta release:
X- 
X- 	I've added a bunch of new parameters to the pcomm.param and
X- 	pcomm.modem files, so the files used with the beta release won't
X- 	work with the v1.0 release.
X- 
X- Things that have changed:
X- 
X- 	Pcomm will attempt to determine if the modem has synchronized at
X- 	a baud rate different than what is expected, and make changes to
X- 	the line settings as appropriate.
X- 
X- 	The quit and interrupt signals are now ignored.
X- 
X- 	All of the file transfer protocols are now functional.
X- 
X- 	The directory search order used to find the support files has
X- 	been changed slightly.
X- 
X- Known limitations:
X- 
X- 	The keyboard macro feature is not implemented at this time.
X- 
X- 	The true screen contents are lost when the "hot key" is pressed.
X- 	Pcomm attempts to compensate (rather poorly) by repainting a
X- 	virtual screen of what it thinks the true screen should look
X- 	like.  Escape sequences in the virtual screen image will be
X- 	ignored when the background is repainted.  For example, if
X- 	you're on a vt100 and you receive a ^[[2J to clear the screen,
X- 	the screen *will* be cleared...  but when the screen is
X- 	repainted, it will contain the characters ^[, [, 2, J (instead
X- 	of performing the function).
X- 
X- 	The disp_tty() routine in s_tty.c currently does not support a
X- 	NUM_TTY definition of greater than 10.
X- 
X- 	For some strange reason, the first keystroke is "lost" after a
X- 	file transfer is complete or after starting data logging.
X- 
X- Future directions:
X- 
X- 	The virtual screen routines need a lot of work.  The most
X- 	commonly used escape sequences (known to terminfo) will be
X- 	processed.
X- 
X- 	I plan to have an option at compile time to have the virtual
X- 	screen buffer held on disk [] or in shared memory [].
X- 
X- 	The input routine is designed so it could be a standalone
X- 	program that gets called from Pcomm. []
X- 
X- -------------------------------------------------------------------------------
X- 
X- Have fun...
X- 
X- Emmet P. Gray				US Army, HQ III Corps & Fort Hood
X- ...!uunet!uiucuxc!fthood!egray		Attn: AFZF-DE-ENV
X- fthood!egray@uxc.cso.uiuc.edu		Directorate of Engineering & Housing
X- 					Environmental Management Office
X- 					Fort Hood, TX 76544-5057
X--- 61,62 ----
X*** old/Waitfor.1	Mon Jul 20 17:02:57 1992
X--- Waitfor.1	Sat Aug 22 16:05:44 1992
X***************
X*** 1,3 ****
X! .TH WAITFOR 1 local
X  .SH NAME
X  waitfor \- wait for a string to appear on the stdin
X--- 1,3 ----
X! .TH waitfor L
X  .SH NAME
X  waitfor \- wait for a string to appear on the stdin
X*** old/config.h	Mon Jul 20 17:02:57 1992
X--- config.h	Mon Aug 31 10:33:41 1992
X***************
X*** 81,84 ****
X--- 81,87 ----
X  #undef	HAVE_USLEEP
X  
X+ /* Does your system have the truncate() system call? */
X+ #define	HAVE_TRUNCATE
X+ 
X  typedef void SIG_TYPE;
X  /* typedef int SIG_TYPE; */
X*** old/dial.c	Mon Jul 20 17:02:58 1992
X--- dial.c	Sat Aug  1 12:24:21 1992
X***************
X*** 333,337 ****
X  		/*
X  		 * OK.. this is the tricky part.  What if the modem returns
X! 		 * the modulation rate (in lieu of the DTE rate)?  For
X  		 * example, the message is "CONNECT 14400", but the DTE
X  		 * is locked at 38400.
X--- 333,337 ----
X  		/*
X  		 * OK.. this is the tricky part.  What if the modem returns
X! 		 * the connected rate (in lieu of the DTE rate)?  For
X  		 * example, the message is "CONNECT 14400", but the DTE
X  		 * is locked at 38400.
X*** old/input.c	Mon Jul 20 17:02:58 1992
X--- input.c	Sat Jul 25 08:29:30 1992
X***************
X*** 161,164 ****
X--- 161,173 ----
X  				status->col--;
X  			}
X+ 					/* sanity check... */
X+ 			if (status->row < 0)
X+ 				status->row = 0;
X+ 			if (status->col < 0)
X+ 				status->col = 0;
X+ 			if (status->row >= status->max_row)
X+ 				status->row = status->max_row -1;
X+ 			if (status->col >= status->max_col)
X+ 				status->col = status->max_col -1;
X  			break;
X  		case 0:
X*** old/ipc_att.c	Mon Jul 20 17:02:58 1992
X--- ipc_att.c	Mon Aug 10 18:26:53 1992
X***************
X*** 4,7 ****
X--- 4,8 ----
X  
X  #include <stdio.h>
X+ #ifndef MAIN
X  #include <stropts.h>
X  #include <poll.h>
X***************
X*** 10,14 ****
X  #include "ipc.h"
X  
X- #ifndef MAIN
X  #define PSEUDO_TTY	"/dev/ptmx"
X  
X--- 11,14 ----
X*** old/ipc_ucb.c	Mon Jul 20 17:02:59 1992
X--- ipc_ucb.c	Mon Aug 10 18:27:12 1992
X***************
X*** 4,7 ****
X--- 4,8 ----
X  
X  #include <stdio.h>
X+ #ifndef MAIN
X  #include <fcntl.h>
X  #include <sys/time.h>
X***************
X*** 11,15 ****
X  #include "ipc.h"
X  
X- #ifndef MAIN
X  static char pty_name[12];
X  static int fdin_mask, num_fds;
X--- 12,15 ----
X*** old/m_lib.c	Mon Jul 20 17:02:59 1992
X--- m_lib.c	Mon Aug 31 08:09:56 1992
X***************
X*** 41,45 ****
X  	while (fgets(buf, 200, fp) != NULL) {
X  		line++;
X! 		if (tty >= NUM_TTY || mod >= NUM_MODEM)
X  			break;
X  					/* get the token */
X--- 41,45 ----
X  	while (fgets(buf, 200, fp) != NULL) {
X  		line++;
X! 		if (tty > NUM_TTY || mod > NUM_MODEM)
X  			break;
X  					/* get the token */
X*** old/script.c	Mon Jul 20 17:02:59 1992
X--- script.c	Mon Aug 17 16:32:24 1992
X***************
X*** 129,133 ****
X--- 129,137 ----
X  	void ipc_update();
X  
X+ #ifdef BSD
X  	if ((kill(epid, 0) == -1) && errno == ESRCH) {
X+ #else /* BSD */
X+ 	if ((kill(-epid, 0) == -1) && errno == ESRCH) {
X+ #endif /* BSD */
X  					/* shut down the duplication of input */
X  		close(dup_pipe[0]);
X*** old/tty_ucb.c	Mon Jul 20 17:02:59 1992
X--- tty_ucb.c	Sun Sep  6 10:29:27 1992
X***************
X*** 42,46 ****
X  	 * the speed.
X  	 */
X! 	baud = modem->init_sp[modem->t_cur];
X  	if (baud == 0)
X  		baud = dir->baud[0];
X--- 42,46 ----
X  	 * the speed.
X  	 */
X! 	baud = modem->lock_sp[modem->t_cur];
X  	if (baud == 0)
X  		baud = dir->baud[0];
X*** old/x_extrnl.c	Mon Jul 20 17:03:00 1992
X--- x_extrnl.c	Sun Sep  6 10:10:52 1992
X***************
X*** 25,29 ****
X  	extern int fd, errno;
X  	WINDOW *xt_win, *newwin();
X! 	int epid, want_out;
X  	unsigned int sleep();
X  	void _exit(), line_set();
X--- 25,29 ----
X  	extern int fd, errno;
X  	WINDOW *xt_win, *newwin();
X! 	int epid, want_out, dummy;
X  	unsigned int sleep();
X  	void _exit(), line_set();
X***************
X*** 81,87 ****
X--- 81,93 ----
X  			break;
X  					/* see if the process it still active */
X+ #ifdef BSD
X  		if ((kill(epid, 0) == -1) && errno == ESRCH) 
X+ #else /* BSD */
X+ 		if ((kill(-epid, 0) == -1) && errno == ESRCH) 
X+ #endif /* BSD */
X  			break;
X  	}
X+ 					/* no zombies please */
X+ 	wait(&dummy);
X  					/* the tty may have been clobbered */
X  	sleep(1);
X*** old/xmodem.c	Mon Jul 20 17:03:00 1992
X--- xmodem.c	Sun Jul 26 10:19:31 1992
X***************
X*** 257,260 ****
X--- 257,264 ----
X  		return(0);
X  
X+ #ifdef HAVE_TRUNCATE
X+ 	return(uid_truncate(file, len));
X+ #else /* HAVE_TRUNCATE */
X+ 
X  	if (!(fp = uid_fopen(file, "r")))
X  		return(1);
X***************
X*** 304,307 ****
X--- 308,312 ----
X  
X  	return(0);
X+ #endif /* HAVE_TRUNCATE */
X  }
X  
X***************
X*** 389,390 ****
X--- 394,440 ----
X  	return(ret);
X  }
X+ 
X+ #ifdef HAVE_TRUNCATE
X+ static int
X+ uid_truncate(path, len)
X+ char *path;
X+ long len;
X+ {
X+ 	int ret;
X+ 
X+ #ifdef SETUID_BROKE
X+ 	int status;
X+ 	void _exit();
X+ 
X+ 	switch(fork()) {
X+ 		case 0:
X+ 			setuid(getuid());
X+ 			setgid(getgid());
X+ 			_exit(truncate(path, len));
X+ 		case -1:
X+ 			fprintf(stderr, "uid_truncate: Can't fork\n");
X+ 			return(-1);
X+ 		default:
X+ 			if (wait(&status) == -1) {
X+ 				fprintf(stderr, "uid_truncate: wait failed\n");
X+ 				return(-1);
X+ 			}
X+ 			ret = status >> 8;
X+ 	}
X+ #else /* SETUID_BROKE */
X+ 	int euid, egid;
X+ 
X+ 	euid = geteuid();
X+ 	egid = getegid();
X+ 
X+ 	setuid(getuid());
X+ 	setgid(getgid());
X+ 
X+ 	ret = truncate(path, len);
X+ 
X+ 	setuid(euid);
X+ 	setgid(egid);
X+ #endif /* SETUID_BROKE */
X+ 	return(ret);
X+ }
X+ #endif /* HAVE_TRUNCATE */
XEnd of Patch
SHAR_EOF
if test 37848 -ne "`wc -c < 'patch.01'`"
then
	echo shar: "error transmitting 'patch.01'" '(should have been 37848 characters)'
fi
fi
echo shar: "extracting 'patch.02'" '(7874 characters)'
if test -f 'patch.02'
then
	echo shar: "will not over-write existing file 'patch.02'"
else
sed 's/^X//' << \SHAR_EOF > 'patch.02'
XSubject: Patch #2 to Pcomm v2.0
X
XThis is patch #2 to the Pcomm v2.0 distribution package.
X
XThis patch will fix a few problems with possible loss of the inherited
Xenvironment for child processes, and a bug in the data and print logging
Xwhen used during scripts.
X
XEmmet P. Gray				US Army, HQ III Corps & Fort Hood
X...!uunet!uiucuxc!fthood!egray		Attn: AFZF-DE-ENV
Xfthood!egray@uxc.cso.uiuc.edu		Directorate of Engineering & Housing
X					Environmental Management Office
X					Fort Hood, TX 76544-5057
X
X-------------------------------------------------------------------------------
XPrereq: "2.0.1"
X*** old/patchlevel.h	Sun Sep  6 16:06:50 1992
X--- patchlevel.h	Thu Nov  5 08:07:18 1992
X***************
X*** 1,2 ****
X! #define VERSION "2.0.1"
X! #define DATE "6 Sep 92"
X--- 1,2 ----
X! #define VERSION "2.0.2"
X! #define DATE "6 Nov 92"
X*** old/Configure.sh	Sun Sep  6 16:06:45 1992
X--- Configure.sh	Fri Oct  2 07:35:57 1992
X***************
X*** 16,27 ****
X  if [ -d /usr/spool/locks ] ;then
X  	echo "Your UUCP lock files go in /usr/spool/locks"
X! 	echo "Therefore you need:	#define LOCK_FILE \"/usr/spool/locks\""
X  else
X  	if [ -d /usr/spool/uucp/LCK ]; then
X  		echo "Your UUCP lock files go in /usr/spool/uucp/LCK"
X! 		echo "Therefore you need:	#define LOCK_FILE \"/usr/spool/uucp/LCK\""
X  	else
X  		echo "Your UUCP lock files go in /usr/spool/uucp"
X! 		echo "Therefore you need:	#define LOCK_FILE \"/usr/spool/uucp\""
X  	fi
X  fi
X--- 16,27 ----
X  if [ -d /usr/spool/locks ] ;then
X  	echo "Your UUCP lock files go in /usr/spool/locks"
X! 	echo "Therefore you need:	#define LOCK_DIR \"/usr/spool/locks\""
X  else
X  	if [ -d /usr/spool/uucp/LCK ]; then
X  		echo "Your UUCP lock files go in /usr/spool/uucp/LCK"
X! 		echo "Therefore you need:	#define LOCK_DIR \"/usr/spool/uucp/LCK\""
X  	else
X  		echo "Your UUCP lock files go in /usr/spool/uucp"
X! 		echo "Therefore you need:	#define LOCK_DIR \"/usr/spool/uucp\""
X  	fi
X  fi
X*** old/Release.notes	Sun Sep  6 16:06:47 1992
X--- Release.notes	Thu Nov  5 08:25:32 1992
X***************
X*** 1,2 ****
X--- 1,9 ----
X+ Patch #2, 6 Nov 92
X+ 
X+ This patch will fix a few problems with possible loss of the inherited
X+ environment for child processes, and a bug in the data and print logging
X+ when used during scripts.
X+ 
X+ -----------------------------------------------------------------------------
X  Patch #1, 6 Sep 92
X  
X*** old/Unixpc.shar	Sun Sep  6 16:06:47 1992
X--- Unixpc.shar	Fri Oct  2 07:52:11 1992
X***************
X*** 9,15 ****
X  #	Setup.sh
X  #	config.h
X! # This archive created: Fri Jul 17 13:45:30 1992
X  export PATH; PATH=/bin:/usr/bin:$PATH
X! echo shar: "extracting 'Makefile'" '(6623 characters)'
X  if test -f 'Makefile'
X  then
X--- 9,15 ----
X  #	Setup.sh
X  #	config.h
X! # This archive created: Sun Sep  6 13:04:17 1992
X  export PATH; PATH=/bin:/usr/bin:$PATH
X! echo shar: "extracting 'Makefile'" '(6665 characters)'
X  if test -f 'Makefile'
X  then
X***************
X*** 39,42 ****
X--- 39,46 ----
X  X#LD = /usr/5bin/cc
X  X
X+ X#for SVR3.2
X+ X#SHLIB = -lc_s
X+ X#OTHER = -lpt
X+ X
X  X#LD = cc
X  X#SHLIB =
X***************
X*** 223,229 ****
X  Xwaitfor.o:	config.h
X  SHAR_EOF
X! if test 6623 -ne "`wc -c < 'Makefile'`"
X  then
X! 	echo shar: "error transmitting 'Makefile'" '(should have been 6623 characters)'
X  fi
X  fi
X--- 227,233 ----
X  Xwaitfor.o:	config.h
X  SHAR_EOF
X! if test 6665 -ne "`wc -c < 'Makefile'`"
X  then
X! 	echo shar: "error transmitting 'Makefile'" '(should have been 6665 characters)'
X  fi
X  fi
X***************
X*** 504,508 ****
X  fi
X  fi
X! echo shar: "extracting 'config.h'" '(2446 characters)'
X  if test -f 'config.h'
X  then
X--- 508,512 ----
X  fi
X  fi
X! echo shar: "extracting 'config.h'" '(2524 characters)'
X  if test -f 'config.h'
X  then
X***************
X*** 592,595 ****
X--- 596,602 ----
X  X#undef	HAVE_USLEEP
X  X
X+ X/* Does your system have the truncate() system call? */
X+ X#undef	HAVE_TRUNCATE
X+ X
X  X/* typedef void SIG_TYPE; */
X  Xtypedef int SIG_TYPE;
X***************
X*** 600,606 ****
X  X#endif /* BSD */
X  SHAR_EOF
X! if test 2446 -ne "`wc -c < 'config.h'`"
X  then
X! 	echo shar: "error transmitting 'config.h'" '(should have been 2446 characters)'
X  fi
X  fi
X--- 607,613 ----
X  X#endif /* BSD */
X  SHAR_EOF
X! if test 2524 -ne "`wc -c < 'config.h'`"
X  then
X! 	echo shar: "error transmitting 'config.h'" '(should have been 2524 characters)'
X  fi
X  fi
X*** old/cmd.c	Sun Sep  6 16:06:47 1992
X--- cmd.c	Thu Nov  5 10:49:19 1992
X***************
X*** 25,29 ****
X  	char buf[256], *s, arg2[256], *strchr(), *str_rep();
X  	char *entry, *strtok(), ld_code;
X! 	void hang_up(), line_set(), pexit(), screen_dump();
X  
X  	if (ipc_read(status->cmd_ipc, buf, 256))
X--- 25,30 ----
X  	char buf[256], *s, arg2[256], *strchr(), *str_rep();
X  	char *entry, *strtok(), ld_code;
X! 	void hang_up(), line_set(), pexit(), screen_dump(), log_toggle();
X! 	void lpr_toggle();
X  
X  	if (ipc_read(status->cmd_ipc, buf, 256))
X***************
X*** 226,230 ****
X  			break;
X  		case PRINTER:
X! 			status->print_status = arg1;
X  			break;
X  		case MODEM_BREAK:
X--- 227,232 ----
X  			break;
X  		case PRINTER:
X! 			if (status->print_status + arg1 == 1)
X! 				lpr_toggle();
X  			break;
X  		case MODEM_BREAK:
X***************
X*** 241,245 ****
X  			break;
X  		case DATA_LOG:
X! 			status->log_status = arg1;
X  			break;
X  		default:
X--- 243,251 ----
X  			break;
X  		case DATA_LOG:
X! 			if (status->log_status + arg1 == 1) {
X! 				if (arg1 == 1 && !strcmp(status->log_path, "NOT_DEFINED"))
X! 					status->log_path = str_rep(status->log_path, param->logfile);
X! 				log_toggle();
X! 			}
X  			break;
X  		default:
X*** old/pcomm_cmd.c	Sun Sep  6 16:06:50 1992
X--- pcomm_cmd.c	Wed Nov  4 08:40:37 1992
X***************
X*** 33,37 ****
X  	static char *xfer_args[] = {"XMODEM", "XMODEM_1K", "MODEM7", "YMODEM",
X  	"YMODEM_G", "ASCII", "EXT_1", "EXT_2", "EXT_3", 0};
X! 	char *command, buf[40], *mkupper(), *arg1, *arg2, *s, *strchr();
X  	char *pcomm_cmd, *getenv();
X  	int cmd_num, i, arg_num, got_it;
X--- 33,37 ----
X  	static char *xfer_args[] = {"XMODEM", "XMODEM_1K", "MODEM7", "YMODEM",
X  	"YMODEM_G", "ASCII", "EXT_1", "EXT_2", "EXT_3", 0};
X! 	char *command, buf[256], *mkupper(), *arg1, *arg2, *s, *strchr();
X  	char *pcomm_cmd, *getenv();
X  	int cmd_num, i, arg_num, got_it;
X*** old/s_prompt.c	Sun Sep  6 16:06:51 1992
X--- s_prompt.c	Thu Nov  5 08:00:53 1992
X***************
X*** 28,32 ****
X  	wrefresh(win);
X  
X! 	if ((ans = get_str(win, 80, "", "\n")) == NULL)
X  		return(NULL);
X  					/* check the value */
X--- 28,32 ----
X  	wrefresh(win);
X  
X! 	if ((ans = get_str(win, 80, "", ";\n")) == NULL)
X  		return(NULL);
X  					/* check the value */
X*** old/script.c	Sun Sep  6 16:06:52 1992
X--- script.c	Fri Oct  2 07:46:44 1992
X***************
X*** 258,285 ****
X  	int n;
X  	extern char **environ;
X! 	char **envp, buf[80], **temp, *malloc(), *str_dup();
X  
X  					/* how many variables do we have? */
X! 	temp = environ;
X  	n = 0;
X! 	while (*temp != NULL) {
X  		n++;
X! 		temp++;
X  	}
X  
X  	envp = (char **) malloc((n+2) * sizeof(char *));
X! 	temp = envp;
X! 	while (*environ != NULL) {
X  					/* don't copy an old value */
X! 		if (strncmp(*environ, "PCOMM_CMD=", 10)) {
X! 			*temp = str_dup(*environ);
X! 			temp++;
X  		}
X! 		environ++;
X  	}
X  	sprintf(buf, "PCOMM_CMD=%s", key);
X! 	*temp = str_dup(buf);
X! 	temp++;
X! 	*temp = NULL;
X  	return(envp);
X  }
X--- 258,286 ----
X  	int n;
X  	extern char **environ;
X! 	char **envp, buf[80], **old, **new, *malloc(), *str_dup();
X  
X  					/* how many variables do we have? */
X! 	old = environ;
X  	n = 0;
X! 	while (*old != NULL) {
X  		n++;
X! 		old++;
X  	}
X  
X  	envp = (char **) malloc((n+2) * sizeof(char *));
X! 	new = envp;
X! 	old = environ;
X! 	while (*old != NULL) {
X  					/* don't copy an old value */
X! 		if (strncmp(*old, "PCOMM_CMD=", 10)) {
X! 			*new = str_dup(*old);
X! 			new++;
X  		}
X! 		old++;
X  	}
X  	sprintf(buf, "PCOMM_CMD=%s", key);
X! 	*new = str_dup(buf);
X! 	new++;
X! 	*new = NULL;
X  	return(envp);
X  }
XEnd of Patch
SHAR_EOF
if test 7874 -ne "`wc -c < 'patch.02'`"
then
	echo shar: "error transmitting 'patch.02'" '(should have been 7874 characters)'
fi
fi
exit 0
#	End of shell archive
