/*
 * Display the welcome screen and find the Pcomm support files.  Returns a
 * pointer to a static area containing the STATUS structure.
 */

#include <stdio.h>
#include <oldcurses.h>
#include "config.h"
#include "misc.h"
#include "status.h"

static char *extra_dir;

struct STATUS *
init(extra)
char *extra;
{
	int i;
	char *memset(), *str_dup();
	static struct STATUS s;
					/* some defaults */
	s.dup_fd = -1;
	s.cmd_ipc = -1;
	s.connected = 0;
	s.log_status = 0;
	s.log_path = str_dup("NOT_DEFINED");
	s.print_status = 0;
	s.row = 0;
	s.col = 0;
	for (i=0; i<MAX_ROW; i++)
		memset(s.vs[i], '\0', MAX_COL);
	s.max_row = (LINES > MAX_ROW) ? MAX_ROW : LINES; 
	s.max_col = (COLS >= MAX_COL) ? MAX_COL -1 : COLS; 

	extra_dir = str_dup(extra);
	return(&s);
}

/*
 * Search the extra directory (supplied on the command line), then the
 * directory in the PCOMM environmental variable, then the current working
 * directory, and lastly, the default directory.
 */

char *
findfile(name)
char *name;
{
	int i;
	char *pcomm, *getenv(), *path, pbuf[200], *getcwd(), *str_dup();
	char temp[200];

					/* see if PCOMM variable is set */
	pcomm = getenv("PCOMM");
	if (pcomm == NULL || *pcomm == '\0')
		pcomm = NULL;
	else {
					/* zap the trailing separator */
		if (pcomm[strlen(pcomm)-1] == '/')
			pcomm[strlen(pcomm)-1] = '\0';
	}

	for (i=0; i<4; i++) {
					/* directory search order */
		switch (i) {
			case 0:		/* extra directory from command line */
				path = extra_dir;
				break;
			case 1:		/* PCOMM environmental variable */
				path = pcomm;
				break;
			case 2:		/* current working directory */
				path = getcwd(pbuf, 200);
				break;
			case 3:		/* Pcomm's default directory */
				path = DEFAULT_DIR;
				break;
		}
		if (path == NULL)
			continue;

		sprintf(temp, "%s/%s", path, name);
					/* read permission checked */
		if (!access(temp, 4))
			return(str_dup(temp));
	}
	return(NULL);
}
