/* 
        COPYRIGHT (C) 1992, 1993, 1994 Oesterreich & Assc. Inc.

        NOTE: NAG is not free - it is shareware! See 'License Terms'
        in nag/README file

*/



#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include "utils.h"

/* globals */
char	TempFileDir[UBUFSIZE];
char	ErrorMessage[UBUFSIZE];



int 
UtilsInit(void)
{
char	*Tmp;

	/* set a tmp dir - first try env TMP; if no good try standard dirs */

        Tmp=getenv("TMP");
        if(Tmp!=NULL)
        {
		if(access(Tmp,R_OK|W_OK)==0)
		{
			strcpy(TempFileDir,Tmp);
			return(1);
		}
        }
	Tmp="/var/tmp";
	if(access(Tmp,R_OK|W_OK)==0)
	{
		strcpy(TempFileDir,Tmp);
		return(1);
	}
	Tmp="/usr/tmp";
	if(access(Tmp,R_OK|W_OK)==0)
	{
		strcpy(TempFileDir,Tmp);
		return(1);
	}
	Tmp="/tmp";
	if(access(Tmp,R_OK|W_OK)==0)
	{
		strcpy(TempFileDir,Tmp);
		return(1);
	}
	Tmp=".";
	if(access(Tmp,R_OK|W_OK)==0)
	{
		strcpy(TempFileDir,Tmp);
		return(1);
	}
	printf("ERROR: Can't find a usable tmp dir.\n");
	return(0);
}

void
LoIt(char *s)
{
	while(*s)
	{
		if(isupper((int)*s))
		{
			*s=(char)tolower((int)*s);
		}
	s++;
	}
}

void
UpIt(char *s)
{
	while(*s)
	{
		if(islower((int)*s))
		{
			*s=(char)toupper((int)*s);
		}
	s++;
	}
}

void
Trim(char *s)
{
char 	*t;
char	tmp[UBUFSIZE];
int	i;

	if(!s||!strlen(s))return;

	t=s;

	while(isspace((int)*t)&&*t)t++;
	strcpy(tmp,t);

	i=strlen(tmp);
	i--;

	while(isspace((int)tmp[i])&&i)
	{
		tmp[i--]='\0';
	}
	strcpy(s,tmp);
}

/* return value associated with keyword is value != NULL 
   return true (1) if keyword but value == NULL */
int
IsKeyword(char *line,char *delimit, char* keyword,char *value)
{
char	tmp[UBUFSIZE];
char	*s;

	strcpy(tmp,line);
	s=strstr(tmp,delimit);
	if(!s)return 0; /* no delimit; no nothing! */

	*s='\0';

	Trim(tmp); /* nuke trailing & leading spaces */

/*	if(!strcmpi(tmp,keyword)) */
	if(!strcmp(tmp,keyword))
	{
		strcpy(tmp,line);
		s=strstr(tmp,delimit);
		s++;
		Trim(s);
		if(value)strcpy(value,s);
		return 1; /* the keyword */
	}
	return 0;
}


void
GetValue
(char *filename,char* comment,char * keyword,char *delimit,char *value,int occ)
{
FILE	*f;
char	in[UBUFSIZE];
int	count=0;

	strcpy(ErrorMessage,"");
	f=fopen(filename,"rt");
	if(!f)
	{
		sprintf(ErrorMessage,"Cannot open file %s.\n",filename);
		return;
	}
	while(fgets(in,sizeof(in),f))
	{
		Trim(in);
		if(!strncmp(in,comment,strlen(comment)))continue;
		if(IsKeyword(in,delimit,keyword,value))
		{
			count++;
			if(count==occ)
			{
				fclose(f);
				return;
			}
		}

	}
	/* keyword not found */
	fclose(f);
	strcpy(value,"");
}

/* return the max width of fields matching keyword */

int
GetMaxFieldWidth(char *filename,char* comment,char * keyword,char *delimit)
{
FILE	*f;
int	max=0,len,j;
char	in[UBUFSIZE];

	strcpy(ErrorMessage,"");
	if(access(filename,F_OK)==-1)
	{       /* no exists so return 0 */
		return(0);
	}
	f=fopen(filename,"rt");
	if(!f)
	{
		sprintf(ErrorMessage,"Cannot open file %s.\n",filename);
		return;
	}
	while(fgets(in,sizeof(in),f))
	{
		Trim(in);
		if(!strncmp(in,comment,strlen(comment)))continue;
		if(IsKeyword(in,delimit,keyword,NULL))
		{
			j=strlen(in);
			len=j-strlen(keyword);
			if(len>max)
			{
				max=len;
			}
		}
	}
	/* keyword not found */
	fclose(f);
	return(max);
}

/* return occurance where is keyword has value , 0 == not found */
/* return the number of fields matching keyword */

int
NValue(char *filename,char* comment,char * keyword,char *delimit)
{
FILE	*f;
int	count=0;
char	in[UBUFSIZE];

	strcpy(ErrorMessage,"");
	if(access(filename,F_OK)==-1)
	{       /* no exists so return 0 */
		return(0);
	}
	f=fopen(filename,"rt");
	if(!f)
	{
		sprintf(ErrorMessage,"Cannot open file %s.\n",filename);
		return;
	}
	while(fgets(in,sizeof(in),f))
	{
		Trim(in);
		if(!strncmp(in,comment,strlen(comment)))continue;
		if(IsKeyword(in,delimit,keyword,NULL))
		{
			count++;
		}

	}
	/* keyword not found */
	fclose(f);
	return(count);
}

/* return occurance where is keyword starts/= value , 0 == not found */

int
IsStart(char *filename,char* comment,char * keyword,char *delimit,char *value)
{
FILE	*f;
int	count=0;
char	in[UBUFSIZE];
char	xvalue[UBUFSIZE];

	strcpy(ErrorMessage,"");
	if(access(filename,F_OK)==-1)
	{       /* no exists so return 0 */
		return(0);
	}
	f=fopen(filename,"rt");
	if(!f)
	{
		sprintf(ErrorMessage,"Cannot open file %s.\n",filename);
		return;
	}
	while(fgets(in,sizeof(in),f))
	{
		Trim(in);
		if(!strncmp(in,comment,strlen(comment)))continue;
		if(IsKeyword(in,delimit,keyword,xvalue))
		{
			count++;
			if(!strncmp(value,xvalue,strlen(value)))
			{
				fclose(f);
				return(count);
			}
		}

	}
	/* keyword not found */
	fclose(f);
	return(0);
}
/* return occurance where is keyword has value , 0 == not found */

int
IsValue(char *filename,char* comment,char * keyword,char *delimit,char *value)
{
FILE	*f;
int	count=0;
char	in[UBUFSIZE];
char	xvalue[UBUFSIZE];

	strcpy(ErrorMessage,"");
	if(access(filename,F_OK)==-1)
	{       /* no exists so return 0 */
		return(0);
	}
	f=fopen(filename,"rt");
	if(!f)
	{
		sprintf(ErrorMessage,"Cannot open file %s.\n",filename);
		return;
	}
	while(fgets(in,sizeof(in),f))
	{
		Trim(in);
		if(!strncmp(in,comment,strlen(comment)))continue;
		if(IsKeyword(in,delimit,keyword,xvalue))
		{
			count++;
			if(!strcmp(value,xvalue))
			{
				fclose(f);
				return(count);
			}
		}

	}
	/* keyword not found */
	fclose(f);
	return(0);
}

void
ChangeValue(char *line,char *delimit,char *value)
{
char 	*s;

	s=strstr(line,delimit);
	s++;
	*s='\0';
	strcat(line,value);
}

/* rename file - needed cause this will work across different drives */

void
UpdateFile(char *old,char *newf)
{
FILE	*f;
char	in[UBUFSIZE];
FILE	*tmpf;

	strcpy(ErrorMessage,"");
	if(remove(old)==-1)
	{
		sprintf(ErrorMessage,"remove of %s fails (%s).",old,strerror(errno));
		return;
	}

	f=fopen(old,"wt");
	if(!f)
	{
		sprintf(ErrorMessage,"Cannot open file %s.\n",old);
		return;
	}

	tmpf=fopen(newf,"rt");
	if(!tmpf)
	{
		sprintf(ErrorMessage,"Cannot open file %s.\n",newf);
		return;
	}


	while(fgets(in,sizeof(in),tmpf))
	{
		fputs(in,f);
	}

	fclose(f);fclose(tmpf);

	remove(newf);
}

/* create file - 0 length */

void
CreateFile(char *newf)
{
FILE	*f;
char	in[UBUFSIZE];
FILE	*tmpf;

	strcpy(ErrorMessage,"");
	f=fopen(newf,"wt");
	fclose(f);
	if(!f)
	{
		sprintf(ErrorMessage,"Cannot open file %s.\n",newf);
	}
}

void
SetValue
(char *filename,char *comment,char *keyword,char *delimit,char *value,int occ)
{
FILE	*f;
char	in[UBUFSIZE],orig[UBUFSIZE];
char	TempFilename[UBUFSIZE];
FILE	*tmpf;
char	*tmpfname;
int	didit=0;
int	count=0;

	strcpy(ErrorMessage,"");
	f=fopen(filename,"rt");
	if(!f)
	{
		sprintf(ErrorMessage,"Cannot open file %s.\n",filename);
		return;
	}

	sprintf(TempFilename,"%s/XXXXXX",TempFileDir);
	tmpfname=(char*)mktemp(TempFilename);
	if(!tmpfname)
	{
		sprintf(ErrorMessage,"mktemp fails for file %s\n.",TempFilename);
		return;
	}
	tmpf=fopen(TempFilename,"wt");
	if(!tmpf)
	{
		sprintf(ErrorMessage,"Cannot open file %s.\n",TempFilename);
		return;
	}


	while(fgets(in,sizeof(in),f))
	{
		strcpy(orig,in);
		Trim(in);
		if(!strncmp(in,comment,strlen(comment)))
		{
			fputs(orig,tmpf);
			continue;
		}
		if(IsKeyword(in,delimit,keyword,NULL))
		{
			count++;
			if((count==occ)&&(didit==0))
			{
				didit=1;
				if(strlen(value))
				{ /* actually delete the field is value is null */
					ChangeValue(orig,delimit,value);
					fputs(orig,tmpf);
					fputs("\n",tmpf);
				}
			}
			else
			{
				fputs(orig,tmpf);
			}
		}
		else /* just write orig line */
		{
			fputs(orig,tmpf);
		}
	}

	fclose(f);fclose(tmpf);

	if(!didit)
	{
		sprintf(ErrorMessage,"keyword %s not found.",keyword);
		remove(TempFilename);
		return;
	}

	UpdateFile(filename,TempFilename);

}

/* append into filename the string value */

void
AppendFile(char *filename,char *value)
{
FILE	*f;
char	in[UBUFSIZE];
char	TempFilename[UBUFSIZE];
FILE	*tmpf;
char	*tmpfname;

	strcpy(ErrorMessage,"");
	f=fopen(filename,"rt");
	if(!f)
	{
		sprintf(ErrorMessage,"Cannot open file %s.\n",filename);
		return;
	}

	sprintf(TempFilename,"%s/XXXXXX",TempFileDir);
	tmpfname=(char*)mktemp(TempFilename);
	if(!tmpfname)
	{
		sprintf(ErrorMessage,"mktemp fails for file %s.",TempFilename);
		return;
	}
	tmpf=fopen(TempFilename,"wt");
	if(!tmpf)
	{
		sprintf(ErrorMessage,"Cannot open file %s.\n",TempFilename);
		return;
	}


	while(fgets(in,sizeof(in),f))
	{
		fputs(in,tmpf);
	}
	fputs(value,tmpf); /* append line */

	fclose(f);fclose(tmpf);

	UpdateFile(filename,TempFilename);
}

/* insert into filename the string value at line n */

void
InsertFile(char *filename,char *value,int line)
{
FILE	*f;
char	in[UBUFSIZE];
char	TempFilename[UBUFSIZE];
FILE	*tmpf;
char	*tmpfname;
int		linecnt=0;

	strcpy(ErrorMessage,"");
	f=fopen(filename,"rt");
	if(!f)
	{
		sprintf(ErrorMessage,"Cannot open file %s.\n",filename);
		return;
	}

	sprintf(TempFilename,"%s/XXXXXX",TempFileDir);
	tmpfname=(char*)mktemp(TempFilename);
	if(!tmpfname)
	{
		sprintf(ErrorMessage,"mktemp fails for file %s.",TempFilename);
		return;
	}
	tmpf=fopen(TempFilename,"wt");
	if(!tmpf)
	{
		sprintf(ErrorMessage,"Cannot open file %s.\n",TempFilename);
		return;
	}


	while(fgets(in,sizeof(in),f))
	{
		linecnt++;
		if(linecnt==line)
		{
			fputs(value,tmpf); /* new line */
			fputs(in,tmpf);    /* the orig */
		}
		else /* just write orig line */
		{
			fputs(in,tmpf);
		}

	}

	fclose(f);fclose(tmpf);

	UpdateFile(filename,TempFilename);

}

/* replace in filename line n with the string value*/

void
ReplaceFile(char *filename,char *value,int line)
{
FILE	*f;
char	in[UBUFSIZE];
char	TempFilename[UBUFSIZE];
FILE	*tmpf;
char	*tmpfname;
int	linecnt=0;

	strcpy(ErrorMessage,"");
	f=fopen(filename,"rt");
	if(!f)
	{
		sprintf(ErrorMessage,"Cannot open file %s.\n",filename);
		return;
	}

	sprintf(TempFilename,"%s/XXXXXX",TempFileDir);
	tmpfname=(char*)mktemp(TempFilename);
	if(!tmpfname)
	{
		sprintf(ErrorMessage,"mktemp fails for file %s.",TempFilename);
		return;
	}
	tmpf=fopen(TempFilename,"wt");
	if(!tmpf)
	{
		sprintf(ErrorMessage,"Cannot open file %s.\n",TempFilename);
		return;
	}


	while(fgets(in,sizeof(in),f))
	{
		linecnt++;
		if(linecnt==line)
		{
			fputs(value,tmpf);
		}
		else /* just write orig line */
		{
			fputs(in,tmpf);
		}

	}

	fclose(f);fclose(tmpf);

	UpdateFile(filename,TempFilename);

}

/* creates filename with input contents */

void
SetFile(char *filename,char *input)
{
FILE	*f;

	strcpy(ErrorMessage,"");
	f=fopen(filename,"wt");
	if(!f)
	{
		sprintf(ErrorMessage,"Cannot open file %s.\n",filename);
		return;
	}

	fputs(input,f);

	fclose(f);
}

int
StringInLine(char *line,char *string)
{
int	len,slen;

/*	if(!strcmpi(line,string)) */
	if(!strcmp(line,string))
	{
		return(1);
	}
	slen=strlen(string);
	len=strlen(line)-slen+1;
	if(len<0)
	{
		return(0);
	}
	while(len)
	{
/*		if(!strncmpi(line,string,strlen(string))) */
		if(!strncmp(line,string,strlen(string)))
		{
			if(isspace(*(line+slen)))
			{
				return(1);
			}
			if(*(line+slen)=='\0')
			{
				return(1);
			}
		}
		line++;
		len--;
	}
	return(0);
}

void
ChangeString(char *line,char *oldstr,char *newstr)
{

int	len,slen;
char	tmp[UBUFSIZE];
char	*string;

	slen=strlen(oldstr);
	len=strlen(line)-slen+1;
	while(len)
	{
/*		if(!strncmpi(line,oldstr,strlen(oldstr))) */
		if(!strncmp(line,oldstr,strlen(oldstr)))
		{
			if(isspace(*(line+slen))||(*(line+slen)=='\0'))
			{
				strcpy(tmp,(line+slen));
				strcpy(line,newstr);
				strcat(line,tmp);
				return;
			}
		}
		line++;
		len--;
	}
	return;
}

int
SetArgN(char *line,int n,char *arg)
{
int	i,argn=0;
char	*s;

	for(i=0;i<strlen(line);i++)
	{
		argn++;
		s=arg;
		while(!isspace((int)line[i])&&line[i])
		{
			*s=line[i];
			i++;s++;
		}
		*s='\0';
		if(argn==n)return(1);
		while(isspace((int)line[i])&&line[i])
		{
			i++;
		}
		i--; /* to adjust for the for loop */
	}
	return(0);
}

/* from filename, get the N argument from the first line matched by idstring */

void
GetArgN(char *filename,char *strid,int n,char *arg)
{
FILE	*f;
char	in[UBUFSIZE];
char	TempFilename[UBUFSIZE];
FILE	*tmpf;
char	*tmpfname;
int	didit=0;

	strcpy(ErrorMessage,"");
	f=fopen(filename,"rt");
	if(!f)
	{
		sprintf(ErrorMessage,"Cannot open file %s.\n",filename);
		return;
	}

	while(fgets(in,sizeof(in),f))
	{
		in[strlen(in)-1]='\0';
		if(StringInLine(in,strid))
		{
			didit=1;
			Trim(in);
			if(!SetArgN(in,n,arg))didit=0;
			break;
		}
	}

	fclose(f);

	if(!didit)
	{
		sprintf(ErrorMessage,"string %s not found.",strid);
		return;
	}
}

/* substitute last occurence of oldstr with newstr in filename */

void
SubsString(char *filename,char *oldstr,char *newstr)
{
FILE	*f;
char	in[UBUFSIZE];
char	TempFilename[UBUFSIZE];
FILE	*tmpf;
char	*tmpfname;
int		didit=0;

	strcpy(ErrorMessage,"");
	f=fopen(filename,"rt");
	if(!f)
	{
		sprintf(ErrorMessage,"Cannot open file %s.\n",filename);
		return;
	}

	sprintf(TempFilename,"%s/XXXXXX",TempFileDir);
	tmpfname=(char*)mktemp(TempFilename);
	if(!tmpfname)
	{
		sprintf(ErrorMessage,"mktemp fails for file %s.",TempFilename);
		return;
	}
	tmpf=fopen(TempFilename,"wt");
	if(!tmpf)
	{
		sprintf(ErrorMessage,"Cannot open file %s.\n",TempFilename);
		return;
	}


	while(fgets(in,sizeof(in),f))
	{
		in[strlen(in)-1]='\0';
		if(StringInLine(in,oldstr))
		{
			didit=1;
			ChangeString(in,oldstr,newstr);
			fputs(in,tmpf);
			fputs("\n",tmpf);
		}
		else /* just write orig line */
		{
			fputs(in,tmpf);
			fputs("\n",tmpf);
		}

	}

	fclose(f);fclose(tmpf);

	if(!didit)
	{
		sprintf(ErrorMessage,"string %s not found.",oldstr);
		remove(TempFilename);
		return;
	}

	UpdateFile(filename,TempFilename);
}

/* returns the line number of the last line with string in it */
/* string is an exact match - delimit by whitspace */
int
GetLastLine(char *filename,char *str)
{
FILE	*f;
char	in[UBUFSIZE];
int	linecnt=0,last=0;;

	strcpy(ErrorMessage,"");
	f=fopen(filename,"rt");
	if(!f)
	{
		sprintf(ErrorMessage,"Cannot open file %s.\n",filename);
		return(0);
	}

	while(fgets(in,sizeof(in),f))
	{
		linecnt++;
		in[strlen(in)-1]='\0';
		if(StringInLine(in,str))
		{
			last=linecnt;
		}
	}

	fclose(f);
	return(last);
}
