/* 
        COPYRIGHT (C) 1992, 1993, 1994 Oesterreich & Assc. Inc.

        NOTE: NAG is not free - it is shareware! See 'License Terms'
        in nag/README file

*/


#include"nag.h"
#include "hooks.h"
#include "utils.h"
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <signal.h>
#include <ctype.h>
#include <setjmp.h>
#include <string.h>
#include <termios.h>


/* external defined hook functions */

extern struct funcID hooks[];

/* bold escape sequences */
extern char BOLDON[],BOLDOFF[];

/* max levels of hyper link indirection */
#define LEVELS 32

/* messages file command definitions */
#define BREAK "{_BREAK}"
#define CLEARCONTEXT "{_CLEARCONTEXT}"
#define CLEARS "{_CLEARS}"
#define CRPAUSE "{_CRPAUSE}"
#define END "{_END}"
#define ERROR "{_ERROR}"
#define POP "{_POP}"
#define POPEN "{_POPEN}"
#define PROMPT "{_PROMPTTITLE}"
#define PROMPTCHARS "{_PROMPTCHARS}"
#define SETFIELD "{_SETFIELD}"
#define SETLIST "{_LISTTITLE}"
#define SETRC "{_SETRC}"
#define SYSTEM "{_SYSTEM}"
#define TERMINFO "{_TERMINFO}"
/* valid comline commands */
#define EXIT "EXIT"

void doint(int);

int	copyright=1;
int	doexit=0;
int	do0reload=0;
int	f; /* Messages file */
char	*HomeMenu="HOME";
char	*MessageFile="./menumess";
char	*RcFile="./.nagrc";
char	*Tmp; /* temp dir pointer */
char	*ContextDir=".";
char	buf[UBUFSIZE];
int	rows; /* Number of lines that are displayed at a time */
int	busy=1; /* main loop control */
char	*messages,*mp;
long	messlen;
char	prompt[UBUFSIZE]; /* late addition - better safe than weird side effects */
char	promptchars[UBUFSIZE];
char	HomeTag[UBUFSIZE];
char	ErrString[UBUFSIZE];
char	SetListTitle[UBUFSIZE];

jmp_buf	env;

struct	tname {
	char	tname[UBUFSIZE];
	char	tsection[UBUFSIZE];
	struct	tname *tnext;
} *tlist=NULL;

char	pline[UBUFSIZE],nline[UBUFSIZE];

main(int argc,char *argv[])
{
char	pr[UBUFSIZE];
char	prchars[UBUFSIZE];
char	ppr[UBUFSIZE];
int	pmret;
int	level=0,comret;
char	mens[LEVELS][LEVELS];
uid_t	uid;
extern 	char 	*optarg;
extern	int 	optind;
int 	checkuidflag=-1,ch,fd;
int	ansiflag=0,termsetupflag=0;

	if(!UtilsInit())exit(1); /* finds and sets a tmp dir */
	if(!Prologue())exit(1); /* various ENV controlled params */

	while ((ch = getopt(argc, argv, "dxatu:m:c:h:")) != EOF)
		switch(ch) 
		{
			case 'h':
 				HomeMenu=optarg;
 				break;
			case 'u':
 				checkuidflag=atoi(optarg);
 				break;
	     		case 'm':
				MessageFile=optarg;
		     		break;
	     		case 'i':
				RcFile=optarg;
		     		break;
	     		case 'c':
				ContextDir=optarg;
		     		break;
	     		case 'x':
				doexit=1;
		     		break;
	     		case 'd':
				do0reload=1;
		     		break;
	     		case 'a':
				ansiflag=1;
		     		break;
	     		case 't':
				termsetupflag=1;
		     		break;
	     		case '?':
	     		default:
			beep();
				printf("ERROR: Invalid option\n");			
				exit(1);
     		}
		argc -= optind;
		argv += optind;


	if(!Epilogue(checkuidflag,ansiflag,&termsetupflag))exit(1);

	/* set up the home menu tag */

	strcpy(HomeTag,"{");
	strcat(HomeTag,HomeMenu);	
	strcat(HomeTag,"}");

	signal(SIGINT,SIG_IGN);
	strcpy(&mens[0][0],HomeTag);
	if(!init())exit(1);
	/* from this point on use only wrline for output */
	if(termsetupflag)
	{
		terminfo();
	}
	strcpy(pline,HomeTag);
	while(busy) {
		if(setjmp(env)!=0)
		{
			signal(SIGINT,SIG_IGN); /*DISABLE INT ! */
			strcpy(pline,HomeTag);
			level=0;
			strcpy(&mens[0][0],HomeTag);
		}
		strcpy(SetListTitle,"- NAG List Manager -");
		strcpy(pr,PR1line);
		strcpy(prchars,PRDATA1);
		strcpy(prompt,"");
		strcpy(promptchars,"");
		strcpy(ErrString,"ERROR:");
		pmret=pm(pline,rows);
		if(pmret==1) /* means do a pop */
		{
			strcpy(pline,HomeTag);
			if(level)
			{
				level--;
				strcpy(pline,&mens[level][0]);
				continue;
			}
		}
if(copyright)
{
	copyright=0;
	wrline("NAG, Copyright (C), 1992,1993, Oesterreich & Assc. Inc., Corralitos, CA.\n\n");
}
		if(strlen(prompt))strcpy(pr,prompt);
		if(strlen(promptchars))strcpy(prchars,promptchars);
		strcpy(ppr,pr);
		strcat(ppr,prchars);
		switch(gl(MAXINPUT,ppr,OPTIONAL,"~")) {
		/* By default, display text tagged by pline;
		   change default display only when a valid tag is returned
	           by comline() (Note: default display generated by error/
		   empty line entered in comline).
		*/
			case -2:
				break; /* gl returns - */
			case -1:
				crpause();
				break; /* gl printed an error message */
			case 0:
				strcpy(pline,HomeTag);
				if(level)
				{
					level--;
					strcpy(pline,&mens[level][0]);
				}
				break; /* gl returned an empty line */
			default:	 
				comret=comline(nline);
				if(comret==0) {
					beep();
					wrline("\n");
					wrline("ERROR: Bad command/topic.\n");
					crpause();
				}
				else if(comret==-1) {
					beep();
					wrline("\n");
					wrline("ERROR: Ambiguous topic; enter more characters.\n");
					crpause();
				}
				else if(comret==2) {
				/* NOTE: this error never happens - this restriction fixed */
					beep();
					wrline("\n");
					wrline("ERROR: No space before '='.\n");
					crpause();
				}
				else if(comret==4) {
					beep();
					wrline("\n");
					wrline("ERROR: Not a writable field.\n");
					crpause();
				}
				else if(comret==3) {
					break; /* did a field - redisplay current */
				}
				else {
					if(strcmp(pline,nline))
					{
						if(level<LEVELS)level++;
						strcpy(&mens[level][0],nline);
					}
					strcpy(pline,nline);
				}
				break;
		} /* end switch */
	} /* end while busy */
	wrline("\n");
	clears();
	RestoreTty();
	exit(0);
}

int
comline(line)
char	*line;
{
int	n,i,j,found=0,dofield;
struct	tname *t;
char	tmp[UBUFSIZE],ptmp[UBUFSIZE];
char	section[UBUFSIZE];
char	*s,fieldarg[UBUFSIZE];

	i=0;dofield=0;
	strcpy(fieldarg,"");
	Trim(buf); /* nuke leading - trailing space */
	if(!strlen(buf))return(0);
	while(buf[i])
	{
		if(buf[i]=='=') /* command to set a field */
		{
			if(i==0)return(0); /* bad command */
			if(i>0)
			{
				/* nuke the = sign */
				buf[i]='\0';
				/* now nuke spaces backwards to keyword */
				j=i-1;
				while(isspace(buf[j]))
				{
					buf[j]='\0';
					j--;
					if(j<0)break;
					/* above code now allows space ! */
					/* return(2);  error - no space allowed */
				}
			}
			dofield=1; /* yes, process field command at end */
			i++; /* arg start after = */
			if(strlen(&buf[i]))
			{
				strcpy(fieldarg,&buf[i]);
				Trim(fieldarg); /* nuke space after = */
				if(!strcmp(fieldarg,"-")) /* means clear the field */
				{
					fieldarg[0]=ESC;
				}
			}
			break;
		}
		if(islower((int)buf[i]))
			buf[i]=(char)toupper((int)buf[i]);
		i++;
	}
	
	if(!(strcmp("EXIT",buf))) {
		if(doexit)
		{
			busy=0;
		}
		else if(surex()) busy=0;
		strcpy(line,pline); 
		return(1);
	}
	if(!(strcmp(HomeMenu,buf))) {
		strcpy(line,HomeTag);
		return(1);
	}
	if(!(strcmp("0RELOAD",buf))) {
		if(do0reload)
		{
			ReLoad();
			strcpy(line,HomeTag);
			return(1);
		}
	}
	t=tlist;
	/* if s1==s2, found pure match; done. */
	/* if s2 in s1, found partial match; look for collisions */
	while(t) {
		if(!(strcmp(t->tname,buf))) {
			found=1;
			strcpy(tmp,t->tname);
			strcpy(section,t->tsection);
			break;		
		}
		else {
			n=strlen(buf);
			strcpy(ptmp,t->tname);
			ptmp[n]='\0';
			if(!(strcmp(ptmp,buf))) {
				found++;
				strcpy(tmp,t->tname);
				strcpy(section,t->tsection);
			}
		}
		t=t->tnext;
	}
	if(found==1) { 
		strcpy(line,"{");
		strcat(line,tmp);
		if(strlen(section))
		{
			strcat(line,section); /* look for match in section */
		}
		strcat(line,"}");
		/* return a match in form {topic[section]} */
		/* used as direct input to pm for display */
		if(dofield)
		{
			if(IsField(line)) /* _SETFIELD line in buf */
			{
				SetField(fieldarg);
				return(3); /* did a field - redisply current */
			}
			if(IsRc(line)) /* _SETRC line in buf */
			{
				SetRc(fieldarg);
				return(3); /* did a field - redisply current */
			}

			/* field not found - return error */
			return(4);
		}
		return(1);	
	}
	if(found>1)return(-1); /* ambiguous error */
	return(0);	 /* no match error */	
}

char*
rm()
{
char	*s;
int	i=0,n;

	while(1) {
		if(mp>=(messages+messlen)) return(0);
		if(i<UBUFSIZE)
		{
			buf[i]=*mp++;
			if(buf[i]=='\n')
			{
				buf[i]='\0';
				return(s=buf);
			}
		}
		else
		{
			buf[UBUFSIZE-1]='\0';
			return(s=buf);
		}
		i++;
	}
}

void
removesections(char *buf)
{
struct	tname *t;
char	*s;
char	tmp[UBUFSIZE];
int	i;

	t=tlist;
	while(t) 
	{
		if(strlen(t->tsection))
		{
			s=strstr(buf,t->tsection);
			if(s!=NULL)
			{ /* remove the section */
				*s='\0';
				i=strlen(t->tsection);	
				while(i--)s++;
				strcat(buf,s);
			}
		}
		t=t->tnext;
	}
}

/* called from pm(); next function */
scanh(buf)
char	*buf;
{
char	tname[UBUFSIZE];
char	tsection[UBUFSIZE];
int	i=0,state=0,nn=0,len;
struct	tname *t,*n;
char	*s,*bufptr;

	bufptr=buf;
	len=strlen(buf);
	while(nn<(len+1)) {
		switch(state) {
		case 0 : 
			if('{'==*buf) { 
				/* check for escape */
				if(buf!=bufptr)
				{
					if(*(--buf)=='\\') /* escape it */
					{
						buf++;
						buf++;
						nn++;
						break;
					}
					buf++;
				}
				state=1;
				if(strlen(BOLDON))
				{
			 		*buf++=BON;
				}
				else
				{
				/* set line mode delimit char here */
			 		*buf++='{';
				}
				nn++;
				break;
			}
			buf++;
			nn++;
			break;
		case 1 :
			tname[i]=*buf;
			i++;nn++;
			buf++;
			if(*buf=='}') {
				/* check for escape */
				if(*(--buf)=='\\') /* escape it */
				{
					buf++;
					buf++;
					nn++;
					break;
				}
				buf++;
				state=2;
				if(strlen(BOLDON))
				{
			 		*buf++=BOFF;
				}
				else
				{
				/* set line mode delimit char here */
			 		*buf++='}';
				}
			 	nn++;
				tname[i]='\0';
				i=0;
			}	
			break;
		case 2 :
			if(strlen(tname)) {
				/* check for section ID */
				strcpy(tsection,"");
				s=strchr(tname,(int)'[');
				if(s!=NULL)
				{
					strcpy(tsection,s);
					*s='\0';	
				}
				t=(struct tname*)malloc(sizeof(struct tname));
				n=tlist;		
				if(tlist) {
					while(n->tnext) n=n->tnext;
					n->tnext=t;t->tnext=NULL;
					strcpy(t->tname,tname);
					strcpy(t->tsection,tsection);
				}
				else {
					tlist=t;tlist->tnext=NULL;
					strcpy(tlist->tname,tname);
					strcpy(t->tsection,tsection);
				}
			}
			state=0;
			break;
		}
	}
	removesections(bufptr);
}

/* insert boldon and boldoff characters */

boldstuff(buf)
char	*buf;
{
char	bbuf[UBUFSIZE];
char	*p=bbuf;
char	*s=buf;
	
	while(*buf)
	{
		if(*buf==BON)
		{
			buf++;
			strcpy(p,BOLDON);
			p+=strlen(BOLDON);
			continue;
		}
		else if(*buf==BOFF)
		{
			buf++;
			strcpy(p,BOLDOFF);
			p+=strlen(BOLDOFF);
			continue;
		}
		else
		{
			*p++=*buf++;
		}	
	}
	*p='\0';
	strcpy(s,bbuf);
}

void
doprompt()
{
int	i;
char	pbuf[UBUFSIZE];

	i=strlen(PROMPT)+1;
	sprintf(prompt,"%s",&buf[i]); 
}

void
dopromptchars()
{
int	i;
char	pbuf[UBUFSIZE];

	i=strlen(PROMPTCHARS)+1;
	if((buf[i]=='\\')&&(buf[i+1]=='n'))
	{
		i++;
		buf[i]='\n';
	}
	sprintf(promptchars,"%s",&buf[i]); 
}

void
doerrstring()
{
int	i;
char	pbuf[UBUFSIZE];

	i=strlen(ERROR)+1;
	sprintf(ErrString,"%s ",&buf[i]); 
}

void
dopopen()
{
int	ErrorCr=0,i,line=0;
char	pbuf[UBUFSIZE];
FILE	*p;

	i=strlen(POPEN)+1;
	sprintf(pbuf,"%s ",&buf[i]); 
 	strcat(pbuf," 2>&1");
	p=popen(pbuf,"r");

	if(p==NULL)
	{
		sprintf(pbuf,"ERROR: Popen fails- %s\n",strerror(errno));
		wrline(pbuf);
		crpause();
		return;
	}
	while(fgets(pbuf,BUFSIZ,p)!=NULL)
	{
		if(!strncmp(ErrString,pbuf,strlen(ErrString)))
		{
			ErrorCr=1;
		}
		if(line>(rows-4))
		{
			line=0;
			wrline("\n");
			crpause();
		}
		wrline(pbuf);
		line++;
	}
	pclose(p);
	if(ErrorCr)
	{
		wrline("\n");
		crpause();
	}
}

void
dosystem()
{
int	i;
char	pbuf[UBUFSIZE];
int	rc;

	i=strlen(SYSTEM)+1;
	sprintf(pbuf,"%s ",&buf[i]); 
	RestoreTty();
	rc=system(pbuf);
	SetTty();
	if((rc==-1)||(rc==127))
	{
		sprintf(pbuf,"system fails; rc: %d\n",rc);
		wrline(pbuf);
		crpause();
		return;
	}
}

/* return only the first alnum field in buf */
void 
wordit(char *buf)
{
	while(isalnum((int)*buf))buf++;
	if(*buf)*buf='\0'; /* if not end, make it end */
}

void
doescapes(char *buf)
{
char	*s,*start;

	start=buf;
	while(s=strchr(start,(int)'\\'))
	{
		start=s;
		start++;
		strcpy(s,start);
		/* check for escaped backslash */
		if(*start=='\\')
		{
			start++;
		}
	}
}

void
dorc(char *buf)
{
char	*dollar;
char	*s,*start;
char	cfile[UBUFSIZE];
char	value[UBUFSIZE];
char	dbuf[UBUFSIZE],tmp[UBUFSIZE];

	start=buf;
	while(dollar=strchr(start,(int)'$'))
	{
		/* check for escape */
		if(dollar!=start) /* obvious that it ain't possible to be sacaped */
		{
			if(*(--dollar)=='\\') /* escape it */
			{
				dollar++;
				dollar++;
				start=dollar;
				continue;
			}
			dollar++;
		}
		s=dollar;s++;
		start=s;
		strcpy(dbuf,s);
		wordit(dbuf);
		UpIt(dbuf);
		/* set rc filename */
		strcpy(cfile,RcFile);
		GetValue(cfile,"#",dbuf,"~",value,1);
		if(strlen(ErrorMessage)||(!strlen(value)))
		{ /* just nuke the field */
			while(isalnum((int)*s))s++;
			if(*s) /* if not end of line */
			{
				strcpy(dollar,s);
			}
		}
		else
		{ /* add field value to buf for display */
			/* save stuff after field */
			while(isalnum((int)*s))s++;
			if(*s) /* if not end of line */
			{
				strcat(value,s);
			}
			strcpy(dollar,value);
		}
	}
}

void
ClearContext(void)
{
char	cfile[UBUFSIZE];
char	parg[UBUFSIZE],pbuf[UBUFSIZE],tmp[UBUFSIZE];
int	i;

	i=strlen(CLEARCONTEXT)+1;
	sprintf(pbuf,"%s ",&buf[i]); 
	Parg(pbuf,parg);
	strcpy(tmp,parg);
	LoIt(tmp);
	/* set context filename */
	strcpy(cfile,ContextDir);
	strcat(cfile,"/context.");
	strcat(cfile,tmp);
	if(unlink(cfile))
	{
		if(errno!=ENOENT)
		{
		wrline("ERROR: clearcontext failed.\n");
		crpause();
		}
	}
}

void
dofields(char *id,char *buf)
{
char	*tilde;
char	*s,*start;
char	cfile[UBUFSIZE];
char	value[UBUFSIZE];
char	dbuf[UBUFSIZE],tmp[UBUFSIZE];
int	N;

	start=buf;
	while(tilde=strchr(start,(int)'~'))
	{
		/* check for escape */
		if(tilde!=start) /* obvious that it ain't possible to be sacaped */
		{
			if(*(--tilde)=='\\') /* escape it */
			{
				tilde++;
				tilde++;
				start=tilde;
				continue;
			}
			tilde++;
		}
		s=tilde;s++;
		start=s;
		strcpy(dbuf,s);
		wordit(dbuf);
		UpIt(dbuf);
		/* set context filename */
		strcpy(cfile,ContextDir);
		strcat(cfile,"/context.");
		strcpy(tmp,id);
		LoIt(tmp);
		/* id is passed within {} - delete them */
		strcpy(tmp,&tmp[1]);
		tmp[strlen(tmp)-1]='\0';
		strcat(cfile,tmp);
		N=NValue(cfile,"#",dbuf,"~");
		if(N==0)
		{ /* just nuke the field */
			while(isalnum((int)*s))s++;
			if(*s) /* if not end of line */
			{
				strcpy(tilde,s);
			}
		}
		else
		{ /* add field value to buf for display */
			GetValue(cfile,"#",dbuf,"~",value,1);
			if(strlen(ErrorMessage))
			{
				wrline("ERROR: ");
				wrline(ErrorMessage);
				wrline("\n");
				crpause();
				return;
			}
			/* mark if list */
			if(N>1)
			{
				strcat(value," ");
				if(strlen(BOLDON))strcat(value,BOLDON);
				strcat(value,"(...) ");
				if(strlen(BOLDOFF))strcat(value,BOLDOFF);
			}
			/* save stuff after field */
			while(isalnum((int)*s))s++;
			if(*s) /* if not end of line */
			{
				strcat(value,s);
			}
			strcpy(tilde,value);
		}
	}
}

/* Parg - return first whitespace sep'd arg in buf and removes it from
          head of buf */

char *
Parg(char *buf,char* parg)
{
char	*s;

	s=buf;
	while(isspace((int)*s)&&*s)s++; /* nuke leading space */
	if(*s)
	{
		while(!isspace((int)*s)&&*s)
		{
			*parg=*s;s++;parg++; /* copy and pass the arg */	
		}
		*parg='\0'; /* terminate the arg */
		strcpy(buf,s); /* update buf */
	}
}

/* set the rc file -
   Used two ways - if arg == NULL, then interactive prompt;
   else setfield to fieldarg */

void
SetRc(char* fieldvalue)
{
int	i,line=0;
char	pbuf[UBUFSIZE];
char	parg[UBUFSIZE],field[UBUFSIZE],prompt[UBUFSIZE];
char	*s,value[UBUFSIZE];
char	cfile[UBUFSIZE];
char	prchars[UBUFSIZE];
struct 	stat sbuf;

	i=strlen(SETRC)+1;
	sprintf(pbuf,"%s ",&buf[i]); 
	Parg(pbuf,parg);
	strcpy(field,parg);
	UpIt(field);
	strcpy(prompt,&pbuf[1]); /* skip the leadin space */
	if(fieldvalue==NULL)
	{
		clears();
		if(strlen(promptchars))
		{
			strcpy(prchars,promptchars);
		}
		else
		{
			strcpy(prchars,PRDATA1);
		}
		s=getinfo(prompt,prchars,OPTIONAL,"~\"");
	}
	else
	{
		s=fieldvalue;
	}
	if(strlen(s)) /* update rc file */
	{
		strcpy(value,s);
		if(*s==(char)ESC)
		{
			strcpy(value,"");
		}
		strcpy(cfile,RcFile);
		/* check for existence */
		if(access(cfile,F_OK)==-1)
		{ 	/* create it */
			CreateFile(cfile);
			if(strlen(ErrorMessage))
			{
				wrline("ERROR: ");
				wrline(ErrorMessage);
				wrline("\n");
				crpause();
				return;
			}
		}
		/* try to get existing value */
		SetValue(cfile,"#",field,"~",value,1);
		if(strlen(ErrorMessage)) /* assume field did not exist */
		{
			sprintf(pbuf,"%s~%s\n",field,value);
			AppendFile(cfile,pbuf);
			if(strlen(ErrorMessage))
			{
				wrline("ERROR: ");
				wrline(ErrorMessage);
				wrline("\n");
				crpause();
				return;
			}
		}
	}
}

void
SetList()
{
int	i;

	i=strlen(SETLIST)+1;
	sprintf(SetListTitle,"%s ",&buf[i]); 
}

void
SetField(char* fieldvalue)
{
int	fieldn,N,i,line=0;
char	pbuf[UBUFSIZE];
char	parg[UBUFSIZE],context[UBUFSIZE],field[UBUFSIZE],sfprompt[UBUFSIZE];
char	*s,value[UBUFSIZE];
char	prchars[UBUFSIZE],cfile[UBUFSIZE],listfile[UBUFSIZE];
struct 	stat sbuf;

	i=strlen(SETFIELD)+1;
	sprintf(pbuf,"%s ",&buf[i]); 
	Parg(pbuf,parg);
	strcpy(context,parg);
	Parg(pbuf,parg);
	strcpy(field,parg);
	UpIt(field);
	Parg(pbuf,parg);
	/* default assume not a list; if parg is splat, make it a list */
	fieldn=1;
	if(strchr(parg,(int)'*'))
	{
		fieldn=-1;
	}
	strcpy(sfprompt,&pbuf[1]); /* skip the leadin space */
	strcpy(cfile,ContextDir);
	strcat(cfile,"/context.");
	LoIt(context);
	strcat(cfile,context);
	strcpy(listfile,ContextDir);
	strcat(listfile,"/list.");
	strcat(listfile,context);
	if(fieldvalue==NULL)
	{
		clears();
		if(fieldn==1)
		{
			if(strlen(promptchars))
			{
				strcpy(prchars,promptchars);
			}
			else
			{
				strcpy(prchars,PRDATA1);
			}
			s=getinfo(sfprompt,prchars,OPTIONAL,"~\"");
		}
		else
		{
			/* LIST MANAGER */
			lm(cfile,listfile,sfprompt,field);
			return;
		}
	}
	else
	{
		s=fieldvalue;
	}
	if(strlen(s)) /* update context file */
	{
		strcpy(value,s);
		if(*s==(char)ESC)
		{
			strcpy(value,"");
		}

		/* check for existence */
		if(access(cfile,F_OK)==-1)
		{ 	/* create it */
			CreateFile(cfile);
			if(strlen(ErrorMessage))
			{
				wrline("ERROR: ");
				wrline(ErrorMessage);
				wrline("\n");
				crpause();
				return;
			}
		}
		/* see how man fields exist */
		N=NValue(cfile,"#",field,"~");

		/* if N==0, append the first field and done (if value not null) */
		if(N==0)
		{
			if(!strlen(value))return;
			sprintf(pbuf,"%s~%s\n",field,value);
			AppendFile(cfile,pbuf);
			if(strlen(ErrorMessage))
			{
				wrline("ERROR: ");
				wrline(ErrorMessage);
				wrline("\n");
				crpause();
				return;
			}
			return;
		}
		/* if not list; setvalue (know it exists cause N!=0 here */
		if(fieldn==1)
		{
			SetValue(cfile,"#",field,"~",value,1);
			if(strlen(ErrorMessage))
			{
				wrline("ERROR: ");
				wrline(ErrorMessage);
				wrline("\n");
				crpause();
				return;
			}
			return;
		}
		/* here treat as list - add the field if value not null */
		if(strlen(value))
		{
			sprintf(pbuf,"%s~%s\n",field,value);
			AppendFile(cfile,pbuf);
			if(strlen(ErrorMessage))
			{
				wrline("ERROR: ");
				wrline(ErrorMessage);
				wrline("\n");
				crpause();
				return;
			}
		}
		else /* nuke the first field */
		{
			SetValue(cfile,"#",field,"~",value,1);
			if(strlen(ErrorMessage))
			{
				wrline("ERROR: ");
				wrline(ErrorMessage);
				wrline("\n");
				crpause();
				return;
			}
			return;
		}
	}
}

/* used to determine is field assoicate with topic - if yes,
   _SETFIELD line is in buf */

int
IsField(id)
char	*id;
{
struct	tname *t,*i;
short	didnotfind=1;

	mp=messages; /* initialize mp for use by rm() */
	while(rm()) {
		if(!strcmp(id,buf)) {
			didnotfind=0;
			break;
		}
	}
	if(didnotfind) return(0);
	while(rm()) {
		if(!strcmp(END,buf))
		{
			return(0);
			break;
		}
		if(!strncmp(SETFIELD,buf,strlen(SETFIELD))) {
			return(1);
			goto loop;
		}
	loop: ;
	}
	return(0);
}

int
IsRc(id)
char	*id;
{
struct	tname *t,*i;
short	didnotfind=1;

	mp=messages; /* initialize mp for use by rm() */
	while(rm()) {
		if(!strcmp(id,buf)) {
			didnotfind=0;
			break;
		}
	}
	if(didnotfind) return(0);
	while(rm()) {
		if(!strcmp(END,buf))
		{
			return(0);
			break;
		}
		if(!strncmp(SETRC,buf,strlen(SETRC))) {
			return(1);
			goto loop;
		}
	loop: ;
	}
	return(0);
}

int
pm(id,rows)
char	*id;
int	rows;
{
struct	tname *t,*i;
short	didnotfind=1;
int	line=0,j;
char	*s;

	clears();
	while(tlist) {	/* free existing list */
		t=tlist->tnext;
		free(tlist);
		tlist=t;
	}
	mp=messages; /* initialize mp for use by rm() */
	while(rm()) {
		if(!strcmp(id,buf)) {
			didnotfind=0;
			break;
		}
	}
	if(didnotfind) return;
	while(rm()) {
		/* process hooked commands */
		j=0;
		while(hooks[j].fname)
		{
			if(!strncmp(hooks[j].fname,buf,strlen(hooks[j].fname)))
			{
				s=strchr(buf,' ');s++;
				if(!strlen(s))s=NULL;
				hooks[j].fptr(s);
				goto loop;
			}
			j++;
		}
		/* process built in commands */
		if(buf[0]=='#')
		{
			goto loop; /* it's a comment line */
				   /* note - self escaping since \# make it
				      in buf[1] */
		}
		if(!strcmp(END,buf)) break;
		if(!strcmp(POP,buf)) {
			return(1);
		}
		if(!strcmp(TERMINFO,buf)) {
			terminfo();
			goto loop;
		}
		if(!strncmp(CLEARCONTEXT,buf,strlen(CLEARCONTEXT))) {
			ClearContext();
			goto loop;
		}
		if(!strncmp(SETLIST,buf,strlen(SETLIST))) {
			SetList();
			goto loop;
		}
		if(!strncmp(SETFIELD,buf,strlen(SETFIELD))) {
			SetField(NULL);
			goto loop;
		}
		if(!strncmp(SETRC,buf,strlen(SETRC))) {
			SetRc(NULL);
			goto loop;
		}
		if(!strcmp(CLEARS,buf)) {
			clears();
			goto loop;
		}
		if(!strncmp(POPEN,buf,strlen(POPEN))) {
			dopopen();
			goto loop;
		}
		if(!strncmp(ERROR,buf,strlen(ERROR))) {
			doerrstring();
			goto loop;
		}
		if(!strncmp(SYSTEM,buf,strlen(SYSTEM))) {
			dosystem();
			goto loop;
		}
		if(!strncmp(PROMPT,buf,strlen(PROMPT))) {
			doprompt();
			goto loop;
		}
		if(!strncmp(PROMPTCHARS,buf,strlen(PROMPTCHARS))) {
			dopromptchars();
			goto loop;
		}
		if(!strcmp(CRPAUSE,buf)) {
			crpause();
			goto loop;
		}
		if(!strcmp(BREAK,buf)) {
			if(can()) {
				return(1);
			}
			goto loop;
		}
	/* default: write text to screen while making a list hyp-words */
		scanh(buf); 
		strcat(buf,"\n");
		if(strlen(BOLDON))
		{
			boldstuff(buf);
		}
		dofields(id,buf);
		dorc(buf);
		doescapes(buf);
		wrline(buf);
		line++;
		if(line>(rows-3))
		{
			line=0;
			wrline("\n");
			crpause();
		}
	loop: ;
	}
	return(0);
}

ReLoad()
{
struct 	stat buf;
long	l;

	f=stat(MessageFile,&buf);
	if(f!=-1)
	{
		messlen=buf.st_size;
		free(messages);
		messages=(char*)malloc(messlen+1);
		mp=messages;
		*(mp+messlen)='\0';
		f=open(MessageFile,O_RDONLY);
		if(f!=-1)
		{
			l=read(f,messages,messlen);
			f=close(f);
			return;
		}
	}
	printf("ERROR: Open of message file failed.\n");
	crpause();
}

int
init()
{
char	*s;
long	l;
struct 	stat buf;

	f=stat(MessageFile,&buf);
	if(f!=-1)
	{
		messlen=buf.st_size;
		messages=(char*)malloc(messlen+1);
		mp=messages;
		*(mp+messlen)='\0';
		f=open(MessageFile,O_RDONLY);
		if(f!=-1)
		{
			l=read(f,messages,messlen);
			f=close(f);
		}
	}
	if(f<0)
	{
		printf("ERROR: message file open fails; %s\n",strerror(errno));
		return(0);
	}
	if(!InitTty())return(0);
	return(1);
}
	
void
doint(int x)
{
int	c;

	strcpy(pline,HomeTag);
	longjmp(env,1);
}

/* Condition the input */
char*
condition()
{
int	i,j;

	/* all to lower case */
/*
	i=0;
	while(buf[i]){
		if(isupper((int)buf[i]))
			buf[i]=(char)tolower((int)buf[i]); 
		i++;
	}
*/
	/* eliminate trailing spaces */
	j=strlen(buf);
	for(i=j;i>0;i--) {
		if(!isspace(buf[i])) break;
		buf[i]='\0';
	}

	/* eliminate leading spaces */
	i=0;
	while(isspace(buf[i])) i++;
	return(&buf[i]);
}

check(s,stat)
char*	s;
int	stat;
{
char	c;

return; /* not used anymore */
}

char*
getinfo(char *gprompt,char *desc,int stat,char *notchars)
{
int	doing=1;
char	*s;

	do {
	loop:
		wrline(gprompt);
		if((gl(MAXINPUT,desc,stat,notchars))<stat) 
		{
			wrline("\nCorrect syntax error, or provide input.\n\n");
			crpause();
			goto loop;	
		}
		s=condition();
	/*	s=buf; debug testing */
		if(!check(s,stat)) {clears(); goto loop;}
		doing=0;
	}
	while(doing);
	return(s);
}

/* routine to insert BOLDON/OFF in place of unescaped { and } */

void
boldit(char *pr)
{
char    *c,prev,tmp[UBUFSIZE],x[UBUFSIZE];

        strcpy(tmp,"");
        x[1]='\0';
        prev='\0';
        c=pr;
        while(*c)
        {
                if(*c=='{')
                {
                        if(prev!='\\')
                        {
                                strcat(tmp,BOLDON);
                        }
                        else
                        {
                                x[0]=*c;
                                strcat(tmp,x);                  
                        }
                }
                else if (*c=='}')
                {
                        if(prev!='\\')
                        {
                                strcat(tmp,BOLDOFF);
                        }
                        else
                        {
                                x[0]=*c;
                                strcat(tmp,x);                  
                        }
                }
                else if (*c=='\\')
                {
                        if(prev=='\\')
                        {
                                x[0]=*c;
                                strcat(tmp,x);                  
                        }
                }
                else
                {
                        x[0]=*c;
                        strcat(tmp,x);                  
                }
                prev=*c;
                c++;
        }
        strcpy(pr,tmp);
}

