/* 
        COPYRIGHT (C) 1992, 1993, 1994 Oesterreich & Assc. Inc.

        NOTE: NAG is not free - it is shareware! See 'License Terms'
        in nag/README file

*/


#include "nag.h"
#include "utils.h"
#include "hooks.h"
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <signal.h>
#include <ctype.h>
#include <setjmp.h>
#include <string.h>

/* to set getinfo prompt */
extern	char promptchars[];

extern char	BOLDON[]; /* set for terminal bold chars*/
extern char	BOLDOFF[]; /* set for terminal bold chars*/
extern char	SetListTitle[]; /* title for list */

/* number of rows/columns to base display on */

extern int rows; /* set in main nag - default is 24 */
#define COLS	78

/* number of lines of info=ROWS - newline buffers */
#define	SHOWLINES	(rows-6)

/* display control global */
int	Start=1;

char*
Center(char *text)
{
char	tmp[UBUFSIZE];
int	j,i;

	if(text)
	{
		if((i=strlen(text)/2)>0)
		{
			for(j=0;j<(COLS/2)-i;j++)
			{
				tmp[j]=' ';
				tmp[j+1]='\0';	
			}
			strcat(tmp,text);
			return(strdup(tmp));
		}
	}
	return(strdup(text));	
}

void
PickDisplay(char* listfile,char *cfile,char* field)
{
char	*s,*c,value[UBUFSIZE],pbuf[UBUFSIZE];
int	Lines=0,N,n,MaxField,Picked;

		clears();
		c=Center(SetListTitle);
		wrline(c);
		free(c);
		wrline("\n\n");
		/* display current list */
		N=NValue(listfile,"#",field,"~");
		MaxField=4+GetMaxFieldWidth(listfile,"#",field,"~");
		for(n=1;n<=N;n++)
		{
			if(Lines>=SHOWLINES)break;
			if(n>=Start)
			{
				GetValue(listfile,"#",field,"~",value,n);
				Picked=IsValue(cfile,"#",field,"~",value);
				if(Picked)
				{
					if(strlen(BOLDON))
					{
						wrline(BOLDON);
					}
					wrline("+ ");
				}
				else
				{
					wrline("  ");
				}
				s=strchr(value,'~');
				if(s)
				{
					*s='\0';s++;
					wrline(value);
					wrline(s);
				}
				else
				{
				wrline(value);
				}
				if(Picked)
				{
					if(strlen(BOLDOFF))
					{
						wrline(BOLDOFF);
					}
				}
				wrline("\n");
				Lines++;
			}
		}
		if(!Lines)
		{
			wrline("\n");
			strcpy(pbuf,"<< Empty-List >>");
			c=Center(pbuf);
			wrline(c);
			free(c);
			wrline("\n");
		}
		wrline("\n");
}

void
ListDisplay(char* listfile,char* field)
{
char	*c,value[UBUFSIZE],pbuf[UBUFSIZE];
int	Lines=0,N,n,MaxField;

		clears();
		c=Center(SetListTitle);
		wrline(c);
		free(c);
		wrline("\n\n");
		/* display current list */
		N=NValue(listfile,"#",field,"~");
		MaxField=4+GetMaxFieldWidth(listfile,"#",field,"~");
		for(n=1;n<=N;n++)
		{
			if(Lines>=SHOWLINES)break;
			if(n>=Start)
			{
				GetValue(listfile,"#",field,"~",value,n);
				wrline(value);
				wrline("\n");
				Lines++;
			}
		}
		if(!Lines)
		{
			wrline("\n");
			strcpy(pbuf,"<< Empty-List >>");
			c=Center(pbuf);
			wrline(c);
			free(c);
			wrline("\n");
		}
		wrline("\n");
}

void
PromptPrep(char *prchars,char *file,char *field)
{
int	N;
char	pbuf[UBUFSIZE];

	if(strlen(promptchars))
	{
		strcpy(prchars,promptchars);
	}
	else
	{
		strcpy(prchars,PRDATA1);
	}
	N=NValue(file,"#",field,"~");
	if(N<(SHOWLINES+1))return;
	if(prchars[0]=='\n')
	{
		sprintf(pbuf,"\n[There's more; <ESC> for next page] %s",&prchars[1]);
	}
	else
	{
		sprintf(pbuf,"[There's more; <ESC> for next page] %s",prchars);

	}
	strcpy(prchars,pbuf);
}

void
MakeList(char *cfile,char *prompt,char *field)
{
char	*s,pbuf[UBUFSIZE],prchars[UBUFSIZE];
int	N,n;

	while(1)
	{
		ListDisplay(cfile,field);
		strcpy(pbuf,prompt);
		PromptPrep(prchars,cfile,field);
		s=getinfo(prompt,prchars,OPTIONAL,"~");
		if(!strlen(s))break; /* done */
		if(*s==ESC)
		{
			N=NValue(cfile,"#",field,"~");
			if(Start>(N-SHOWLINES))
			{
				Start=1;
			}
			else
			{
				Start=Start+SHOWLINES;
			}
			continue;
		}
		n=IsValue(cfile,"#",field,"~",s);
		if(n)
		{ 	/* remove it - a la toggle */
			SetValue(cfile,"#",field,"~","",n);
			/* end case - reset start if needed */
			N=NValue(cfile,"#",field,"~");
			if(Start>(N))
			{
				Start=1;
			}
		}
		else
		{ 	/* add it */
			sprintf(pbuf,"%s~%s\n",field,s);
			if(access(cfile,F_OK)==-1)
			{	/* no exists so create */
				CreateFile(cfile);
			}
			AppendFile(cfile,pbuf);
		}
	}
}

void
PickList(char *cfile,char *list,char *prompt,char *field)
{
char	*s,pbuf[UBUFSIZE],prchars[UBUFSIZE],value[UBUFSIZE];
int	N,n;

	while(1)
	{
		PickDisplay(list,cfile,field);
		strcpy(pbuf,prompt);
		PromptPrep(prchars,list,field);
		s=getinfo(prompt,prchars,OPTIONAL,"~");
		if(!strlen(s))break; /* done */
		if(*s==ESC)
		{
			N=NValue(list,"#",field,"~");
			if(Start>(N-SHOWLINES))
			{
				Start=1;
			}
			else
			{
				Start=Start+SHOWLINES;
			}
			continue;
		}
               	if(!(n=IsStart(list,"#",field,"~",s)))
		{
			sprintf(pbuf,"ERROR: %s not in list.\n\n",s);
			beep();
			wrline("\n");
			wrline(pbuf);
			crpause();
			continue;
		}
		GetValue(list,"#",field,"~",value,n);
		n=IsValue(cfile,"#",field,"~",value);
		if(n)
		{ 	/* remove it - a la toggle */
			SetValue(cfile,"#",field,"~","",n);
		}
		else
		{ 	/* add it */
			sprintf(pbuf,"%s~%s\n",field,value);
			if(access(cfile,F_OK)==-1)
			{	/* no exists so create */
				CreateFile(cfile);
			}
			AppendFile(cfile,pbuf);
		}
	}
}

void
lm(char *cfile,char *list,char *prompt,char *field)
{
	if(access(list,F_OK)==-1)
	{
		MakeList(cfile,prompt,field);
	}
	else
	{
		PickList(cfile,list,prompt,field);
	}

	return;
}

