#include <stdio.h>
#include <fcntl.h>
#include <signal.h>

typedef struct {
	unsigned char magic[2];
	char *cmd;
	char *opt;
}  CompressMethod;
static CompressMethod zTable[] = {
	0x1f, 0x9d, "compress", "-dc",
	0x1f, 0x1e, "gunzip", NULL,	/* this is old packed Unix-Format, but pcat 
					   doesn't know stdin ... but gunzip does */
	0x1f, 0x8b, "gunzip", NULL
};
#define MethodCnt	sizeof(zTable)/sizeof(CompressMethod)

int isZfile(name)
char *name;
{
  int Method, res, file;
  unsigned char magic[2];

  file = open(name, O_RDONLY);
  res = read(file, magic, 2);
  close(file);
  if (res != 2)
	return -1;

  for (Method=0; Method < MethodCnt; Method++)
	if (zTable[Method].magic[0] == magic[0] &&
	    zTable[Method].magic[1] == magic[1]) {
		return Method;
	  } 
  return -1;
}

static int pid[64];

int Zopen(name, Method)
char *name; int Method;
{
  int ph[2], p, file;

  if (Method < 0 || Method >= MethodCnt)
    return -1;

  if (pipe(ph))
    return -1;
  
  if ((p = fork()) == -1)
    return -1;

  if (p == 0)
  {
    if ((file = open(name, O_RDONLY)) == -1)
      exit(1);

    dup2(file, 0);
    dup2(ph[1], 1);
    dup2(ph[1], 2);
    close(ph[1]);
    close(ph[0]);
    close(file);

    if (execlp(zTable[Method].cmd, zTable[Method].cmd, zTable[Method].opt, NULL) == -1)
      exit(1);
  }
  else
    close(ph[1]);

  pid[ph[0]] = p;
  return ph[0];
}

void Zclose(handle)
int handle;
{
  close(handle);
  kill(pid[handle], SIGPIPE);
  waitpid(pid[handle], NULL, 0);
}
