.\" $Id: xwit.man,v 3.2 95/10/18 16:59:20 dd Exp $
.TH XWIT 1X
.SH NAME
xwit \- window interface tool: pop or iconify this xterm window or named windows
.SH SYNOPSIS
.B
xwit
'in \n(.iu+\w'\fBxwit \fR'u
.RB [ -display
.IR display ]
.RB [ -sync ]
.RB [ -pop ]
.RB [ -iconify ]
.RB [ -unmap ]
.br
.RB [ -resize
.IR w\ h ]
.RB [ -rows
.IR r ]
.RB [ -columns
.IR c ]
.RB [ - [ r ] move
.IR x\ y ]
.br
.RB [ - [ r ] warp 
.IR x\ y ]
.RB [ -colormap
.IR colormapid ]
.RB [ - [ no ] save ]
.br
.RB [ -name
.IR name ]
.RB [ -iconname
.IR name ]
.br
.RB [ -bitmap
.IR file ]
.RB [ -mask
.IR file ]
.RB [ - [ r ] iconmove
.IR x\ y ]
.br
.RB [ - [ no ] backingstore ]
.RB [ - [ no ] saveunder ]
.br
.RB [ - [ no ] keyrepeat
.IR "keycode ... keycode - keycode ..." ]
.br
.RB [ -id
.IR windowid ]
.RB [ -root ]
.RB [ -select ]
.RB [ -names
.IR initialsubstring... ]
.in
.SH DESCRIPTION
.B xwit
is an X window interface tool.
By default when used with no arguments in an xterm it
de-iconifies and raises the window.
You can specify a different function to do, such as iconifying the window,
and apply it to several windows whose name begins with one of the given
strings, or a particular window id given, or the window id found
in the environment variable
.B WINDOWID.
(This variable is set by xterm for the program, usually the shell, it runs.)
.SH OPTIONS
.TP
-display
is followed by the display to open.
.TP
-sync
causes all X requests to be performed synchronously.
.TP
-pop
is the default action.
It need only be given if it is wanted as well as some other function.
.TP
-iconify
will iconify the windows instead of popping them.
.TP
-unmap
will iconify windows by unmapping with a non ICCCM compliant window manager.
(Beware, this option is not usually what you want).
.TP
-resize w h
resize windows to the given pixel size.
.TP
-rows r
resize windows to the given number of rows.
.TP
-columns c
resize windows to the given number of columns.
.TP
-move x y
move windows to the given absolute position relative to its parent.
(If the x or y value is negative it is taken relative to the right or
bottom edge of the parent.)
.TP
-rmove x y
move windows by the given relative amount.
.TP
-warp x y
move the cursor to the given position relative to the specified window.
Add -root to warp to an absolute position.
.TP
-rwarp x y
move the cursor by the given relative amount.
.TP
-colormap colormapid
install the given colormap into the given window.
-save -nosave
immediately enable or disable the screen saver.
.TP
-name name
set the WM_NAME property to the given string.
.TP
-iconname name
set the WM_ICON_NAME property to the given string.
.TP
-bitmap file
use the given bitmap file as the icon bitmap for the window.
.TP
-mask file
use the given bitmap file as the icon mask for the window.
.TP
-iconmove x y
move icons to the given absolute position.  (Will not work with some
window managers.)
.TP
-riconmove x y
move icons by the given relative amount.  (Will not work with some
window managers.)
.TP
-backingstore -bs -nobackingstore -nobs
enable or disable backing store for the window.
.TP
-saveunder -su -nosaveunder -nosu
enable or disable saveunders for the window.
.TP
-keyrepeat -nokeyrepeat
is followed by a list of keycodes (decimal numbers, see xmodmap(1)).
A range can be specified as a lower number, ``-'', and upper number
as three separate arguments.
The individual setting of auto-repeat for those keycodes is set on or off.
The global setting of auto-repeat can be set with xset(1).
When off, no keys will repeat.
.TP
-id
is followed by a single window number, in decimal; or, if it begins with
0x, in hexadecimal.
.TP
-root
selects the root window.
.TP
-select
allows the user to interactively select a window with the mouse.
.TP
-names
if given must be the last option and is followed by a list of strings.
All windows that have a name that begins exactly like one of the strings
will be acted upon.
By using a null string (-names ''), all names will be matched.
.SH EXAMPLES
To iconify all windows (probably not quite what you want to do)

.ta 1i
	xwit -names ''

To de-iconify and pop ``this'' xterm and warp the cursor into it

	xwit -pop -warp 50 50

To gently agitate your oclock on the screen

 	while   xwit -rmove 0 10 -name oclock
 	do      xwit -rmove 0 -10 -name oclock
 	done
.SH DIAGNOSTICS
Exit status is 0 if any action is taken, 1 if no window matches the list
supplied to -names, 2 if an error occurs.
.SH LIMITATIONS
Since each application is supposed to request these functions of the
window manager, some of them may not like other clients mapping and unmapping
for them behind their back.
The iconification is requested of the window manager using the ICCCM.
Non ICCCM compliant window managers may not react correctly.
.SH AUTHORS
Mark M Martin, CETIA France, mmm@cetia.fr
David DiGiacomo, david@slack.com
