.TH XGETFTP 1
.SH NAME
xgetftp \- an X-based tool for browsing and retrieving files from ftp sites
.SH SYNOPSIS
.B xgetftp
[ 
.B \-q
] 
[
.I hostname
]
.SH DESCRIPTION
.B xgetftp
is a sophisticated browsing and file retrieval tool for 
ftp.  It has an X-window user-interface based on the Motif widget set.
Available features include caching of directories, simple
file/directory retrieval, remote text file viewing, caching of viewed files,
and re-use of previously cached files and directories, and also a
simple interface to Archie.
.SH OPTIONS
.TP
.B \-q
This is the "quiet" flag, which will disable the
printing of responses from the ftp server to standard
output.
.TP
.B hostname
If a hostname is given at startup, the program will
attempt to connect to that host using the anonymous login.
.SH USER INTERFACE
The user interface is organized as follows:
.HP
.B Main Window
.br
Pops up after program is started, and contains the entire user
interface.
.HP
.B File List Window
.br
Holds a list of all items in a given directory on the remote
host.  The user can manipulate the files and directories in this
window by either single-clicking or double-clicking on a file or
directory.  A double click on a directory will move the user 'into'
that directory and the contents will be displayed in the File List
Window.  A single-click selects the file or directory for further
action (see below).  Multiple files and/or directories may be selected
by dragging with the mouse.
.HP
.B Current Directory Name
.br
Holds complete pathname of current remote directory.
.HP
.B Status Line
.br
Located at the very bottom of the main window, this tells the user
what host is currently connected to, what file is being retrieved,
and when the retrieval is complete.  Information about deletion and
saving of caches is also given on the status line.
.HP
.B Command Buttons
.br
For performing actions on selected items (see below).
.HP
.B Mode Buttons
.br
For selecting Ascii/Binary mode.  Simply clicking on one of the
buttons selects the appropriate mode.  The default mode is binary.
.HP
.B Menus
.br
For other interaction (see below).
.SH COMMANDS
There are three command buttons, located below the menu:
.HP
.B "View"
.br
The user can view a selected remote file in a separate window.
Viewed files may be cached, if caching is turned on (the default).
Files will be cached in a directory called the "cache root" -- this
is normally the directory $HOME/.xgetftpcachedir . However, the 
user may specify an alternative directory using the environment
variable $XGETFTPCACHEDIR.  Within the cache root directory, each
host has its own directory, which has the same name as the complete
host address -- this is known as the "host cache root".  All the cache
information for a host will be stored it's cache root.  The cache
directory will be created automatically when needed.

When the "view" command is given, a separate child window will pop
up and the contents of the file will be displayed in it.  The user
can navigate through the contents by using the scroll bar.  Pressing
the "Done" button will close the view window.

Note that if the file to be viewed has a ".Z" prefix, it will be
uncompressed within the cache and the uncompressed version will be
shown.
.HP
.B "Retrieve"
.br
All the selected files and directories will be retrieved from the
remote host and stored in the "Destination Directory".  The Destination
Directory is the user's current working directory by default.
.HP
.B "Cd Up"
.br
This moves the user up the remote directory hierarchy. 
.SH MENUS
.HP
.B "File Menu"
.br
About xgetftp...
.br
Gives some information about the program.

Set Preferences...
.br
Allows the user to set and save preferences.  Preferences may be
saved, and are stored in the file $HOME/.xgetftp.

The user preferences are:
.br
Cache View - Whether to cache remote files viewed
.br
Reuse View - Whether to reuse previously cached/viewed files
.br
Reuse Dir - Whether to reuse previously cached directory information
.br
Autosave Dir - Whether to save directory information upon disconnection or exit
.br
Confirm - Confirm cache reuse

Exit
.br
Exits the program.

.HP
.B "Ftp Menu"
.br
Open Connection...
.br
Closes the current connection and pops up a window to prompt the user for
a hostname, username and password.  If the "autosave dir" preference is
set, the directory cache for the current connection will be saved
before the connection is closed.

In the Open Connection window, the username is initially set to
"anonymous", in which case the password entry is ignored.  If anonymous
connection is not wanted, then a username and password must be typed
in.  Note that nothing will be shown in the password entry window when
typing in the password.  Also note that the hostname, username and
password fields will be retained through multiple Opens in the same
session, but will not be retained across sessions. Also, whenever the
password entry window receives the "focus", the current password will
be deleted and a fresh password will need to be typed in.

After all the information has been typed in, click on the Connect button
to start the connection.

A connection will be attempted to the new host, and upon success the
root directory will be displayed in the File List Window.  At this point,
if the Confirm Cache preference is set, and a directory cache for the
host exists and is being used, an informational window will pop up and
will display the time the cache was last modified.  This allows the
user to determine whether the possibility that the cache might be
stale.

.br
Close Connection...
.br
Closes the connection to the current host. If the "autosave dir"
preference is set, the directory cache for the host will be saved before
the connection is closed.

.br
Set Directory...
.br
Sets the destination directory for retrieved files.  The default is
the user's current working directory.

.HP
.B "Cache Menu"
.br
Purge Dir Cache
.br
Deletes the previously saved directory information (if any) about the
host currently connected to.  After the info is deleted, the ftp server
is queried for its root level directory listing and the user is moved
to the root level.  

This function should be executed if the user believes the cache to
be stale.  If xgetftp starts doing wierd things like showing blank
lines in the directory listing or if double-clicking a directory
doesn't work, then it is very likely that there have been major
changes to the ftp server structure and the cache is out of date.

The user can also use the cache creation time in Cache information window
to help determine if the cache is stale and should be replaced.
Generally, a cache that is more that a week or two old should be
deleted.

.br
Purge View Cache
.br
Deletes the viewed file hierarchy for the host currently connected to.

.br
Save Dir Cache
.br
Saves all known directory information about the host currently connected
to.  The directory information is stored in the host's root cache
directory in a file called "DIRCACHE".

.HP
.B "Archie Menu"
.br
Search...
.br
Search for a file using Archie.  A new child window will pop up, which
will have three main areas : the search string area, a "Find" action
button, and a large text view area.  The user should select the 
search string area, type in the string to be searched for, and then
select the "Find" button.  After a brief delay (which will depend
on the archie server), any information found will be displayed in
the text view area.  The user may scroll through the text view area
by using the scroll-bars.

.SH FILES
.PD 0
.TP 20
.B $HOME/.xgetftprc
This is the file that stores the user preferences.
.TP 20
.B $XGETFTPCACHEDIR/*
This directory (if specified) holds all the cache information. 
.TP 20
.B $HOME/.xgetftpcachedir
This is the default directory for the cache information.

.SH "SEE ALSO"
.BR ftp (1)

.SH DIAGNOSTICS
xgetftp will print messages to stderr if compiled with the DEBUG
flag defined.

.SH BUGS
Symbolic links on the remote host will not be handled.  Trying to
retrieve or traverse a symbolic link will result in a warning bell.

Some ftp servers do not return a standard "ls -l" output when given
the DIR command.  xgetftp cannot parse a non-standard output and
will not function properly.

.SH AUTHOR
Salim Alam
.br
University of Colorado, Boulder
.br
salim@cs.colorado.edu

