/*************************************************************************
 *
 * HEADER: 
 *  ui_funcs
 *
 **************************************************************************/

/*
 * Menu ids
 */
#define menuFILE_ABOUT		101
#define menuFILE_SET_PREFS	102
#define menuFILE_EXIT		103

#define menuFTP_OPEN		201
#define menuFTP_CLOSE		202
#define menuFTP_SET_DIR		203
#define menuFTP_SHOW_WIN	204

#define menuCACHE_PURGE_DIR	301
#define menuCACHE_PURGE_VIEW	302
#define menuCACHE_SAVE_DIR	303

#define menuARCHIE_SEARCH	401


/*
 * Command ids
 */
#define cmdVIEW			1
#define cmdRETRIEVE		2
#define cmdCD_UP		3
#define cmdASCII		4
#define cmdIMAGE		5


/*
 * Exported variables
 */
extern Display      *display;   /* The X display           	  */   
extern XtAppContext app_context;/* The application context	  */

#define UPASSLEN	20	/* Max user passwd length	  */
extern char	    user_passwd[];
				/* The password typed in by user  */

extern Widget toplevelW;        /* The top level Widget    	  */
extern Widget mainwindowW;      /* The main window Widget  	  */
extern Widget workframeW;       /* Frame of list, currdir	  */
extern Widget prefdialogW;      /* User Preferences dialog	  */
extern Widget aboutdialogW;     /* The "About..." Dialog  	  */
extern Widget menubarW;         /* The menu bar           	  */
extern Widget filelistW;        /* The scrolled list widget	  */
extern Widget statuslineW;	/* The status line label	  */
extern Widget cmdrowcolW;       /* The commands rowcolumn  	  */
extern Widget opendlgW;         /* Open Connection dialog	  */
extern Widget hosttextW;        /* Hostname                	  */
extern Widget usertextW;        /* Username                	  */
extern Widget viewbbW;          /* Dialog for text viewer 	  */
extern Widget viewtextW;        /* Text for file viewed   	  */
extern Widget archiebbW;        /* Dialog for Archie query	  */
extern Widget archietextW;      /* Result of Archie query 	  */
extern Widget archiefindtextW;  /* String to look for     	  */
extern Widget retrievedirdlgW;	/* Retrieve directory dialog	  */



/*
 * Public functions
 */
#define ui_beep(x)		XBell(display, x)

void
ui_initialize(int *pargc, char **argv);

void
ui_create_pref_dialog(Widget parent, XtCallbackProc cbproc, Prefs *pprefs);

void
ui_create_about_dialog(Widget parent);

void
ui_create_cache_dialog(Widget parent);

void
ui_set_cache_dialog_string(char *str);

void
ui_show_cache_dialog(void);

void
ui_create_view_dialog(Widget parent);

void
ui_create_archie_dialog(Widget parent, XtCallbackProc cbproc);

void
ui_create_menus(Widget parent, XtCallbackProc cbproc);

void
ui_create_work_window(Widget parent, XtCallbackProc cb1, XtCallbackProc cb2);

void
ui_create_commands(Widget parent, XtCallbackProc cmdcb, XtCallbackProc typecb);

void
ui_create_currdir_widget(Widget parent);

void
ui_create_open_dialog(Widget parent, XtCallbackProc cbproc);

void
ui_create_retrieve_dir_dialog(Widget parent, XtCallbackProc cbproc, char *dir);

void
ui_set_currdir(char *str);

void
ui_create_status_line(Widget parent);

void
ui_set_status_line(char *str);

void
ui_set_cursor_busy(Widget w);

void
ui_set_cursor_normal(Widget w);
