/*************************************************************************
 * MODULE
 *  ui_funcs
 *
 * DESCRIPTION
 *  Provides misc. functions for creating and using the user interface
 *
 * AUTHOR:
 *  Salim Alam
 *  University of Colorado, Boulder
 *
 * MODIFICATION LOG:
 *  93.04.19 S.A. - added cache info dialog... note: This file could really
 *		    be optimized to be much smaller...
 *  93.04.02 S.A. - new Open dialog
 *  93.03.17 S.A. - modified default host, removed "Cancel" from about dlg
 *		    added label to open connection dialog.
 *  93.03.11 S.A. - Fixed mesg initialization problem.
 *
 **************************************************************************/

#include <X11/cursorfont.h>
#include <Xm/Xm.h>
#include <Xm/MainW.h>
#include <Xm/List.h>
#include <Xm/RowColumn.h>
#include <Xm/PushBG.h>
#include <Xm/Form.h>
#include <Xm/CascadeB.h>
#include <Xm/Frame.h>
#include <Xm/LabelG.h>
#include <Xm/Text.h>
#include <Xm/MessageB.h>
#include <Xm/ToggleBG.h>
#include <Xm/SelectioB.h>
#include <stdio.h>
#include "prefs.h"
#include "control.h"
#include "ui_funcs.h"


/*
 * Global & Exported variables
 */
Display	     *display;			/* The X display	   */
XtAppContext app_context;		/* The application context */
char 	     user_passwd[UPASSLEN+1];	/* User's password	   */

Widget toplevelW;			/* The top level Widget	   */
Widget mainwindowW;			/* The main window Widget  */
Widget workframeW;			/* Frame of list, currdir  */
Widget prefdialogW;			/* User Preferences dialog */
Widget cachedialogW;			/* Dialog to cache use	   */
Widget aboutdialogW;			/* The "About..." Dialog   */
Widget menubarW;			/* The menu bar		   */
Widget filelistW;			/* The scrolled list widget*/
Widget statuslineW;			/* Status line label	   */
Widget cmdrowcolW;			/* The commands rowcolumn  */
Widget opendlgW;			/* Open Connection dialog  */
Widget hosttextW;			/* Hostname		   */
Widget usertextW;			/* Username		   */
Widget viewbbW;				/* Dialog for text viewer  */
Widget viewtextW;			/* Text for file viewed    */
Widget archiebbW;			/* Dialog for Archie query */
Widget archietextW;			/* Result of Archie query  */
Widget archiefindtextW;			/* String to look for      */
Widget retrievedirdlgW;			/* Dialog for Retrieve dir */

/*
 * Private Global variables
 */
static Widget currdirtextW;		/* Curr Dir Label	   */
static Widget currdirlabelW;		/* Text for curr dir	   */
static int    user_passwd_len;		/* Length of user passwd   */


void ui_initialize(int * pargc, char **argv)
{
    Arg args[2];

    /*
     * init toolkit & create toplevel widgets 
     */
    toplevelW = XtAppInitialize(&app_context, "Xgetftp",
	NULL, 0, pargc, argv, NULL, NULL, 0);

    display = XtDisplay(toplevelW);

    XtSetArg(args[0], XmNmainWindowMarginWidth, 5);
    XtSetArg(args[1], XmNmainWindowMarginHeight, 1);

    mainwindowW = XmCreateMainWindow(toplevelW, "mainw", (ArgList)args, 2);
    XtManageChild(mainwindowW);
}



void prefbtn_cb(Widget w, int what, XmPushButtonCallbackStruct *cb)
{
    switch (what)
    {
      case 0:
	prefs_save(user_prefs);

      case 1:	
	XtUnmanageChild(prefdialogW);
	break;
    }
}

void ui_create_pref_dialog(Widget parent, XtCallbackProc cbproc, Prefs *pprefs)
{
    Widget rowcolW;
    Widget donebtnW;
    Widget savebtnW;
    Widget itemsW[5];
    int nargs;
    Arg args[3];
    XmString xmstr[1];

    prefs_load(pprefs);

    xmstr[0] = XmStringCreateSimple("User Preferences");
    XtSetArg(args[0], XmNdialogTitle, xmstr[0]);
    XtSetArg(args[1], XmNwidth, 200);
    XtSetArg(args[2], XmNheight, 250);
    prefdialogW = XmCreateBulletinBoardDialog(parent, "prefdlg", args, 3);
    XmStringFree(xmstr[0]);

    XtSetArg(args[0], XmNpacking, XmPACK_COLUMN);
    rowcolW = XmCreateRowColumn(prefdialogW, "prefrowcol", args, 1);
    XtManageChild(rowcolW);

    nargs = 0;
    if (pprefs->cache_view)
    {
	XtSetArg(args[nargs], XmNset, True);
	nargs++;
    }
    xmstr[0] = XmStringCreateSimple("View Cache On");
    XtSetArg(args[nargs], XmNlabelString, xmstr[0]);
    nargs++;
    itemsW[0] = XmCreateToggleButtonGadget(rowcolW, "preftb1", args, nargs);
    XmStringFree(xmstr[0]);

    nargs = 0;
    if (pprefs->reuse_view)
    {
	XtSetArg(args[nargs], XmNset, True);
	nargs++;
    }
    xmstr[0] = XmStringCreateSimple("Reuse View Cache");
    XtSetArg(args[nargs], XmNlabelString, xmstr[0]);
    nargs++;
    itemsW[1] = XmCreateToggleButtonGadget(rowcolW, "preftb2", args, nargs);
    XmStringFree(xmstr[0]);

    nargs = 0;
    if (pprefs->reuse_dir)
    {
	XtSetArg(args[nargs], XmNset, True);
	nargs++;
    }
    xmstr[0] = XmStringCreateSimple("Reuse Directory Cache");
    XtSetArg(args[nargs], XmNlabelString, xmstr[0]);
    nargs++;
    itemsW[2] = XmCreateToggleButtonGadget(rowcolW, "preftb3", args, nargs);
    XmStringFree(xmstr[0]);

    nargs = 0;
    if (pprefs->autosave_dir)
    {
	XtSetArg(args[nargs], XmNset, True);
	nargs++;
    }
    xmstr[0] = XmStringCreateSimple("Autosave Directory Cache");
    XtSetArg(args[nargs], XmNlabelString, xmstr[0]);
    nargs++;
    itemsW[3] = XmCreateToggleButtonGadget(rowcolW, "preftb4", args, nargs);
    XmStringFree(xmstr[0]);

    nargs = 0;
    if (pprefs->confirm)
    {
	XtSetArg(args[nargs], XmNset, True);
	nargs++;
    }
    xmstr[0] = XmStringCreateSimple("Confirm Cache Reuse");
    XtSetArg(args[nargs], XmNlabelString, xmstr[0]);
    nargs++;
    itemsW[4] = XmCreateToggleButtonGadget(rowcolW, "preftb5", args, nargs);
    XmStringFree(xmstr[0]);


    XtAddCallback(itemsW[0], XmNvalueChangedCallback, (XtCallbackProc)
	cbproc, (XtPointer) prefCACHE_VIEW);
    XtAddCallback(itemsW[1], XmNvalueChangedCallback, (XtCallbackProc)
	cbproc, (XtPointer) prefREUSE_VIEW);
    XtAddCallback(itemsW[2], XmNvalueChangedCallback, (XtCallbackProc)
	cbproc, (XtPointer) prefREUSE_DIR);
    XtAddCallback(itemsW[3], XmNvalueChangedCallback, (XtCallbackProc)
	cbproc, (XtPointer) prefAUTOSAVE_DIR);
    XtAddCallback(itemsW[4], XmNvalueChangedCallback, (XtCallbackProc)
	cbproc, (XtPointer) prefCONFIRM);


    XtManageChildren(itemsW, 5);


    XtSetArg(args[0], XmNx, 10);
    XtSetArg(args[1], XmNy, 215);
    xmstr[0] = XmStringCreateSimple("Done");
    XtSetArg(args[2], XmNlabelString, xmstr[0]);
    donebtnW = XmCreatePushButtonGadget(prefdialogW, "prefdone", args, 3);
    XmStringFree(xmstr[0]);
    XtAddCallback(donebtnW, XmNactivateCallback, (XtCallbackProc) prefbtn_cb,
	(XtPointer)1);
    XtManageChild(donebtnW);

    XtSetArg(args[0], XmNx, 80);
    XtSetArg(args[1], XmNy, 215);
    xmstr[0] = XmStringCreateSimple("Save");
    XtSetArg(args[2], XmNlabelString, xmstr[0]);
    savebtnW = XmCreatePushButtonGadget(prefdialogW, "prefsave", args, 3);
    XmStringFree(xmstr[0]);
    XtAddCallback(savebtnW, XmNactivateCallback, (XtCallbackProc) prefbtn_cb,
	(XtPointer)0);
    XtManageChild(savebtnW);
}



void ui_create_about_dialog(Widget parent)
{
    Arg args[3];
    XmString xmstr[2];
    char *mesg = "xgetftp v2.0\n\nSalim Alam\nUniversity of Colorado, Boulder\n\nPlease email serious bug reports\nto: salim@cs.colorado.edu";

    xmstr[0] = XmStringCreateLtoR(mesg, XmSTRING_DEFAULT_CHARSET);
    XtSetArg(args[0], XmNmessageString, xmstr[0]);
    xmstr[1] = XmStringCreateLtoR("About xgetftp...", XmSTRING_DEFAULT_CHARSET);
    XtSetArg(args[1], XmNdialogTitle, xmstr[1]);
    XtSetArg(args[2], XmNwidth, 275);
    aboutdialogW = XmCreateInformationDialog(parent, "aboutdlg", args, 3);
    XmStringFree(xmstr[0]);
    XmStringFree(xmstr[1]);

    XtUnmanageChild(XmMessageBoxGetChild(aboutdialogW, XmDIALOG_HELP_BUTTON));
    XtUnmanageChild(XmMessageBoxGetChild(aboutdialogW, XmDIALOG_CANCEL_BUTTON));
}


void ui_create_cache_dialog(Widget parent)
{
    Arg args[2];
    XmString xmstr[1];

    xmstr[0] = XmStringCreateLtoR("Cache Use", XmSTRING_DEFAULT_CHARSET);
    XtSetArg(args[0], XmNdialogTitle, xmstr[0]);
    XtSetArg(args[1], XmNwidth, 275);
    cachedialogW = XmCreateInformationDialog(parent, "cachedlg", args, 2);
    XmStringFree(xmstr[0]);

    XtUnmanageChild(XmMessageBoxGetChild(cachedialogW, XmDIALOG_HELP_BUTTON));
    XtUnmanageChild(XmMessageBoxGetChild(cachedialogW, XmDIALOG_CANCEL_BUTTON));
}


void ui_set_cache_dialog_string(char *str)
{
    Arg args[1];
    XmString xmstr[1];
   
    xmstr[0] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
    XtSetArg(args[0], XmNmessageString, xmstr[0]);
    XtSetValues(cachedialogW, args, 1);
}


void ui_show_cache_dialog(void)
{
    XtManageChild(cachedialogW);
}


void ui_create_work_window(Widget parent, XtCallbackProc dblclkcb,
	XtCallbackProc selectcb)
{
    Widget workformW;
    Arg args[10];

    XtSetArg(args[0], XmNmarginWidth, 5);
    XtSetArg(args[1], XmNmarginHeight, 5);
    workframeW = XmCreateFrame(parent, "frame", args, 2);
    XtManageChild(workframeW);

    XtSetArg(args[0], XmNresizable, False);
    workformW = XmCreateForm(workframeW, "form", args, 1);
    XtManageChild(workformW);

    ui_create_currdir_widget(workformW);

    XtSetArg(args[0], XmNselectionPolicy, XmEXTENDED_SELECT);
    XtSetArg(args[1], XmNdoubleClickInterval, 400);
    filelistW = XmCreateScrolledList(workformW, "filelist", args, 2);

    XtSetArg(args[0], XmNwidth, 500);
    XtSetArg(args[1], XmNheight, 390);
    XtSetArg(args[2], XmNleftOffset, 10);
    XtSetArg(args[3], XmNleftAttachment, XmATTACH_FORM);
    XtSetArg(args[4], XmNrightOffset, 10);
    XtSetArg(args[5], XmNrightAttachment, XmATTACH_FORM);
    XtSetArg(args[6], XmNtopOffset, 40);
    XtSetArg(args[7], XmNtopAttachment, XmATTACH_FORM);
    XtSetArg(args[8], XmNbottomOffset, 5);
    XtSetArg(args[9], XmNbottomAttachment, XmATTACH_FORM);
    XtSetValues(XtParent(filelistW), args, 10);

    XtAddCallback(filelistW, XmNdefaultActionCallback, dblclkcb, NULL);
    XtAddCallback(filelistW, XmNextendedSelectionCallback, selectcb, NULL);
    XtManageChild(filelistW);
}


void ui_create_commands(Widget parent, XtCallbackProc cmdcbproc,
	XtCallbackProc typecbproc)
{
    Widget cmdbtnsW[3];
    Widget typeboxW;
    Widget typebtnsW[2];
    Arg args[2];
    XmString xmstr[1];

    /*
     * Create Command Buttons
     */
    XtSetArg(args[0], XmNorientation, XmHORIZONTAL);
    XtSetArg(args[1], XmNpacking, XmPACK_COLUMN);
    cmdrowcolW = XmCreateRowColumn(parent, "commands", args, 2);
    XtManageChild(cmdrowcolW);

    xmstr[0] = XmStringCreateLtoR("View", XmSTRING_DEFAULT_CHARSET);
    XtSetArg(args[0], XmNlabelString, xmstr[0]);
    cmdbtnsW[0] = XmCreatePushButtonGadget(cmdrowcolW, "cmdb1", args, 1);
    XmStringFree(xmstr[0]);

    xmstr[0] = XmStringCreateLtoR("Retrieve", XmSTRING_DEFAULT_CHARSET);
    XtSetArg(args[0], XmNlabelString, xmstr[0]);
    cmdbtnsW[1] = XmCreatePushButtonGadget(cmdrowcolW, "cmdb2", args, 1);
    XmStringFree(xmstr[0]);

    xmstr[0] = XmStringCreateLtoR("Cd ..", XmSTRING_DEFAULT_CHARSET);
    XtSetArg(args[0], XmNlabelString, xmstr[0]);
    cmdbtnsW[2] = XmCreatePushButtonGadget(cmdrowcolW, "cmdb3", args, 1);
    XmStringFree(xmstr[0]);

    XtAddCallback(cmdbtnsW[0], XmNactivateCallback, cmdcbproc, 
	(XtPointer) cmdVIEW);
    XtAddCallback(cmdbtnsW[1], XmNactivateCallback, cmdcbproc, 
	(XtPointer) cmdRETRIEVE);
    XtAddCallback(cmdbtnsW[2], XmNactivateCallback, cmdcbproc, 
	(XtPointer) cmdCD_UP);

    XtManageChildren(cmdbtnsW, 3);


    /*
     * Create "Type" Toggles
     */
    XtSetArg(args[0], XmNorientation, XmHORIZONTAL);
    typeboxW = XmCreateRadioBox(cmdrowcolW, "typebox", args, 1);
    XtManageChild(typeboxW);

    xmstr[0] = XmStringCreateLtoR("ASCII", XmSTRING_DEFAULT_CHARSET);
    XtSetArg(args[0], XmNlabelString, xmstr[0]);
    typebtnsW[0] = XmCreateToggleButtonGadget(typeboxW, "type_a", args, 1);
    XmStringFree(xmstr[0]);

    xmstr[0] = XmStringCreateLtoR("BINARY", XmSTRING_DEFAULT_CHARSET);
    XtSetArg(args[0], XmNlabelString, xmstr[0]);
    XtSetArg(args[1], XmNset, True);
    typebtnsW[1] = XmCreateToggleButtonGadget(typeboxW, "type_i", args, 2);
    XmStringFree(xmstr[0]);

    XtAddCallback(typebtnsW[0], XmNvalueChangedCallback, typecbproc, 
	(XtPointer) cmdASCII);
    XtAddCallback(typebtnsW[1], XmNvalueChangedCallback, typecbproc, 
	(XtPointer) cmdIMAGE);

    XtManageChildren(typebtnsW, 2);
}



void ui_create_menus(Widget parent, XtCallbackProc cbproc)
/*
 * Create all the menus needed.  "parent" is the parent Widget,
 * and "cbproc" is the callback procedure.  Returns the menubar
 * Widget
 */
{
    Widget pulldownsW[4];	/* The menu bar pulldows	*/
    Widget menubarbtnsW[4];	/* The menu bar buttons		*/
    Widget buttons1W[3];	/* Menu#1 items			*/
    Widget buttons2W[4];	/* Menu#2 items			*/
    Widget buttons3W[3];	/* Menu#3 items			*/
    Widget buttons4W[1];	/* Menu#4 items			*/
    Arg args[3];
    XmString xmstr[1];


    /*
     * create menubar, pulldowns and cascade buttons
     */
    menubarW = XmCreateMenuBar(parent, "menubar", (ArgList)NULL, 0);
    XtManageChild(menubarW);

    pulldownsW[0] = XmCreatePulldownMenu(menubarW, "pulldown1", NULL, 0);
    XtSetArg(args[0], XmNsubMenuId, pulldownsW[0]);
    xmstr[0] = XmStringCreateLtoR("File", XmSTRING_DEFAULT_CHARSET);
    XtSetArg(args[1], XmNlabelString, xmstr[0]);
    menubarbtnsW[0] = XmCreateCascadeButton(menubarW, "m1cascade", args, 2);
    XmStringFree(xmstr[0]);

    pulldownsW[1] = XmCreatePulldownMenu(menubarW, "pulldown2", NULL, 0);
    XtSetArg(args[0], XmNsubMenuId, pulldownsW[1]);
    xmstr[0] = XmStringCreateLtoR("FTP", XmSTRING_DEFAULT_CHARSET);
    XtSetArg(args[1], XmNlabelString, xmstr[0]);
    menubarbtnsW[1] = XmCreateCascadeButton(menubarW, "m2cascade", args, 2);
    XmStringFree(xmstr[0]);

    pulldownsW[2] = XmCreatePulldownMenu(menubarW, "pulldown3", NULL, 0);
    XtSetArg(args[0], XmNsubMenuId, pulldownsW[2]);
    xmstr[0] = XmStringCreateLtoR("Cache", XmSTRING_DEFAULT_CHARSET);
    XtSetArg(args[1], XmNlabelString, xmstr[0]);
    menubarbtnsW[2] = XmCreateCascadeButton(menubarW, "m3cascade", args, 2);
    XmStringFree(xmstr[0]);

    pulldownsW[3] = XmCreatePulldownMenu(menubarW, "pulldown4", NULL, 0);
    XtSetArg(args[0], XmNsubMenuId, pulldownsW[3]);
    xmstr[0] = XmStringCreateLtoR("Archie", XmSTRING_DEFAULT_CHARSET);
    XtSetArg(args[1], XmNlabelString, xmstr[0]);
    menubarbtnsW[3] = XmCreateCascadeButton(menubarW, "m4cascade", args, 2);
    XmStringFree(xmstr[0]);

    XtManageChildren(menubarbtnsW, 4);



    /*
     * add pushbuttons to menu cascade buttons 
     */
    xmstr[0] = XmStringCreateLtoR("About xgetftp...", XmSTRING_DEFAULT_CHARSET);
    XtSetArg(args[0], XmNlabelString, xmstr[0]);
    buttons1W[0] = XmCreatePushButtonGadget(pulldownsW[0], "m1b1", args, 1);
    XmStringFree(xmstr[0]);
    XtAddCallback(buttons1W[0], XmNactivateCallback, cbproc, 
	(XtPointer) menuFILE_ABOUT);

    xmstr[0] = XmStringCreateLtoR("Set Preferences...", XmSTRING_DEFAULT_CHARSET);
    XtSetArg(args[0], XmNlabelString, xmstr[0]);
    buttons1W[1] = XmCreatePushButtonGadget(pulldownsW[0], "m1b2", args, 1);
    XmStringFree(xmstr[0]);
    XtAddCallback(buttons1W[1],XmNactivateCallback,cbproc,
	(XtPointer) menuFILE_SET_PREFS);

    xmstr[0] = XmStringCreateLtoR("Exit", XmSTRING_DEFAULT_CHARSET);
    XtSetArg(args[0], XmNlabelString, xmstr[0]);
    buttons1W[2] = XmCreatePushButtonGadget(pulldownsW[0], "m1b3", args, 1);
    XmStringFree(xmstr[0]);
    XtAddCallback(buttons1W[2], XmNactivateCallback, cbproc, 
	(XtPointer) menuFILE_EXIT);

    XtManageChildren(buttons1W, 3);


    xmstr[0] = XmStringCreateLtoR("Open Connection...", XmSTRING_DEFAULT_CHARSET);
    XtSetArg(args[0], XmNlabelString, xmstr[0]);
    buttons2W[0] = XmCreatePushButtonGadget(pulldownsW[1], "m2b1", args, 1);
    XmStringFree(xmstr[0]);
    XtAddCallback(buttons2W[0], XmNactivateCallback, cbproc, 
	(XtPointer) menuFTP_OPEN);

    xmstr[0] = XmStringCreateLtoR("Close Connection", XmSTRING_DEFAULT_CHARSET);
    XtSetArg(args[0], XmNlabelString, xmstr[0]);
    buttons2W[1] = XmCreatePushButtonGadget(pulldownsW[1], "m2b2", args, 1);
    XmStringFree(xmstr[0]);
    XtAddCallback(buttons2W[1], XmNactivateCallback, cbproc, 
	(XtPointer) menuFTP_CLOSE);

    xmstr[0] = XmStringCreateLtoR("Set Destination Dir...",
	XmSTRING_DEFAULT_CHARSET);
    XtSetArg(args[0], XmNlabelString, xmstr[0]);
    buttons2W[2] = XmCreatePushButtonGadget(pulldownsW[1], "m2b3", args, 1);
    XmStringFree(xmstr[0]);
    XtAddCallback(buttons2W[2], XmNactivateCallback, cbproc, 
	(XtPointer) menuFTP_SET_DIR);

/*
    buttons2W[3] = XmCreatePushButtonGadget(pulldownsW[1], "m2b4", NULL, 0);
    XtAddCallback(buttons2W[2], XmNactivateCallback, cbproc, 
	(XtPointer) menuFTP_SHOW_WIN);
*/

    XtManageChildren(buttons2W, 3);


    xmstr[0] = XmStringCreateLtoR("Purge Dir Cache", XmSTRING_DEFAULT_CHARSET);
    XtSetArg(args[0], XmNlabelString, xmstr[0]);
    buttons3W[0] = XmCreatePushButtonGadget(pulldownsW[2], "m3b1", args, 1);
    XmStringFree(xmstr[0]);
    XtAddCallback(buttons3W[0], XmNactivateCallback, cbproc, 
	(XtPointer) menuCACHE_PURGE_DIR);

    xmstr[0] = XmStringCreateLtoR("Purge View Cache", XmSTRING_DEFAULT_CHARSET);
    XtSetArg(args[0], XmNlabelString, xmstr[0]);
    buttons3W[1] = XmCreatePushButtonGadget(pulldownsW[2], "m3b2", args, 1);
    XmStringFree(xmstr[0]);
    XtAddCallback(buttons3W[1], XmNactivateCallback, cbproc, 
	(XtPointer) menuCACHE_PURGE_VIEW);

    xmstr[0] = XmStringCreateLtoR("Save Dir Cache", XmSTRING_DEFAULT_CHARSET);
    XtSetArg(args[0], XmNlabelString, xmstr[0]);
    buttons3W[2] = XmCreatePushButtonGadget(pulldownsW[2], "m3b3", args, 1);
    XmStringFree(xmstr[0]);
    XtAddCallback(buttons3W[2], XmNactivateCallback, cbproc, 
	(XtPointer) menuCACHE_SAVE_DIR);

    XtManageChildren(buttons3W, 3);


    xmstr[0] = XmStringCreateLtoR("Search...", XmSTRING_DEFAULT_CHARSET);
    XtSetArg(args[0], XmNlabelString, xmstr[0]);
    buttons4W[0] = XmCreatePushButtonGadget(pulldownsW[3], "m4b1", args, 1);
    XmStringFree(xmstr[0]);
    XtAddCallback(buttons4W[0], XmNactivateCallback, cbproc, 
	(XtPointer) menuARCHIE_SEARCH);

    XtManageChildren(buttons4W, 1);
}



void ui_create_view_dialog(Widget parent)
{
    Arg args[6];
    XmString xmstr[1];
    Widget viewdoneW;

    xmstr[0] = XmStringCreateSimple("File Viewer");
    XtSetArg(args[0], XmNdialogTitle, xmstr[0]);
    XtSetArg(args[1], XmNwidth, 550);
    XtSetArg(args[2], XmNheight, 430);
    viewbbW = XmCreateBulletinBoardDialog(parent, "popbb", args, 3);
    XmStringFree(xmstr[0]);

    XtSetArg(args[0], XmNx, 10);
    XtSetArg(args[1], XmNy, 20);
    XtSetArg(args[2], XmNeditable, False);
    XtSetArg(args[3], XmNeditMode, XmMULTI_LINE_EDIT);
    XtSetArg(args[4], XmNrows, 24);
    XtSetArg(args[5], XmNcolumns, 80);
    viewtextW = XmCreateScrolledText(viewbbW, "poptext", args, 6);
    XtManageChild(viewtextW);

    XtSetArg(args[0], XmNx, 15);
    XtSetArg(args[1], XmNy, 380);
    xmstr[0] = XmStringCreateSimple("Done");
    XtSetArg(args[2], XmNlabelString, xmstr[0]);
    viewdoneW = XmCreatePushButtonGadget(viewbbW, "popdone", args, 3);
    XmStringFree(xmstr[0]);
    XtManageChild(viewdoneW);
    XtSetArg(args[0], XmNdefaultButton, viewdoneW);
    XtSetValues(viewbbW, args, 1);
}



void archiedoneCB(Widget w, caddr_t data, XmPushButtonCallbackStruct *cb)
{
    XtUnmanageChild(archiebbW);
}

void ui_create_archie_dialog(Widget parent, XtCallbackProc cbproc)
{
    Widget findlabelW;
    Widget archiedoneW;
    XmString xmstr[1];
    Arg args[5];

    xmstr[0] = XmStringCreateSimple("Archie Search");
    XtSetArg(args[0], XmNdialogTitle, xmstr[0]);
    XtSetArg(args[1], XmNwidth, 550);
    XtSetArg(args[2], XmNheight, 430);
    XtSetArg(args[3], XmNautoUnmanage, False);
    archiebbW = XmCreateBulletinBoardDialog(parent, "popbb2", args, 4);
    XmStringFree(xmstr[0]);

    xmstr[0] = XmStringCreateSimple("Find:");
    XtSetArg(args[0], XmNlabelString, xmstr[0]);
    XtSetArg(args[1], XmNx, 10);
    XtSetArg(args[2], XmNy, 13);
    findlabelW = XmCreatePushButtonGadget(archiebbW, "findlabel", args, 3);
    XmStringFree(xmstr[0]);
    XtAddCallback(findlabelW, XmNactivateCallback, cbproc, (XtPointer) NULL);
    XtManageChild(findlabelW);

    XtSetArg(args[0], XmNx, 60);
    XtSetArg(args[1], XmNy, 10);
    XtSetArg(args[2], XmNeditable, True);
    XtSetArg(args[3], XmNrows, 1);
    XtSetArg(args[4], XmNcolumns, 60);
    archiefindtextW = XmCreateText(archiebbW, "findtext", args, 5);
    XtManageChild(archiefindtextW);

    XtSetArg(args[0], XmNeditable, False);
    XtSetArg(args[1], XmNeditMode, XmMULTI_LINE_EDIT);
    XtSetArg(args[2], XmNrows, 20);
    XtSetArg(args[3], XmNcolumns, 80);
    archietextW = XmCreateScrolledText(archiebbW,"archietext", args, 4);

    XtSetArg(args[0], XmNx, 10);
    XtSetArg(args[1], XmNy, 70);
    XtSetValues(XtParent(archietextW), args, 2);
    XtManageChild(archietextW);

    XtSetArg(args[0], XmNx, 15);
    XtSetArg(args[1], XmNy, 380);
    xmstr[0] = XmStringCreateSimple("Done");
    XtSetArg(args[2], XmNlabelString, xmstr[0]);
    archiedoneW = XmCreatePushButtonGadget(archiebbW, "archiedone", args, 3);
    XmStringFree(xmstr[0]);
    XtAddCallback(archiedoneW, XmNactivateCallback, (XtCallbackProc) 
	archiedoneCB, NULL);
    XtManageChild(archiedoneW);
}


void ui_create_retrieve_dir_dialog(Widget parent, XtCallbackProc cbproc,
	char *retrieve_dir)
{
    Arg args[3];
    XmString xmstr[2];

    xmstr[0] = XmStringCreateLtoR(retrieve_dir, XmSTRING_DEFAULT_CHARSET);
    XtSetArg(args[0], XmNtextString, xmstr[0]);
    xmstr[1] = XmStringCreateSimple("Set Retrieve Directory");
    XtSetArg(args[1], XmNdialogTitle, xmstr[1]);
    XtSetArg(args[2], XmNwidth, 275);
    retrievedirdlgW = XmCreatePromptDialog(parent, "retrievedirdlg", args, 3);
    XmStringFree(xmstr[0]);
    XmStringFree(xmstr[1]);
    XtUnmanageChild(XmSelectionBoxGetChild(retrievedirdlgW,
	XmDIALOG_HELP_BUTTON));
    XtAddCallback(retrievedirdlgW, XmNokCallback, cbproc, (XtPointer) NULL);
}


void ui_create_currdir_widget(Widget parent)
{
    Arg args[6];
    XmString xmstr[1];

    XtSetArg(args[0], XmNleftOffset, 10);
    XtSetArg(args[1], XmNleftAttachment, XmATTACH_FORM);
    XtSetArg(args[2], XmNy, 10);
    xmstr[0] = XmStringCreateSimple("Current Dir:");
    XtSetArg(args[3], XmNlabelString, xmstr[0]);
    currdirlabelW = XmCreateLabelGadget(parent, "currdirlabel", args, 4);
    XmStringFree(xmstr[0]);
    XtManageChild(currdirlabelW);

    XtSetArg(args[0], XmNleftOffset, 86);
    XtSetArg(args[1], XmNleftAttachment, XmATTACH_FORM);
    XtSetArg(args[2], XmNy, 5);
    XtSetArg(args[3], XmNeditable, False);
    XtSetArg(args[4], XmNrows, 1);
    XtSetArg(args[5], XmNcolumns, 67);
    currdirtextW  = XmCreateText(parent, "currdirtext", args, 6);
    XtManageChild(currdirtextW);
}



void ui_set_currdir(char *str)
{
    XmTextSetString(currdirtextW, str);
}


void cancelCB(Widget w, caddr_t data, XmPushButtonCallbackStruct *cb)
{
    XtUnmanageChild(opendlgW);
}

void modifyCB(Widget w, caddr_t data, XmTextVerifyCallbackStruct *cb)
{
    if (cb->text->ptr == NULL) { /* backspace */
	if (user_passwd_len > 0)
            user_passwd[--user_passwd_len] = '\0'; 
	cb->doit = False;
        return;
    }

    if (cb->text->length > 1) {
        cb->doit = False; /* don't allow "paste" operations */
        return; /* make the user *type* the password! */
    }

    if (user_passwd_len < UPASSLEN)
    {
    	user_passwd[user_passwd_len++] = *(cb->text->ptr);
	user_passwd[user_passwd_len] = '\0';
    }

    cb->doit = False;
}

void focusCB(Widget w, caddr_t data, XmAnyCallbackStruct *cb)
{
    user_passwd[user_passwd_len=0] = '\0';
}

void ui_create_open_dialog(Widget parent, XtCallbackProc cbproc)
{
    Widget hostlabelW;
    Widget userlabelW;
    Widget passlabelW;
    Widget passtextW;
    Widget okbuttonW;
    Widget cancelbuttonW;
    XmString xmstr[1];
    Arg args[6];

    /* Create open bulletin board dialog */
    xmstr[0] = XmStringCreateSimple("Open Connection");
    XtSetArg(args[0], XmNdialogTitle, xmstr[0]);
    XtSetArg(args[1], XmNwidth, 275);
    XtSetArg(args[2], XmNheight, 250);
    XtSetArg(args[3], XmNautoUnmanage, False);
    opendlgW = XmCreateBulletinBoardDialog(parent, "opendlg", args, 4);
    XmStringFree(xmstr[0]);

    /* Create hostname query */
    xmstr[0] = XmStringCreateSimple("Hostname:");
    XtSetArg(args[0], XmNlabelString, xmstr[0]);
    XtSetArg(args[1], XmNx, 10);
    XtSetArg(args[2], XmNy, 10);
    hostlabelW = XmCreateLabelGadget(opendlgW, "hostlabel", args, 3);
    XmStringFree(xmstr[0]);
    XtManageChild(hostlabelW);

    XtSetArg(args[0], XmNx, 10);
    XtSetArg(args[1], XmNy, 30);
    XtSetArg(args[2], XmNeditable, True);
    XtSetArg(args[3], XmNrows, 1);
    XtSetArg(args[4], XmNcolumns, 40);
    hosttextW = XmCreateText(opendlgW, "host", args, 5);
    XtManageChild(hosttextW);

    /* Create username query */
    xmstr[0] = XmStringCreateSimple("User:");
    XtSetArg(args[0], XmNlabelString, xmstr[0]);
    XtSetArg(args[1], XmNx, 10);
    XtSetArg(args[2], XmNy, 70);
    userlabelW = XmCreateLabelGadget(opendlgW, "userlabel", args, 3);
    XmStringFree(xmstr[0]);
    XtManageChild(userlabelW);

    XtSetArg(args[0], XmNx, 10);
    XtSetArg(args[1], XmNy, 90);
    XtSetArg(args[2], XmNeditable, True);
    XtSetArg(args[3], XmNrows, 1);
    XtSetArg(args[4], XmNcolumns, 40);
    XtSetArg(args[5], XmNvalue, "anonymous");
    usertextW = XmCreateText(opendlgW, "usertext", args, 6);
    XtManageChild(usertextW);

    /* Create password query */
    xmstr[0] = XmStringCreateSimple("Password:");
    XtSetArg(args[0], XmNlabelString, xmstr[0]);
    XtSetArg(args[1], XmNx, 10);
    XtSetArg(args[2], XmNy, 130);
    passlabelW = XmCreateLabelGadget(opendlgW, "passlabel", args, 3);
    XmStringFree(xmstr[0]);
    XtManageChild(passlabelW);

    XtSetArg(args[0], XmNx, 10);
    XtSetArg(args[1], XmNy, 150);
    XtSetArg(args[2], XmNeditable, True);
    XtSetArg(args[3], XmNrows, 1);
    XtSetArg(args[4], XmNcolumns, 40);
    XtSetArg(args[5], XmNverifyBell, False);
    passtextW = XmCreateText(opendlgW, "passtext", args, 6);
    XtAddCallback(passtextW, XmNmodifyVerifyCallback, (XtCallbackProc)
	modifyCB, (XtPointer) NULL);
    XtAddCallback(passtextW, XmNfocusCallback, (XtCallbackProc) focusCB,
	(XtPointer) NULL);
    XtManageChild(passtextW);

    /* Create buttons */
    xmstr[0] = XmStringCreateSimple("Connect!");
    XtSetArg(args[0], XmNlabelString, xmstr[0]);
    XtSetArg(args[1], XmNx, 20);
    XtSetArg(args[2], XmNy, 200);
    okbuttonW = XmCreatePushButtonGadget(opendlgW, "okbutton", args, 3);
    XmStringFree(xmstr[0]);
    XtAddCallback(okbuttonW, XmNactivateCallback, cbproc, (XtPointer) NULL);
    XtManageChild(okbuttonW);

    xmstr[0] = XmStringCreateSimple("Cancel");
    XtSetArg(args[0], XmNlabelString, xmstr[0]);
    XtSetArg(args[1], XmNx, 150);
    XtSetArg(args[2], XmNy, 200);
    cancelbuttonW = XmCreatePushButtonGadget(opendlgW, "cancelbutton", args, 3);
    XmStringFree(xmstr[0]);
    XtAddCallback(cancelbuttonW, XmNactivateCallback, (XtCallbackProc) cancelCB,
	(XtPointer) NULL);
    XtManageChild(cancelbuttonW);
}



void ui_create_status_line(Widget parent)
{
    statuslineW = XmCreateLabelGadget(parent, "status", (ArgList)NULL, 0);
    XtManageChild(statuslineW);
}



void ui_set_status_line(char *str)
/*
 * Set the status line to 'str'
 */
{
    XmString labeltext;
    Arg args[1];

    labeltext = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
    XtSetArg(args[0], XmNlabelString, labeltext);
    XtSetValues(statuslineW, args, 1);
    XmStringFree(labeltext);
}



void ui_set_cursor_busy(Widget w)
/*
 * Sets the cursor to be a "watch" symbol in the Widget w
 */
{
    Cursor cursor;

    cursor = XCreateFontCursor(XtDisplay(w), XC_watch);
    XDefineCursor(XtDisplay(w), XtWindow(w), cursor);
    XFlush(XtDisplay(w));
}



void ui_set_cursor_normal(Widget w)
/*
 * Resets the cursor in Widget w
 */
{
    XUndefineCursor(XtDisplay(w), XtWindow(w));
    XFlush(XtDisplay(w));
}

