/*
 * HEADER: cache.h
 */

/*
 * The following typedefs are exported to other modules, but are not
 * meant to be used explicitly.
 */

typedef struct _cacheinfo *cacheinfo_ptr;

#define fitypFILE	0
#define fitypDIRECTORY	1
#define fitypLINK	2

typedef struct _fileinfo
{
    char *line;
    char *name;
    char type;
    char fCached;
    cacheinfo_ptr next_level;
} fileinfo;

typedef struct _cacheinfo
{
    int num_entries;
    fileinfo *entry_arr;
    cacheinfo_ptr prev_level;
} cacheinfo;


/*
 * The following variables are exported to other modules.  They should
 * be managed using the functions provided by this module.
 */

extern cacheinfo_ptr toplevel;
extern cacheinfo_ptr currlevel;


/*
 * Public function prototypes.
 */

void
cache_set_root(char *root);

void
cache_next_dir(char *dir);

void
cache_prev_dir(void);

char *
cache_make_filename(char *filename);

int
cache_init_level(cacheinfo_ptr *level, cacheinfo_ptr prev, char *filename);

void
cache_print_level(cacheinfo_ptr level);

void
cache_free_levels(cacheinfo_ptr *plevel);

int
cache_save_cache(char * filepath);

int
cache_load_cache(char * filepath);
