#include <stdio.h>
#include <ctype.h>
#include <errno.h>
#include <X11/Xos.h>
#include <X11/Xmu/CharSet.h>
#include "twm.h"
#include "screen.h"
#include "menus.h"
#include "util.h"
#include "gram.h"
#include "parse.h"
#include <X11/Xatom.h>
#include "vdt.h"

/* For m4... */
#include <sys/param.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>

FILE *raw;
static FILE *start_m4();
static FILE *twmrc;
#define BUF_LEN 2000

int m4_pid;
char InitFile[99];

#define MAXHOSTNAME 255
#define Resolution(pixels, mm)	((((pixels) * 100000 / (mm)) + 50) / 100)
#define EXTRA	(15)

main()
  {
  char buff[BUF_LEN];
	raw = fopen ("sample-twmrc/cross.twmrc", "r");
    twmrc = start_m4(raw);
    if (fgets(buff, BUF_LEN, twmrc) == NULL)
      {
      puts ("NUL RETURN");
      }
  puts(buff);
  }
static FILE *start_m4(fraw)
FILE *fraw;
{
	int fno;
	int fids[2];
	int fres;		/* Fork result */

	fno = fileno(fraw);
	/* if (-1 == fcntl(fno, F_SETFD, 0)) perror("fcntl()"); */
	pipe(fids);
	fres = fork();
	if (fres < 0) {
		perror("Fork for m4 failed");
		exit(23);
	}
	if (fres == 0) {
/*******
		extern Display *dpy;
		extern char *display_name;
**************/
		static char *m4_defs();
		char *tmp_file;
		/* Child */
		close(0);			/* stdin */
		close(1);			/* stdout */
		dup2(fno, 0);		/* stdin = fraw */
		dup2(fids[1], 1);	/* stdout = pipe to parent */
		/* get_defs("m4", dpy, display_name) */
/*		tmp_file = m4_defs(dpy, display_name); */
/*	tmp_file = m4_defs(dpy, ":0.0");  */
	tmp_file = "/tmp/tabc";
		execlp("m4", "m4", tmp_file, "-", NULL); 
		/* If we get here we are screwed... */
		perror("Can't execlp() m4");
		exit(124);
	}
	/* Parent */
	close(fids[1]);
	m4_pid = fres;
#if 0
#define USEC 100000
	{
	struct timeval tv;

	timerclear(&tv);
	tv.tv_sec = USEC / 1000000;
	tv.tv_usec = USEC % 1000000;
	select(0, NULL, NULL, NULL, &tv);
	}
#undef USEC
	kill(m4_pid, SIGSTOP);
#endif /* 0 */
	return(fdopen(fids[0], "r"));
}

#ifdef NOTREALLY
static char *MkDef(name, def)
char *name, *def;
{
	static char *cp = NULL;
	static int maxsize = 0;
	int n, nl;

	/* The char * storage only lasts for 1 call... */
	if ((n = EXTRA + ((nl = strlen(name)) +  strlen(def))) > maxsize) {
		if (cp) free(cp);
		cp = malloc(n);
		maxsize = n;
	}
	/* Otherwise cp is aready big 'nuf */
	if (cp == NULL) { 
		fprintf(stderr, "%s: Can't get %d bytes for arg parm\n",
			ProgramName, n);
		exit(33);
	}
	strcpy(cp, "define(");
	strcpy(cp+7, name);
	*(cp + nl + 7) = ',';
	*(cp + nl + 8) = ' ';
	strcpy(cp + nl + 9, def);
	strcat(cp + nl + 9, ")dnl\n");
	return(cp);
}

static char *m4_defs(display, host)
Display *display;
char *host;
{
	extern int KeepTmpFile;
	int i;
	Screen *screen;
	Visual *visual;
	char client[MAXHOSTNAME], server[MAXHOSTNAME], *colon;
	struct hostent *hostname;
	char *vc;		/* Visual Class */
	static char tmp_name[] = "/tmp/twmrcXXXXXX";
	int fd;
	FILE *tmpf;
	char *sp;
	char *getenv_res;	/* Result of a getenv() call */
	Boolean tvtwm = False;

	fd = mkstemp(tmp_name);		/* I *hope* mkstemp exists, because */
					/* I tried to find the "portable" */
					/* mktmp... */
	if (fd < 0) {
		perror("mkstemp failed in m4_defs");
		exit(377);
	}
	tmpf = fdopen(fd, "w+");
	XmuGetHostname(client, MAXHOSTNAME);
	hostname = gethostbyname(client);
	strcpy(server, XDisplayName(host));
	colon = index(server, ':');
	if (colon != NULL) *colon = '\0';
	if ((server[0] == '\0') || (!strcmp(server, "unix")))
		strcpy(server, client); /* must be connected to :0 or unix:0 */
	/* The machine running the X server */
	fputs(MkDef("SERVERHOST", server), tmpf);
	/* The machine running the window manager process */
	fputs(MkDef("CLIENTHOST", client), tmpf);
	if (hostname)
		fputs(MkDef("HOSTNAME", hostname->h_name), tmpf);
	else
		fputs(MkDef("HOSTNAME", client), tmpf);
	if ((getenv_res = getenv("USER")) == NULL)
	    if ((getenv_res = getenv("LOGNAME")) == NULL)
		getenv_res = "nobody";
	fputs(MkDef("USER", getenv_res), tmpf);
	if ((getenv_res = getenv("HOME")) == NULL) 
	    getenv_res = ".";
	fputs(MkDef("HOME", getenv_res), tmpf);
	fputs(MkNum("VERSION", ProtocolVersion(display)), tmpf);
	fputs(MkNum("REVISION", ProtocolRevision(display)), tmpf);
	fputs(MkDef("VENDOR", ServerVendor(display)), tmpf);
	fputs(MkNum("RELEASE", VendorRelease(display)), tmpf);
	screen = ScreenOfDisplay(display, Scr->screen);
	visual = DefaultVisualOfScreen(screen);
	fputs(MkNum("WIDTH", screen->width), tmpf);
	fputs(MkNum("HEIGHT", screen->height), tmpf);
	fputs(MkNum("X_RESOLUTION",Resolution(screen->width,screen->mwidth)), tmpf);
	fputs(MkNum("Y_RESOLUTION",Resolution(screen->height,screen->mheight)),tmpf);
	fputs(MkNum("PLANES",DisplayPlanes(display, DefaultScreen(display))), tmpf);
	fputs(MkNum("BITS_PER_RGB", visual->bits_per_rgb), tmpf);
	for (sp=ProgramName ; sp < (ProgramName+strlen(ProgramName)-4) ; sp++)
		if (!strncmp(sp, "tvtwm", 5))
		    tvtwm = True;
	fputs(MkDef("TWM_TYPE", tvtwm ? "tvtwm" : "twm"), tmpf);
	switch(visual->class) {
		case(StaticGray):	vc = "StaticGray";	break;
		case(GrayScale):	vc = "GrayScale";	break;
		case(StaticColor):	vc = "StaticColor";	break;
		case(PseudoColor):	vc = "PseudoColor";	break;
		case(TrueColor):	vc = "TrueColor";	break;
		case(DirectColor):	vc = "DirectColor";	break;
		default:			vc = "NonStandard";	break;
	}
	fputs(MkDef("CLASS", vc), tmpf);
	if (visual->class != StaticGray && visual->class != GrayScale) {
		fputs(MkDef("COLOR", "Yes"), tmpf);
	} else {
		fputs(MkDef("COLOR", "No"), tmpf);
	}
	fputs(MkDef("INITFILE", InitFile), tmpf);
#ifdef RJC
	fputs(MkDef("RJC", "Yes"), tmpf);
#else
	fputs(MkDef("RJC", "No"), tmpf);
#endif
#ifdef XPM
	fputs(MkDef("XPM", "Yes"), tmpf);
#else
	fputs(MkDef("XPM", "No"), tmpf);
#endif
	/* This is prob (Eng) UMCP only... */
	def_netmask(tmpf);
	/* ...This is prob (Eng) UMCP only */
#if 0
	for(i -= 1; i >= 0; i--) {
		fprintf(stderr, "%d: %s\n", i, defs[i]);
	}
#endif
	if (KeepTmpFile) {
		fprintf(stderr, "Left file: %s\n", tmp_name);
	} else {
		fprintf(tmpf, "syscmd(/bin/rm %s)\n", tmp_name);
	}
	fclose(tmpf);
	return(tmp_name);
}
#endif
