/*
 * week menu widgets.
 *
 *	destroy_week_menu()		remove week menu
 *	create_week_menu()		Create all widgets in week calendar
 *					window.
 */

#ifndef MIPS
#include <stdlib.h>
#endif
#include <stdio.h>
#include <time.h>
#include <varargs.h>
#include <Xm/Xm.h>
#include <Xm/DialogS.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/RowColumn.h>
#include <Xm/LabelP.h>
#include <Xm/ArrowBP.h>
#include <Xm/ArrowBG.h>
#include <Xm/PushBP.h>
#include <Xm/PushBG.h>
#include <Xm/Text.h>
#include <Xm/ScrolledW.h>
#include <Xm/DrawingA.h>
#include <Xm/Protocols.h>
#include "cal.h"

static void done_callback(), user_callback(), edit_callback(), sync_callback();
static void week_callback(), prev_callback(), next_callback();
extern void help_callback();
extern time_t length_of_month();
extern struct tm *time_to_tm();

extern Display		*display;	/* everybody uses the same server */
extern struct config	config;		/* global configuration data */
extern struct list	*mainlist;	/* list of all schedule entries */
extern time_t		curr_week;	/* week being displayed, time in sec */
extern struct week	week;		/* info on week view */

static BOOL		have_shell;	/* week window is being displayed */
static Widget		shell;


/*
 * destroy the week menu. Remove it from the screen, and destroy its widgets.
 */

destroy_week_menu()
{
	if (have_shell) {
		XtPopdown(shell);
		XTDESTROYWIDGET(shell);
		destroy_week();
		have_shell = FALSE;
		week.canvas = 0;
	}
}


/*
 * create the week menu for the week beginning on curr_week.
 */

create_week_menu()
{
	Arg		args[15];
	int		n;
	Widget		form, w;
	Atom		closewindow;

	build_week();

	if (have_shell) {
		resize_canvas(shell, week.scroll, week.canvas,
					week.canvas_xs, week.canvas_ys);
		XtPopup(shell, XtGrabNone);
		XRaiseWindow(display, XtWindow(shell));
		redraw_week_calendar();
		return;
	}
	n = 0;
	XtSetArg(args[n], XmNdeleteResponse,	XmDO_NOTHING);		n++;
	XtSetArg(args[n], XmNiconic,		False);			n++;
	shell = XtAppCreateShell("Week View", "plan",
			applicationShellWidgetClass, display, args, n);
#	ifdef EDITRES
	XtAddEventHandler(shell, (EventMask)0, TRUE, 
 			_XEditResCheckMessages, NULL);
#	endif
	set_icon(shell, 0);

	form = XtCreateWidget("weekform", xmFormWidgetClass,
			shell, NULL, 0);
	XtAddCallback(form, XmNhelpCallback, help_callback, (XtPointer)"week");

							/*-- buttons --*/
	n = 0;
	XtSetArg(args[n], XmNbottomAttachment,	XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNbottomOffset,	8);			n++;
	XtSetArg(args[n], XmNleftAttachment,	XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNleftOffset,	8);			n++;
	XtSetArg(args[n], XmNwidth,		50);			n++;
	w = XtCreateManagedWidget("Prev", xmPushButtonWidgetClass,
			form, args, n);
	XtAddCallback(w, XmNactivateCallback, prev_callback, (XtPointer)0);
	XtAddCallback(w, XmNhelpCallback,     help_callback, (XtPointer)
								"week_prev");
	n = 0;
	XtSetArg(args[n], XmNbottomAttachment,	XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNbottomOffset,	8);			n++;
	XtSetArg(args[n], XmNleftAttachment,	XmATTACH_WIDGET);	n++;
	XtSetArg(args[n], XmNleftWidget,	w);			n++;
	XtSetArg(args[n], XmNleftOffset,	8);			n++;
	XtSetArg(args[n], XmNwidth,		50);			n++;
	w = XtCreateManagedWidget("Next", xmPushButtonWidgetClass,
			form, args, n);
	XtAddCallback(w, XmNactivateCallback,next_callback, (XtPointer)0);
	XtAddCallback(w, XmNhelpCallback,    help_callback, (XtPointer)
								"week_next");

	n = 0;
	XtSetArg(args[n], XmNbottomAttachment,	XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNbottomOffset,	8);			n++;
	XtSetArg(args[n], XmNrightAttachment,	XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNrightOffset,	8);			n++;
	XtSetArg(args[n], XmNwidth,		80);			n++;
	w = XtCreateManagedWidget("Done", xmPushButtonWidgetClass,
			form, args, n);
	XtAddCallback(w, XmNactivateCallback, done_callback, (XtPointer)0);
	XtAddCallback(w, XmNhelpCallback,     help_callback, (XtPointer)
								"week_done");
	n = 0;
	XtSetArg(args[n], XmNbottomAttachment,	XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNbottomOffset,	8);			n++;
	XtSetArg(args[n], XmNrightAttachment,	XmATTACH_WIDGET);	n++;
	XtSetArg(args[n], XmNrightWidget,	w);			n++;
	XtSetArg(args[n], XmNrightOffset,	8);			n++;
	XtSetArg(args[n], XmNwidth,		80);			n++;
	w = XtCreateManagedWidget("Help", xmPushButtonWidgetClass,
			form, args, n);
	XtAddCallback(w, XmNactivateCallback,help_callback, (XtPointer)"week");
	XtAddCallback(w, XmNhelpCallback,    help_callback, (XtPointer)"week");

	n = 0;
	XtSetArg(args[n], XmNbottomAttachment,	XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNbottomOffset,	8);			n++;
	XtSetArg(args[n], XmNrightAttachment,	XmATTACH_WIDGET);	n++;
	XtSetArg(args[n], XmNrightWidget,	w);			n++;
	XtSetArg(args[n], XmNrightOffset,	8);			n++;
	XtSetArg(args[n], XmNwidth,		80);			n++;
	w = XtCreateManagedWidget("Users", xmPushButtonWidgetClass,
			form, args, n);
	XtAddCallback(w, XmNactivateCallback, user_callback, (XtPointer)0);
	XtAddCallback(w, XmNhelpCallback,     help_callback, (XtPointer)
								"week_user");

	n = 0;
	XtSetArg(args[n], XmNbottomAttachment,	XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNbottomOffset,	8);			n++;
	XtSetArg(args[n], XmNrightAttachment,	XmATTACH_WIDGET);	n++;
	XtSetArg(args[n], XmNrightWidget,	w);			n++;
	XtSetArg(args[n], XmNrightOffset,	8);			n++;
	XtSetArg(args[n], XmNwidth,		80);			n++;
	w = XtCreateManagedWidget("Edit", xmPushButtonWidgetClass,
			form, args, n);
	XtAddCallback(w, XmNactivateCallback, edit_callback, (XtPointer)0);
	XtAddCallback(w, XmNhelpCallback,     help_callback, (XtPointer)
								"week_edit");

	n = 0;
	XtSetArg(args[n], XmNbottomAttachment,	XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNbottomOffset,	8);			n++;
	XtSetArg(args[n], XmNrightAttachment,	XmATTACH_WIDGET);	n++;
	XtSetArg(args[n], XmNrightWidget,	w);			n++;
	XtSetArg(args[n], XmNrightOffset,	8);			n++;
	XtSetArg(args[n], XmNwidth,		80);			n++;
	w = XtCreateManagedWidget("Sync", xmPushButtonWidgetClass,
			form, args, n);
	XtAddCallback(w, XmNactivateCallback, sync_callback, (XtPointer)0);
	XtAddCallback(w, XmNhelpCallback,     help_callback, (XtPointer)
								"week_sync");

							/*--- infotext --- */
	n = 0;
	XtSetArg(args[n], XmNleftAttachment,	XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNleftOffset,	8);			n++;
	XtSetArg(args[n], XmNrightAttachment,	XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNrightOffset,	8);			n++;
	XtSetArg(args[n], XmNbottomAttachment,	XmATTACH_WIDGET);	n++;
	XtSetArg(args[n], XmNbottomWidget,	w);			n++;
	XtSetArg(args[n], XmNbottomOffset,	8);			n++;
	XtSetArg(args[n], XmNalignment,         XmALIGNMENT_BEGINNING);	n++;
	week.info = XtCreateManagedWidget(" ", xmLabelWidgetClass,
			form, args, n);

							/*--- week view ---*/
	n = 0;
	XtSetArg(args[n], XmNtopAttachment,	XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNtopOffset,		8);			n++;
	XtSetArg(args[n], XmNbottomAttachment,	XmATTACH_WIDGET);	n++;
	XtSetArg(args[n], XmNbottomWidget,	week.info);		n++;
	XtSetArg(args[n], XmNbottomOffset,	8);			n++;
	XtSetArg(args[n], XmNleftAttachment,	XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNleftOffset,	8);			n++;
	XtSetArg(args[n], XmNrightAttachment,	XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNrightOffset,	8);			n++;
	XtSetArg(args[n], XmNwidth,		week.canvas_xs +4);	n++;
	XtSetArg(args[n], XmNheight,		week.canvas_ys +4);	n++;
	XtSetArg(args[n], XmNscrollingPolicy,	XmAUTOMATIC);		n++;
	week.scroll = XtCreateWidget("scroll", xmScrolledWindowWidgetClass,
			form, args, n);

	n = 0;
	XtSetArg(args[n], XmNwidth,		week.canvas_xs);	n++;
	XtSetArg(args[n], XmNheight,		week.canvas_ys);	n++;
	week.canvas = XtCreateWidget("weekcal", xmDrawingAreaWidgetClass,
			week.scroll, args, n);
	XtAddCallback(week.canvas, XmNinputCallback,
					week_callback, (XtPointer)NULL);
	XtAddCallback(week.canvas, XmNexposeCallback,
					week_callback, (XtPointer)NULL);

	XtManageChild(week.canvas);
	XtManageChild(week.scroll);
	XtManageChild(form);

	XtPopup(shell, XtGrabNone);
	closewindow = XmInternAtom(display, "WM_DELETE_WINDOW", False);
	XmAddWMProtocolCallback(shell, closewindow,
					done_callback, (XtPointer)shell);
	have_shell = TRUE;
}


/*
 * resize a DrawingArea canvas, and resize the shell that contains it by
 * the same amount. Also, resize the scrolling widget around the canvas.
 * Make it a bit larger for the shadow.
 */

resize_canvas(shell, scroll, canvas, xs, ys)
	Widget		shell;		/* shell with the DrawingArea */
	Widget		scroll;		/* scrolling area around canvas */
	Widget		canvas;		/* DrawingArea */
	int		xs, ys;		/* new DrawingArea size */
{
	Arg		args[2];
	Dimension	sh_xs, sh_ys;	/* previous size of the shell */
	Dimension	can_xs, can_ys;	/* previous size of the canvas */

	XtSetArg(args[0], XmNwidth,  &sh_xs);
	XtSetArg(args[1], XmNheight, &sh_ys);
	XtGetValues(shell, args, 2);

	XtSetArg(args[0], XmNwidth,  &can_xs);
	XtSetArg(args[1], XmNheight, &can_ys);
	XtGetValues(canvas, args, 2);

	XtSetArg(args[0], XmNwidth,  xs);
	XtSetArg(args[1], XmNheight, ys);
	XtSetValues(canvas, args, 2);

	XtSetArg(args[0], XmNwidth,  xs+4);
	XtSetArg(args[1], XmNheight, ys+4);
	XtSetValues(scroll, args, 2);

	XtSetArg(args[0], XmNwidth,  sh_xs - can_xs + xs);
	XtSetArg(args[1], XmNheight, sh_ys - can_ys + ys);
	XtSetValues(shell, args, 2);
}


/*-------------------------------------------------- callbacks --------------*/
/*
 * All of these routines are direct X callbacks.
 */

/*ARGSUSED*/
static void prev_callback(widget, item, data)
	Widget				widget;
	int				item;
	XmToggleButtonCallbackStruct	*data;
{
	struct tm *tm = time_to_tm(curr_week);
	if (tm->tm_yday > 6) {
		curr_week -= 7*86400;
		draw_week_calendar();
	}
}


/*ARGSUSED*/
static void next_callback(widget, item, data)
	Widget				widget;
	int				item;
	XmToggleButtonCallbackStruct	*data;
{
	struct tm *tm = time_to_tm(curr_week);
	if (tm->tm_yday < 365-6) {
		curr_week += 7*86400;
		draw_week_calendar();
	}
}


/*ARGSUSED*/
static void done_callback(widget, item, data)
	Widget				widget;
	int				item;
	XmToggleButtonCallbackStruct	*data;
{
	destroy_week_menu();
}


/*ARGSUSED*/
static void user_callback(widget, item, data)
	Widget				widget;
	int				item;
	XmToggleButtonCallbackStruct	*data;
{
	create_user_popup();
}


/*ARGSUSED*/
static void edit_callback(widget, item, data)
	Widget				widget;
	int				item;
	XmToggleButtonCallbackStruct	*data;
{
	create_list_popup(mainlist, curr_week, NDAYS*86400,
					0, (struct entry *)0);
}


/*ARGSUSED*/
static void sync_callback(widget, item, data)
	Widget				widget;
	int				item;
	XmToggleButtonCallbackStruct	*data;
{
	force_user_list_update();
	draw_week_calendar();
}


/*ARGSUSED*/
static void week_callback(w, data, info)
	Widget				w;
	XtPointer			data;
	XmDrawingAreaCallbackStruct	*info;
{
	if (info->reason == XmCR_INPUT && info->event->xany.type ==ButtonPress)
		clicked_week_calendar(info->event->xbutton.x,
				      info->event->xbutton.y,
				      info->event->xbutton.time);

	else if (info->reason == XmCR_EXPOSE) {
		XEvent dummy;
		while (XCheckWindowEvent(display, info->window, ExposureMask,
								&dummy));
		redraw_week_calendar();
	}
}
