%{
extern char	*mystrdup();
extern int	 parse_year;
int		 yacc_small;
int		 yacc_stringcolor;
char		*yacc_string;
int		 yacc_daycolor;
static int	 m, d, y;
%}

%union { int ival; char *sval; }
%type  <ival> color offset length expr pexpr number month
%token <ival> NUMBER MONTH WDAY COLOR
%token <sval> STRING
%token        IN PLUS MINUS SMALL CYEAR LEAPYEAR
%token        LENGTH EASTER EQ NE LE GE LT GT

%left OR
%left AND
%right EQ NE LE GE LT GT
%left '-' '+'
%left '*' '/'
%nonassoc '!'
%nonassoc UMINUS
%left '?' ':'

%start list

%%
list	:
	| list small color STRING color		{ yacc_stringcolor = $3;
						  yacc_string      = $4;
						  yacc_daycolor    = $5; }
	  entry					{ free(yacc_string); }
	;

small	:					{ yacc_small = 0; }
	| SMALL					{ yacc_small = 1; }
	;

color	:					{ $$ = 0; }
	| COLOR					{ $$ = $1; }
	;

entry	: EASTER offset length			{ seteaster($2, $3); }
	| date offset length			{ setdate( m,  d,  y, $2, $3);}
	| WDAY offset length			{ setwday( 0, $1,  0, $2, $3);}
	| NUMBER WDAY offset length		{ setwday($1, $2,  0, $3, $4);}
	| NUMBER WDAY IN month offset length	{ setwday($1, $2, $4, $5, $6);}
	| WDAY NUMBER date offset length	{ setdoff($1, $2,m,d,y,$4,$5);}
	;

offset	:					{ $$ =   0; }
	| PLUS NUMBER				{ $$ =  $2; }
	| MINUS NUMBER				{ $$ = -$2; }
	;

length	:					{ $$ =   1; }
	| LENGTH NUMBER				{ $$ =  $2; }
	;

date	: pexpr '.' month			{ m = $3; d = $1; y = 0;  }
	| pexpr '.' month '.'			{ m = $3; d = $1; y = 0;  }
	| pexpr '.' month '.' expr		{ m = $3; d = $1; y = $5; }
	| month '/' pexpr			{ m = $1; d = $3; y = 0;  }
	| month '/' pexpr '/' pexpr		{ m = $1; d = $3; y = $5; }
	| MONTH pexpr				{ m = $1; d = $2; y = 0;  }
	| MONTH pexpr pexpr			{ m = $1; d = $2; y = $3; }
	| pexpr MONTH				{ m = $2; d = $1; y = 0;  }
	| pexpr MONTH pexpr			{ m = $2; d = $1; y = $3; }
	| pexpr '.' MONTH			{ m = $3; d = $1; y = 0;  }
	| pexpr '.' MONTH pexpr			{ m = $3; d = $1; y = $4; }
	;

month	: MONTH | pexpr;

expr	: pexpr					{ $$ = $1; }
	| expr OR  expr				{ $$ = $1 || $3; }
	| expr AND expr				{ $$ = $1 && $3; }
	| expr EQ  expr				{ $$ = $1 == $3; }
	| expr NE  expr				{ $$ = $1 != $3; }
	| expr LE  expr				{ $$ = $1 <= $3; }
	| expr GE  expr				{ $$ = $1 >= $3; }
	| expr LT  expr				{ $$ = $1 <  $3; }
	| expr GT  expr				{ $$ = $1 >  $3; }
	| expr '+' expr				{ $$ = $1 +  $3; }
	| expr '-' expr				{ $$ = $1 -  $3; }
	| expr '*' expr				{ $$ = $1 *  $3; }
	| expr '/' expr				{ $$ = $3 ?  $1 / $3 : 0; }
	| expr '%' expr				{ $$ = $3 ?  $1 % $3 : 0;}
	| expr '?' expr ':' expr		{ $$ = $3 ?  $1 % $3 : 0;}
	| '!' expr				{ $$ = !$2; }
	;

pexpr	: '(' expr ')'				{ $$ = $2; }
	| number				{ $$ = $1; }
	;

number	: NUMBER
	| '-' NUMBER %prec UMINUS		{ $$ = -$2; }
	| CYEAR					{ $$ = parse_year; }
	| LEAPYEAR pexpr			{ $$ = !(($2) & 3); }
	;
%%
