# Copyright (c) 1994 by Sanjay Ghemawat
#############################################################################
# Hook mechanisms
#
# Commands
#
#	create-hook	<hook>
#	run-hook	<hook> [<args>...]
#	append-hook	<hook> {<argspec>} {<body>}
#	prepend-hook	<hook> {<argspec>} {<body>}
#
# Example
#
#	create-hook dayview-startup
#	...
#	append-hook dayview-startup {view} {
#	    wm title [$view window] SpecialTitle
#	}
#	...
#	run-hook dayview-startup $view
#
# Global Variables
#
#	hooks		Array of hook lists.  Each hook list is a list
#			of procedure names.
#
#	hookid		Integer for generating unique procedure names.

catch {unset hook}
catch {unset hookid}

set hook(junk) {}
unset hook(junk)
set hookid 0

proc create-hook {name} {
    global hook
    if [info exists hook($name)] {error "hook $name already exists"}
    set hook($name) {}
}

proc append-hook {name argspec body} {
    global hook hookid
    if ![info exists hook($name)] {error "no hook named $name"}

    incr hookid
    proc _hook_$hookid $argspec $body

    lappend hook($name) _hook_$hookid
}

proc prepend-hook {name argspec body} {
    global hook hookid
    if ![info exists hook($name)] {error "no hook named $name"}

    incr hookid
    proc _hook_$hookid $argspec $body

    set hook($name) [linsert $hook($name) 0 _hook_$hookid]
}

proc run-hook {name args} {
    global hook hookid
    if ![info exists hook($name)] {error "no hook named $name"}

    foreach h $hook($name) {
	if [catch {eval $h $args} msg] {
	    error_notify "" "Error running hook \"$name\"\n\n$msg"
	}
    }
}
