/* Copyright (c) 1994 Sanjay Ghemawat */

/*
This program converts a file into C code that can be used to
initialize an array of characters.  The array of characters will
contain exactly the characters present in the input file.

Sample usage: "file2h < input > output.h"

The file generated above can be used as follows --

\begin{verbatim}
	static char fileContents[] = {
	#include "output.h"
	};

	foo() {
	    ...
	    for (int i = 0; i < sizeof(fileContents)/sizeof(char); i++) {
		putchar(fileContents[i]);
	    }
	    ...
	}
\end{verbatim}

Or,

\begin{verbatim}
	static char fileString[] = {
	#include "output.h"
        ,'\0'
	};

	foo() {
	    ...
	    printf("%s", fileString);
	    ...
	}
\end{verbatim}
*/

#include <ctype.h>
#include <stdio.h>

main() {
    int start;
    int c;

    start = 1;
    while ((c = getchar()) != EOF) {
	// Separate with a comma from any previous character
	if (start) {
	    start = 0;
	}
	else {
	    putchar(',');
	    putchar('\n');
	}

	putchar('\'');
	switch (c) {
	  case '\\':
	    putchar('\\');
	    putchar('\\');
	    break;
	  case '\'':
	    putchar('\\');
	    putchar('\'');
	    break;
	  case '\n':
	    putchar('\\');
	    putchar('n');
	    break;
	  case '\t':
	    putchar('\\');
	    putchar('t');
	    break;
	  default:
	    if (isprint(c)) {
		putchar(c);
	    }
	    else {
		printf("\\%03o", c);
	    }
	    break;
	}

	putchar('\'');
    }

    putchar('\n');

    return 0;
}
