/* srch_act.c - part of asedit program */

/*
 * Copyright 1991 - 1993,  Andrzej Stochniol, London, UK
 *
 * ASEDIT text editor, both binary and source (hereafter, Software) is
 * copyrighted by Andrzej Stochniol (hereafter, AS) and ownership remains
 * with AS.
 *
 * AS grants you (hereafter, Licensee) a license to use the Software
 * for academic, research and internal business purposes only, without a
 * fee.  Licensee may distribute the binary and source code (if released)
 * to third parties provided that the copyright notice and this statement
 * appears on all copies and that no charge is associated with such copies.
 *
 * Licensee may make derivative works.  However, if Licensee distributes
 * any derivative work based on or derived from the Software, then
 * Licensee will:
 * (1) notify AS regarding its distribution of the derivative work, and
 * (2) clearly notify users that such derivative work is a modified version
 *      and not the original ASEDIT distributed by AS.
 *
 * Any Licensee wishing to make commercial use of the Software should
 * contact AS to negotiate an appropriate license for such commercial use.
 * Commercial use includes:
 * (1) integration of all or part of the source code into a product for sale
 *     or license by or on behalf of Licensee to third parties, or
 * (2) distribution of the binary code or source code to third parties that
 *     need it to utilize a commercial product sold or licensed by or on 
 *     behalf of Licensee.
 *
 * A. STOCHNIOL MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS
 * SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR
 * IMPLIED WARRANTY.  IN NO EVENT SHALL A. STOCHNIOL BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 *
 * 	Andrzej Stochniol	(A.Stochniol@ic.ac.uk)
 * 	30 Hatch Road
 * 	London SW16 4PN
 * 	UK
 */

#include <stdio.h>
#include <string.h>

#include <Xm/ToggleB.h>
#include <Xm/ToggleBG.h>
#include <Xm/Text.h>

#include "asedit.h"

/*****************************  find_string  ********************************
*
*	finds the string search_string in the text widget "win->edit_text"
*/
#ifdef _NO_PROTO
void find_string( win )
    aseditWindowStruct *win;
#else  /* ! _NO_PROTO */

void find_string(aseditWindowStruct *win)
#endif
{
    /* first_pos, last_pos - are set to show the position of the
       found text */

    long len, position, start_position;

    String text_buffer;
    Arg    al[2];
    Boolean search_forward=   True;	/* search direction */
    Boolean case_sensitive=   True;
    Boolean whole_words_only= False;


    len = strlen(win->search_string);

    if(len == 0L)
    {
	show_error_message(win, (char *) lstr.sm_have_to_enter);
	return;
    }
    /* get the state of search_forward toggle gadget */
    search_forward   = XmToggleButtonGadgetGetState (win->forward_toggle);
    /* get the state of case_sensitive and whole_words_only toggles */
    case_sensitive   = XmToggleButtonGetState (win->case_sensitive_toggle);
    whole_words_only = XmToggleButtonGetState (win->whole_words_only_toggle);

    /* get the address of the internally stored text
       and the cursor position (i.e. starting position) */
    XtSetArg(al[0], XmNvalue, &text_buffer);
    XtSetArg(al[1], XmNcursorPosition, &start_position);
    XtGetValues(win->edit_text, al, 2);



    /* find a search string position in the text widget buffer;
       if the position is < 0 the string has not been found,
       therefore pop up appriopriate dialog;
       if position >= 0 OK go there ... */
    position =  find_string_pos_in_buffer(win->search_string, text_buffer,
					start_position, -1L, search_forward,
					case_sensitive, whole_words_only);
    if(position >= 0L)
    {

	/* set the first and last position of the text found */
	win->found_string_start_pos = position;
	win->found_string_end_pos  = position + len;

	/* for the forward search set the cursor to be posittioned after
	   the string found, for the backward search - before the string found */
	if(search_forward)  position += len;
	/*? do we need clear selection before setting it ..==> no we do not !!
	    XmTextClearSelection(win->edit_text, win->timestamp_search_request); ****/

	/* set the selection for the text found */
	/* XmTextSetSelection also sets the position of the insert cursor to
	   last_pos and then invokes the widget's XmNmotionVerifyCallback */
	XmTextSetSelection(win->edit_text, win->found_string_start_pos, win->found_string_end_pos, win->timestamp_search_request);


	/* set the cursor position; next search will start from that place */
	XmTextSetInsertionPosition(win->edit_text, position);

	/* NOTE about XmTextSetSelection above:
	    because we use above the XmTextSetSelection, which invokes the
	    text widget's XmNmotionVerifyCallback we don't have to find and
	    write out the line and column numbers here (as was done in asedit 1.1[01]),
	    they will be found inside TextCB  !!!!
	    So as of asedit 1.12 the previous lines delimited with
	    ifdef _SHOW_LINE_COLUMN  are deleted.
	*/

    }
    else
    {
	win->found_string_start_pos = win->found_string_end_pos = -1;	/* the search was unsuccessful */
	show_error_message(win, (char *)lstr.sm_not_found);
    }
#ifndef	GET_TEXT_VALUE_BUG_FIXED
    XtFree(text_buffer);
#endif	/* GET_TEXT_VALUE_BUG_FIXED */
    return;

} /* find_string */


/*****************************  change_all_found_strings  *******************
*
*	find all strings in the text widget and change them to a new string
*	without	asking for confirmation
*/
#ifdef _NO_PROTO
void change_all_found_strings(win, start)
    aseditWindowStruct *win;
    Boolean start;
#else  /* ! _NO_PROTO */

void change_all_found_strings(aseditWindowStruct *win, Boolean start)
#endif
{
    /* "start" must be True when this procedure is called to start the process
       of changing of all text occurrences;
       and it must be False when it is called second time when the bottom or top
       of the file has been reached in the previous call */

    long len, position, start_position, end_position;
    long first_pos, last_pos;		/* positions of the text found */
    long buf_size, new_string_len;
    String text_buffer;
    Arg    al[2];
    register int ac;
    char   work[256];
    XmString  xmstr;		/* work XmString */
    static Boolean search_forward=   True;	/* search direction */
    static Boolean case_sensitive=   True;
    static Boolean whole_words_only= False;
    static int items_changed=0;
    static  long change_all_start_position;	/* it remembers the starting position
			and it is used to detect that the change has been finished;
			thi value is updated to take into account replacement
			with different length of the new string */



    len = strlen(win->search_string);
    new_string_len = strlen(win->new_string);

    if(len == 0L)
    {
	show_error_message(win, (char *) lstr.sm_have_to_enter);
	return;
    }
    if(start)
    {
	/* get the state of search_forward toggle gadget - only when the whole
	   search is started (we don't allow the user to change it during the whole
	   process; otherwise it would be difficult to find out when
	   the whole process is finished) */
	search_forward   = XmToggleButtonGadgetGetState (win->forward_toggle);
	/* get the state of case_sensitive and whole_words_only toggles */
	case_sensitive   = XmToggleButtonGetState (win->case_sensitive_toggle);
	whole_words_only = XmToggleButtonGetState (win->whole_words_only_toggle);

	/* get the address of the internally stored text
	   and the cursor position (i.e. starting position) */
	XtSetArg(al[0], XmNvalue, &text_buffer);
	XtSetArg(al[1], XmNcursorPosition, &start_position);
	XtGetValues(win->edit_text, al, 2);
	items_changed = 0;
	change_all_start_position = start_position;
	end_position	= -1;		/* search up to the edge of the file (i.e.
					up to the end for forward search, up to the
					beginning for the backward search */
    }
    else
    {
	/* get the address of the internally stored text */
	XtSetArg(al[0], XmNvalue, &text_buffer);
	XtGetValues(win->edit_text, al, 1);
	start_position = -1;	/* start at the beginning or at the end of the
				   file (dependent on the search direction) */
	end_position   = change_all_start_position;	/* do not go beyond
							   the overall start position;
							   finish off the search */
    }

    /* find a search string position in the text widget buffer;
       if the position is < 0 the string has not been found,
       therefore pop up appriopriate dialog;
       if position >= 0 OK go there ... */
    position =  find_string_pos_in_buffer(win->search_string, text_buffer,
					start_position, end_position, search_forward,
					case_sensitive, whole_words_only);
    while (position >= 0L)
    {
	/* the position returned always shows the first character of the string
	   found, no matter if we search forward or backward so we can set
	   the first and last position of the text found as follows: */

	/* set the first and last position of the found text */
	first_pos = position;
	last_pos  = position+len;

	/* to speed the process of changing we do not mark the found text
	   nor we change the cursor position during the substitution process */

	XmTextReplace(win->edit_text, first_pos, last_pos, win->new_string);
	items_changed++;	/* increase the counter */

	/* move the starting position of the search to start a new search
	   just after the text changed (or before it for a backward search) */
	if(search_forward) start_position = last_pos + (new_string_len - len);
	else		   start_position = first_pos;

	/* update the change_all_start_position in the case when the text was
	   changed before it (take into account a difference in the length)*/
	if(position < change_all_start_position)
		change_all_start_position += (new_string_len - len);
	if(change_all_start_position < 0) change_all_start_position = 0;

#ifndef	GET_TEXT_VALUE_BUG_FIXED
	XtFree(text_buffer);
#endif	/* GET_TEXT_VALUE_BUG_FIXED */
	/* get the address of the internally stored text (it may have been changed)
	   and search again */
	XtSetArg(al[0], XmNvalue, &text_buffer);
	XtGetValues(win->edit_text, al, 1);

	/* set the end_position of the search appropriately
	   to the mode of the search (up to the edge of the file or finish off
	   the search beyond the edge of the file) */
	if(!start) end_position = change_all_start_position;  /* else = -1 */

	position =  find_string_pos_in_buffer(win->search_string, text_buffer,
					start_position, end_position, search_forward,
					case_sensitive, whole_words_only);

    }
    /* convert the the last found position (that is = the start  of the
    unsuccessful search) into the line & column number and display them;
    set the cursor position to it */
    XtSetArg(al[0], XmNcursorPosition, start_position);
    XtSetValues(win->edit_text, al, 1);

    buf_size = (long) strlen(text_buffer);

    if(win->status_line_on)	/* calculate line & column only when they are shown */
    {
	textPosToLineColumn(text_buffer, buf_size, start_position,
			&(win->line), &(win->column), &(win->column_ntab) );
	write_lw(win->line_number,   charset, "%-5ld", win->line);
	write_lw(win->column_number, charset, "%-4ld", win->column);

    }

#ifndef	GET_TEXT_VALUE_BUG_FIXED
    XtFree(text_buffer);
#endif	/* GET_TEXT_VALUE_BUG_FIXED */

    if(!start  ||  (search_forward && change_all_start_position == 0L) ||
		   (!search_forward && change_all_start_position == buf_size))
    {
	/* 3 situations may generate the end of the search message:
	   - it was a second call to this procedure to finish off the previous
	     search starting from the beginning (or the end) up to the overall start
	   - it was a forward search  started right from the text beginning,
	   - it was a backward search started right from the text end
	*/

	sprintf(work, "%s %d.",
		(char *)lstr.sm_change_all_completed,items_changed);
	xmstr = XmStringCreateLtoR(work, charset);
	if(win->search_end_message == NULL)	/* create it first */
		create_search_end_message(win);
	ac = 0;
	XtSetArg(al[ac], XmNmessageString, xmstr );  ac++;
	XtSetValues(win->search_end_message, al, ac);
	XmStringFree(xmstr);	/* free memory allocated for XmString */
	asManageDialog(win->search_end_message);

    }
    else
    {	/* a question about continuing the change process is asked */
	if(search_forward) strcpy(work, (char *)lstr.sq_doc_end);
	else        strcpy(work, (char *)lstr.sq_doc_beg);
	xmstr = XmStringCreateLtoR(work, charset);
	if(win->continue_search_question == NULL)	/* create it first */
		create_continue_search_question(win);
	ac = 0;
	XtSetArg(al[ac], XmNmessageString, xmstr );  ac++;
	XtSetValues(win->continue_search_question, al, ac);
	asManageDialog(win->continue_search_question);
	XmStringFree(xmstr);	/* free memory allocated for XmString */
    }
    return;

} /* change_all_found_strings */


/* some simple utility functions ..... (self explanatory)  */

#ifdef _NO_PROTO
void set_change_buttons_sensitivity(win, state)
     aseditWindowStruct *win;
     Boolean state;
#else  /* ! _NO_PROTO */

void set_change_buttons_sensitivity(aseditWindowStruct *win, Boolean state)
#endif
{
     /* when state = False - turn off the sensitivity of the "action" buttons
			     of the change dialog and set the default button
			     the cancel ("Close") button;
	when state = True  - restore the default sensitive state of the "action"
			     buttons and restore the default button to the Ok
     */
     Arg al[2];
     register int ac;

     /* set the sensitivity of the change buttons sensitivity */
     XtSetSensitive(win->change_verify_button, state);
     XtSetSensitive(win->change_all_button, state);
     /* set the appropriate default button  */
     ac = 0;
     if(state == True)
	{ XtSetArg(al[ac], XmNdefaultButton, win->change_verify_button); ac++; }
     else
	 /* set the deafult button to the Cancel button;
	    otherwise when we press Enter the "change_verify_button" is activated
	    no matter that it is actually insensitive */
	{ XtSetArg(al[ac], XmNdefaultButton, win->cancel_replace_dialog_button); ac++; }

     XtSetValues(win->replace_dialog, al, ac);

}    /* set_change_buttons_sensitivity */
