
/* file_act.c - part of asedit program */
/*
 * Copyright 1991 - 1993,  Andrzej Stochniol, London, UK
 *
 * ASEDIT text editor, both binary and source (hereafter, Software) is
 * copyrighted by Andrzej Stochniol (hereafter, AS) and ownership remains
 * with AS.
 *
 * AS grants you (hereafter, Licensee) a license to use the Software
 * for academic, research and internal business purposes only, without a
 * fee.  Licensee may distribute the binary and source code (if released)
 * to third parties provided that the copyright notice and this statement
 * appears on all copies and that no charge is associated with such copies.
 *
 * Licensee may make derivative works.  However, if Licensee distributes
 * any derivative work based on or derived from the Software, then
 * Licensee will:
 * (1) notify AS regarding its distribution of the derivative work, and
 * (2) clearly notify users that such derivative work is a modified version
 *      and not the original ASEDIT distributed by AS.
 *
 * Any Licensee wishing to make commercial use of the Software should
 * contact AS to negotiate an appropriate license for such commercial use.
 * Commercial use includes:
 * (1) integration of all or part of the source code into a product for sale
 *     or license by or on behalf of Licensee to third parties, or 
 * (2) distribution of the binary code or source code to third parties that
 *     need it to utilize a commercial product sold or licensed by or on
 *     behalf of Licensee.
 *
 * A. STOCHNIOL MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS
 * SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR
 * IMPLIED WARRANTY.  IN NO EVENT SHALL A. STOCHNIOL BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 *
 * 	Andrzej Stochniol	(A.Stochniol@ic.ac.uk)
 * 	30 Hatch Road
 * 	London SW16 4PN
 * 	UK
 */

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <Xm/Text.h>

#include "asedit.h"


#ifdef _NO_PROTO
void open_file_in_last_window(filename)
    char *filename;
#else  /* ! _NO_PROTO */

void open_file_in_last_window(char *filename)
#endif
{
    /* opens the specified file in the asedit last window or the default
       file (when filename is NULL)
    */
    char            *work;          /* work string */
    char            *error_open;
    int len;
    static int      as_def_names_count = 0;	/* counter for default names */

    if(filename != NULL && (len=strlen(filename)) )
    {
	 asedit_last_window->filename = XtMalloc(len+1);
	 strcpy(asedit_last_window->filename, filename);
    }
    else
    {
	 /* use the default name .... */
	 char *NoName = (char *)lstr.noname;
	 as_def_names_count ++;		/* increase the counter */
	 len = strlen(NoName) + 5;
	 asedit_last_window->filename = XtMalloc(len);
	 sprintf(asedit_last_window->filename,"%s%d", NoName ,as_def_names_count);

    }
    /* open file; if file can't be opened or created (e.g. irregular)
       show message and set name to NULL;  if file exists
       open it, if does not but can be created  set the empty text */
    if (!OpenFile(asedit_last_window, False))   /* OpenFile is called with
					only_existing_files = False */
    {
	error_open = (char *)lstr.fm_unable_to_open;
	work = XtMalloc(strlen(error_open) + strlen(asedit_last_window->filename) +1);
	strcpy(work, error_open);
	strcat(work, asedit_last_window->filename);
	show_error_message(asedit_last_window, work);
        XtFree(asedit_last_window->filename);   asedit_last_window->filename = NULL;
        XtFree(work);
    }

}



/*****************************	OpenFile  ************************************
**
**	Calls ReadFile to read the file. Returns true if file
** 	exists and open is sucessful (for only_existing_files).
**	Parameter only_existing_files gives a way of using this
**	procedure for both file options: Load (only_existing_files=True)
**	and New (only_existing_files parameter should be False).
**	Adds file contents to the
**	appropriate widget, makes appropriate items sensitive etc.
**	Calls a procedure to set the title ot the main window (toplevel widget)
**      and the icon name.
*/
#ifdef _NO_PROTO
Boolean OpenFile(win, only_existing_files)
   aseditWindowStruct *win;
   Boolean only_existing_files;
#else  /* ! _NO_PROTO */

Boolean OpenFile(aseditWindowStruct *win, Boolean only_existing_files)
#endif
{
   char * file_string=NULL;	/* Contents of file. 	  */
   Boolean         read_only;		/* shows the file read only status */
   register int ac;			/* arg count		    */
   Arg al[10];				/* widget arg list	    */
   struct stat statbuf;			/* Information on a file. */

   /* make sure the file is a regular text file (if not return FALSE
      immediately)*/
   if(stat(win->filename, &statbuf) == 0  &&
	(statbuf.st_mode & S_IFMT) != S_IFREG )
   {
	/*!!!!! temporary output .... */
	fprintf(stderr, "\n%s: %s", win->filename, (char *)lstr.fm_not_regular);
	return(FALSE);
   }


   if( (file_string = ReadFile(win->filename, &read_only)) != NULL  ||
		!only_existing_files)
   {
           if(read_only) win->file_read_only = read_only;	/* 30 SEPT late change */

	   ac = 0;
	   XtSetArg(al[ac], XmNeditable, !win->file_read_only); ac++; /* if file is read only
						editable is set to False & vice versa */
	   /* set appropriate colour for the text widget to distinguish between
	      editable and read-only files */
	   if(win->file_read_only) XtSetArg(al[ac], XmNbackground, text_read_only_background);
	   else		      XtSetArg(al[ac], XmNbackground, text_edit_background);
	   ac++;
	   XtSetArg(al[ac], XmNsensitive, True);	ac++;	/* make text sensitive */
	   XtSetValues(win->edit_text1, al, ac);

	   /* hack for Motif 1.2: when the string for the text widget is NULL text modify callback
	      is not generated; in that case we don't set the flag file_just_loaded;
	      if we do we lose the first action during editing !!!!
	   */
	   if(file_string != NULL && strlen(file_string))
					win->file_just_loaded = True;	/* reset the just loaded flag */
	   else				win->file_just_loaded = False;

	   /* we have to use XmTextSetString to set the string; when I use
	      XtSetArg(al[ac], XmNvalue, (char *) file_string); etc... it does not
	      work properly when file_string was empty and the rest was the same
	      probably;  it does not work occasionally during loading of a file (comments
	      from Kennan (i.e. the there is an inconsistent behaviour );
	   ****/
	   XmTextSetString(win->edit_text1, (char *)file_string);  /* add the file string to the text widget */


	   /* free the memory associated with the file_string */
	   if(file_string != NULL) XtFree(file_string);

	   /* reinitialize the changes counter, reset undo/redo stacks */
	   win->changes_counter = 0L;
	   reset_undo_redo(win);
	   /* write appropriate info into changes_status widget */
	   if(!win->file_read_only)   write_lw(win->changes_status, charset, " ");
	   else 		 write_lw(win->changes_status, charset,
						(char *)lstr.read_only_marker);

	   /* make undo/redo buttons insensitive */
	   XtSetSensitive(win->menu_undo_button,  False);
	   XtSetSensitive(win->menu_redo_button,  False);
	   XFlush(display);		/* make sure that these buttons are
					   insensitive before processing any keyboard
					   actions (for very busy systems)*/



	   /* make appropriate items sensitive */
	   XtSetSensitive(win->menu_copy_button, True);
	   /* set the sensitivity of buttons dependend only on read_only
	      status of the file (cut button, clear button, replace button)
	   */
	   if(!win->file_read_only)
	   {
		XtSetSensitive(win->menu_cut_button, 	True);
		XtSetSensitive(win->menu_clear_button, 	True);
		XtSetSensitive(win->menu_replace_button, 	True);
		XtSetSensitive(win->menu_insert_button, 	True);
	   }
	   else
	   {
		XtSetSensitive(win->menu_cut_button, 	False);
		XtSetSensitive(win->menu_clear_button, 	False);
		XtSetSensitive(win->menu_replace_button, 	False);
		XtSetSensitive(win->menu_insert_button, 	False);
	   }
	   /* set the sensitivity of the paste button */
	   if(!win->file_read_only && clipboard_filled)
			XtSetSensitive(win->menu_paste_button, True);
	   else   	XtSetSensitive(win->menu_paste_button, False);

	   /* set appropriate file buttons to sensitive */
	   XtSetSensitive(win->menu_close_button,	True);
	   XtSetSensitive(win->menu_save_as_button, 	True);
	   XtSetSensitive(win->menu_print_button,	True);
	   /* menu_save_button will be insensitive for read only files .... */
	   if(!win->file_read_only)	XtSetSensitive(win->menu_save_button, True);
	   else			XtSetSensitive(win->menu_save_button, False);


	   /* set appropriate search buttons to sensitive */
	   XtSetSensitive(win->menu_find_button,         True);
	   XtSetSensitive(win->menu_gotoline_button,     True);
	   if( win->search_string != NULL)
		   XtSetSensitive(win->menu_find_again_button,   True);
	   else    XtSetSensitive(win->menu_find_again_button,   False);
	   XtSetSensitive(win->menu_mark_button,         True);

	   /* setting a new title of the main window and the icon name.
	       They include the name of the file just opened */
	   set_titles_mwindow_icon(win, win->filename);
	   return(True);
   }
   else
   {
	   /* setting a new title (name of the program only) */
	   set_titles_mwindow_icon(win, NULL);
	   return(False);
   }

}  /* OpenFile */



/*****************************  SaveFile  ************************************
**  	Save the currently edited file.
*/
#ifdef _NO_PROTO
Boolean SaveFile(win)
aseditWindowStruct *win;
#else  /* ! _NO_PROTO */

Boolean SaveFile(aseditWindowStruct *win)
#endif
{
    char * file_string = NULL;	   /* Contents of file.		      */
    Boolean	    result;


    /* get the text string */
    file_string = XmTextGetString(win->edit_text);

    result = WriteFile(win->filename, file_string);

    if (file_string != NULL)  XtFree(file_string); /* free the text string */

    if(result)
    {
	win->changes_counter = 0L;
	write_lw(win->changes_status, charset, " ");
	return(True);
    }
    else return(False);

}   /* SaveFile */


/*****************************  ResetAllMarks  ***********************************
**
**  	Reset all bookmarks and set the appropriate buttons to insensitive	
*/
#ifdef _NO_PROTO
void ResetAllMarks(win)
aseditWindowStruct *win;
#else  /* ! _NO_PROTO */

void ResetAllMarks(aseditWindowStruct *win)
#endif
{
    int i, nmarks = TOTAL_MARKS;
    /* we should really get the number of marks from the size of the appropriate
       pulldown !! 
    */

    for(i=0; i<nmarks; i++)
    {
	win->marks_used  = False;
	win->mark_set[i] = False;
	win->mark_pos[i] = 0;
	XtSetSensitive(win->menu_mark_go_button[i], False);
    }

}   /*  ResetAllMarks */


/*****************************  CloseFile  ***********************************
**
**  	Close the present file. Set sensitivity of appropriate menu items.
*/
#ifdef _NO_PROTO
void CloseFile(win)
aseditWindowStruct *win;
#else  /* ! _NO_PROTO */

void CloseFile(aseditWindowStruct *win)
#endif
{
    /* zero out the text string in the text widget.
       Warning: it causes a value changed callback. */
    Arg al[5];
    register int ac;

    /* we use Motif convenience function  to zero out the text instead of setting the resources in one
       go  i.e. using additionally XtSetArg(al[ac], XmNvalue , "");  ac++; because we have some problems
       with the other method in the ReadFile procedure; so to be on a safe side .... */
    XmTextSetString(win->edit_text1, " ");  /** setting not an empty string
			seems to make the asedit on SUN/Motif 1.2.1 more stable
			****** ??????? */

    ac = 0;
    XtSetArg(al[ac], XmNsensitive, False);	ac++;	/* set text to insensitive */
    /* set the colour of the text background to read only colour */
    XtSetArg(al[ac], XmNbackground, text_read_only_background);	ac++;
    XtSetValues(win->edit_text1, al, ac);


    /* reinitialize the changes counter, reset redo/undo stacks */
    win->changes_counter = 0L;  write_lw(win->changes_status, charset, " ");
    reset_undo_redo(win);


    /* free the file name */
    if (win->filename != NULL) { XtFree(win->filename);	win->filename = NULL; }

    /* blank the line & column number display  */
    write_lw(win->line_number,   charset, "     ");
    write_lw(win->column_number, charset, "    ");

    /* unmanage replace_dialog & save_as_dialog if they are active (they
       may be on the screen and they do not make any sense when no file is open) */
    if(win->replace_dialog != NULL) XtUnmanageChild( win->replace_dialog );
    if(win->save_as_dialog != NULL) XtUnmanageChild( win->save_as_dialog );


    /* set appropriate file buttons to insensitive */
    XtSetSensitive(win->menu_close_button,   False);
    XtSetSensitive(win->menu_save_button,    False);
    XtSetSensitive(win->menu_save_as_button, False);
    XtSetSensitive(win->menu_insert_button,  False);
    XtSetSensitive(win->menu_print_button,   False);

    XtSetSensitive(win->menu_undo_button,  False);
    XtSetSensitive(win->menu_redo_button,  False);
    XtSetSensitive(win->menu_cut_button,   False);
    XtSetSensitive(win->menu_copy_button,  False);
    XtSetSensitive(win->menu_paste_button, False);
    XtSetSensitive(win->menu_clear_button, False);

    XtSetSensitive(win->menu_find_button,         False);
    XtSetSensitive(win->menu_replace_button,      False);
    XtSetSensitive(win->menu_find_again_button,   False);
    XtSetSensitive(win->menu_gotoline_button,     False);
    XtSetSensitive(win->menu_mark_button,     False);

    /* setting a new title of the main window (name of the program only) */
    set_titles_mwindow_icon(win, NULL);

    /* reset all bookmarks */
    ResetAllMarks(win);

}   /* CloseFile */


/*****************************  InsertFile  ************************************
**
**      Inserts the specified file into the current edit_text widget.
**      Calls ReadFile to read the file. Returns true if file
**      exists and insert is sucessful.
*/
#ifdef _NO_PROTO
Boolean InsertFile(win, filename)
   aseditWindowStruct *win;
   char *filename;
#else  /* ! _NO_PROTO */

Boolean InsertFile(aseditWindowStruct *win, char *filename)
#endif
{
   char * file_string=NULL;     /* Contents of file.      */
   Boolean         read_only;           /* shows the file read only status */
   register int ac;                     /* arg count                */
   Arg al[10];                          /* widget arg list          */
   struct stat statbuf;                 /* Information on a file. */


   if( (file_string = ReadFile(filename, &read_only)) != NULL)
   {
	return(True);
   }
   else
   {
           return(False);
   }

}  /* InsertFile */



