
static char sccsid[] = "@(#)asedit.c	1.2 asedit, 30.09.1993";

/*
 * Copyright 1991 - 1993,  Andrzej Stochniol, London, UK
 *
 * ASEDIT text editor, both binary and source (hereafter, Software) is
 * copyrighted by Andrzej Stochniol (hereafter, AS) and ownership remains
 * with AS.
 *
 * AS grants you (hereafter, Licensee) a license to use the Software
 * for academic, research and internal business purposes only, without a
 * fee.  Licensee may distribute the binary and source code (if released)
 * to third parties provided that the copyright notice and this statement
 * appears on all copies and that no charge is associated with such copies.
 *
 * Licensee may make derivative works.  However, if Licensee distributes
 * any derivative work based on or derived from the Software, then
 * Licensee will:
 * (1) notify AS regarding its distribution of the derivative work, and
 * (2) clearly notify users that such derivative work is a modified version
 *      and not the original ASEDIT distributed by AS.
 *
 * Any Licensee wishing to make commercial use of the Software should
 * contact AS to negotiate an appropriate license for such commercial use.
 * Commercial use includes:
 * (1) integration of all or part of the source code into a product for sale
 *     or license by or on behalf of Licensee to third parties, or 
 * (2) distribution of the binary code or source code to third parties that
 *     need it to utilize a commercial product sold or licensed by or on
 *     behalf of Licensee.
 *
 * A. STOCHNIOL MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS
 * SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR
 * IMPLIED WARRANTY.  IN NO EVENT SHALL A. STOCHNIOL BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 *
 * 	Andrzej Stochniol	(A.Stochniol@ic.ac.uk)
 * 	30 Hatch Road
 * 	London SW16 4PN
 * 	UK
 *
 *
 *      Telephone: +44 (0) 81-679 5795
 *      (work)Tel: +44 (0) 71-589 5111 ext. 6151
 *            Fax: +44 (0) 71-584 1560
 *
 */

/*
 * asedit - Motif based editor
 *
 * Last changes: 30.09.1993
 *
 * asedit is a user friendly editor for X-Windows/Motif environment.
 * A Motif Text widget is used as a base for the editor.
 * Another text widget is used as a base for the hypertext system
 * We use a text widget as emulation of a future (if any) help widget.
*/



#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/types.h>
#include <signal.h>
#include <X11/Xatom.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <Xm/Xm.h>
#include <Xm/CascadeB.h>
#include <Xm/DialogS.h>
#include <Xm/BulletinB.h>
#include <Xm/FileSB.h>
#include <Xm/MainW.h>
#include <Xm/MessageB.h>
#include <Xm/Label.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/SelectioB.h>
#include <Xm/ToggleB.h>
#include <Xm/ToggleBG.h>
#include <Xm/Text.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/PanedW.h>


#if (XtSpecificationRelease > 3)
#   include <Xm/Protocols.h>	/* needed because of XmAddWMProtocolCallback;
				   available since X11R4 */
#   include <locale.h>		/* we support localization for X11R4 upwards */
#endif


#if (XtSpecificationRelease > 4)
    /* include Xaw EditRes protocol ...(works OK since X11R5) */
#   include <X11/Xmu/Editres.h>
#endif


#include "asedit.h"

#if (XmVersion == 1000)
    /* conditional Motif 1.0 compilation **/
#   include "clipbrd.h"
#endif


/*
  Widget and non-widget resources if the application defaults file can't be
  found.  Generated automatically from Asedit.ad by "ad2c".  Comment out the
  include line (but not the NULL) if you don't want any resources compiled
  in.
*/

#if (XmVersion > 1000)
    /* fallbackResources are only used from Motif 1.1  **/
    static String fallbackResources[] = {
#   	include "Asedit.ad.h"
	NULL
    };

#endif  /* XmVersion ... */

#if (XmVersion >= 1002)
    static char motif1_2_id[] = "@(#)asedit extra version for Motif 1.2";
#endif

/*****************************	Forward Declarations  ***********************/

/* I am commited to use ANSI compliant function prototypes. This is the proper
   way to handle function declarations and signatures (declaring the types of
   the parameters to the function). This convention is good style (and save
   a lot of debugging time!).

   Unfortunately there are still systems that do not support ANSI function
   prototypes. Because of that to make asedit portable to those systems I was
   forced to use conditional compilation. So, where appropriate I am using
   Motif based  #ifdef _NO_PROTO. It makes the code less readable, but there
   is really no other choice (sorry!).
*/
#ifdef _NO_PROTO	/* prototypes for non-ANSI systems follow ... */

static Widget CreateMenus ();
static void set_paste_buttons();
static void asedit_find();
static void asedit_change();
static void asedit_mark_set();
static void asedit_mark_goto();
Boolean PrintString();

extern void ResetAllMarks();
extern char *make_tmpnam ();

#else  /* ! _NO_PROTO, ANSI prototypes follow */

static Widget CreateMenus (aseditWindowStruct *win, Widget parent);
static void set_paste_buttons();
static void asedit_find(Widget w, XEvent *event, char **params, Cardinal *num_params);
static void asedit_change(Widget w, XEvent *event, char **params, Cardinal *num_params);
static void asedit_mark_set(Widget w, XEvent *event, char **params, Cardinal *num_params);
static void asedit_mark_goto(Widget w, XEvent *event, char **params, Cardinal *num_params);
Boolean PrintString(char *text_string, char *print_command);

extern void ResetAllMarks(aseditWindowStruct *win);
extern char *make_tmpnam (void);

#endif	/* end of conditional _NO_PROTO prototypes  compilation */


/* extra actions for edit text widgets */
static XtActionsRec AseditExtraActionsTable[] = {
  {"asedit-find",               (XtActionProc)asedit_find},
  {"asedit-change",             (XtActionProc)asedit_change},
  {"asedit-mark-set",           (XtActionProc)asedit_mark_set},
  {"asedit-mark-goto",          (XtActionProc)asedit_mark_goto},
};


/* all customizable definitions for menu structures are now (20.02.1993)
    defined as resources (i.e labelString, mnemonic, acceleratorText &
    accelerator); note slight name changes for menu items (Open <-- Open... etc.)
*/

static as_menuh_struct File_menu[] ={
	 {"New",      MenuCB, HelpCB, MENU_NEW,   	NULL},
	 {"Open",     MenuCB, HelpCB, MENU_OPEN,  	NULL},
	 {"Close",    MenuCB, HelpCB, MENU_CLOSE, 	NULL},
	 {"Save",     MenuCB, HelpCB, MENU_SAVE,  	NULL},
	 {"Save_As",  MenuCB, HelpCB, MENU_SAVE_AS, 	NULL},
	 {NULL},				/* separator */
	 {"Insert",    MenuCB, HelpCB, MENU_INSERT,   	NULL},
	 {"Print",    MenuCB, HelpCB, MENU_PRINT,   	NULL},
	 {NULL},				/* separator */
	 {"Exit",     MenuCB, HelpCB, MENU_EXIT,    	NULL},
	 };


static as_menuh_struct Edit_menu[] ={
	 {"Undo",     MenuCB, HelpCB, MENU_UNDO,	NULL},
	 {"Redo",     MenuCB, HelpCB, MENU_REDO,     	NULL},
	 {NULL},
	 {"Cut",      MenuCB, HelpCB, MENU_CUT,     	NULL},
	 {"Copy",     MenuCB, HelpCB, MENU_COPY,    	NULL},
	 {"Paste",    MenuCB, HelpCB, MENU_PASTE,   	NULL},
	 {NULL},					/* separator */
	 {"Clear",    MenuCB, HelpCB, MENU_CLEAR, 	NULL}
	 };


/**** remember that the following two submenus *MUST* have TOTAL_MARKS entries;
      (i.e. most probably 10, see asedit.h) 
***/

static as_menuh_struct Mark_menu_set[] ={
	 {"0",     MenuCB, HelpCB, MENU_MARK_SET0,  '0', 	NULL},
	 {"1",     MenuCB, HelpCB, MENU_MARK_SET1,  '1',   	NULL},
	 {"2",     MenuCB, HelpCB, MENU_MARK_SET2,  '2',  	NULL},
	 {"3",     MenuCB, HelpCB, MENU_MARK_SET3,  '3',  	NULL},
	 {"4",     MenuCB, HelpCB, MENU_MARK_SET4,  '4',  	NULL},
	 {"5",     MenuCB, HelpCB, MENU_MARK_SET5,  '5',  	NULL},
	 {"6",     MenuCB, HelpCB, MENU_MARK_SET6,  '6',  	NULL},
	 {"7",     MenuCB, HelpCB, MENU_MARK_SET7,  '7',  	NULL},
	 {"8",     MenuCB, HelpCB, MENU_MARK_SET8,  '8',  	NULL},
	 {"9",     MenuCB, HelpCB, MENU_MARK_SET9,  '9',  	NULL},
	};

static as_menuh_struct Mark_menu_go[] ={
	 {"0",     MenuCB, HelpCB, MENU_MARK_GO0,   '0', 	NULL},
	 {"1",     MenuCB, HelpCB, MENU_MARK_GO1,   '1',  	NULL},
	 {"2",     MenuCB, HelpCB, MENU_MARK_GO2,   '2', 	NULL},
	 {"3",     MenuCB, HelpCB, MENU_MARK_GO3,   '3', 	NULL},
	 {"4",     MenuCB, HelpCB, MENU_MARK_GO4,   '4', 	NULL},
	 {"5",     MenuCB, HelpCB, MENU_MARK_GO5,   '5', 	NULL},
	 {"6",     MenuCB, HelpCB, MENU_MARK_GO6,   '6', 	NULL},
	 {"7",     MenuCB, HelpCB, MENU_MARK_GO7,   '7', 	NULL},
	 {"8",     MenuCB, HelpCB, MENU_MARK_GO8,   '8', 	NULL},
	 {"9",     MenuCB, HelpCB, MENU_MARK_GO9,   '9', 	NULL},
	};

static as_menuh_struct Mark_menu[] ={
	 {"Set",    NULL, HelpCB, MENU_MARK_SET,0, NULL, NULL, Mark_menu_set,
		XtNumber(Mark_menu_set),	NULL},
	 {"Go_to",    NULL, HelpCB, MENU_MARK_GO,0, NULL, NULL, Mark_menu_go,
		XtNumber(Mark_menu_go),	NULL}
	};


static as_menuh_struct Search_menu[] ={
	 {"Find",     MenuCB, HelpCB, MENU_FIND,    	NULL},
	 {"Repeat",   MenuCB, HelpCB, MENU_REPEAT_FIND,NULL},
	 {"Change",   MenuCB, HelpCB, MENU_CHANGE, 	NULL},
	 {"Go_to",    MenuCB, HelpCB, MENU_GOTOLINE,	NULL,},
 	 {NULL},					/* separator */
	 {"Mark",    NULL, HelpCB, MENU_MARK,0, NULL, NULL, Mark_menu,
		XtNumber(Mark_menu),	NULL} 
	 };


/* Describe the menu bar, giving only the names to appear in
 * the menu bar and pointers to each pulldown pane, already defined.
 */

static as_menuh_struct Main_menu[] ={
	 {"File",   NULL, HelpCB, MENU_FILE,    0, NULL, NULL, File_menu,
		XtNumber(File_menu),NULL},
	 {"Edit",   NULL, HelpCB, MENU_EDIT,    0, NULL, NULL, Edit_menu,
		XtNumber(Edit_menu),NULL},
	 {"Search", NULL, HelpCB, MENU_SEARCH,  0, NULL, NULL, Search_menu,
		XtNumber(Search_menu),NULL},
	 };


/* Describe the structures for the help menu */

static as_menuh_struct Help_menu[] ={
	 {"On_Keys",	HelpCB, HelpCB, MENU_H_ON_KEYS,  	NULL},
	 {"Index", 	HelpCB, HelpCB, MENU_H_INDEX,     	NULL},
	 {"On_Help",    HelpCB, HelpCB, MENU_H_ON_HELP,    	NULL},
	 {NULL},			/* separator */
	 {"About",      MenuCB, HelpCB, MENU_H_ABOUT,	    	NULL}
	 };

/* Describe the Help button in the menu bar */

static as_menuh_struct help_Main_menu[] ={
	 {"Help",   NULL, HelpCB, MENU_HELP,  0, NULL, NULL, Help_menu,
		XtNumber(Help_menu),NULL}
	 };


/* new resource fields for X ... */

#define XtNas_lstr		"as_lstr"
#define XtCAs_lstr		"As_lstr"

static XtResource resources[] = {
    { "noname", "Noname", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, noname), XmRString, ""},
    { "tmpDir", "TmpDir", XmRString, sizeof(String),
       XtOffset(as_lstr_ptr, tmpDir), XmRString, NULL},

    { "helpDir", "HelpDir", XmRString, sizeof(String),
       XtOffset(as_lstr_ptr, helpDir), XmRString, NULL},
 
    { "backupFileSuffix", "BackupFileSuffix", XmRString, sizeof(String),
       XtOffset(as_lstr_ptr, backupFileSuffix), XmRString, NULL},

    { "fm_unable_to_open", "Fm_unable_to_open", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, fm_unable_to_open), XmRString, ""},
    { "fm_unable_to_save", "Fm_unable_to_save", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, fm_unable_to_save), XmRString, ""},
    { "fm_not_closed", "Fm_not_closed", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, fm_not_closed), XmRString, ""},
    { "fm_print_failed", "Fm_print_failed", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, fm_print_failed), XmRString, ""},
    { "fm_exit_aborted", "Fm_exit_aborted", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, fm_exit_aborted), XmRString, ""},
    { "fm_not_printed", "Fm_not_printed", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, fm_not_printed), XmRString, ""},
    { "fm_no_selection", "Fm_no_selection", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, fm_no_selection), XmRString, ""},
    { "fm_no_printer", "Fm_no_printer", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, fm_no_printer), XmRString, ""},
    { "fm_not_regular", "Fm_not_regular", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, fm_not_regular), XmRString, ""},
    { "fq_overwrite", "Fq_overwrite", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, fq_overwrite), XmRString, ""},
    { "fq_save_changes", "Fq_save_changes", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, fq_save_changes), XmRString, ""},
    { "find_label", "Find_label", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, find_label), XmRString, ""},
    { "find_next_label", "Find_next_label", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, find_next_label), XmRString, ""},
    { "change_label", "Change_label", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, change_label), XmRString, ""},
    { "find_n_verify_label", "Find_n_verify_label", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, find_n_verify_label), XmRString, ""},
    { "find_dialogTitle", "Find_dialogTitle", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, find_dialogTitle), XmRString, ""},
    { "change_dialogTitle", "Change_dialogTitle", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, change_dialogTitle), XmRString, ""},
    { "sm_have_to_enter", "Sm_have_to_enter", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, sm_have_to_enter), XmRString, ""},
    { "sm_not_found", "Sm_not_found", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, sm_not_found), XmRString, ""},
    { "sm_change_all_completed", "Sm_change_all_completed", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, sm_change_all_completed), XmRString, ""},
    { "sm_line_range", "Sm_line_range", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, sm_line_range), XmRString, ""},
    { "sq_change", "Sq_change", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, sq_change), XmRString, ""},
    { "sq_doc_end", "Sq_doc_end", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, sq_doc_end), XmRString, ""},
    { "sq_doc_beg", "Sq_doc_beg", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, sq_doc_beg), XmRString, ""},

    { "read_only_marker", "Read_only_marker", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, read_only_marker), XmRString, ""},

    { "help_err_fopen", "Help_err_fopen", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, help_err_fopen), XmRString, ""},
    { "help_err_finc", "Help_err_finc", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, help_err_finc), XmRString, ""},
    { "help_no_info", "Help_no_info", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, help_no_info), XmRString, ""},

    { "initial_geometry", "Initial_geometry", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, initial_geometry), XmRString, ""},
    { "first_window_iconic", "First_window_iconic", XmRBoolean, sizeof(Boolean),
      XtOffset(as_lstr_ptr, first_window_iconic), XmRString, "False"}
    };


Display		*display;	/*  Display		*/
Widget toplevel;		/* application shell (top level) (such a name
				   is used inside the clipboard functions ! )*/
Widget help_dialog = NULL;		/* global help for all asedit windows */

aseditWindowStruct *asedit_last_window = NULL;	/* the last asedit win structure in the chain */

/* all widget declarations moved to asedit.h ....(for version >= 1.2) */


char *PROGRAM_CLASS = "Asedit";  	
				/* PROGRAM_CLASS should be declared as 
					const char * 
				    but SUN does not recognize const
				    declaration yet !!!
				 */
char   *PROGRAM_NAME;		/* will be assigned from the command line */

Boolean	clipboard_filled=False; 	/* to show if there is something
					   in clipbboard to paste from */

Pixel	text_edit_background;	/* background colour of the main text widget
				   ( it is the colour of a recessed widget) */
Pixel   text_read_only_background;	/* a lighter colour to show that the file
					   is read only */
Pixel	select_menu_background;	/* background for editable widgets pop down
				   from the menus; it is equal to the menu buttons
				   arm colour */
Pixmap	xm_question_mark;	/* Motif question mark pixmap (initialized in
				   install_as_images) */

XmFontList default_fontlist;	/* default font list for the edit text widget */


XmStringCharSet charset = (XmStringCharSet) XmSTRING_DEFAULT_CHARSET;
				/* used to set up XmStrings */


XtAppContext app_context;	/* application context */

as_lstr		lstr;		/* language dependent messages */


/* temp hack */
/* three strings exported to ht_help .... */
String help_err_fopen, help_err_finc, help_no_info;

/*****************************  main  ***************************************
**
*/
#ifdef _NO_PROTO
void main (argc, argv)
	unsigned int argc;
	char *argv[];
#else  /* ! _NO_PROTO */

void main (unsigned int argc, char *argv[])
#endif
{

    Arg			al[10];		/*  arg list		*/
    register int	ac;		/*  arg count		*/
    Boolean		set_signals = False;	/***!!!!!should be False; **/
    Atom		clipboard_atom;		/* to check if we have something in the clipboard */

    /* Ignore signals for now, but record whether they were already
       ignored or not so we can catch them later if need be.
    */
    if ((signal(SIGQUIT, SIG_IGN) != SIG_IGN) &&
	(signal(SIGINT,  SIG_IGN) != SIG_IGN))	set_signals = True;


    /* 	Get application name 	*/
    if (( PROGRAM_NAME = strrchr(argv[0], (int) '/')) == NULL)
		PROGRAM_NAME = argv[0];
    else
		PROGRAM_NAME++;

    /*	Initialize toolkit and open display (!!! version dependent).	*/

    /* first set some special arguments for the toplevel shell (common for X11R3/4/5) */
    ac = 0;
    XtSetArg(al[ac], XmNmappedWhenManaged, False);	ac++;
    /* to AVOID:  "Error: Shell widget asedit has zero width and/or height"  set width & height explicitly */
    XtSetArg(al[ac], XmNwidth, 100);		ac++;
    XtSetArg(al[ac], XmNheight, 50);		ac++;

#if (XtSpecificationRelease  == 3)
    XtToolkitInitialize ();
    app_context = XtCreateApplicationContext();

    display = XtOpenDisplay (app_context, NULL, PROGRAM_NAME, PROGRAM_CLASS,
			cline_options, XtNumber(cline_options), &argc, argv);
    if (!display)
    {
	XtWarning ("can't open display, exiting...");
	exit (1);
    }
    /*	Create ApplicationShell.	*/
    toplevel = XtAppCreateShell (PROGRAM_NAME, PROGRAM_CLASS,
			applicationShellWidgetClass, display, al, ac);
    
#elif (XtSpecificationRelease > 4)

    /* initialize locale ... */
    /***** NOT YET!!!!    XtSetLanguageProc(NULL, NULL, NULL);   ****/

    /*  there is a subtle difference in declaration of XtAppInitialize in X11R4
	and in X11R5; in X11R4 argc_in_out is declared as Cardinal* (i.e. in
	practice unsigned int*) but in X11R5 it is declared as int *  !!!
	So to avoid messages when prototypes are used we have to differentiate
	this situation (I hate small "improvements")
    */
    toplevel = XtAppInitialize(&app_context, (String)PROGRAM_CLASS,
			cline_options, XtNumber(cline_options), 
			(int *)&argc, argv, fallbackResources, al, ac);
    display = XtDisplay(toplevel);

#else	/* ... X11R4 version .... */
    /* initialize locale with the standard setlocale function */
    setlocale(LC_ALL,"");

    toplevel = XtAppInitialize(&app_context, (String)PROGRAM_CLASS,
			cline_options, XtNumber(cline_options),
			 (unsigned *)&argc, argv, fallbackResources, al, ac);
    display = XtDisplay(toplevel);

    /* we don't have to check for a valid display because it is done in
       XtAppInitialize (on error a message "Error: Can't Open Display" is shown )
    */
#endif


#if (XtSpecificationRelease > 4)
    /* addition of the X11R5 editres protocol */
    XtAddEventHandler(toplevel, (EventMask)0, True, _XEditResCheckMessages, NULL);
#endif

    /* If we need to handle keyboard signals, do it now */
    if (set_signals) { signal(SIGQUIT, ByeBye);	signal(SIGINT, ByeBye); }

    /* always handle the following */
    signal(SIGTERM, ByeBye);
    signal(SIGHUP,  ByeBye);


    /* add asedit extra actions;
       the following should be before the first widget that may use
       our extra actions is created but after the toolkit initialization
    */
    XtAppAddActions(app_context, AseditExtraActionsTable, XtNumber(AseditExtraActionsTable));


    /* Get application resources (here: language strings) */
    XtGetApplicationResources(toplevel, (XtPointer)&lstr, resources,
				XtNumber(resources), NULL, 0);

    /* set pointers to three strings  exported to ht_help .... */
    help_err_fopen = lstr.help_err_fopen;
    help_err_finc  = lstr.help_err_finc;
    help_no_info   = lstr.help_no_info;


    next_window(NULL);

    /* The creation of help_dialog is postponed (since asedit 1.2x) until 
       the dialog is needed (see HelpCB)
    */

    /*	Realize toplevel widgets.	*/
    XtRealizeWidget (toplevel);


    /* now check if the desktop clipboard is filled ...
       if yes enable paste button !!!
    */
    clipboard_atom = XmInternAtom(display, "CLIPBOARD", False);
    if(XGetSelectionOwner(display, clipboard_atom))
    {
	/* the clipboard is filled ..... */
	clipboard_filled = True;
    }


    /* if a file name was specified in the command line open it */
    if(argc > 1)
    {   /* assume that the specified parameter is a filename */
	open_file_in_last_window(argv[1]);
    }
    else
    {
	/* use the default name .... */
	open_file_in_last_window(NULL);
    }

    /*	Process events 	*/

    XtAppMainLoop(app_context);

}   /* main */


#ifdef _NO_PROTO
void make_window(win)
    aseditWindowStruct *win;
#else  /* _NO_PROTO */
void make_window(aseditWindowStruct *win)
#endif
{
    Widget          main;           /*  MainWindow          */
    Widget          menu_bar;       /*  RowColumn           */
    Widget          work_area;      /*  work area in the main widget */

    Arg             al[10];         /*  arg list            */
    register int    ac;             /*  arg count           */
    char            *work;          /* work string */
    Atom            wm_delete_window;       /* used with for WM_DELETE_WINDOW */
    Atom            wm_quit_appl;           /* used with _WM_QUIT_APPL on SGI */
    Atom            clipboard_atom;         /* to check if we have something in the clipboard */

    /*      Create MainWindow.      */
    ac = 0;
    XtSetArg (al[ac], XmNshadowThickness, 0);  ac++;
    main = XmCreateMainWindow (win->topshell, "main", al, ac);
    XtManageChild (main);


    /*      Create and manage all menus     */
    menu_bar = CreateMenus (win, main);



    win->menu_bar = menu_bar;

    /* 	Creation of each dialog in asedit 1.2x is postponed until
	it is needed (they are with one exception children of menu_bar)
    */
    if(win->prev == NULL) install_as_images(menu_bar);   /* install it only for the first time */

    /* create work area in main widget */
    work_area = CreateEditWorkArea(win, main);

    /*      Set areas of MainWindow         */
    XmMainWindowSetAreas (main, menu_bar, NULL, NULL, NULL,
					work_area);


    /*  set asedit icon in a way that supports the best portability into
	environments where user may not be running the most up-to-date
	window manager; as a background and foreground colours appropriate
	colours of the edit_text widget are used; icon_title <--- PROGRAM_NAME;
	(in fact the icon name will be dynamically changed to show
	the name of currently edited file - see set_titles_mwindow_icon procedure )
    */

    set_asedit_icon(win->topshell, win->edit_text, PROGRAM_NAME);


    /*      Realize topshell widget.       */
    XtRealizeWidget (win->topshell);


#if (XtSpecificationRelease > 3)
    /*  in X11R4 we can use WM protocol callback to catch when user presses
	the "Close" item on the system menu attached to the top-level shell
	and make some clenup before exiting the application
	Additionally we intercept _WM_QUIT_APP if it exists (SGI case)
    */
    wm_delete_window = XmInternAtom(display, "WM_DELETE_WINDOW", False);
    wm_quit_appl = XmInternAtom(display, "_WM_QUIT_APP", False);
    XmAddWMProtocolCallback(win->topshell, wm_delete_window,
			(XtCallbackProc) FinalCleanupCB, mk_asdat(0) );
    XmAddWMProtocolCallback(win->topshell, wm_quit_appl,
			(XtCallbackProc) FinalCleanupCB, mk_asdat(0) );

    /*  for the "Close" to be properly intercepted we have to set
	XmNdeleteResponse on the top shell to XmDO_NOTHING
	(otherwise the application will still be killed!)
    */
    ac = 0;
    XtSetArg (al[ac], XmNdeleteResponse,XmDO_NOTHING);  ac++;
    XtSetValues(win->topshell, al, ac);

#endif

    /*  Pop the window (topshell) up. */
    XtPopup (win->topshell, XtGrabNone);
    XFlush (display);
    XSync (display, False);


}   /*  make_window */


#ifdef _NO_PROTO
void next_window(win_prev)
    aseditWindowStruct *win_prev;
#else  /* _NO_PROTO */
void next_window(aseditWindowStruct *win_prev)
#endif
{
    Arg             al[10];         /*  arg list            */
    register int    ac;             /*  arg count           */
    aseditWindowStruct *win=NULL;


    /* first create a new  aseditWindowStruct  structure */

    win = new_asedit_win(win_prev);

    /* store win as the last in the chain ... */
    asedit_last_window = win;

    ac = 0;
    if(win_prev != NULL)
    {
	/* not a first window, open it down and right ...*/
	Dimension x_prev, y_prev, scrx, scry, x, y, width, height;
	char geom[20];

	scrx = WidthOfScreen (XtScreen (toplevel));
	scry = HeightOfScreen (XtScreen (toplevel));

	ac = 0;
	XtSetArg(al[ac], XmNx,      &x_prev);	ac++;
	XtSetArg(al[ac], XmNy,      &y_prev);	ac++;
	XtSetArg(al[ac], XmNwidth,  &width);	ac++;
	XtSetArg(al[ac], XmNheight, &height);	ac++;
	XtGetValues (win_prev->topshell, al, ac);

	/* Try open down and right 50 pixels...(if not possible correct it) */
	x = x_prev + 50;
	y = y_prev + 50;
	/* If not possible, deal with it... */
	while (x + width  > scrx)    x -= 100;
	while (y + height > scry)    y -= 100;

	sprintf (geom, "+%d+%d\0", x, y);

	ac = 0;
	XtSetArg (al[ac], XmNgeometry, (long)geom); ac++;
	XtSetArg (al[ac], XmNdefaultPosition, False); ac++;
	XtSetArg (al[ac], XmNwidth, width); 	ac++;
	XtSetArg (al[ac], XmNheight, height);	ac++;
    }
    else
    {	/* first window, check if it is needed to be iconic etc. */
	if (lstr.first_window_iconic)
		{ XtSetArg (al[ac], XmNiconic, True); ac++; }
	if (lstr.initial_geometry != NULL && strlen(lstr.initial_geometry))
		{ XtSetArg (al[ac], XmNgeometry, (long)lstr.initial_geometry); ac++; }
    }
    XtSetArg(al[ac], XmNtitle, PROGRAM_NAME); ac++;

    win->topshell = XtCreatePopupShell ("main", topLevelShellWidgetClass,
			     toplevel, al, ac);

#if (XtSpecificationRelease > 4)
    /* X11R5 editres addition ...... */
    XtAddEventHandler(win->topshell, (EventMask)0, True, _XEditResCheckMessages, NULL);
#endif

    make_window(win);

}   /* next_window */



/* Definitions of functions that accept a variable number of arguments.
   There are separate definitions for macros compatible with UNIX System V
   (<varargs.h>) and for ANSI C (<stdarg.h>).
   Use STDARG.H for ANSI C compatibility (whenever possible).
   NOTE: You can't include both STDARG.H and VARARGS.H
   A symbol _NO_STDARG is defined by me in the Imakefile !!!
*/

#ifndef _NO_STDARG
#include <stdarg.h>

#ifdef _NO_PROTO
void write_lw(/*  Widget label, XmStringCharSet charset, va_list arg_list, ...  */);

#else   /* ! _NO_PROTO */
void write_lw(Widget label, XmStringCharSet charset, va_list arg_list, ...);
#endif
#else	/*  ( _NO_STDARG) now version for non-ANSI C (UNIX system V varargs)  */

#include <varargs.h>

#ifdef _NO_PROTO
void write_lw(/* va_alist */);
#else  /* ! _NO_PROTO */
void write_lw(va_list va_alist);
#endif

#endif	/* _NO_STDARG */


/*****************************  MenuCB  *************************************
**
**	Process callbacks from PushButtons in PulldownMenus.
*/
#ifdef _NO_PROTO
void MenuCB (w, client_data, call_data)
    Widget w;
    caddr_t client_data;
    caddr_t call_data;
#else  /* ! _NO_PROTO */

void MenuCB (Widget w, caddr_t client_data, caddr_t call_data)
#endif
/*    Comment for novice users:
**    in Motif standard callback parameters are as follows:
**    Widget		w;		-   widget id
**    caddr_t		client_data;	-   data from application
**    caddr_t		call_data;	-   data from widget class
*/
{

    register int ac;		/* arg count		    */
    Arg al[10];			/* arg list		    */
    char *command;		/* command used in printing */
    XmString  xmstr;		/* work XmString */
    char      work[326];	/* work string: max. file name ~256 + strings ... */

    int id 		    = get_id_from_asdat(client_data);
    aseditWindowStruct *win = get_win_from_asdat(client_data);


    TurnWatchCursor(True);
    switch (id)
    {
	case MENU_OPEN:
	    /* version 1.2x - we open a new window so simply put the open dialog */
	    show_open_dialog(win);
	    break;

	case MENU_NEW:
	    next_window(asedit_last_window);
	    open_file_in_last_window(NULL);   /* open a new default file ...  */
	    break;

	case MENU_CLOSE:
	    if (win->changes_counter != 0L) /* display the 'save' message dialog */
	    {
		show_save_changes_dialog(win);
		win->reason_save_question = id;
	    }
	    else	CloseFile(win);
	    break;

	case MENU_SAVE:
	    /* first check if the name is not a default NoName ... if so
	       call save_as with empty name */
	    if(strncmp(win->filename, lstr.noname, strlen(lstr.noname)) == 0)
	    {
		show_save_as_dialog(win, NULL);
	    }
	    else
	    {
		/* create a backup file and write the current text to a file */
		if(!SaveFile(win))
		{	/* generate error message that file can't be saved */
		    strcpy(work, (char *)lstr.fm_unable_to_save);
		    strcat(work, win->filename);
		    show_error_message(win, work);
		}
	    }
	    break;

	case MENU_SAVE_AS:
	    /* Display the 'save as' dialog with the present filename displayed in it. */
	    if(strncmp(win->filename, lstr.noname, strlen(lstr.noname)) == 0)
	    		show_save_as_dialog(win, NULL);
	    else
	    {
                /* lets get the event time needed for the selection(send that using
			 win->timestamp_search_request)  */
                XmAnyCallbackStruct * cb = (XmAnyCallbackStruct *) call_data;
                win->timestamp_search_request = cb->event->xbutton.time;
		show_save_as_dialog(win, win->filename);
	    }
	    break;

	case MENU_INSERT:
	    show_insert_dialog(win);
	    break;

	case MENU_PRINT:

	    show_print_dialog(win);
	    break;

	case MENU_EXIT:
	    /* exit if there is no files open */
	    if (win->changes_counter != 0L) /* display the 'save' message dialog */
	    {
		show_save_changes_dialog(win);
		win->reason_save_question = id;
	    }
	    else
	    {
		CloseFile(win);	/* close up the file */
		remove_asedit_win (win);
		if(!asedit_last_window) exit (0);	/* exit this program */
	    }
	    break;


	case MENU_UNDO:
	case MENU_REDO:
	    UndoRedo(win, id);
	    break;


#if (XmVersion == 1000)
	/* for Motif 1.0.x  functions dealing with clipboard do not exist
	       - use my old functions */
	case MENU_CUT:
	case MENU_COPY:	/* action is the same, except that for MENU_CUT
				   the primary selection is deleted also */
	    {
		/* needed to get the event time */
		XmAnyCallbackStruct * cb = (XmAnyCallbackStruct *) call_data;
		char *selected_string = XmTextGetSelection (win->edit_text); /* text selection    */

		/* call a routine to copy a selection to the clipboard */
		/* allow pasting when an item is sucessfully copied to the clipboard */
		if( CopyStringToClipboard(selected_string,cb->event->xbutton.time) )
		{
		    clipboard_filled = True;
		    set_paste_buttons();	/* set sensitivity ... */
		}
		if(selected_string != NULL)
			XtFree(selected_string);   /* free allocated memory */
		/* call routine to delete primary selection (only for the cut option)*/
		if( id == MENU_CUT)	DeletePrimarySelection(win->edit_text);
	    }
	    break;

	case MENU_PASTE:
	    /* call the routine that paste the text at the cursor position */
	    PasteItemFromClipboard(win->edit_text);
	    break;

	case MENU_CLEAR:
	    /* call routine to delete primary selection */
	    DeletePrimarySelection(win->edit_text);
	    break;
#else
	/* since Motif 1.1 text clipboard functions are defined as standard - use them */

	case MENU_CUT:
	    if( XmTextCut(win->edit_text, CurrentTime) )
	    {   /* cut successful */
		clipboard_filled = True;
		set_paste_buttons();        /* set sensitivity ... */
	    }
	    break;

	case MENU_COPY:
	    if( XmTextCopy(win->edit_text, CurrentTime) )
	    {   /* copy successful */
		clipboard_filled = True;
		set_paste_buttons();        /* set sensitivity ... */
	    }
	    break;

	case MENU_PASTE:
	    XmTextPaste(win->edit_text);
	    break;

	case MENU_CLEAR:
	    XmTextClearSelection(win->edit_text, CurrentTime);
	    break;
#endif

	case MENU_FIND:
	case MENU_CHANGE:
	    /* set the reason for managing replace_dialog  (it is important
	       because this dialog is shared between find & replace option, so only
	       one callback for each button was registered) */
	    win->search_reason = id;
	    show_replace_dialog(win);

	    break;

	case MENU_REPEAT_FIND:
	    /* the last find action is repeated */
	    find_string(win);
	    break;

	case MENU_GOTOLINE:
	    show_gotoline_dialog(win);
	    break;

	case MENU_MARK_SET0:
	case MENU_MARK_SET1:
	case MENU_MARK_SET2:
	case MENU_MARK_SET3:
	case MENU_MARK_SET4:
	case MENU_MARK_SET5:
	case MENU_MARK_SET6:
	case MENU_MARK_SET7:
	case MENU_MARK_SET8:
	case MENU_MARK_SET9:
	    {
		int mark= id - MENU_MARK_SET0;
		XmTextPosition pos;
		/* get the value of the cursor position */
                XtSetArg(al[0], XmNcursorPosition, &pos);
                XtGetValues(win->edit_text, al, 1);
		win->mark_pos[mark] = pos;
		win->mark_set[mark] = True;
		win->marks_used     = True;
		XtSetSensitive( win->menu_mark_go_button[mark], True);
	    }
	    break;

	case MENU_MARK_GO0:
	case MENU_MARK_GO1:
	case MENU_MARK_GO2:
	case MENU_MARK_GO3:
	case MENU_MARK_GO4:
	case MENU_MARK_GO5:
	case MENU_MARK_GO6:
	case MENU_MARK_GO7:
	case MENU_MARK_GO8:
	case MENU_MARK_GO9:
	    {
		int mark = id -  MENU_MARK_GO0;
		XmTextSetCursorPosition(win->edit_text, win->mark_pos[mark]);  /* causes call to
					TextCB, so we don't have to worry about line, column numbers*/
	    }
	    break;

	case MENU_H_ABOUT:
	    show_about_message(win);
	    break;


	default:
	    /* an unknown client_data was received and there is no setup to handle this */
	    fprintf(stderr, "Warning: an unknown client_data in menu callback\n");
	    break;
    }
    TurnWatchCursor(False);

} /* MenuCB */


/*****************************  DialogOkCB  *********************************
**
**	Process callback from Dialog OK actions.
*/
#ifdef _NO_PROTO
void DialogOkCB (w, client_data, call_data)
    Widget w;
    caddr_t client_data;
    caddr_t call_data;
#else  /* ! _NO_PROTO */

void DialogOkCB (Widget w, caddr_t client_data, caddr_t call_data)
#endif
{
    FILE *fout;		/* used to test if the specified file exists */
    static char *save_as_filename=NULL;  /* new file name; temporary pointer -
			- the allocated memory should not be freed if
			this pointer is assigned later on to the filename */
    char 	    work[326];	    /* work string: max. file name ~256 + strings ... */
    XmString        xmstr;          /*  work XmString */
    Arg		    al[5];
    register int    ac;

    int id 		    = get_id_from_asdat(client_data);
    aseditWindowStruct *win = get_win_from_asdat(client_data);


    TurnWatchCursor(True);
    switch ( id )
    {
	case DIALOG_OPEN:
	    /* if there is a file in the current window open a new window;
		otherwise just open the file and read it into the text widget
		in the current window
	    */
	    if (win->filename != NULL) 
	    {
                /* create a new window and load (open) the file selected */
		XmFileSelectionBoxCallbackStruct *fcb =
			 (XmFileSelectionBoxCallbackStruct *) call_data;
		char *filename=NULL;

            	next_window(asedit_last_window);
	        XtUnmanageChild (w);	/* popdown the file selection box */

		/* get the filename from the file selection box */
		XmStringGetLtoR(fcb->value, charset, &filename);
		/*** 30 SEPT late addition: 3 lines*/
                /* set the file_read_only to the value requested by the user */
                if(win->view_only_toggle!= NULL)         /* safety check */
                   asedit_last_window->file_read_only = XmToggleButtonGetState(win->view_only_toggle);

	        open_file_in_last_window(filename);
		if(filename != NULL) XtFree(filename);
	    }
	    else
	    {
		 XmFileSelectionBoxCallbackStruct *fcb =
                         (XmFileSelectionBoxCallbackStruct *) call_data;

                /* get the filename from the file selection box */
                XmStringGetLtoR(fcb->value, charset, &(win->filename));
                /*** 30 SEPT late addition: 3 lines*/
                /* set the file_read_only to the value requested by the user */
                if(win->view_only_toggle!= NULL)         /* safety check */
                   win->file_read_only = XmToggleButtonGetState(win->view_only_toggle);


		/* open file if it exists, if not set the empty text;
                   if file can't be opened or created show error message and
                   close the previous file */

                if (!OpenFile(win, False))    /* OpenFile is called with only_existing_files = False */
                {
                    strcpy(work,lstr.fm_unable_to_open);
                    strcat(work, win->filename);
                    /* popdown the selection box - it is important
                       to do that before popup of the error_message  because
                       otherwise the current window lose focus !! */
                    XtUnmanageChild (w);
                    show_error_message(win, work);
		    if(win->filename != NULL) {XtFree(win->filename); win->filename = NULL; }
                }
		else XtUnmanageChild (w);    /* popdown the file selection box */
	    }
	    break;

	case DIALOG_SAVE_CHANGES:
	    /* save the current file, unmanage the dialog and simply proceed
	       with the action that prompted the save_changes_dialog */
	    if(!SaveFile(win))
	    {	/* generate error message that file can't be saved */

		strcpy(work, (char *)lstr.fm_unable_to_save);
		strcat(work, win->filename);
		if( win->reason_save_question == MENU_CLOSE)
			strcat(work,	(char *)lstr.fm_not_closed);
		if( win->reason_save_question == MENU_EXIT)
			strcat(work,	(char *)lstr.fm_exit_aborted);
		XtUnmanageChild (w);
		show_error_message(win, work);
		if( win->reason_save_question == MENU_EXIT ||
		    win->reason_save_question == MENU_CLOSE)
			break;		/* do not proceed the original action */
	    }
	    else XtUnmanageChild (w);		/* popdown the save question */

	    switch(win->reason_save_question)
	    {
		case MENU_CLOSE:
		    CloseFile(win);
		    break;

		case MENU_EXIT:
		    remove_asedit_win (win);
		    if(!asedit_last_window) exit (0);    /* exit this program */
		    break;

		default:
		    /* an unknown reason_save_question */
		    fprintf (stderr, "Warning: an unknown reason_save_question in accept callback \n");
		    break;
	    }
	    break;


	case DIALOG_SAVE_AS:
	    { /* grouping brackets to use local *scb */
		XmSelectionBoxCallbackStruct *scb =
			 (XmSelectionBoxCallbackStruct *) call_data;
		/* free the memory .. (it happens when save as was selected,
		   a file with such a name existed already and the user
		   answered Cancel to overwrite question )  */
		if (save_as_filename != NULL)
			{ XtFree(save_as_filename); save_as_filename = NULL; }
		/* get the new filename string from the file selection box */
		XmStringGetLtoR(scb->value, charset, &save_as_filename);
	    }

	    /* check  if such a file already exists; if it exists
	       ask if it should be overwritten or not; if such a file
	       does not exist just save the file with the new name */

	    if ((fout = fopen(save_as_filename, "r")) != NULL)
	    {	/* file already exist ... - popup appropriate dialog */
		fclose(fout);
		XtUnmanageChild (w);

		show_overwrite_question(win, save_as_filename);
	    }
	    else
	    {   /* save as .... */
		/* free the old file name memory */
		if (win->filename != NULL) { XtFree(win->filename); win->filename = NULL; }
		win->filename = save_as_filename;	/* use this name */
			save_as_filename = NULL;
		/* setting a new title of the main window and the icon name.
		   They include the new name of the file */
		set_titles_mwindow_icon(win, win->filename);

		if(!SaveFile(win))
		{	/* generate error message that file can't be saved */
		    strcpy(work, (char *)lstr.fm_unable_to_save);
		    strcat(work, win->filename);
		    XtUnmanageChild (w);
		    show_error_message(win, work);
		}
		else XtUnmanageChild(w);
	    }
	    break;

	case DIALOG_INSERT:
	    {
		char * file_string=NULL;     /* Contents of file.      */
		char * filename = NULL;
   		Boolean         read_only;           /* shows the file read only status */
 		XmFileSelectionBoxCallbackStruct *fcb =
                         (XmFileSelectionBoxCallbackStruct *) call_data;

                /* get the filename from the file selection box */
                XmStringGetLtoR(fcb->value, charset, &filename);
		if( (file_string = ReadFile(filename, &read_only)) != (char *)NULL)
		{
		    XmTextPosition cursorPos;	/* insert in the current position */
		    XtSetArg(al[0], XmNcursorPosition, &cursorPos);
           	    XtGetValues(win->edit_text, al, 1);
		    /* insert new text */
                    XmTextReplace(win->edit_text, cursorPos, cursorPos, file_string);
		
		    XtUnmanageChild(w);
		    XtFree(file_string);
		}
		else
		{
		    strcpy(work,lstr.fm_unable_to_open);
                    strcat(work, filename);
                    /**XtUnmanageChild (w);  give him/her another chance (DO NOT unmanage).... */
                    show_error_message(win, work);
		}

	    }
	    break;


	case QUESTION_OVERWRITE:
	    /* overwrite the existing file ... */
	    /* free the old file name memory */
	    if (win->filename != NULL) { XtFree(win->filename); win->filename = NULL; }
	    win->filename = save_as_filename;	/* use this name */
	    save_as_filename = NULL;        /* set to NULL in order
					not to free memory allocated
					for save_as_filename (now it
					is used by filename !) */
	    /* setting a new title of the main window and the icon name.
	       They include the new name of the file */
	    set_titles_mwindow_icon(win, win->filename);

	    if(!SaveFile(win))
	    {	/* generate error message that file can't be saved */
		strcpy(work, (char *)lstr.fm_unable_to_save);
		strcat(work, win->filename);
		XtUnmanageChild (w);
		show_error_message(win, work);
	    }
	    else XtUnmanageChild (w);
	    break;

	case DIALOG_PRINT_NEW:
	    {   /* grouping brackets to use local *scb */
		XmSelectionBoxCallbackStruct *scb =
			 (XmSelectionBoxCallbackStruct *) call_data;
  		Boolean print_ok = True;
		char *print_cmd=NULL;
		char *text_string=NULL;		/* text to be printed */

		/* get the print commnad string from the selection box */
		XmStringGetLtoR(scb->value, charset, &print_cmd);
		if(print_cmd != NULL && strlen(print_cmd))
		{
		    if(win->print_complete_toggle!= NULL)	/* safety check */
		    {
			if(XmToggleButtonGetState(win->print_complete_toggle))
			{
			    /* get the text of the whole file */
			    text_string = (char *)XmTextGetString(win->edit_text);
			}
			else
			{
			    /* get the selection only */
			    text_string = XmTextGetSelection(win->edit_text);
			    if(text_string == NULL)
		            {
				/* popup the error message about non-existent selection */
                    		sprintf(work, "%s",  (char *)lstr.fm_no_selection);
                    		show_error_message(win, work);
				if(print_cmd) XtFree(print_cmd);
				break;
			    }
			}
			print_ok = PrintString(text_string, print_cmd);
			if(text_string) XtFree(text_string);   /* free allocated memory */
			if(print_cmd)   XtFree(print_cmd);

		    }
		    XtUnmanageChild(w);		/* pop-down the dialog */
		    if(!print_ok)  show_error_message(win, (char *)lstr.fm_print_failed);
		}
		else
		{
		    /* popup the error message about empty print command string */
		    sprintf(work, "%s", (char *)lstr.fm_no_printer);
		    show_error_message(win, work);
		}
	    }
	    break;


	case DIALOG_FIND_OR_CHANGE:
	    /* there may be two reasons for this callback:
	       one comes from find option and the second from change
	       option; therefore we treat them separately */

	    if(win->search_string) { XtFree(win->search_string); win->search_string=NULL; }
	    /* get the search string */
	    win->search_string = (char *)XmTextGetString(win->text_to_find);
	    {   /* grouping brackets to use local *scb */
		XmSelectionBoxCallbackStruct *scb =
			 (XmSelectionBoxCallbackStruct *) call_data;

		/* set the timestamp needed to set selection (it is
		   needed for the Search option as well ) */
		win->timestamp_search_request = scb->event->xkey.time;
	    }

	    /* let's set the search again button to sensitive no matter (!)
	       if the search or change actions happened */
	    if(win->search_string != NULL)
		XtSetSensitive(win->menu_find_again_button,   True);

	    if(win->search_reason == MENU_FIND)   /* find operation */
	    {
		find_string(win);
	    }
	    else
	    {	/* find & confirm change operation */
		if(win->new_string)  { XtFree(win->new_string);  win->new_string=NULL; }
		win->new_string = (char *)XmTextGetString(win->new_text);
		find_string(win);
		/* if the string was found prompt up the change prompt */
		if(win->found_string_start_pos >= 0L ) show_change_prompt(win);
	    }
	    break;

	case DIALOG_GOTOLINE:
	    {   /* grouping brackets to use local *scb */
		XmSelectionBoxCallbackStruct *scb =
			 (XmSelectionBoxCallbackStruct *) call_data;
		long line_no, position, found_lines;
		String text_buffer;
		Arg    al[2];
		char   *line_string=NULL;

		/* get the line number string from the gotoline prompt box */
		XmStringGetLtoR(scb->value, charset, &line_string);

		line_no = atol(line_string);	/* convert the string into the line number */
		/* free the memory allocated for line_string, because it is no longer needed */
		XtFree(line_string);

		/* get the address of the internally stored text */
		XtSetArg(al[0], XmNvalue, &text_buffer);
		XtGetValues(win->edit_text, al, 1);

		/* find a position of the line in the text widget buffer;
		     if the position is < 0 the line has not been found,
		     therefore pop up appriopriate dialog;
		     if position >= 0 OK go there ... */
		position = find_line_pos(line_no, text_buffer, &found_lines);

#ifndef	GET_TEXT_VALUE_BUG_FIXED
		/* There is a misdesign in the current implementation of the Text
		   widget. A method of obtaining XmNvalue by calling XtGetValues()
		   or XtVaGetValues() (in the appropriate way) should return
		   a pointer to internal data stored in the Text widget. In reality
		   the Text widget responds by allocating memory and returning
		   a copy of the text just like XmTextGetString(). Currently
		   this data MUST be freed after use (otherwise we get memory
		   leakage!). If that design misfeature is fixed in a feature
		   release of the Motif toolkit we should define
				GET_TEXT_VALUE_BUG_FIXED
		   in the Imakefile/Makefile/source or get rid of appropriate
		   "ifndef's" altogether ! (they appears in 2 files: asedit.c
		   and undo.c).
		*/
		XtFree(text_buffer);
#endif	/* GET_TEXT_VALUE_BUG_FIXED */
		if(position >= 0L)
		{
		    XtSetArg(al[0], XmNcursorPosition, position);
		    XtSetValues(win->edit_text, al, 1);

		    /* display the line & column numbers (column = 1) */
		    win->line = line_no;	/* global value of line & column */
		    win->column = 1;
		    win->column_ntab = 1;
		    write_lw(win->line_number,   charset, "%-5ld", win->line);
		    write_lw(win->column_number, charset, "1   ");

		}
		else
		{
		    sprintf(work,
			 "%s\n               1 - %ld",
			 (char *)lstr.sm_line_range,found_lines);
		    show_error_message(win, work);
		}
	    }
	    break;

	case DIALOG_CHANGE_PROMPT:
	    /* the first and last position of the string to change
	       has been set already so just use them ... */
	    XmTextReplace(win->edit_text, win->found_string_start_pos, win->found_string_end_pos, win->new_string);

	    /**  there is a very strange bug/behauviour (?)  of text widget
	      (Motif 1.0, Motif 1.1 ...?) that appears when I use
	      replace during the backward search: when the new text is longer
	      than the previous one the cursor position internally seems to
	      be greater then it should be for that difference; when we activate
	      the text widget then everything is O.K. but when we go straight
	      to further search that difference exists!! (and it may cause
	      annoyance in case when you change for example 'test' into 'tests';
	      this will cause 1 position difference in a new search and this is
	      enough to spoil it - the word test will be found again and again,
	      as long as we answer OK to replace !!! & and changed to testsss... )
	      (a starting position for a search is found as a current cursor
	      position !)
	      It seems to be OK (finally) since version 1.1.4 !!!
	    ***/

	    /* now the find and verify should be continued .... */
	    find_string(win);
	    if(win->found_string_start_pos < 0L )
	    {
		XtUnmanageChild(w);
		/* restore the sensitivity of the buttons  */
		set_change_buttons_sensitivity(win, True);
	    }
	    break;

	case QUESTION_CONTINUE_SEARCH:
	    XtUnmanageChild(w);
	    XFlush(display);	/*  because the search options may take a long while 
				    and the cursor is timed out lets explicitly flush the display*/
	    change_all_found_strings(win, False);	/* continue the previous change
						all process (do not start a new one) */
	    break;

	default:
	    /* an unknown callback type */
	    fprintf (stderr, "Warning: in accept callback\n");
	    break;
    }
    TurnWatchCursor(False);

}   /* DialogOkCB */


/*****************************  DialogApplyCB  ******************************
**
**	Process callbacks from Dialog apply actions.
**	(often this action is equivalent to the No answer !)
*/
#ifdef _NO_PROTO
void DialogApplyCB (w, client_data, call_data)
    Widget w;
    caddr_t client_data;
    caddr_t call_data;
#else  /* ! _NO_PROTO */

void DialogApplyCB (Widget w, caddr_t client_data, caddr_t call_data)
#endif
{
    char *command;			/* command used in printing */

    int id 		    = get_id_from_asdat(client_data);
    aseditWindowStruct *win = get_win_from_asdat(client_data);


    TurnWatchCursor(True);
    switch ( id )
    {
	case DIALOG_SAVE_CHANGES:
	    /* "NO" answer: do not save the current file, simply proceed with
		the action that prompted the save_changes_dialog (first pop
		down the save changes dialog) */
	    XtUnmanageChild (w);
	    switch(win->reason_save_question)
	    {
		case MENU_CLOSE:
		    CloseFile(win);
		    break;

		case MENU_EXIT:
		    remove_asedit_win (win);
                    if(!asedit_last_window) exit (0);    /* exit this program */
		    break;

		default:
		    /* an unknown reason_save_question */
		    fprintf (stderr, "Warning: an unknown reason_save_question in cancel callback \n");
		    break;
	    }
	    break;

	case DIALOG_FIND_OR_CHANGE:
	    if(win->search_reason == MENU_CHANGE)  /* change all options */
	    {
		/* get the strings ... */
		if(win->search_string) { XtFree(win->search_string); win->search_string=NULL; }
		/* get the search string */
		win->search_string = (char *)XmTextGetString(win->text_to_find);

		if(win->new_string)  { XtFree(win->new_string);  win->new_string=NULL; }
		win->new_string = (char *)XmTextGetString(win->new_text);

		{   /* grouping brackets to use local *scb */
		    XmSelectionBoxCallbackStruct *scb =
			 (XmSelectionBoxCallbackStruct *) call_data;

		    /* set the timestamp needed to set selection (it is
		       needed for the Search option as well ) */
		    win->timestamp_search_request = scb->event->xkey.time;
		}

		  /* let's set the search again button to sensitive */
		if(win->search_string != NULL)
		    XtSetSensitive(win->menu_find_again_button,   True);


		/* we make insensitive the "Find & Verify" and "Change All" buttons
		   to show the user which dialog he should concentrate on
		   and not to confuse him */
		set_change_buttons_sensitivity(win, False);

		change_all_found_strings(win, True);

		/* the buttons sensitivity will be restored as a response
		   to a message ending the change all process **/
	    }
	    break;

	case DIALOG_CHANGE_PROMPT:
	    /* skip the replace but continue the search */
	    find_string(win);
	    if(win->found_string_start_pos < 0L )
	    {
		XtUnmanageChild(w);
		/* restore the buttons sensitivity */
		set_change_buttons_sensitivity(win, True);
	    }
	    break;

	default:
	    /* an unknown client_data was received and there is no setup to handle this */
	    fprintf (stderr, "Warning: an unknown client_data in apply callback\n");
	    break;

    }
    TurnWatchCursor(False);
} /* DialogApplyCB */


/*****************************  DialogCancelCB  *****************************
**
**	Process callbacks from Dialog cancel actions.
**
**	(because we access that procedure from inside ht_help we didn't declare
**	it as static)
*/
#ifdef _NO_PROTO
void DialogCancelCB (w, client_data, call_data)
    Widget w;
    caddr_t client_data;
    caddr_t call_data;
#else  /* ! _NO_PROTO */

void DialogCancelCB (Widget w, caddr_t client_data, caddr_t call_data)
#endif
{
    int id 		    = get_id_from_asdat(client_data);
    aseditWindowStruct *win = get_win_from_asdat(client_data);

    switch (id)
    {

	case DIALOG_OPEN:
	case DIALOG_SAVE_AS:
	case DIALOG_PRINT_NEW:
	case DIALOG_INSERT:
	case DIALOG_SAVE_CHANGES:
	case QUESTION_OVERWRITE:
	case DIALOG_FIND_OR_CHANGE:
	case DIALOG_GOTOLINE:
	case ERROR_MESSAGE:

	    /* popdown the dialog (important when autoUnmanage set to False ) **/
	    XtUnmanageChild (w);
	    break;

	case HTEXT_HELP:
	    /* unmanage specifically help_dialog widget */
	    XtUnmanageChild( help_dialog);
	    break;

	case DIALOG_CHANGE_PROMPT:
	case QUESTION_CONTINUE_SEARCH:
	case MESSAGE_SEARCH_END:	/* Close option */
	    XtUnmanageChild (w);
	    /* restore the sensitivity of the change buttons */
	    set_change_buttons_sensitivity(win, True);
	    break;

	default:
	    /* an unknown client_data was received and
	       there is no setup to handle this */
	    fprintf (stderr, "Warning: an unknown client_data in cancel callback\n");
	    break;
    }
} /* DialogCancelCB */



/* calc_lc.c - calculate line and column numbers (freeware version) !!!*/

/*****************************  calc_text_lcn  *****************************
**
**	Calculates line and column numbers in the edit_text widget.
**	(called from TextCB)
*/
#ifdef _NO_PROTO
void calc_text_lcn (w, client_data, call_data)
    Widget w;
    caddr_t client_data;
    caddr_t call_data;
#else  /* ! _NO_PROTO */

void calc_text_lcn (Widget w, caddr_t client_data, caddr_t call_data)
#endif
{

      XmTextVerifyCallbackStruct  *txt_data = (XmTextVerifyCallbackStruct *) call_data;
      long pos;			/* in Motif XmTextPosition is defined as long */
      String text_buffer;
      Arg    al[2];
      int    reason;		/* reason for the callback */
      long   extra_column, extra_line, pos_mod, extra_column_ntab;

      int id                  = get_id_from_asdat(client_data);
      aseditWindowStruct *win = get_win_from_asdat(client_data);

      /* only for version which shows line and column during editing;
	 convert the current position into line and column */

      reason = txt_data->reason;
      pos = txt_data->newInsert;

      /* for MODIFYING_TEXT_VALUE because the changes have not been done yet it
	 is better to use the startPos instead of newInsert . It is exactly
	 the same for entering information but it is more appropriate for deleting
	 information !!!!
	 Actually when we paste a text with a middle button in a place different
	 then the insert cursor using txt_data->startPos is appropriate as well !!(Jan 93)!*/

      if(reason == XmCR_MODIFYING_TEXT_VALUE)	 pos = txt_data->startPos;


      /* modifying marks ..... */
      if(win->marks_used && (reason == XmCR_MODIFYING_TEXT_VALUE))
      {
	int i, len = txt_data->text->length, del_len;

	if(len <= 0)  del_len = (int) (txt_data->endPos - txt_data->startPos); /* amount of text deleted */
	for(i=0; i < TOTAL_MARKS; i++)
	{
	    if(win->mark_set[i])
	    {
		if(win->mark_pos[i] < pos)	;	/* DO Nothing */
		else
		{
		   if(len > 0)  win->mark_pos[i] +=len;		/* text adding ... */
		   else			/* check for  text deleting ... (or just replacing with
						pending delete */
		   {
			/* now check if any data is to be  deleted  */
			if(del_len > 0)
			{
			     /* text deleting ...(or just replacing with pending delete) */
			     
			    if(win->mark_pos[i] >= (pos+del_len)) win->mark_pos[i] -= del_len;
			    else win->mark_pos[i] = pos;
			}
		    }
		}
	    }
	}
      }

      /* for the MODIFYING_TEXT_VALUE  (when the text is entered) the
	increment of the column and line number will be calculated
	on the basis what text is entered;
      */
      if(reason == XmCR_MODIFYING_TEXT_VALUE && txt_data->text->length > 0)
      {

	/* there is some extra text to enter; usually it is one character from
	   the keyboard but it may be more than one character from the paste
	   operation. Therefore call a procedure to find how many extra lines
	   and/or columns will be added (taking into accounts tab characters).

	   Before that check if a text is not being pasted with a middle
	   button under Motif 1.1.x. (in such a case
	   when a text is pasted with the middle button in a place different
	   then the current insert position in order to calculate properly
	   the new position we have to find the line and column where the
	   text actually is being pasted in !!!)
	*/
	if(txt_data->startPos != txt_data->newInsert)
	{
	    /* the text is being pasted in the place different then the current
	       line and column. Recalculate them first ...
	       (it is probably redesigned and can't happen in Motif 1.2 ...)
	    */

	    /*********
		To FINISH .... but it is not worth because this situation is
		going to be obsolete anyway & nobody have ever complained about
		that rare situation ....
		To FINISH
	    ****/
	}

	textPosToLineColumn(txt_data->text->ptr, (long)txt_data->text->length,
		 (long)txt_data->text->length, &extra_line, &extra_column,
		 &extra_column_ntab);


	if(extra_line <= 1L)	/* there was no extra line */
		{ win->column += extra_column-1 ; win->column_ntab += extra_column_ntab-1 ; }
	else			/* there were extra lines so column value is reset */
	{
		win->column      = extra_column;
		win->column_ntab = extra_column_ntab;
		win->line       += extra_line - 1;
	}

      }
      else
      {
	long buf_size;			/* size of the text buffer */

	{
	    /* get the address of the internally stored text (to be axact it returns the string, not a pointer!) */
	    XtSetArg(al[0], XmNvalue, &text_buffer);
	    XtGetValues(w, al, 1);
	    buf_size    = (long) strlen(text_buffer);
	}

	/* search from beginning */
	textPosToLineColumn(text_buffer, buf_size, pos,
			&(win->line), &(win->column), &(win->column_ntab) );

#    ifndef	GET_TEXT_VALUE_BUG_FIXED
	XtFree(text_buffer);
#    endif	/* GET_TEXT_VALUE_BUG_FIXED */

      }


#ifdef _AS_DEBUG	/* old debug from the TextCB */
	fprintf(stderr, "Position: %ld  line: %ld column: %ld\n", pos, win->line, win->column);
	fprintf(stderr, "callback el.: currInsert %ld newInsert %ld startPos %ld endPos %ld\n",
			txt_data->currInsert, txt_data->newInsert,
			txt_data->startPos,   txt_data->endPos);
	/* for modifying data print what's in the text block */
	/****  
	if(reason == XmCR_MODIFYING_TEXT_VALUE && txt_data->text != NULL)
	{
	    fprintf(stderr,"Text block length & 1st byte: %d %c", txt_data->text->length,
					txt_data->text->ptr[0]);
	}
	*****/

#endif	/* end of conditional _AS_DEBUG */


} /* calc_text_lcn */




/*****************************  TextCB  *************************************
**
**	Process callbacks from edit_text widget.
**	 i.e. modifyVerifyCallback and motionVerifyCallback
*/
#ifdef _NO_PROTO
void TextCB (w, client_data, call_data)
    Widget w;
    caddr_t client_data;
    caddr_t call_data;
#else  /* ! _NO_PROTO */

void TextCB (Widget w, caddr_t client_data, caddr_t call_data)
#endif
{

    XmTextVerifyCallbackStruct  *txt_data = (XmTextVerifyCallbackStruct *) call_data;
    int    reason;		/* reason for the callback */

    int id 		    = get_id_from_asdat(client_data);
    aseditWindowStruct *win = get_win_from_asdat(client_data);


    reason = txt_data->reason;

#ifdef _AS_DEBUG
    fprintf(stderr,"\nText: %s:\n",
		reason == XmCR_MODIFYING_TEXT_VALUE ? "MODIFYING_TEXT_VALUE" :
		reason == XmCR_MOVING_INSERT_CURSOR ? "MOVING_INSERT_CURSOR" :
		reason == XmCR_FOCUS		    ? "FOCUS" : "unknown"
		);
#endif


    if(reason !=  XmCR_FOCUS && w != win->edit_text) return;

    switch(reason)
    {
	case XmCR_FOCUS:
	   win->edit_text = w;
	   return;

	case XmCR_MODIFYING_TEXT_VALUE:
	    /* check if this is a first MODIFYING call after loading a file;
               if so don't do anything (especially don't calculate the line
		and column i.e. RETURN after settin the appropriate flag
	        to False !!
     	    */
	    if(win->file_just_loaded)
	    {
		win->file_just_loaded = False;
		win->line = win->column = 1;
    		if(win->status_line_on)     /* write the line & column  */
    		{
      			write_lw(win->line_number,   charset, "%-5ld", win->line);
      			write_lw(win->column_number, charset, "%-4ld", win->column);
    		}

		return;
     	    }
	    /* increase the changes_counter to indicate that the file has been modified
	       and the user should be notified before loading a new one, closing
	       this one, exiting from the program etc.. */
	    if(!win->do_undo_redo_action)
	    {
		if(win->changes_counter < 0L) win->changes_counter = 0L;
		(win->changes_counter) ++;
		if(win->changes_counter == 1L)	/* show asterisk changes_status widget */
			write_lw(win->changes_status, charset, "*");

	    }

	    break;

	case XmCR_MOVING_INSERT_CURSOR:
	    break;

	default:
	    /* an unknown client_data was received and there is no setup to handle this */
	    fprintf(stderr, "Warning: an unknown client_data in text callback\n");
	    fprintf(stderr,"Detected reason = %d \n", reason);
	    return;
    }


    if(!win->do_undo_redo_action)
	SaveActionForUndo( w, client_data, call_data);  /* save the action for undo */
    win->do_undo_redo_action = False;


    if(win->status_line_on)	/* calculate line & column only when they are shown */
    {
      /* for Motif 1.2 we get ususally modify/moving callbacks for each
	 text modifications (the initial file loading case was already
	 resolved); so don't waste time and call the line
	 calculations only with moving callbacks
      */

      if(XmVersion >= 1002 && reason == XmCR_MODIFYING_TEXT_VALUE) return;

      calc_text_lcn (w, client_data, call_data); /* calculate line & column */

      write_lw(win->line_number,   charset, "%-5ld", win->line);
      write_lw(win->column_number, charset, "%-4ld", win->column);
    }

} /* TextCB*/


/*****************************  CreateMenus  *********************************
**
**		Create all menus as children of a MenuBar
**		Returns the MenuBar
*/
#ifdef _NO_PROTO
static Widget CreateMenus (win, parent)
	aseditWindowStruct *win;
	Widget parent;
#else  /* ! _NO_PROTO */

static Widget CreateMenus (aseditWindowStruct *win, Widget parent)
#endif
{
	Widget		menu_bar;	/*  RowColumn	 		*/
	Widget		help_button;	/*  cascade help button		*/

	Arg		al[10];		/*  arg list			*/
	register int	ac;		/*  arg count			*/
	Pixel		background;	/* used for proper set up of mono screens */
	Pixel		foreground;
	int		i;



	/*  Create and manage a menu bar (menu area). */
	menu_bar = XmCreateMenuBar(parent, "menu_bar", NULL, 0);

	/* Create the menu from the description */

	as_create_menuh(NULL, menu_bar, Main_menu,
			 XtNumber(Main_menu), charset);

	XtManageChild(menu_bar);

	/* setting the global widgets (they must be accessible from other
	   procedures) to widgets created in the as_create_menuh procedure */
	/*****  watch out to set these properly !!!!! (it's an ugly hack ...) */

	win->menu_undo_button  = Edit_menu[0].w;
	win->menu_redo_button  = Edit_menu[1].w;
	/*                            2  - separator in the menu */
	win->menu_cut_button   = Edit_menu[3].w;
	win->menu_copy_button  = Edit_menu[4].w;
	win->menu_paste_button = Edit_menu[5].w;
	/* 			      6  - separator ... */
	win->menu_clear_button = Edit_menu[7].w;

	win->menu_close_button  = File_menu[2].w;
	win->menu_save_button   = File_menu[3].w;
	win->menu_save_as_button= File_menu[4].w;
	/*				    5    - separator */
	win->menu_insert_button  =File_menu[6].w;
	win->menu_print_button  = File_menu[7].w;

	win->menu_find_button  	    =	Search_menu[0].w;
	win->menu_find_again_button = 	Search_menu[1].w;
	win->menu_replace_button    =	Search_menu[2].w;
	win->menu_gotoline_button   = 	Search_menu[3].w;
	/*				            4    - separator */
	win->menu_mark_button   = 	Search_menu[5].w;


	/* store the bookmarks buttons */
	for(i=0; i < TOTAL_MARKS; i++)
        {
	    win->menu_mark_set_button[i] =  Mark_menu_set[i].w;
	    win->menu_mark_go_button[i] =   Mark_menu_go[i].w; 
	}
	ResetAllMarks(win);

	/* turn off sensitivity of undo, redo, cut, copy, paste and clear buttons */
	XtSetSensitive(win->menu_undo_button,  False);
	XtSetSensitive(win->menu_redo_button,  False);
	XtSetSensitive(win->menu_cut_button,   False);
	XtSetSensitive(win->menu_copy_button,  False);
	XtSetSensitive(win->menu_paste_button, False);
	XtSetSensitive(win->menu_clear_button, False);

	/* set appropriate file buttons to insensitive */
	XtSetSensitive(win->menu_close_button,   False);
	XtSetSensitive(win->menu_save_button,    False);
	XtSetSensitive(win->menu_save_as_button, False);
	XtSetSensitive(win->menu_insert_button,  False);
	XtSetSensitive(win->menu_print_button,   False);

	/* set all search buttons to insensitive */
	XtSetSensitive(win->menu_find_button,         False);
	XtSetSensitive(win->menu_replace_button,      False);
	XtSetSensitive(win->menu_find_again_button,   False);
	XtSetSensitive(win->menu_gotoline_button,     False);
	XtSetSensitive(win->menu_mark_button,         False);


	/* get a colour to be used for editable text widgets; the colour
	   will be the same as a colour of an armed button */
	ac = 0;
	XtSetArg(al[ac],  XmNbackground, &background);          ac++;
	XtSetArg(al[ac],  XmNforeground, &foreground);          ac++;
	XtSetArg(al[ac],  XmNarmColor, &select_menu_background); 	ac++;
	XtGetValues(win->menu_find_button, al, ac);
	/* now check if the select_menu_background is not by chance identical
	   with the background (it happens on mono screens or for a black/white
	   setup); if so do not apply it, but use the standard background.
	 */
	if(select_menu_background == foreground)
		select_menu_background = background;



	/* create the Help button and help pulldown menu using a predefined
	   structure and my procedure */

	as_create_menuh(NULL, menu_bar, help_Main_menu,
			 XtNumber(help_Main_menu), charset);

	/* setting the help cascade button */
	help_button   = help_Main_menu[0].w;

	ac = 0;
	XtSetArg (al[ac], XmNmenuHelpWidget, help_button);  ac++;
	XtSetValues (menu_bar, al, ac);


	/* create a hypertext help dialog */
        /* we create just one help_dialog common for all windows ..... (asedit 1.2 upwards)
           see the addition in the main program !!!
	   ac=0;
	   win->help_dialog =  CreateHyperTextHelp(menu_bar, "help window", al, ac);
        ***/

	return (menu_bar);
} /* CreateMenus */


#ifdef _NO_PROTO
void FinalCleanupCB(w, client_data, call_data)
    Widget   w;
    caddr_t  client_data, call_data;
#else  /* ! _NO_PROTO */

void FinalCleanupCB(Widget w, caddr_t client_data, caddr_t call_data)
#endif
{
    int id                  = get_id_from_asdat(client_data);
    aseditWindowStruct *win = get_win_from_asdat(client_data);

    if (win->changes_counter != 0L) /* display the 'save' message dialog */
    {
	show_save_changes_dialog(win);
	win->reason_save_question = MENU_EXIT;
    }
    else
    {
	CloseFile(win); 		/* close up the file */
	remove_asedit_win (win);
	if(!asedit_last_window)
	{
	    XCloseDisplay(display);
	    exit (0);    		/* exit this program */
	}
    }

}   /* FinalCleanupCB */


/*
 * ByeBye - clean up and exit.
 */
#ifdef _NO_PROTO
void ByeBye()
#else  /* ! _NO_PROTO */

void ByeBye(void)
#endif
{
  	/* exit if there is no files open */
  	/*** NOT FINISHED properly; for the time being ByeBye (called from the interupt handler)
          cares only for the last window; a strategy to save (by default) all edited
	  files should be devised
  	***/
	aseditWindowStruct *win = asedit_last_window;

	if (win->changes_counter != 0L) /* display the 'save' message dialog */
	{
	   show_save_changes_dialog(win);
	   win->reason_save_question = MENU_EXIT;
	}
	else
	{
 	   CloseFile(win); /* close up the file */
	   XtUnmapWidget(toplevel);
	   XCloseDisplay(display);
	   exit (0);    /* exit this program */
	}
} /* ByeBye */


#include <X11/cursorfont.h>

/****************************	TurnWatchCursor	*****************************
  TurnWatchCursor turns on/off the "watch" cursor over the application
  to provide feedback for the user that he is going to be waiting
  a while before he can intercat with the application again.
*/
#ifdef _NO_PROTO
void TurnWatchCursor(turn_on)
    Boolean turn_on;
#else  /* ! _NO_PROTO */

void TurnWatchCursor(Boolean turn_on)
#endif
{
    static int locked;
    static Cursor cursor;
    XSetWindowAttributes attrs;
    XEvent	event;
    aseditWindowStruct *wc=NULL;    /* current window */

    /* "locked" keeps track if we've already called the function.
       This allows recursion and is necessary for most situations;
    */
    turn_on ? locked++ : locked--;
    if(locked > 1 || ( locked ==1 && turn_on == False ))
		return;		/* already locked and we're not unlocking */

    if(!cursor)		/* if not initialized do it */
	cursor = XCreateFontCursor(display, XC_watch);
    /* if "turn_on" is true, then turn on watch cursor, otherwise, return
       the shell's cursor to normal
    */
    attrs.cursor = turn_on ? cursor : None;
    /* change the main application shell's cursor to the timeout cursor
       (or reset it to normal). Do the same to all other shells except those
       created as XmDIALOG_APPLICATION_MODAL (the last can't be active
       during such activities that needs setting timeout for the cursor)
    */

    /* DO that for all asedit windows .... */
    wc = asedit_last_window;            /* start from the last */

    if(wc == NULL)  return;             /* sanity check */

    if( (help_dialog) && XtIsRealized(help_dialog))		/* global widget */
	XChangeWindowAttributes(display, XtWindow(help_dialog), CWCursor, &attrs);

    do          /* loop until there is no previous window */
    {
	if(XtIsRealized(wc->topshell))	/* a widget must be realized to have its window */
	    XChangeWindowAttributes(display, XtWindow(wc->topshell), CWCursor, &attrs);

	if( (wc->open_dialog) && XtIsRealized(wc->open_dialog))
	    XChangeWindowAttributes(display, XtWindow(wc->open_dialog), CWCursor, &attrs);
	if( (wc->save_as_dialog) && XtIsRealized(wc->save_as_dialog))
	    XChangeWindowAttributes(display, XtWindow(wc->save_as_dialog), CWCursor, &attrs);
	if( (wc->print_dialog) && XtIsRealized(wc->print_dialog))
	    XChangeWindowAttributes(display, XtWindow(wc->print_dialog), CWCursor, &attrs);
	if( (wc->insert_dialog) && XtIsRealized(wc->insert_dialog))
	    XChangeWindowAttributes(display, XtWindow(wc->insert_dialog), CWCursor, &attrs);
	if( (wc->gotoline_dialog) && XtIsRealized(wc->gotoline_dialog))
	    XChangeWindowAttributes(display, XtWindow(wc->gotoline_dialog), CWCursor, &attrs);
	if( (wc->replace_dialog) && XtIsRealized(wc->replace_dialog))
	    XChangeWindowAttributes(display, XtWindow(wc->replace_dialog), CWCursor, &attrs);
	if( (wc->about_program_message) && XtIsRealized(wc->about_program_message))
	    XChangeWindowAttributes(display, XtWindow(wc->about_program_message), CWCursor, &attrs);

    	XFlush(display);
    
	wc   = wc->prev;

    } while(wc);

    if(turn_on)
    {	/* we are timing out - in some cases that's the place to put up a
	   a working_dialog to show explicite to the user that he has to wait ...
	*/
	;
    }
    else
    {
	/* get rid of all button and keyboard events that occured during the
	   time out. The user shouldn't have done anything during this time,
	   so flush for button and keypress events. HeyRelease events are not
	   discarded because accelerators require the corresponding release
	   event before normal input can continue.
	*/
	while (XCheckMaskEvent(display, ButtonPressMask | ButtonReleaseMask |
		ButtonMotionMask | PointerMotionMask | KeyPressMask, &event))
	{
		/* do nothing */
	}
	/* if you used a working_dialog you should destroy it now ... */
    }
}   /* TurnWatchCursor */



#ifdef _NO_PROTO
static void set_paste_buttons()
#else  /* ! _NO_PROTO */

static void set_paste_buttons()
#endif
{
    aseditWindowStruct *wc=NULL;    /* current window */

    /* DO that for all asedit windows .... */
    wc = asedit_last_window;            /* start from the last */

    if(wc == NULL)  return;             /* sanity check */

    do          /* loop until there is no previous window */
    {
        /* for read only files && for empty windows the paste button is insensitive */
    	if(!wc->file_read_only && (wc->filename!=NULL)) XtSetSensitive(wc->menu_paste_button, True);
        wc   = wc->prev;
    } while(wc);

}

/**************************     find_win_for_edit_text  ************************
 finds asedit win structure for the given edit_text windget (a win element)
*/
#ifdef _NO_PROTO
static aseditWindowStruct * find_win_for_edit_text(edit_text)
    Widget edit_text;
#else  /* ! _NO_PROTO */

static aseditWindowStruct * find_win_for_edit_text(Widget edit_text)
#endif
{
    aseditWindowStruct *wc=NULL;    /* current window */

    /* DO that for all asedit windows .... */
    wc = asedit_last_window;            /* start from the last */

    if(wc == NULL)  return(wc);             /* sanity check */

    do          /* loop until there is no previous window */
    {
        if( wc->edit_text == edit_text) break;  /* FOUND */

        wc   = wc->prev;

    } while(wc);

    /* if not found, returns NULL */

    return(wc);

}   /* find_win_for_edit_text */


#ifdef _NO_PROTO
static void asedit_find(w, event, params, num_params)
    Widget w;
    XEvent *event;
    char **params;
    Cardinal *num_params;
#else  /* _NO_PROTO */

static void asedit_find(Widget w, XEvent *event, char **params, Cardinal *num_params)
#endif
{

    aseditWindowStruct *win =  find_win_for_edit_text(w);

    TurnWatchCursor(True);
    if(win)     /* sanity check */
    {
        /* set the reason for managing replace_dialog */
        win->search_reason = MENU_FIND;
	show_replace_dialog(win);
    }
    TurnWatchCursor(False);

}   /* asedit_find */


#ifdef _NO_PROTO
static void asedit_change(w, event, params, num_params)
    Widget w;
    XEvent *event;
    char **params;
    Cardinal *num_params;
#else  /* _NO_PROTO */

static void asedit_change(Widget w, XEvent *event, char **params, Cardinal *num_params)
#endif
{
    aseditWindowStruct *win =  find_win_for_edit_text(w);

    TurnWatchCursor(True);
    if(win)     /* sanity check */
    {
	/* set the reason for managing replace_dialog */
	win->search_reason = MENU_CHANGE;
	show_replace_dialog(win);
    }
    TurnWatchCursor(False);

}   /* asedit_change */


#ifdef _NO_PROTO
static void asedit_mark_set(w, event, params, num_params)
    Widget w;
    XEvent *event;
    char **params;
    Cardinal *num_params;
#else  /* _NO_PROTO */

static void asedit_mark_set(Widget w, XEvent *event, char **params, Cardinal *num_params)
#endif
{

    aseditWindowStruct *win =  find_win_for_edit_text(w);
    int         mark=0;

    if(win && num_params)     /* sanity check */
    {
        
        mark = (int) atol(params[0]);
        if(mark >= 0 && mark < TOTAL_MARKS)     /* sanity check */
        {
	    XmTextPosition pos;
    	    Arg al[1];                 /* arg list                 */

            /* get the value of the cursor position */
            XtSetArg(al[0], XmNcursorPosition, &pos);
            XtGetValues(win->edit_text, al, 1);
	    win->mark_pos[mark] = pos;
	    win->mark_set[mark] = True;
            win->marks_used     = True;
            XtSetSensitive( win->menu_mark_go_button[mark], True);
        }
    }

}   /* asedit_mark_set */


#ifdef _NO_PROTO
static void asedit_mark_goto(w, event, params, num_params)
    Widget w;
    XEvent *event;
    char **params;
    Cardinal *num_params;
#else  /* _NO_PROTO */
static void asedit_mark_goto(Widget w, XEvent *event, char **params, Cardinal *num_params)
#endif
{

    aseditWindowStruct *win =  find_win_for_edit_text(w);
    int 	mark=0;

    if(win && win->marks_used && num_params)     /* sanity check */
    {
	
	mark = (int) atol(params[0]);
	if(mark >= 0 && mark < TOTAL_MARKS)	/* sanity check */
	{
	    if(win->mark_set[mark]) XmTextSetCursorPosition(win->edit_text, win->mark_pos[mark]);
	}
    }

}   /* asedit_mark_goto */


/****************************  PrintString  **********************************
	PrintString  - prints a text pointed to by *text_string using *print_command
	(If successful returns True.)
*/
#ifdef _NO_PROTO
Boolean PrintString(text_string, print_command)
    char *text_string;
    char *print_command;
#else  /* _NO_PROTO */

Boolean PrintString(char *text_string, char *print_command)
#endif
{
    FILE *tfp;                          /* Pointer to a temporary file. */
    char work[256];
    Boolean result=True;
    int status;
    char system_call_buf[BUFSIZ];
    char *tempname;     /* Temporary file name .*/

    /* Note: errors here related to file operations shouldn't really happen, so
       just to simplify we leave them in English and write them out on stderr
       (they might happen when the temp dir is full, tmpDir (X) or TEMPDIR is set
        incorrectly etc.)
    */

    if(text_string == NULL || print_command == NULL) return(False);

    tempname = make_tmpnam();   /* use tmpnam function and consider tmpDir X resource
                                   or TMPDIR environmental variable (if set) */

    if ((tfp = fopen(tempname, "w")) == NULL) {
       fprintf(stderr, "Warning: unable to open temp file '%s', text not printed.\n", tempname);
       XtFree(tempname);
       return(False);
    }
    /* write to a temp file */
    fwrite(text_string, sizeof(char), strlen(text_string) , tfp);

    /* flush and close the file */
    if (fflush(tfp) != NULL)
        { result=False;  fprintf(stderr,"Warning: unable to flush temp file '%s'.\n", tempname); }
    if (fclose(tfp) != NULL)
        { result=False;  fprintf(stderr,"Warning: unable to close temp file '%s'.\n", tempname); }

    if(!result) { unlink(tempname); XtFree(tempname); return(result); }

    sprintf(work, "cat %s | %s", tempname, print_command);
    if (system(work) != NULL)  result=False;

    unlink (tempname);
    XtFree (tempname);

    return(result);

}   /* PrintString */






