#ifndef lint
static char sccsid[] = "@(#)popup.c	2.2 8/12/88";
#endif

/*
 *	popup - pop up error dialog windows
 */


#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/notice.h>
#include <stdio.h>


#define X_GAP		25
#define Y_GAP		30

#define MAX(a,b)	(((a)>(b))?(a):(b))
#define MIN(a,b)	(((a)<(b))?(a):(b))


/* ---------------------------- Imports -------------------------------- */

/* extern char		*sprintf (); */

static
do_pop (frame, s, show_cancel)
	Frame	frame;
	char	*s;
	int	show_cancel;
{
	int	answer;

	if ( show_cancel )
	  answer = notice_prompt(frame, NULL,
							 NOTICE_MESSAGE_STRINGS, s, NULL,
							 NOTICE_BUTTON_YES, "   OK   ",
							 NOTICE_BUTTON_NO,  " Cancel ",
							 NULL);
	else
	  answer = notice_prompt(frame, NULL,
							 NOTICE_MESSAGE_STRINGS, s, NULL,
							 NOTICE_BUTTON_YES, "   OK   ",
							 NULL);
	  
	return (answer == NOTICE_YES ? 1 : 0);
}


/*
 *	Glue routine for a confirmer dialog box.  The first argument is
 *	the frame relative to which the dialog window is displayed.  The
 *	remaining arguments are a format string and generic args for
 *	the sprintf call.  The flag is passed to the dialog frame creation
 *	routine which indicates that both the OK and CANCEL buttons are
 *	to be displayed.
 */

/*VARARGS2*/
pop_confirm (frame, s, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9)
	Frame	frame;
	char	*s;
	long	a0, a1, a2, a3, a4, a5, a6, a7, a8, a9;
{
	char	temp [512];

	(void) sprintf (temp, s, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9);
	return (do_pop (frame, temp, TRUE));
}


/*
 *	Glue routine for a simple info popup frame.  Only the OK button is
 *	displayed and the frame waits until it is clicked.
 */

/*VARARGS2*/
pop_msg (frame, s, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9)
	Frame	frame;
	char	*s;
	long	a0, a1, a2, a3, a4, a5, a6, a7, a8, a9;
{
	char	temp [512];

	(void) sprintf (temp, s, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9);
	return (do_pop (frame, temp, FALSE));
}

