#ifndef lint
static char sccsid[] = "@(#)panel.c	2.3 8/16/88";
#endif

/*
 *	Stuff dealing with the panel
 */

/*
 * -------------------------------------------------------------------------
 *	ROLO - A Sun Tool to implement a Rolodex-style list of notes
 *
 *	This code manipulates "cards" in a visual manner approximating
 *	a rolodex file.  All the cards are stored in one real file, the
 *	cards are seperated by a ^L (form-feed).  The default path
 *	name is $HOME/.rolo.  A different pathname may be specified at
 *	startup on the command line.  The pathname is relative to the
 *	user's home directory.
 *
 *	Due to bugs in the 3.0 distribution, especially with text subwindows,
 *	this code is only guaranteed to compile and run properly with 3.2
 *	or greater.
 *
 *	This code is public domain, anyone and everyone is welcome to it.
 *	All I ask is that my name and this notice remain on it.  If Sun would
 *	like to bundle it with their product they are welcome to do so,
 *	I only ask that the sources be included in the binary distribution.
 *
 *	Please return any fixes, improvements, gripes, etc to me.
 *
 *	Ron Hitchens		ronbo@vixen.uucp
 *	March 1987 (V1.0)	hitchens@cs.utexas.edu
 *	August 1988 (V2.0)
 * -------------------------------------------------------------------------
 */


#include <stdio.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/textsw.h>
#include <xview/seln.h>
#include <sys/param.h>
#include <ctype.h>

#include "defs.h"
#include "help.h"



/* ------------------------------ Exports ---------------------------------- */

void			show_card (), set_slider_max ();

Notify_value		rolo_destroy(), catch_resize();


/* ------------------------------ Imports ---------------------------------- */

extern Textsw		rolocard;

extern struct card	*first, *last, *current;

extern int		need_save;

extern char		*rolofile;

extern struct card	*make_card (), *insert_card (), *undelete_card (),
			*pop_card ();

extern Menu		gen_undelete (), gen_undelete_before();

extern Menu_item	check_stack ();

extern void		delete_card (), dispose_card (),
			push_card (), dump_rolo (),
			nuke_active_cards (), init_rolo (),
			sort_cards (), set_stripe (),
			read_rolo (), write_rolo ();

extern char		*first_char (), *index (), *re_comp (), *strcpy (),
			*strncpy (), *strcat (),/*  *sprintf (),*/ *getenv ();

extern caddr_t		undel_menu_card ();


/* ------------------------------ Locals ----------------------------------- */

static Panel_item	regex_item, slider_item;

static int		panel_height, panel_width;

static int		mask_from_menu_value (), value_from_mask (),
			filename_ok ();

static void		next_button (), next_button_next(),  next_button_S_next(),
  prev_button (), prev_button_prev(), prev_button_S_prev(),
  new_button (), new_card_after(), new_card_before(),
  delete_button (), delete_button_delete(), delete_button_undelete(),
  delete_button_undelete_before(), 
  file_button (), file_button_save(), file_button_reload(), file_button_sort(),
  file_button_sort_backwards(), file_button_load(),
  file_button_save_to_file(),

  done_button (), done_n_save(), done_n_save_exit(), done_n_exit(),
  find_button (), find_button_forward(), find_button_reverse(),

list_button (), help_button (),
  slider_proc (), button_event(), goto_card (),
  no_comprendo ();

static char		*get_selection ();


/* prev new next delete */
static u_short		buttons1_image [] = {
#include "buttons1.icon"
};

/* drawer (file), "?" (help), flag (finished) and list */
static u_short		buttons2_image [] = {
#include "buttons2.icon"
};

#undef pr_region
Server_image pr_region(i_image, i_w, x, y, w, h)
char *i_image;
{
	int i;
	int wb = w/8;
	int xb = x/8;
    int i_wb = i_w/8;
	char *image          = (char *)malloc(h*wb);
	Server_image retval;

	/* build the image */
	for( i = 0; i < h; i++ ) {
		bcopy(i_image + y*i_wb + xb + i*i_wb, image + i*wb, wb);
	}
	
	retval = (Server_image)xv_create(NULL, SERVER_IMAGE, 
									 XV_WIDTH, 32,
									 XV_HEIGHT, 32,
									 SERVER_IMAGE_BITS, image,
									 NULL
									 );

	return(retval);
}


/* ------------------------------------------------------------------------- */



/*
 *	Actually create the panel subwindow and all the items in it.
 */
static Panel	panel;
static Frame    frame;
Panel init_panel (_frame)
	Frame	_frame;
{
	int	panel_columns;
	Menu tmpmenu;

	frame = _frame;
	panel = xv_create (frame, PANEL,
		PANEL_LAYOUT,		PANEL_HORIZONTAL,
/*		PANEL_EVENT_PROC,	button_event, */
		PANEL_ITEM_X_GAP,	10,
		PANEL_ITEM_Y_GAP,	9,
		0);

	/* 1st row */
	/* next prev new delete list file help done */
	tmpmenu = menu_create (
						   MENU_ACTION_ITEM, "    Next Card  ", next_button_next,
						   MENU_ACTION_ITEM, "(S) Last Card  ", next_button_S_next, 
						   NULL, NULL);

	(void) xv_create (panel, PANEL_BUTTON,
		PANEL_LABEL_IMAGE,	pr_region(buttons1_image, 64, 0, 32, 32, 32),
		PANEL_ITEM_MENU,	tmpmenu,
		PANEL_NOTIFY_PROC,	next_button, 
		XV_X, xv_col(panel, 0),
        XV_Y, xv_row(panel, 0),
		0);

	tmpmenu = menu_create (
						   MENU_ACTION_ITEM,"    Previous Card", prev_button_prev,
						   MENU_ACTION_ITEM, "(S) First Card   ", prev_button_S_prev,
						   NULL, NULL);
	(void) xv_create (panel, PANEL_BUTTON,
		PANEL_LABEL_IMAGE,	pr_region(buttons1_image, 64, 0, 0, 32, 32),
		PANEL_ITEM_MENU,	tmpmenu,
		PANEL_NOTIFY_PROC,	prev_button,
		0);

	tmpmenu = menu_create (
						   MENU_ACTION_ITEM, "    New Card After this One ", new_card_after,
						   MENU_ACTION_ITEM, "(S) New Card Before this One", new_card_before,
						   NULL, NULL);
	(void) xv_create (panel, PANEL_BUTTON,
		PANEL_LABEL_IMAGE,	pr_region (buttons1_image, 64, 32, 0, 32, 32),
		PANEL_ITEM_MENU,	tmpmenu,
		PANEL_NOTIFY_PROC,	new_button,
		0);

	tmpmenu =  xv_create (NULL, MENU,
				MENU_NOTIFY_PROC, delete_button_delete,
				MENU_ITEM,
					MENU_STRING,
						"    Delete this card        ",
					MENU_VALUE,		1,
					MENU_NOTIFY_PROC, delete_button_delete,
					0,
				MENU_ITEM,
					MENU_STRING,
						"(S) UnDelete a Card (after) ",
					MENU_NOTIFY_PROC, delete_button_undelete,
					MENU_GEN_PROC,		check_stack,
					MENU_GEN_PULLRIGHT,	gen_undelete, 
					MENU_CLIENT_DATA,	FALSE,
					0,
				MENU_ITEM,
						  MENU_STRING,
						  "(C) UnDelete a Card (before)",
						  MENU_NOTIFY_PROC, delete_button_undelete_before,
						  MENU_GEN_PROC,		check_stack,
						  MENU_GEN_PULLRIGHT,	gen_undelete_before, 
						  MENU_CLIENT_DATA,	TRUE,
						  NULL,
			   NULL);

	(void) xv_create (panel, PANEL_BUTTON,
		PANEL_LABEL_IMAGE,	pr_region (buttons1_image, 64, 32, 32, 32, 32),
		PANEL_ITEM_MENU, tmpmenu,
		PANEL_NOTIFY_PROC,	delete_button,
		0);

	tmpmenu = menu_create (
						   MENU_ACTION_ITEM, "Show Index List of Cards",  list_button,
						   NULL);
	(void) xv_create (panel, PANEL_BUTTON,
		PANEL_LABEL_IMAGE,	pr_region(buttons2_image, 64, 32, 32, 32, 32),
		PANEL_ITEM_MENU,	tmpmenu,
		0);

	tmpmenu = menu_create (
						   MENU_ACTION_ITEM,
						   "      Save Cards to Disk  ",
						   file_button_save,

						   MENU_ACTION_ITEM,
						   "  (S) Reload From Disk    ",
						   file_button_reload,

						   MENU_ACTION_ITEM,
						   "  (C) Sort Cards          ",
						   file_button_sort,

						   MENU_ACTION_ITEM,
						   "(S+C) Sort Backwards      ",
						   file_button_sort_backwards,

						   MENU_ACTION_ITEM,
						   "      Load From Named File",
						   file_button_load,

						   MENU_ACTION_ITEM,
						   "      Save To Named File  ",
						   file_button_save_to_file,
						   NULL);

	(void) xv_create (panel, PANEL_BUTTON,
		PANEL_LABEL_IMAGE,	pr_region(buttons2_image, 64, 0, 0, 32, 32),
		PANEL_NOTIFY_PROC,	file_button,
		PANEL_ITEM_MENU, tmpmenu,
		0);

	tmpmenu = menu_create (
						   MENU_ACTION_ITEM, "Display Help Message", help_button, 
						   NULL);

	(void) xv_create (panel, PANEL_BUTTON,
		PANEL_LABEL_IMAGE,	pr_region(buttons2_image, 64, 32, 0, 32, 32),
		PANEL_ITEM_MENU,	tmpmenu,
		0);

	tmpmenu = menu_create (
						   MENU_ACTION_ITEM, 
						   "   Save Changes and Close  ", 
						   done_n_save,

						   MENU_ACTION_ITEM,
						   "(S) Exit Rolo, Save Changes ",
						   done_n_save_exit,
						   
						   MENU_ACTION_ITEM,
						   "(C) Exit, Don't Save Changes", 
						   done_n_exit,
						   NULL);
	(void) xv_create (panel, PANEL_BUTTON,
		PANEL_LABEL_IMAGE,	pr_region(buttons2_image, 64, 0, 32, 32, 32),
		PANEL_NOTIFY_PROC,	done_button,
		PANEL_ITEM_MENU,	tmpmenu,
		0);

	/*
	 * Tighten up the window around the buttons in the first row, this
	 * will be the width of the panel window, so we save that size for
	 * later reference.  We also ask for the width of the panel in
	 * columns for computing the width of the find pattern text item.
	 */
	window_fit_width (panel); 
	panel_width = (int) xv_get (panel, XV_WIDTH);
	panel_columns = (int) xv_get (panel, WIN_COLUMNS);

	/*
	 * Begin second row, set the inter-item gap so the Find button and
	 * the text item following it are placed nicely.
	 */
	xv_set (panel, PANEL_ITEM_X_GAP, 8, 0);

	tmpmenu = menu_create (
						   MENU_ACTION_ITEM,
						   "    Find Regular Expression, Forward",
						   find_button_forward,
						   
						   MENU_ACTION_ITEM,
						   "(S) Find Regular Expression, Reverse", 
						   find_button_reverse, 
						   NULL);

	(void) xv_create (panel, PANEL_BUTTON,
		PANEL_LABEL_STRING, "Find", 
		PANEL_ITEM_MENU,	tmpmenu, 
		PANEL_NOTIFY_PROC,	find_button,
		0);

	regex_item = xv_create (panel, PANEL_TEXT,
		PANEL_BLINK_CARET,		TRUE,
		PANEL_LABEL_STRING,		"",
		PANEL_VALUE_DISPLAY_LENGTH,	panel_columns - 10,
		PANEL_VALUE_STORED_LENGTH,	80,
		PANEL_NOTIFY_PROC,	find_button,
		0);

	/*
	 * Begin the third row, squeeze the inter-item gap back down so that
	 * the slider value is displayed close to the slider bar.
	 */
	xv_set (panel, PANEL_ITEM_X_GAP, 4, 0);

	tmpmenu = menu_create (
				MENU_ITEM,
					MENU_STRING,	"Pick a card, any card",
					MENU_VALUE,	0,
					0,
				0);

	slider_item = xv_create (panel, PANEL_SLIDER,
		PANEL_MIN_VALUE,	0,
		PANEL_MAX_VALUE,	1,
		PANEL_VALUE,		1,
		/* This slider width is temp, recomputed later */
		PANEL_SLIDER_WIDTH, 500,
		PANEL_SHOW_RANGE,	FALSE,
		PANEL_SHOW_VALUE,	TRUE,
		PANEL_NOTIFY_LEVEL,	PANEL_DONE,
		PANEL_NOTIFY_PROC,	slider_proc,
		PANEL_ITEM_MENU, tmpmenu,
		0);

	/*
	 * Adjust the position of the text item slightly for better aesthetic
	 * placement relative to the label in the Find button.  Do it after
	 * creating the slider so that the slider is placed relative to the
	 * original position of the text item, not the final position.
	 */
	xv_set (regex_item,
		XV_Y,	xv_get (regex_item, XV_Y) + 4,
		0);
	/*
	 * Tighten up the panel window in both directions around the final
	 * layout.  Save off the resulting height for later use.
	 */
	window_fit_height (panel); 
	panel_height = (int) xv_get (panel, XV_HEIGHT);

	return (panel);
}

/* ------------------------------------------------------------------------- */


/*		Panel item notification handlers		*/

/*
 *	Notification proc for the "next" button.  If the button is pressed
 *	with no shift, the card is advanced to the next one.  If pressed
 *	with the shift key, then jump to the last card.
 */

do_bozo(panel,p)
Panel panel;
struct card *p;
{
	static int	bozo = 0;	/* speak second time end is reached */
	if (p == NULL_CARD) {		/* did we step off end of the list? */ 
		if (panel == NULL || bozo != 0) {	/* have we already beeped once? */
			msg ("This is the last card");
		} else {
			window_bell (panel);
		}
		bozo = (bozo+1)&1;
		return(1);
	}
	return(0);
}

static int in_next_panel;
static void next_button_next(item, event)
Panel_item item;
Event *event;
{
	struct card	*p;
	if ( in_next_panel ) {
		in_next_panel = 0;
		return;
	}
	save_card (current);
	p = current->c_next;
	if ( !do_bozo(panel,p) )
	  show_card (p);		/* all is well, display the new card */
}

static void next_button_S_next(item, event)
Panel_item item;
Event *event;
{
	if ( in_next_panel ) {
		in_next_panel = 0;
		return;
	}
	save_card (current);
	show_card (last);		/* all is well, display the new card */
}

/*ARGSUSED*/
static
void
next_button (item, event)
	Panel_item	item;
	Event		*event;
{
	if ( event_action(event) == ACTION_MENU )
	  return;
	switch (value_from_mask (event)) {
	  case SHIFT_CLICK:		/* click plus shift (menu item 2) */
		next_button_S_next(item, event);
		break;

	  default:			/* any other shift mask (or none) */
		next_button_next(item, event);
		break;
	}
	in_next_panel = 1; 
}


/*
 *	Notification proc for the "Previous" button.  Similar to the proc
 *	above for next card.
 */
static in_prev_panel;

static void prev_button_prev(item,event)
Panel_item item;
Event *event;
{
	struct card	*p;
	if ( in_prev_panel ) {
		in_prev_panel = 0;
		return;
	}
	save_card (current);
	p = current->c_prev;	/* move backwards one card */
	if ( !do_bozo(panel,p) )
	  show_card(p);
}

static void prev_button_S_prev(item,event)
Panel_item item;
Event *event;
{
	if ( in_prev_panel ) {
		in_prev_panel = 0;
		return;
	}
	save_card (current);
	show_card (first);
}

/*ARGSUSED*/
static void prev_button (item, event)
	Panel_item	item;
	Event		*event;
{

	if ( event_action(event) == ACTION_MENU )
	  return;

	switch (value_from_mask (event)) {
	  case SHIFT_CLICK:
		prev_button_S_prev(item, event);
		break;

	default:
		prev_button_prev(item, event);
		break;
	}
	in_prev_panel = 1;
}


/*
 *	Notification for the "New Card" button.  The new card is inserted
 *	after the currently displayed card, unless the shift key is down,
 *	in which case it is inserted before the current card.
 */

static in_new_button;

static void new_card_after (item, event)
Panel_item	item;
Event		*event;
{
	struct	card	*c, *p;
	if ( in_new_button ) {
		in_new_button = 0;
		return;
	}
	save_card (current);
	c = make_card (NULL);
	if (c == NULL_CARD) {
		msg ("Can't allocate space for a new card");
		return;
	}
	p = current;			/* insert after current */
	p = insert_card (c, p);			/* insert c after p */
	need_save = TRUE;			/* Things have changed */
	set_slider_max (renumber (first));	/* update slider range */
	show_card (p);	
}

static void new_card_before(item, event)
	Panel_item	item;
	Event		*event;
{
	struct	card	*c, *p;	
	if ( in_new_button ) {
		in_new_button = 0;
		return;
	}
	save_card (current);
	c = make_card (NULL);
	if (c == NULL_CARD) {
		msg ("Can't allocate space for a new card");
		return;
	}
	p = current->c_prev;		/* c_prev may be NULL */
	p = insert_card (c, p);			/* insert c after p */
	need_save = TRUE;			/* Things have changed */
	set_slider_max (renumber (first));	/* update slider range */
	show_card (p);	
}

/*ARGSUSED*/
static void new_button (item, event)
	Panel_item	item;
	Event		*event;
{

	if ( event_action(event) == ACTION_MENU )
	  return;
	switch (value_from_mask (event)) {
	  case SHIFT_CLICK:			/* click+shift, insert before */
		new_card_before(item, event);
		break;

	  default:
		new_card_after(item, event);
		break;
	}
	in_new_button = 1;
}


/*
 *	Notification proc for the "Delete" button.  A plain click deletes
 *	the current card and pushes it on the deleted stack.  Shift and
 *	Control key modifiers undelete the card on the top of the stack.
 *	The undelete operations via the menu are special for the delete
 *	button.  Picking either undelete operation from the menu does not
 *	wind up as a call to this function.  Those operations are entirely
 *	handled by the menu code via action and gen procs.  See the menu
 *	procs in cards.c.  
 */

static int in_delete_button;
static void delete_button_delete (item, event)
Panel_item	item;
Event		*event;
{
	struct card	*p;
	if ( in_delete_button ) {
		in_delete_button = 0;
		return;
	}
	if (first == last) {
		/* if we're deleting the last card, add a dummy */
		(void) insert_card (make_card (NULL), NULL_CARD);
	}
	
	/* and the new current card will be... */
	save_card(current);
	p = (current == last) ? current->c_prev : current->c_next;
	delete_card (current);
	need_save = TRUE;
	set_slider_max( renumber(first));
	if ( !do_bozo(panel,p) )
	  show_card(p);
}

static void delete_button_undelete_before (item, event)
Panel_item	item;
Event		*event;
{
	struct card *p;
	if ( in_delete_button ) {
		in_delete_button = 0;
		return;
	}
	save_card (current);
	p = undelete_card (current->c_prev);	/* can be nil */
	need_save = TRUE;
	set_slider_max (renumber (first));
	if ( !do_bozo(panel,p) )
	  show_card(p);
}

static void delete_button_undelete (item, event)
Panel_item	item;
Event		*event;
{
	struct card *p;
	if ( in_delete_button ) {
		in_delete_button = 0;
		return;
	}
	save_card (current);
	p = undelete_card (current);
	need_save = TRUE;
	set_slider_max (renumber (first));
	if ( !do_bozo(panel,p) )
	  show_card(p);
}

/*ARGSUSED*/
static void delete_button (item, event)
Panel_item	item;
Event		*event;
{
	if ( event_action(event) == ACTION_MENU )
	  return;


	switch (value_from_mask (event)) {
	  case PLAIN_CLICK:
		delete_button_delete(item, event);
		break;

	  case SHIFT_CLICK:
		delete_button_undelete(item, event);
		break;

	  case CTRL_CLICK:
		delete_button_undelete_before(item, event);
		break;
		
	  default:
		no_comprendo (event, "delete_button");
		return;
	}
	in_delete_button = 1;
}

/*
 *	Notification proc for the "File" button.  
 */

static int in_file_button;

static void file_button_save (item, event)
Panel_item	item;
Event		*event;
{
	if ( in_file_button ) {
		in_file_button = 0;
		return;
	}
	save_card (current);
	dump_rolo (first, rolofile);
}

static void file_button_reload (item, event)
Panel_item	item;
Event		*event;
{
	if ( in_file_button ) {
		in_file_button = 0;
		return;
	}
	save_card (current);
	if ((need_save == TRUE) && (verify_no_save () == FALSE)) {
		return;
	}
	nuke_active_cards ();
	init_rolo (rolofile);
}

static void file_button_sort (item, event)
Panel_item	item;
Event		*event;
{
	if ( in_file_button ) {
		in_file_button = 0;
		return;
	}
	save_card (current);
	sort_cards (FALSE);
	need_save = TRUE;
}

static void file_button_sort_backwards (item, event)
Panel_item	item;
Event		*event;
{
	if ( in_file_button ) {
		in_file_button = 0;
		return;
	}
	save_card (current);
	sort_cards (TRUE);
	need_save = TRUE;
}

static void file_button_load (item, event)
Panel_item	item;
Event		*event;
{
	char *filename;
	if ( in_file_button ) {
		in_file_button = 0;
		return;
	}
	save_card (current);
	filename = get_selection ();
	if (filename == NULL) {
		msg ("No active selection, need a filename to load from");
		return;
	}
	if (filename_ok (filename) == FALSE) {
		return;
	}
	if ((need_save == TRUE) && (verify_no_save () == FALSE)) {
		return;
	}
	read_rolo (filename);
}

static void file_button_save_to_file (item, event)
Panel_item	item;
Event		*event;
{
	char *filename;
	if ( in_file_button ) {
		in_file_button = 0;
		return;
	}
	save_card (current);
	filename = get_selection ();
	if (filename == NULL) {
		msg ("No active selection, need a filename to save to");
		return;
	}
	if (filename_ok (filename) == FALSE) {
		return;
	}
	write_rolo (filename);
}

/*ARGSUSED*/
static void file_button (item, event)
Panel_item	item;
Event		*event;
{
	char		*filename;

	if ( event_action(event) == ACTION_MENU )
	  return;

	switch (value_from_mask (event)) {
	  case PLAIN_CLICK:			/* Plain save */
		file_button_save(item, event);
		break;

	case SHIFT_CLICK:			/* reload, no save first */
		file_button_reload(item, event);
		break;

	case CTRL_CLICK:			/* sort ascending */
		file_button_sort(item, event);
		break;

	case CTRL_SHIFT_CLICK:			/* sort descending */
		file_button_sort_backwards(item, event);
		break;

	case META_CLICK:			/* load named file */
		file_button_load(item, event);
		break;

	case META_SHIFT_CLICK:			/* store to named file */
		file_button_save_to_file(item, event);
		break;

	default:				/* say what? */
		no_comprendo (event, "file_button");
		return;
	}
	in_file_button = 1;
}


/*
 *	Notification proc for the "Done" button.  This covers both closing
 *	the tool and exiting.  (The checkered flag button is supposed to
 *	convey the idea of "finished".  Yeah, I know, you got a better idea?)
 */

static int in_done_button;
static void done_n_save (item, event)
Panel_item	item;
Event		*event;
{
	if (in_done_button) {
		in_done_button = 0;
		return;
	}
	save_card (current);
	if (need_save) {
		dump_rolo (first, rolofile);
	}
	xv_set (frame, FRAME_CLOSED, TRUE, 0);
}

static void done_n_save_exit (item, event)
Panel_item	item;
Event		*event;
{
	if (in_done_button) {
		in_done_button = 0;
		return;
	}
	save_card (current);
	if (need_save) {
		dump_rolo (first, rolofile);
	}
	xv_destroy_safe (frame);
}

static void done_n_exit (item, event)
Panel_item	item;
Event		*event;
{
	if (in_done_button) {
		in_done_button = 0;
		return;
	}
	save_card (current);
	if (need_save && (verify_no_save () == FALSE)) {
		return;
	}
	need_save = FALSE;
	xv_destroy_safe (frame);
}

static void done_button (item, event)
	Panel_item	item;
	Event		*event;
{
	if ( event_action(event) == ACTION_MENU )
	  return;

	switch (value_from_mask (event)) {
	  case SHIFT_CLICK:			/* save cards and exit */
		done_n_save_exit(item,event);
		break;

	case CTRL_CLICK:			/* don't save and exit */
		done_n_exit(item,event);
		break;

	default:				/* save and go iconic */
		done_n_save(item,event);
		return;
	}

	in_done_button = 1;
	xv_destroy_safe (frame);
}


/*
 *	Notification proc for both the "Find" button and text item for
 *	the search pattern.  This proc will be called from the pattern item
 *	if you type return.  If this proc is called, and there is an active
 *	selection, that will be used as the search pattern.  The selection
 *	will also be inserted into the pattern item if it is currently empty.
 */

static  int in_find_button;
static	char	*e, regbuf [MAX_SELN_LEN];

init_find_button()
{
	static		int bozo = 0;
	save_card (current);

	/* if selection active, use it */
	if ((e = get_selection ()) != NULL) {
		char	*pe = (char *) xv_get(regex_item, PANEL_VALUE);

		(void) strcpy (regbuf, e);
		/* if panel item is empty, copy selection into it */
/*		if ((pe == NULL) || (strlen (pe) == 0)) { /* */
			xv_set (regex_item, PANEL_VALUE, regbuf, 0);
/*		} /* */
	} else {
		/* else use panel value */
		(void) strcpy (regbuf, (char *) xv_get(regex_item, PANEL_VALUE));
	}

	if (strlen (regbuf) == 0) {
		if (bozo) {
			msg ("Enter an expression to search for");
		} else {
			window_bell (panel);
			bozo++;
		}
		return(0);
	}

	bozo = 0;
	e = re_comp (regbuf);
	if (e != NULL) {
		msg ("Regular Expression error: %s", e);
		return(0);
	}
	return(1);
}

static void find_button_forward (item, event)
Panel_item	item;
Event		*event;
{
	struct card *p;
	if ( in_find_button ) {
		in_find_button = 0;
		return;
	}
	if ( !init_find_button() )
	  return;
	p = (current == last) ? first : current->c_next;
	while (p != current) {
		if (re_exec (p->c_text) == 1) {
			show_card (p);
			return;
		}
		p = (p == last) ? first : p->c_next;
	}
	if (re_exec (p->c_text) != 1)		/* wrapped back to current */
	  window_bell (panel);
}

static void find_button_reverse (item, event)
Panel_item	item;
Event		*event;
{
	struct card *p;
	if ( in_find_button ) {
		in_find_button = 0;
		return;
	}
	if ( !init_find_button() )
	  return;
	p = (current == first) ? last : current->c_prev;
	while (p != current) {
		if (re_exec (p->c_text) == 1) {
			show_card (p);
			return;
		}
		p = (p == first) ? last : p->c_prev;
	}
	if (re_exec (p->c_text) != 1)		/* wrapped back to current */
		window_bell (panel);
}

/*ARGSUSED*/
static void find_button (item, event)
Panel_item	item;
Event		*event;
{
	if ( event_action(event) == ACTION_MENU )
	  return;

	if (value_from_mask(event) == SHIFT_CLICK) {		/* search backwards */
		find_button_reverse(item,event);
	} else {
		find_button_forward(item,event);
	}
	in_find_button = 1;
}


/*
 *	Notification proc for the "List" button.  The text window is used
 *	to display the first non-blank line of each card.
 */

/*ARGSUSED*/
static
void
list_button (item, event)
	Panel_item	item;
	Event		*event;
{
	struct card 	*p;

	save_card (current);			/* save off pending changes */

	textsw_reset (rolocard, 0, 0);		/* clear the text window */

	for (p = first; p != NULL_CARD; p = p->c_next) {
		char	*nl;
		char	line_buf [MAX_INDEX_LINE + 2];

		(void) sprintf (line_buf, "%d: ", p->c_num);/* prepend number */
		textsw_insert (rolocard, line_buf, strlen (line_buf));

		(void) strncpy (line_buf, first_char (p->c_text),
			MAX_INDEX_LINE);
		line_buf [MAX_INDEX_LINE] = 0;	/* make sure it's terminated */

		(void) strcat (line_buf, "\n");	/* make sure of newline */
		nl = index (line_buf, '\n');
		*++nl = '\0';			/* chop at first line break */
		textsw_insert (rolocard, line_buf, strlen (line_buf));
	}

	xv_set (rolocard, TEXTSW_INSERTION_POINT, 0, 0);	/* rewind */
	textsw_normalize_view (rolocard, 0);

	current = NULL_CARD;			/* indicate no card displayed */
	update_num_display (LISTALLCARDS);
}



/*
 *	Notification proc for the "Help" button.  The text window is used to
 *	display a help message.  The text of the help message is defined
 *	in help.h as an array of string pointers (there is too much text to
 *	be parsed as one long string token).
 */

/*ARGSUSED*/
static
void
help_button (item, event)
	Panel_item	item;
	Event		*event;
{
	int		i;

	save_card (current);			/* capture any pending mods */

	textsw_reset (rolocard, 0, 0);		/* empty the window */

	/* insert the help strings into the window in order */
	for (i = 0; i < sizeof (help_msg) / sizeof (char *); i++) {
  		textsw_insert (rolocard, help_msg [i], strlen (help_msg [i]));
	}

  	xv_set (rolocard, TEXTSW_INSERTION_POINT, 0, 0);	/* rewind */
  	textsw_normalize_view (rolocard, 0);

  	current = NULL_CARD;			/* indicate no card displayed */
  	update_num_display (HELPDISPLAYED);	/* set title bar */
}


/*
 *	Notification proc for the slider item on the panel.  This one's easy.
 */

/*ARGSUSED*/
static
void
slider_proc (item, value, event)
	Panel_item	item;
	int		value;
	Event		*event;
{
	save_card (current);
	goto_card (value);
}

/* ----------------------------------------------------------------------- */

/*		Utility procs called by the event handlers above	*/


/*
 *	Set the range on the slider.  Lower bound is always 1, upper bound
 *	is set to the argument i.  The slider size is adjusted according to
 *	how many digits it takes to represent the value.  This looks a bit
 *	goofy because of the way the ATTR_COLS() macro works.  These macros
 *	do NOT return an integer which represents a number of pixels, they
 *	encode a value in the high bits which is interpreted later inside
 *	the library code.  This means you cannot say:
 *		x = panel_width - ATTR_COLS(n);
 *	See the macro definitions in <sunwindow/attr.h>
 */

void
set_slider_max (i)
	int	i;
{
	int	delta = 6;		/* space for 3 digits */

	if (i < 100) {
		delta = 5;		/* space for 2 digits */
	}

	if (i < 10) {
		delta = 4;		/* space for 1 digit */
	}

	xv_set (slider_item,
		PANEL_MIN_VALUE,	1,
		PANEL_MAX_VALUE,	i,
/*		PANEL_SLIDER_WIDTH,	panel_width - 15 + xv_cols (-delta), */
		0);
}


/*
 *	Display the card pointed to by p.  Reset the text window, which
 *	clears it.  Insert the text of the card into the window, then
 *	roll it back to the beginning.  After displaying the text of
 *	the card, update the display items on the panel and set the global
 *	current pointer to point at this card.
 */

void
show_card (p)
	struct	card	*p;
{
	textsw_reset (rolocard, 0, 0);
	textsw_insert (rolocard, p->c_text, strlen (p->c_text));
	xv_set (rolocard, TEXTSW_INSERTION_POINT, 0, 0);
	textsw_normalize_view (rolocard, 0);
	update_num_display (p->c_num);
	current = p;
}


/*
 *	Change to the card with the given index number.  The number is
 *	range checked, then searched for.  When found, the pointer to the
 *	card struct is passed to the function which actually changes
 *	to the new card.
 */

static
void
goto_card (i)
	int		i;
{
	struct	card	*p, *q;

	if ((i < 1) || (i > last->c_num)) {
		msg ("Sorry, don't have a card #%d", i);
		show_card (first);	/* show something we're sure of */
		return;			/* unlikely to happen */
	}

	/* reduce the search space a bit */
	if ((current != NULL_CARD) && (i >= current->c_num)) {
		q = current;
	} else {
		q = first;
	}

	for (p = q; p != NULL_CARD; p = p->c_next) {
		if (p->c_num == i) {
			show_card (p);
			return;
		}
	}

	msg ("Unexpected inconsistency, couldn't find card #%d", i);
}


/*
 *	Save off the contents of the card being displayed in the text window.
 *	If the data in the window has been modified by the user, we need to
 *	replace the data in the card struct with the contents of the window.
 *	Since there isn't a way to load some data into the window as an
 *	initial value and mark it as "clean", we need to use a brute force
 *	method to determine if any changes have been made.  We copy out
 *	the contents of the window and compare it to the data we inserted
 *	in the first place.  If they are the same, no change was made and
 *	there is nothing to do.  If they are different, we throw away the
 *	old contents and stash the pointer to the new in the card struct.
 */

save_card (p)
	struct	card 	*p;
{
	int	red, len;
	char	*c;

	if (p == NULL_CARD) {
		/*
		 * If nil, the text window is being used for an index list
		 * or help message.  If so, we know there is no card data
		 * to be saved, and that some button has been clicked.  So
		 * at this point we'll redisplay the last card that was
		 * displayed.  The slider item should still remember which
		 * one it was.
		 */
		goto_card ((int) xv_get (slider_item, PANEL_VALUE));
		return;
	}

	len = (int) xv_get (rolocard, TEXTSW_LENGTH);
	c = malloc (len + 1);
	red = (int) xv_get (rolocard, TEXTSW_CONTENTS, 0, c, len);
	if (red != len) {
		fprintf (stderr, "rolo: fetch error: red=%d, len=%d\n",
				red, len);
		return;
	}

	c [len] = '\0';
	if (strcmp (c, p->c_text) == 0) {
		free (c);			/* didn't change */
	} else {
		free (p->c_text);		/* changed and must save */
		p->c_text = c;
		need_save = TRUE;
	}
}


/*
 *	Update the displayed information which indicates which card is
 *	currently being displayed.  Provisions are made for the special
 *	cases where the help message or index list is being displayed.
 *	The tool name stripe and the slider value are set to indicate
 *	the number of the current card.
 */

update_num_display (i)
	int	i;
{
	char	buf [MAXPATHLEN + 20];		/* worst case */

	switch (i) {
	case LISTALLCARDS:
		(void) sprintf (buf, "%s - %s  (First lines of all %d cards)",
				NAME, rolofile, last->c_num);
		break;

	case HELPDISPLAYED:
		(void) sprintf (buf, "%s - %s  (Help Message)",
				NAME, rolofile);
		break;

	default:
		xv_set (slider_item, PANEL_VALUE, i, 0);
		(void) sprintf (buf, "%s - %s  (Card %d of %d)",
				NAME, rolofile, i, last->c_num);
		break;
	}

	set_stripe (buf);
}


/*
 *	Ask the user if they're really sure they don't want to save the
 *	changes they've made.  This function only really exists because
 *	the same question is asked in two places (I really hate duplicating
 *	code).
 */

verify_no_save ()
{
	return (confirm (
 		"You have made changes which will be lost.  Are you sure?"));
}


/*
 *	Complain about an unknown shiftmask in a click event.
 */

static
void
no_comprendo (event, p)
	Event	*event;
	char	*p;
{
	char	buf [100];

	(void) sprintf (buf, " %s: Huh?  Don't understand click value %d",
		p, value_from_mask (event));
	msg ("%s", buf);
}


/*
 *	Make sure a filename is reasonable.  This is important because the
 *	filename is provided via the selection mechanism, which could contain
 *	all manner of gibberish.
 */

static
int
filename_ok (p)
	char	*p;
{
	char	*q, *bad_chars = "!^&*()|~`{}[]:;\\\"'<>?";

	for (q = p; *q != '\0'; q++) {
		if (( ! isgraph (*q)) || (index (bad_chars, *q) != NULL)) {
			msg ("Sorry, that looks like a bad filename to me");
			return (FALSE);
		}
	}

	return (TRUE);
}


/*
 *	Get the primary selection, copy it into a static buffer, up to a
 *	maximum, and return a pointer to it.  Return NULL if there is no
 *	current primary selection to get.
 */

static
char *
get_selection()
{
	Seln_holder	holder;
	Seln_request	*buffer;
	static char 	sel_text [MAX_SELN_LEN + 1];
	static notfirsttime = 0;
	Xv_server server = (Xv_server)xv_get(xv_get(frame, XV_SCREEN), SCREEN_SERVER);
	
	holder = selection_inquire (server, SELN_PRIMARY);
	buffer = selection_ask (server, &holder, SELN_REQ_CONTENTS_ASCII, NULL, NULL);

	(void) strcpy (sel_text, buffer->data + sizeof (SELN_REQ_CONTENTS_ASCII));

	if (strlen (sel_text) == 0 || !notfirsttime++) {
		/* empty string is no sel. */
		return (NULL);
	}

	return (sel_text);
}

/* ----------------------------------------------------------------------- */

/*		Panel event dispatcher, trap menu button events		*/


/*
 *	Convert a value representing a menu item into the corresponding
 *	event shift mask for faking a button click.  The menu value, which
 *	is 1-relative, is decremented by one, then the lowest three bits
 *	are examined and the corresponding shiftmask bits are set.
 */

/*
 *	Given an event, translate it into an integer number representing
 *	which logical choice it is.  The value returned will be in the
 *	range 0-7, made up of the three possible bits representing the
 *	states of the SHIFT, CONTROL and META shift keys.  The effect is
 *	that the number returned by this function will be one less than
 *	the value initially passed into mask_from_menu_value().
 */

static
int
value_from_mask (event)
	Event	*event;
{
	int	value = 0;

	/*
	 * These macros don't return TRUE or FALSE, exactly.  They return
	 * the corresponding bits from the shiftmask.  For example, the
	 * value of event_ctrl_is_down() is 0x30 if the control key was
	 * down.  That means you can't compare the result to TRUE.
	 */

	if (event_shift_is_down (event) != 0) {
		value |= 1;
	}

	if (event_ctrl_is_down (event) != 0) {
		value |= 2;
	}

	if (event_meta_is_down (event) != 0) {
		value |= 4;
	}

	return (value);
}

/* ----------------------------------------------------------------------- */

/*		Interposer functions watching for frame events		*/


/*
 *	Interposer proc for catching window resize events.  We're a little
 *	bit fascist here and insist that the frame remain at least big
 *	enough to display the whole panel and at least three lines of the
 *	text window.
 */

#define MIN_CARD_ROWS	3

Notify_value
catch_resize (frame, event, arg, type)
	Frame			frame;
	Event			*event;
	Notify_arg		arg;
	Notify_event_type	type;
{
	Panel			panel;
	int			width;
	int			height;
	int			card_height;
	int			frame_height;
	Notify_value		value;

	value = notify_next_event_func (frame, event, arg, type);

	if (event_id (event) != WIN_RESIZE) {
		return (value);
	}

	if ((int) xv_get (frame, FRAME_CLOSED) == TRUE) {
		return (value);
	}

	panel = (Panel) xv_get (frame, FRAME_NTH_SUBWINDOW, 1);


	width = (int) xv_get (panel, XV_WIDTH);

	if (width < panel_width) {
		xv_set (panel, XV_WIDTH, panel_width, 0);
		window_fit_width (frame);
	}


	height = (int) xv_get (panel, XV_HEIGHT);

	if (height < panel_height) {
		xv_set (panel, XV_HEIGHT, panel_height, 0);
		window_fit_height (frame);
	}

	card_height = (int) xv_get (rolocard, WIN_ROWS);
	if (card_height < MIN_CARD_ROWS) {
		xv_set (rolocard, WIN_ROWS, MIN_CARD_ROWS, 0);
		window_fit_height (frame);
	}

	/*
	 * This catches cases where the subwindows are completely clipped
	 * and don't shrink as far as the frame is concerned.
	 */
	card_height = (int) xv_get (rolocard, XV_HEIGHT);
	frame_height = (int) xv_get (frame, XV_HEIGHT);
	if (frame_height < (panel_height + card_height)) {
		window_fit_height (frame);
	}

	return (value);
}


/*
 *	Interposer function to catch destroy events.  We want to know when
 *	the tool about to be destroyed so that we can save any changes to the
 *	cards back out to disk.  This gets a little tricky because the
 *	text edit window will veto a tool destroy (selecting Quit from
 *	the tool menu) if there is any text in the window.  This is because
 *	from its point of view the text buffer has been modified because we
 *	inserted the initial contents of the card.  The way we get around
 *	this is by saving the contents of the window, resetting it, calling
 *	the rest of the notification chain, then restoring the contents of
 *	the window.  The destroy proc for the text window is called in that
 *	notification chain and it will see an empty window and not object to
 *	the tool being destroyed.  If this function is called again with
 *	a notification flag other than DESTROY_CHECKING, that means the tool
 *	is really going away (either the user OKed a quit or suntools is
 *	shutting down).  In that case we write the cards back out if they
 *	have been changed, without any fancy footwork.
 */

Notify_value
rolo_destroy (frame, status)
	Frame	frame;
	Destroy_status status;
{
	if (status == DESTROY_CHECKING) {
		Notify_value	s;

		save_card (current);
		textsw_reset (rolocard, 0, 0);		/* fake out textedit */
		s = notify_next_destroy_func (frame, status);
		show_card (current);
		return (s);
	}

	save_card (current);
	if (need_save) {
		dump_rolo (first, rolofile);
	}

	return (notify_next_destroy_func (frame, status));
}

