\begindata{text,538270272}
\textdsversion{12}
\template{default}
\define{global
}
\example{-- wc.n


-- Count the words in a text.

-- 	A word is a contiguous sequence of letters.



-- To use as a main program:

--	nessrun -b /usr/andy/lib/ness/wc.n <filename>

-- the number of words in the file is printed.

--

-- To call from a Ness function:

--	wc_countwords( <a marker for the text> )

-- returns an integer value giving the number of words.




marker letters	-- a list of the letters that 

			-- may occur in words

	:= "abcdefghijklmnopqrstuvwxyz"

         ~ "ABCDEFGHIJKLMNOPQRSTUVWXYZ"



-- countwords(text) counts the number of sequences 

--    of adjacent letters

--

-- 'text' is a marker for a substring of the full text

--    token(x, m) searches forward from the beginning of

--    x through the rest of text for the first sequence 

--    of characters all of which are in m

--

--    Any Ness program can call wc_countwords().

--

\leftindent{integer}

function wc_countwords(text)

\leftindent{integer count

marker t

count := 0          	-- no  words so far

t := token(text,letters)	-- find first word

\leftindent{\leftindent{\leftindent{\leftindent{-- check to see if the token 
found

-- starts after the end of the text}}}}

while t /= "" and extent(t, text) /= "" do \leftindent{

count := count + 1	-- count this word

t :=         	 	-- find next word

		-- start search at next(t), 

		-- the first character after 

		-- the preceding word

  token(finish(t), letters)

		-- if no word was found, token()

		-- returns an empty string}

end while

return count}

end function 



-- the main program initializes the global variable,

--    reads a file, counts the number of words in it,

--    and prints a line

-- span(x, m) finds the longest initial substring of

--    x composed of characters from m

-- ~ indicates concatenation of string values

--

function main(args)\leftindent{

marker filename


-- extract the file name from argument list

-- find the initial substring of args which is 

-- composed of letters, digits, dots, and slashes.

filename := span(start(args), letters ~ "./0123456789")


-- read file, count words, and print result

printline ("The text of " ~ filename ~ " has "\leftindent{

~ textimage(wc_countwords(readfile(filename))) 

~ " words")}}

end function



-- Select some text.  Type ESC ESC, and respond to 

-- the "Ness:" prompt with

--	wc_showcount()

--

-- The following function will be called and will show 

-- the number of words in the current selection

--

function wc_showcount() \leftindent{

TellUser(textimage(wc_countwords(\leftindent{\leftindent{

currentselection(currentinset))))}}}

end function



-- To use the following entry point, 

-- put these lines in your .atkinit:

--	load ness

--	call ness-load /usr/andy/lib/ness/wc.n

-- Then choosing the menu entry "Count words" will show 

-- a count of the words in the current selection

--

extend "view:textview"\leftindent{

on menu "Search/Spell,Count words~60"\leftindent{

wc_showcount()}

end menu}

end extend}


-- 
\begindata{bp,537558784}
\enddata{bp,537558784}
\view{bpv,537558784,39,0,0}

-- Copyright 1992 Carnegie Mellon University and IBM.  All rights reserved.

\smaller{\smaller{-- $Disclaimer: 

-- Permission to use, copy, modify, and distribute this software and its 

-- documentation for any purpose is hereby granted without fee, 

-- provided that the above copyright notice appear in all copies and that 

-- both that copyright notice, this permission notice, and the following 

-- disclaimer appear in supporting documentation, and that the names of 

-- IBM, Carnegie Mellon University, and other copyright holders, not be 

-- used in advertising or publicity pertaining to distribution of the software 

-- without specific, written prior permission.

-- 

-- IBM, CARNEGIE MELLON UNIVERSITY, AND THE OTHER COPYRIGHT HOLDERS 

-- DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING 

-- ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT 

-- SHALL IBM, CARNEGIE MELLON UNIVERSITY, OR ANY OTHER COPYRIGHT HOLDER 

-- BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY 

-- DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, 

-- WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS 

-- ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 

-- OF THIS SOFTWARE.

--  $

}}\enddata{text,538270272}
