/*
 * Copyright (c) 1994, 1995.  Netscape Communications Corporation.  All
 * rights reserved.
 * 
 * Use of this software is governed by the terms of the license agreement for
 * the Netscape FastTrack or Netscape Enterprise Server between the
 * parties.
 */


/* ------------------------------------------------------------------------ */


/*
 * session.h: Deals with virtual sessions
 *
 * A session is the time between when a client connects and when it
 * disconnects. Several requests may be handled in one session.
 *
 * Rob McCool
 */


#ifndef SESSION_H
#define SESSION_H


#ifdef __cplusplus
extern "C" {
#endif

#include "../netsite.h"  /* MALLOC etc */
#include "net.h"          /* dns-related stuff */
#include "buffer.h"       /* netbuf */
#ifdef MALLOC_POOLS
#include "pool.h"
#endif /* MALLOC_POOLS */


/* ------------------------------ Structures ------------------------------ */



#define SESSION_HASHSIZE 5


typedef struct Session {
    /* Client-specific information */
    pblock *client;

    SYS_NETFD csd;
    netbuf *inbuf;
    int csd_open;

    struct in_addr iaddr;

#ifdef MCC_PROXY
    int req_cnt;
#endif

#ifdef MALLOC_POOLS
    pool_handle_t *pool;
#endif /* MALLOC_POOLS */

    void *clauth;		/* ACL client authentication information */
    struct Session *next;
	int fill;
} Session;


/* ------------------------------ Prototypes ------------------------------ */


/*
 * session_create creates a new request structure for the client with the
 * given socket descriptor and sockaddr.
 */

NSAPI_PUBLIC Session *session_alloc(SYS_NETFD csd, struct sockaddr_in *sac); /* internal */
NSAPI_PUBLIC Session *session_fill(Session *sn); /* internal */
NSAPI_PUBLIC Session *session_create(SYS_NETFD csd, struct sockaddr_in *sac);

/*
 * session_free frees the given session
 */

NSAPI_PUBLIC void session_free(Session *sn);

/*
 * session_dns returns the DNS hostname of the client of this session,
 * and inserts it into the client pblock. Returns NULL if unavailable.
 */

#define session_dns(sn) session_dns_lookup(sn, 0)

/*
 * session_maxdns looks up a hostname from an IP address, and then verifies 
 * that the host is really who they claim to be. 
 */

#define session_maxdns(sn) session_dns_lookup(sn, 1)

NSAPI_PUBLIC char *session_dns_lookup(Session *sn, int verify);

#ifdef __cplusplus
}
#endif

#endif
