/*
 * Copyright (c) 1994, 1995.  Netscape Communications Corporation.  All
 * rights reserved.
 * 
 * Use of this software is governed by the terms of the license agreement for
 * the Netscape FastTrack or Netscape Enterprise Server between the
 * parties.
 */


/* ------------------------------------------------------------------------ */


/*
 * regexp.h: Wrapper for system's regular expression handlers
 *
 *
 *
 *
 *
 *
 * Ari Luotonen
 * Copyright (c) 1995 Netscape Communcations Corporation
 *
 */

#ifndef NS_REGEXP_H
#define NS_REGEXP_H

#include "../netsite.h"


/* --------------------------- Public routines ---------------------------- */


/*
 * regexp_valid takes a regular expression exp as input. It returns:
 * 
 *  NON_REGEXP      if exp is a standard string
 *                  (above not used -- always returns VALID_REGEXP!!)
 *  INVALID_REGEXP  if exp is a regular expression, but invalid
 *  VALID_REGEXP    if exp is a valid regular expression
 */

int regexp_valid(char *exp);


/*
 * regexp_match 
 * 
 * Takes a prevalidated shell expression exp, and a string str.
 *
 * Returns 0 on match and 1 on non-match.
 */

int regexp_match(char *str, char *exp);


/*
 * regexp_cmp
 * 
 * Same as above, but validates the exp first. 0 on match, 1 on non-match,
 * -1 on invalid exp. regexp_casecmp does the same thing but is case 
 * insensitive.
 */

int regexp_cmp(char *str, char *exp);
int regexp_casecmp(char *str, char *exp);

#endif
