/*
 * Copyright (c) 1994, 1995.  Netscape Communications Corporation.  All
 * rights reserved.
 * 
 * Use of this software is governed by the terms of the license agreement for
 * the Netscape FastTrack or Netscape Enterprise Server between the
 * parties.
 */


/* ------------------------------------------------------------------------ */


/*
 * pool.h
 *
 * Module for handling memory allocations.
 *
 * Notes:
 * This module is used instead of the NSPR prarena module because the prarenas
 * did not fit as cleanly into the existing server.
 *
 * Mike Belshe
 * 10-02-95
 *
 */
#ifndef _POOL_H_
#define _POOL_H_

#ifdef __cplusplus
extern "C" {
#endif

#ifdef MALLOC_POOLS

#include <sys/types.h>

/* Thread-Private data key index for accessing the thread-private memory pool.
 * Each thread creates its own pool for allocating data.  The MALLOC/FREE/etc
 * macros have been defined to check the thread private data area with the
 * thread_malloc_key index to find the address for the pool currently in use.
 *
 * If a thread wants to use a different pool, it must change the thread-local-
 * storage[thread_malloc_key].  (declared in daemon.c)
 */
extern int thread_malloc_key;

typedef void *pool_handle_t;

/* pool_create()
 * Function to create a new pool.
 * Returns non-NULL on success, NULL on failure.
 */
NSAPI_PUBLIC pool_handle_t *pool_create(void);

/* pool_destroy()
 * Frees all memory associated with a pool and destroys the pool.
 */
NSAPI_PUBLIC void pool_destroy(pool_handle_t *pool_handle);

/* pool_enabled()
 * Check if the pools are enabled and a pool is currently set
 * for this thread.  Return 1 if enabled, 0 if not enabled.
 */
NSAPI_PUBLIC int pool_enabled(void);

NSAPI_PUBLIC void *pool_malloc(pool_handle_t *pool_handle, size_t size );
NSAPI_PUBLIC void pool_free(pool_handle_t *pool_handle, void *ptr );

NSAPI_PUBLIC 
void *pool_calloc(pool_handle_t *pool_handle, size_t nelem, size_t elsize);

NSAPI_PUBLIC 
void *pool_realloc(pool_handle_t *pool_handle, void *ptr, size_t size );

NSAPI_PUBLIC char *pool_strdup(pool_handle_t *pool_handle, char *orig_str );

#endif /* MALLOC_POOLS */

#ifdef __cplusplus
}
#endif

#endif /* _POOL_H_ */
