#include "../src/parms.h"
#include "../src/structs.h"

/*
 *	structsize
 *
 *	Tells you the size of some of the structures in the
 *	data base.
 *
 *	This is useful when installing new versions of the
 *	notesfile code.  I have recently (Sept 6, '83) played
 *	with one of the structures and it resulted in a 
 *	non-obvious (but quickly figured out) change in the
 *	size of the data structures.  This broke extant notesfiles.
 *
 *	If things don't fly when you first use new code, I would
 *	suggest compiling and running this file with both the
 *	old and new structure files (it will work with both)
 *	and see what changed.  Then play with the filler space
 *	that I left in the structure definitions to make things
 *	work out.
 *
 *	Sorry that things like this have to happen. *sigh*
 *
 *	-- Ray Essick	September 6, 1983
 *
 * $Header: /home/ace/master/rmtc/misc/notes/utility/structsize.c,v 1.7 1989/05/15 11:05:35 polk Exp $
 *
 */

main ()
{

    printf ("size of descr_f %d\n", sizeof (struct descr_f));
    printf ("size of note_f %d\n", sizeof (struct note_f));
    printf ("size of resp_f %d\n", sizeof (struct resp_f));

    domore ();
    exit (0);
}

domore ()
{
    struct nflist_f nflistf;
    struct seq_f    seqf;
    struct io_f iof;
    struct descr_f  descrf;
    struct note_f   notef;
    struct resp_f   respf;
    struct dsply_f  dsplyf;
    struct txtbuf_f txtbuff;
    struct daddr_f  daddrf;
    struct perm_f   permf;
    struct id_f idf;
    struct when_f   whenf;
    struct auth_f   authf;


#define	OFFSETIN(s,f)	\
    printf ("Offset in s of f is 0x%x\n", &((struct  s *) 0) -> f);


#define	SIZEOF(s) \
    printf ("\nsize of s is 0x%x\n", sizeof (s));

    SIZEOF (authf);
    OFFSETIN (auth_f, aname);
    OFFSETIN (auth_f, asystem);
    OFFSETIN (auth_f, aid);

    SIZEOF (whenf);
    OFFSETIN (when_f, w_year);
    OFFSETIN (when_f, w_month);
    OFFSETIN (when_f, w_day);
    OFFSETIN (when_f, w_hours);
    OFFSETIN (when_f, w_mins);
    OFFSETIN (when_f, w_gmttime);

    SIZEOF (idf);
    OFFSETIN (id_f, sys);
    OFFSETIN (id_f, uniqid);

    SIZEOF (permf);
    OFFSETIN (perm_f, ptype);
    OFFSETIN (perm_f, name);
    OFFSETIN (perm_f, perms);

    SIZEOF (daddrf);
    OFFSETIN (daddr_f, addr);
    OFFSETIN (daddr_f, textlen);

    SIZEOF (txtbuff);
    OFFSETIN (txtbuf_f, txtbuf);

    SIZEOF (dsplyf);
    OFFSETIN (dsply_f, d_head);
    OFFSETIN (dsply_f, d_buf);
    OFFSETIN (dsply_f, optr);
    OFFSETIN (dsply_f, olim);
    OFFSETIN (dsply_f, outcount);

    SIZEOF (respf);
    OFFSETIN (resp_f, r_first);
    OFFSETIN (resp_f, r_last);
    OFFSETIN (resp_f, r_id);
    OFFSETIN (resp_f, r_addr);
    OFFSETIN (resp_f, r_when);
    OFFSETIN (resp_f, r_from);
    OFFSETIN (resp_f, r_rcvd);
    OFFSETIN (resp_f, r_auth);
    OFFSETIN (resp_f, r_stat);
    OFFSETIN (resp_f, r_next);
    OFFSETIN (resp_f, r_previous);


    SIZEOF (notef);
    OFFSETIN (note_f, n_id);
    OFFSETIN (note_f, n_nresp);
    OFFSETIN (note_f, ntitle);
    OFFSETIN (note_f, n_auth);
    OFFSETIN (note_f, n_date);
    OFFSETIN (note_f, n_rcvd);
    OFFSETIN (note_f, n_lmod);
    OFFSETIN (note_f, n_from);
    OFFSETIN (note_f, n_rindx);
    OFFSETIN (note_f, n_addr);
    OFFSETIN (note_f, n_stat);

    SIZEOF (descrf);
    OFFSETIN (descr_f, d_format);
    OFFSETIN (descr_f, d_title);
    OFFSETIN (descr_f, d_drmes);
    OFFSETIN (descr_f, d_plcy);
    OFFSETIN (descr_f, d_lastm);
    OFFSETIN (descr_f, d_stat);
    OFFSETIN (descr_f, d_nnote);
    OFFSETIN (descr_f, d_id);
    OFFSETIN (descr_f, d_lstxmit);
    OFFSETIN (descr_f, d_created);
    OFFSETIN (descr_f, d_lastuse);
    OFFSETIN (descr_f, d_daysused);
    OFFSETIN (descr_f, d_rspwrit);
    OFFSETIN (descr_f, d_notwrit);
    OFFSETIN (descr_f, entries);
    OFFSETIN (descr_f, walltime);
    OFFSETIN (descr_f, d_rspread);
    OFFSETIN (descr_f, d_notread);
    OFFSETIN (descr_f, d_rsprcvd);
    OFFSETIN (descr_f, d_notrcvd);
    OFFSETIN (descr_f, d_rspxmit);
    OFFSETIN (descr_f, d_notxmit);
    OFFSETIN (descr_f, d_notdrop);
    OFFSETIN (descr_f, d_rspdrop);
    OFFSETIN (descr_f, d_orphans);
    OFFSETIN (descr_f, netwrkouts);
    OFFSETIN (descr_f, netwrkins);
    OFFSETIN (descr_f, d_nfnum);
    OFFSETIN (descr_f, d_archtime);
    OFFSETIN (descr_f, d_workset);
    OFFSETIN (descr_f, d_delnote);
    OFFSETIN (descr_f, d_delresp);
    OFFSETIN (descr_f, d_dmesgstat);
    OFFSETIN (descr_f, d_archkeep);
    OFFSETIN (descr_f, d_adopted);
    OFFSETIN (descr_f, d_longnote);
    OFFSETIN (descr_f, d_filler);

    SIZEOF (iof);
    OFFSETIN (io_f, fidtxt);
    OFFSETIN (io_f, fidndx);
    OFFSETIN (io_f, fidrdx);
    OFFSETIN (io_f, descr);

    OFFSETIN (io_f, nf);
    OFFSETIN (io_f, basedir);
    OFFSETIN (io_f, fullname);
    OFFSETIN (io_f, xstring);
    OFFSETIN (io_f, xauthor);

    OFFSETIN (io_f, stime);
    OFFSETIN (io_f, access);
    OFFSETIN (io_f, nrspwrit);
    OFFSETIN (io_f, nnotwrit);
    OFFSETIN (io_f, entered);
    OFFSETIN (io_f, nrspread);
    OFFSETIN (io_f, nnotread);

    OFFSETIN (io_f, nnotxmit);
    OFFSETIN (io_f, nrspxmit);
    OFFSETIN (io_f, nnotrcvd);
    OFFSETIN (io_f, nrsprcvd);
    OFFSETIN (io_f, nnotdrop);
    OFFSETIN (io_f, nrspdrop);
    OFFSETIN (io_f, norphans);
    OFFSETIN (io_f, adopted);

    SIZEOF (seqf);
    OFFSETIN (seq_f, nfname);
    OFFSETIN (seq_f, lastin);

    SIZEOF (nflistf);
    OFFSETIN (nflist_f, nf_name);
    OFFSETIN (nflist_f, nf_active);
    OFFSETIN (nflist_f, nf_seqmode);

}
