#include "../src/parms.h"
#include "../src/structs.h"

#ifdef	RCSIDENT
static char rcsid[] = "$Header: /home/ace/master/rmtc/misc/notes/utility/dump.c,v 1.6 1984/03/07 19:04:55 notes Exp $";
#endif	RCSIDENT

/*
 *	dumpnf(nfname)
 *
 *	Dump a notesfile. Parameters are a notesfile name, a name
 *	for the descriptor information, and a name for the rest
 *	of the notesfile.
 *
 */

dumpnf (nfname, dfile, nfile)
char   *nfname;						/* name of notesfile */
char   *dfile;						/* descriptor */
char   *nfile;						/* articles */
{
    struct io_f io;
    struct note_f   note;
    FILE * dout;
    FILE * nout;
    int     i;

    if ((i = init (&io, nfname)) < 0)
	return (i);					/* die */
    if ((dout = fopen (dfile, "w")) == NULL)
    {
	closenf (&io);					/* die */
	return (-1);
    }
    if ((nout = fopen (nfile, "w")) == NULL)
    {
	closenf (&io);
	fclose (dout);
	return (-1);					/* die again */
    }

    dmpdescr (&io, dout);				/* dump the descriptor */
    for (i = 1; i < io.descr.d_nnote; i++)		/* dump each note */
    {
	getnrec (&io, i, &note);			/* get record */
	if (note.n_stat & DELETED)
	    continue;					/* ignore */
	dmpnote (&io, &note, i, nout, 1);		/* base note */
	dmprall (&io, &note, i, nout, 1);		/* and responses */
    }

    fclose (dout);					/* close descriptor */
    fclose (nout);					/* and text */
    closenf (&io);					/* and notesfile */
    return (0);						/* return nicely */
}


/*
 *	dmpdescr
 *
 *	Dump a notesfile descriptor and it's policy note if there is
 *	one.  Send it to the supplied stdio file.
 *
 */

dmpdescr (io, dmpfile)
struct io_f *io;
FILE * dmpfile;
{
    char    buf[128];					/* hold strings */
    register int    i;

    getdscr (io, &io -> descr);				/* grab descriptor */
    fprintf (dmpfile, "NF-Title: ");
    for (i = 0; i < len (io -> descr.d_title, TITLEN); i++)
	putc (io -> descr.d_title[i], dmpfile);
    putc ('\n', dmpfile);
    fprintf (dmpfile, "NF-Director-Message: ");
    for (i = 0; i < len (io -> descr.d_drmes, DMLEN); i++)
	putc (io -> descr.d_drmes[i], dmpfile);
    putc ('\n', dmpfile);
    sprdate (&io -> descr.d_lastm, buf);
    fprintf (dmpfile, "NF-Last-Modified: %s\n", buf);
    fprintf (dmpfile, "NF-Status:");			/* status */
    {
	if (io -> descr.d_stat & ANONOK)
	    fprintf (dmpfile, " Anonymous");
	if (io -> descr.d_stat & OPEN)
	    fprintf (dmpfile, " Open");
	if (io -> descr.d_stat & NETWRKD)
	    fprintf (dmpfile, " Networked");
	if (io -> descr.d_stat & ISARCH)
	    fprintf (dmpfile, " Archive");
    }
    putc ('\n', dmpfile);				/* end status line */
    fprintf (dmpfile, "NF-Id-Sequence: %s.%ld\n", io -> descr.d_id.sys,
	    io -> descr.d_id.uniqid);
    fprintf (dmpfile, "NF-Number: %ld\n", (long) io -> descr.d_nfnum);
    sprdate (&io -> descr.d_lstxmit, buf);
    fprintf (dmpfile, "NF-Last-Transmit: %s\n", buf);
    sprdate (&io -> descr.d_created, buf);
    fprintf (dmpfile, "NF-Created: %s\n", buf);
    sprdate (&io -> descr.d_lastuse, buf);
    fprintf (dmpfile, "NF-Last-Used: %s\n", buf);
    fprintf (dmpfile, "NF-Days-Used: %ld\n", io -> descr.d_daysused);
    fprintf (dmpfile, "NF-Notes-Written: %ld\n", io -> descr.d_notwrit);
    fprintf (dmpfile, "NF-Notes-Read: %ld\n", io -> descr.d_notread);
    fprintf (dmpfile, "NF-Notes-Transmitted: %ld\n", io -> descr.d_notxmit);
    fprintf (dmpfile, "NF-Notes-Received: %ld\n", io -> descr.d_notrcvd);
    fprintf (dmpfile, "NF-Notes-Dropped: %ld\n", io -> descr.d_notdrop);
    fprintf (dmpfile, "NF-Responses-Written: %ld\n", io -> descr.d_rspwrit);
    fprintf (dmpfile, "NF-Responses-Read: %ld\n", io -> descr.d_rspread);
    fprintf (dmpfile, "NF-Responses-Transmitted: %ld\n", io -> descr.d_rspxmit);
    fprintf (dmpfile, "NF-Responses-Received: %ld\n", io -> descr.d_rsprcvd);
    fprintf (dmpfile, "NF-Responses-Dropped: %ld\n", io -> descr.d_rspdrop);
    fprintf (dmpfile, "NF-Entries: %ld\n", io -> descr.entries);
    fprintf (dmpfile, "NF-Walltime: %ld\n", io -> descr.walltime);
    fprintf (dmpfile, "NF-Orphans-Received: %ld\n", io -> descr.d_orphans);
    fprintf (dmpfile, "NF-Orphans-Adopted: %ld\n", io -> descr.d_adopted);
    fprintf (dmpfile, "NF-Transmits: %ld\n", io -> descr.netwrkouts);
    fprintf (dmpfile, "NF-Receives: %ld\n", io -> descr.netwrkins);
    fprintf (dmpfile, "NF-Expiration-Age: %ld Days\n", io -> descr.d_archtime);
    switch ((int) io -> descr.d_archkeep)
    {
	case KEEPYES: 
	    strcpy (buf, "Archive");
	    break;
	case KEEPNO: 
	    strcpy (buf, "Delete");
	    break;
	default: 
	    strcpy (buf, "Default");
	    break;
    }
    fprintf (dmpfile, "NF-Expiration-Action: %s\n", buf);
    switch ((int) io -> descr.d_dmesgstat)
    {
	case DIRON: 
	    strcpy (buf, "Director Message On");
	    break;
	case DIROFF: 
	    strcpy (buf, "Director Message Off");
	    break;
	case DIRNOCARE: 
	    strcpy (buf, "Director Message Either");
	    break;
	default: 
	    strcpy (buf, "Default");
	    break;
    }
    fprintf (dmpfile, "NF-Expiration-Status: %s\n", buf);
    fprintf (dmpfile, "NF-Working-Set-Size: %ld\n", io -> descr.d_workset);
    fprintf (dmpfile, "NF-Longest-Text: %ld bytes\n", io -> descr.d_longnote);

    if (io -> descr.d_plcy)				/* if a policy note */
    {							/* dump it */
	struct note_f   note;
	getnrec (io, 0, &note);
	fprintf (dmpfile, "NF-Policy-Exists: %s\n",
		io -> descr.d_plcy ? "Yes" : "No");
	dmpnote (io, &note, 0, dmpfile, TRUE);		/* dump it */
    }
}
