/*
    Gn: A Server for the Internet Gopher Protocol(*).
    File: gn/sio.c
    Version 2.15
    
    Copyright (C) 1994  <by John Franks>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    (*) Gopher is a registered trademark of the Univ. of Minn.
*/

#include <stdio.h>
#include <string.h>
#include "gn.h"


extern void	www_escape(),
		www_replace(),
		www_unreplace();

static int	cache_inlist = FALSE;

static void	parse_cache(),
		parse_2cache();

char *
get_input( sel)
char	*sel;
{
	if ( fgets( sel, PATHLEN, stdin) == NULL) {
		return NULL;
	}
	chop( sel);
	return ( sel);
}


void
send_text_line( line)
char	*line;
{
	chop( line);
	if ( http) {
		fputs( line, stdout);
		fputs( "\n", stdout);
	}
	else {
		if ( streq( line, "."))
		strcat( line, ".");
			/* Double a '.' if on line by itself */
		fputs( line, stdout);
		fputs( "\r\n", stdout);
	}
}

void
send_cache_line( cep)
Cache_entry	*cep;
{
	register char	*cp;


	char		buf[MAXLEN],
			line[MAXLEN];
	int		att;

	Item    item;

	att = cep->attribute;
        if ( (cep->entrytype == HTTPTEXT) || (att == INVISIBLE) 
			|| ( att == HTTPONLY) || ( att == HTTPLINK))
		return;
	
	strcpy( line , cep->cacheline);

	if ( (accesstype == DIRCHK) && (cep->entrytype == LOCAL) ) {
		parse_selector( &item, cep->path, FULL);
		if (!chkaccess( &item, FALSE))  
			return;
	}

	if ( cep->entrytype == ILINE || cep->hnameflag == TRUE ) {
		cp = strchr( line, '\t');
		strcpy( buf, cp);
		*cp = '\0';
		www_unreplace( line);
			/* Delete everything in <> angle brackets */
		strcat( line, buf);
	}
	fputs( line, stdout);
	fputs( "\r\n", stdout);
}

void
send_end()
{
	fputs( ".\r\n", stdout);
}



/*
 * read_cache() reads from a cache file (fp) and fills the Cache_entry
 * struct pointed to by cep.  It puts the primary cache file line in
 * cep->cacheline first.  Then it reads the secondary line to fill
 * out the entrytype, content  suffix and encoding fields.  Next it calls
 * parse_cache( cep) which parses cep->cacheline and fills in the 
 * remaining fields.  It returns NULL when the cache file has been
 * exhausted and otherwise returns its first argument.
 */

Cache_entry *
read_cache( cep, fp)
Cache_entry	*cep;
FILE	*fp;

{
	int	c;
	char	cacheline2[MAXLEN];



	if ( fgets( cep->cacheline, MAXLEN, fp) == NULL) {
		return NULL;
	}

	chop( cep->cacheline);
	*cep->content = *cep->suffix = '\0';
	cep->type1 = *(cep->cacheline);
	cep->hnameflag = FALSE;
	cep->attribute = 0;
	cep->entrytype = REMGOPHER; /* assume this by default */

	switch ( cep->type1) {
	case 'i':
		cep->entrytype = ILINE;
		return (cep);

	case '8':
	case 'T':
		cep->entrytype = TELNETLINK;
		break;

	case 'o':
		if ( strncmp( cep->cacheline, "owner:", 6) == 0 ) {
			strcpy( cache_owner, cep->cacheline + 6);
			return ( read_cache( cep, fp));
		}


	case 'h':
		if ( strncmp( cep->cacheline, "http:", 5) == 0 ) {
			cep->entrytype = HTTPTEXT;
			cep->type1 = '\0';
			return ( cep);
		}
		/*
		 * If a cache line starts with "hname:", then the name
		 * field may contain HTML.  Set Cache_entry.hnameflag
                 * and strip the "hname:" from the cache line.  The
		 * bcopy() may cause a portability problem, though:
		 */

		if ( strncmp( cep->cacheline, "hname:", 6) == 0 ) {
			cep->hnameflag = TRUE;
			strcpy( cep->cacheline, cep->cacheline + 6);
			cep->type1 = *(cep->cacheline);
		}


	}

	if ( ( c = fgetc( fp)) == '\t') {
		if ( fgets( cacheline2, MAXLEN, fp) == NULL) {
			writelog( "", "Corrupt secondary cache line", "");
			return (cep);
		}

		chop( cacheline2);
		parse_2cache( cep, cacheline2);
	}
	else {
		ungetc( c, fp);
		/* No secondary cacheline:  leave entrytype as REMGOPHER */
	}
	parse_cache( cep);
	return (cep);
}

/*
 * parse_cache( cep) looks at a primary line from a .cache file and fills in
 * the fields of the Cache_entry struct pointed to by cep.  These fields
 * are name,  path, host and port.

 * Type1 is the single character type which is the first character of
 * the .cache line.
 */


static void
parse_cache(  cep)
Cache_entry	*cep;
{
	register char	*cp,
			*cp2,
			*cp3,
			*cp4;

	char		cline[MAXLEN];


	strcpy( cline, cep->cacheline);
	
	if ( (cp = strchr( cline, '\t')) == (char *) NULL) {
		senderr2( "Corrupted cache entry [no tabs]", cline);
		exit( 2);
	}

	*cp++ = '\0';
	strcpy( cep->name, &cline[1]);
	
	/* cp points after 1st tab */

	if ( (cp2 = strchr( cp, '\t')) == (char *) NULL) {
		senderr2( "Corrupted cache entry [no 2nd tab]", cline);
		exit( 2);
	}
	*cp2++ = '\0';

	/* cp2 points after 2nd tab */

	strcpy( cep->path, cp);
	if ( (strncmp( cep->path, "ftp:", 4) == 0)
			&& (cep->entrytype != REMHTTP) )
		cep->entrytype = FTPLINK;

	if ( (cp3 = strchr( cp2, '\t')) == (char *) NULL) {
		senderr2( "Corrupted cache entry [no 3rd tab]",
				cep->cacheline);
		exit( 2);
	}
	*cp3++ = '\0';

	/* cp3 points after 3rd tab */

	strcpy( cep->host, cp2);
	if ( (cp4 = strchr( cp3, '\t')) !=  NULL)
		*cp4 = '\0';
	strcpy( cep->port,  cp3);
}



/*
 * Parse secondary cache line and file in appropriate fields of struct
 * pointed to by cep.  The first tab in this line has been removed.
 */

static void
parse_2cache( cep, line)
Cache_entry	*cep;
char		*line;
{
	register char	*cp,
			*cp2;
	char		*parray[4],
			attribute[MIDLEN];

	int		i = 0;


	parray[0] = cep->content;
	parray[1] = cep->suffix;
	parray[2] = cep->encoding;
	parray[3] = attribute;

	cp = cp2 = line;
	while ( *cp && (i < 4)) {
		if ( *cp == '\t') {
			*cp++ = '\0';
			strcpy( parray[i++], cp2);
			cp2 = cp;
			continue;
		}
		cp++;
	}
	strcpy( parray[i++], cp2);
	while ( i < 4 )
		strcpy( parray[i++], "");


	if ( streq( cep->content, "gopher_link")) {
		/* leave entrytype as is */
		cep->content[0] = '\0';
	} else if ( streq( cep->content, "gn_link")
			|| (cep->attribute == GNLINK)) {
		cep->entrytype = REMGN;
		cep->content[0] = '\0';
	} else {
		cep->entrytype = LOCAL;
	}

	switch ( *attribute){
	case 'i':
		cep->attribute = INVISIBLE;
		break;
	case 'n':
		cep->attribute = NOSEARCH;
		break;
	case 'g':
		if ( attribute[1] == 'n' )   /* it's "gnlink" */
			cep->attribute = GNLINK;
		else
			cep->attribute = GOPHERONLY;
		break;
	case 'h':
		cep->attribute = HTTPONLY;
		break;
	case 'u':
		cep->attribute = HTTPLINK;
		cep->entrytype = REMHTTP;
		cep->content[0] = '\0';
		break;
	default:
		cep->attribute = 0;
	}

}


void
www_cache_line( cep)
Cache_entry	*cep;
{
	register char	*cp,
			*cp2;
	char		*prog,
			*endanchor,
			out[PATHLEN],
			buf[PATHLEN],
			cache[PATHLEN];

	int		len;

	Item    	item;




        if ( (cep->attribute == INVISIBLE) || (cep->attribute == GOPHERONLY) )
		return;

	switch ( cep->entrytype) {
	case HTTPTEXT:
		strcpy( out, cep->cacheline + 5);
		if ( http && cache_inlist)
			send_text_line( "</UL>");
		send_text_line( out);
		cache_inlist = FALSE;		
		return;
	case ILINE:
		strcpy(out, cep->cacheline + 1);
		cp = strchr( out, '\t');
		*cp = '\0';
		if ( http && cache_inlist)
			send_text_line( "</UL>");
		send_text_line( out);
		cache_inlist = FALSE;		
		return;
	}

	if ( (accesstype == DIRCHK) && (cep->entrytype == LOCAL) ) {
		strcpy( buf, cep->path);
		parse_selector( &item, buf, FULL);
		if (!chkaccess( &item, FALSE))  
			return;
	}

	www_escape( cep->path);
	if (cep->hnameflag == FALSE) {
		www_replace( cep->name);
		endanchor = "</A>";
        } else {
	  	endanchor = "";
	}

	switch (cep->entrytype) {
	case TELNETLINK:
		strcpy( buf, cep->cacheline);
		prog = ( cep->type1 == '8' ? "telnet" : "tn3270");
		sprintf( out, "<li> <a href=\"%s://%s:%s\">%s%s", 
			prog, cep->host, cep->port, cep->name, endanchor);
		break;
	case FTPLINK:
		if ( 	((cp2 =  strchr(cep->path, ':')) != NULL) &&
				((cp =  strchr(cp2, '@')) != NULL) ) {
			*cp++ = '\0';
			cp2++;
			sprintf( out, "<li> <a href=\"ftp://%s%s\">%s%s", 
				cp2, cp, cep->name, endanchor);
			break;
		}

	case LOCAL:
  	case REMGN:
		/* Fix up 0h and 1h paths */		        
		if ( strncmp( cep->path, "0h", 2) == 0 ) {
		        /* have to take care of explicit caches... just */
			/* move it out of the way if there is one */
			cp = strstr( cep->path, "%28");
			if (cp) {
				strcpy( cache, cp);
				*cp = '\0';
			}
			else
				*cache = '\0';
			len = strlen( cep->path);
			cp = cep->path + len - 4;
			if ( streq( cp, ".txt"))
				strcpy( cp, ".html");
			else
				strcat( cep->path, ".html");
			if (cache)
				strcat( cep->path, cache);
		}
		if ( strncmp( cep->path, "1h", 2) == 0 ) {
			cp = strstr( cep->path, "%28");
			if (cp) {
				strcpy( cache, cp);
				*cp = '\0';
			}
			else
				*cache = '\0';
			len = strlen( cep->path);
			cp = cep->path + len - 6;
			if ( streq( cp, ".cache"))
				strcpy( cp, ".html");
			else
				strcat( cep->path, ".html");
			if (cache)
			   	strcat( cep->path, cache);
		}

		sprintf(out,"<li> <a href=\"http://%s:%s/%s\">%s%s", 
			cep->host, cep->port, cep->path, cep->name,
			endanchor);
		break;

	case REMHTTP:
		sprintf(out,"<li> <a href=\"%s\">%s</A>",
			cep->path, cep->name);
		break;

	case REMGOPHER:
	default:
		sprintf(out,
			"<li> <a href=\"gopher://%s:%s/%c%s\">%s%s", 
			cep->host, cep->port, cep->type1, 
			cep->path, cep->name, endanchor);
	}

	if ( !cache_inlist)
			send_text_line( "<UL>");
	cache_inlist = TRUE;
	send_text_line( out);
}


void
cache_epilog( http)
int	http;
{
	if ( http) {
		if ( cache_inlist)
			send_text_line( "</UL>" );
		send_text_line( "</BODY>\n</HTML>" );
	}
	else
		send_end();
}
